/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store;

import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;

public class NamespacePropKey
extends PropStoreKey<NamespaceId> {
    private NamespacePropKey(InstanceId instanceId, String path, NamespaceId id) {
        super(instanceId, path, id);
    }

    public static NamespacePropKey of(ServerContext context, NamespaceId id) {
        return NamespacePropKey.of(context.getInstanceID(), id);
    }

    public static NamespacePropKey of(InstanceId instanceId, NamespaceId id) {
        return new NamespacePropKey(instanceId, NamespacePropKey.buildNodePath(instanceId, id), id);
    }

    private static String buildNodePath(InstanceId instanceId, NamespaceId id) {
        return ZooUtil.getRoot((InstanceId)instanceId) + "/namespaces/" + id.canonical() + "/config";
    }
}

