/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.delegation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.accumulo.core.securityImpl.thrift.TAuthenticationKey;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.ThriftMessageUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.thrift.TBase;

public class AuthenticationKey
implements Writable {
    private TAuthenticationKey authKey;
    private SecretKey secret;

    public AuthenticationKey() {
    }

    public AuthenticationKey(int keyId, long creationDate, long expirationDate, SecretKey key) {
        Objects.requireNonNull(key);
        this.authKey = new TAuthenticationKey(ByteBuffer.wrap(key.getEncoded()));
        this.authKey.setCreationDate(creationDate);
        this.authKey.setKeyId(keyId);
        this.authKey.setExpirationDate(expirationDate);
        this.secret = key;
    }

    public int getKeyId() {
        Objects.requireNonNull(this.authKey);
        return this.authKey.getKeyId();
    }

    public long getCreationDate() {
        Objects.requireNonNull(this.authKey);
        return this.authKey.getCreationDate();
    }

    public long getExpirationDate() {
        Objects.requireNonNull(this.authKey);
        return this.authKey.getExpirationDate();
    }

    SecretKey getKey() {
        return this.secret;
    }

    public int hashCode() {
        if (this.authKey == null) {
            return 1;
        }
        HashCodeBuilder hcb = new HashCodeBuilder(29, 31);
        hcb.append(this.authKey.getKeyId()).append(this.authKey.getExpirationDate()).append(this.authKey.getCreationDate()).append(this.secret.getEncoded());
        return hcb.toHashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof AuthenticationKey && Objects.equals(this.authKey, ((AuthenticationKey)obj).authKey);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("AuthenticationKey[");
        if (this.authKey == null) {
            buf.append("null]");
        } else {
            buf.append("id=").append(this.authKey.getKeyId()).append(", expiration=").append(this.authKey.getExpirationDate()).append(", creation=").append(this.authKey.getCreationDate()).append("]");
        }
        return buf.toString();
    }

    public void write(DataOutput out) throws IOException {
        if (this.authKey == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
            return;
        }
        ThriftMessageUtil util = new ThriftMessageUtil();
        ByteBuffer serialized = util.serialize((TBase)this.authKey);
        WritableUtils.writeVInt((DataOutput)out, (int)(serialized.limit() - serialized.arrayOffset()));
        ByteBufferUtil.write((DataOutput)out, (ByteBuffer)serialized);
    }

    public void readFields(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        if (length == 0) {
            return;
        }
        ThriftMessageUtil util = new ThriftMessageUtil();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        this.authKey = (TAuthenticationKey)util.deserialize(bytes, (TBase)new TAuthenticationKey());
        this.secret = AuthenticationTokenSecretManager.createSecretKey(this.authKey.getSecret());
    }
}

