/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.ToDoubleFunction;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.spi.cache.BlockCache;

public class BlockCacheMetrics
implements MetricsProducer {
    BlockCache indexCache;
    BlockCache dataCache;
    BlockCache summaryCache;

    public BlockCacheMetrics(BlockCache indexCache, BlockCache dataCache, BlockCache summaryCache) {
        this.indexCache = indexCache;
        this.dataCache = dataCache;
        this.summaryCache = summaryCache;
    }

    public void registerMetrics(MeterRegistry registry) {
        ToDoubleFunction<BlockCache> getHitCount = cache -> cache.getStats().hitCount();
        ToDoubleFunction<BlockCache> getRequestCount = cache -> cache.getStats().requestCount();
        FunctionCounter.builder((String)"accumulo.blockcache.index.hitcount", (Object)this.indexCache, getHitCount).description("Index block cache hit count").register(registry);
        FunctionCounter.builder((String)"accumulo.blockcache.index.requestcount", (Object)this.indexCache, getRequestCount).description("Index block cache request count").register(registry);
        FunctionCounter.builder((String)"accumulo.blockcache.data.hitcount", (Object)this.dataCache, getHitCount).description("Data block cache hit count").register(registry);
        FunctionCounter.builder((String)"accumulo.blockcache.data.requestcount", (Object)this.dataCache, getRequestCount).description("Data block cache request count").register(registry);
        FunctionCounter.builder((String)"accumulo.blockcache.summary.hitcount", (Object)this.summaryCache, getHitCount).description("Summary block cache hit count").register(registry);
        FunctionCounter.builder((String)"accumulo.blockcache.summary.requestcount", (Object)this.summaryCache, getRequestCount).description("Summary block cache request count").register(registry);
    }
}

