/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.server.replication.WorkAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WorkDriver
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkDriver.class);
    private Manager manager;
    private AccumuloClient client;
    private AccumuloConfiguration conf;
    private WorkAssigner assigner;
    private String assignerImplName;

    public WorkDriver(Manager manager) {
        this.manager = manager;
        this.client = manager.getContext();
        this.conf = manager.getConfiguration();
        this.configureWorkAssigner();
    }

    protected void configureWorkAssigner() {
        String workAssignerClass = this.conf.get(Property.REPLICATION_WORK_ASSIGNER);
        if (this.assigner == null || !this.assigner.getClass().getName().equals(workAssignerClass)) {
            log.info("Initializing work assigner implementation of {}", (Object)workAssignerClass);
            try {
                Class<?> clz = Class.forName(workAssignerClass);
                Class<WorkAssigner> workAssignerClz = clz.asSubclass(WorkAssigner.class);
                this.assigner = workAssignerClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error("Could not instantiate configured work assigner {}", (Object)workAssignerClass, (Object)e);
                throw new RuntimeException(e);
            }
            this.assigner.configure(this.conf, this.client);
            this.assignerImplName = this.assigner.getClass().getName();
        }
    }

    public String getName() {
        return this.assigner.getName();
    }

    @Override
    public void run() {
        log.info("Starting replication work assignment thread using {}", (Object)this.assignerImplName);
        while (this.manager.stillManager()) {
            try {
                this.assigner.assignWork();
            }
            catch (Exception e) {
                log.error("Error while assigning work", (Throwable)e);
            }
            long sleepTime = this.conf.getTimeInMillis(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP);
            log.trace("Sleeping {} ms before next work assignment", (Object)sleepTime);
            UtilWaitThread.sleepUninterruptibly((long)sleepTime, (TimeUnit)TimeUnit.MILLISECONDS);
            this.configureWorkAssigner();
        }
    }
}

