/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import java.util.EnumSet;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.slf4j.LoggerFactory;

class FinishCloneTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final CloneInfo cloneInfo;

    public FinishCloneTable(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) {
        EnumSet<TableState> expectedCurrStates = EnumSet.of(TableState.NEW);
        if (this.cloneInfo.isKeepOffline()) {
            environment.getTableManager().transitionTableState(this.cloneInfo.getTableId(), TableState.OFFLINE, expectedCurrStates);
        } else {
            environment.getTableManager().transitionTableState(this.cloneInfo.getTableId(), TableState.ONLINE, expectedCurrStates);
        }
        Utils.unreserveTable(environment, this.cloneInfo.getTableId(), tid, true);
        Utils.unreserveNamespace(environment, this.cloneInfo.getNamespaceId(), tid, false);
        Utils.unreserveTable(environment, this.cloneInfo.getSrcTableId(), tid, false);
        environment.getEventCoordinator().event("Cloned table %s from %s", this.cloneInfo.getTableName(), this.cloneInfo.getSrcTableId());
        LoggerFactory.getLogger(FinishCloneTable.class).debug("Cloned table " + String.valueOf(this.cloneInfo.getSrcTableId()) + " " + String.valueOf(this.cloneInfo.getTableId()) + " " + this.cloneInfo.getTableName());
        return null;
    }

    @Override
    public void undo(long tid, Manager environment) {
    }
}

