/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.delete;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUp
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(CleanUp.class);
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final NamespaceId namespaceId;
    private long creationTime;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (System.currentTimeMillis() < this.creationTime) {
            this.creationTime = System.currentTimeMillis();
        }
    }

    public CleanUp(TableId tableId, NamespaceId namespaceId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long isReady(long tid, Manager manager) throws Exception {
        if (!manager.hasCycled(this.creationTime)) {
            return 50L;
        }
        boolean done = true;
        Range tableRange = new KeyExtent(this.tableId, null, null).toMetaRange();
        Scanner scanner = manager.getContext().createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((AccumuloConfiguration)manager.getConfiguration(), (ScannerBase)scanner, (CurrentState)manager, (Ample.DataLevel)Ample.DataLevel.of((TableId)this.tableId));
        scanner.setRange(tableRange);
        for (Map.Entry entry : scanner) {
            TabletLocationState locationState = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            TabletState state = locationState.getState(manager.onlineTabletServers());
            if (state.equals((Object)TabletState.UNASSIGNED)) continue;
            log.debug("Still waiting for table({}) to be deleted; Target tablet state: UNASSIGNED, Current tablet state: {}, locationState: {}", new Object[]{this.tableId, state, locationState});
            done = false;
            break;
        }
        if (!done) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) {
        manager.clearMigrations(this.tableId);
        int refCount = 0;
        try {
            ServerContext client = manager.getContext();
            try (BatchScanner bs = client.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 8);){
                Range allTables = MetadataSchema.TabletsSection.getRange();
                Range tableRange = MetadataSchema.TabletsSection.getRange((TableId)this.tableId);
                Range beforeTable = new Range(allTables.getStartKey(), true, tableRange.getStartKey(), false);
                Range afterTable = new Range(tableRange.getEndKey(), false, allTables.getEndKey(), true);
                bs.setRanges(Arrays.asList(beforeTable, afterTable));
                bs.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                IteratorSetting cfg = new IteratorSetting(40, "grep", GrepIterator.class);
                GrepIterator.setTerm((IteratorSetting)cfg, (String)("/" + String.valueOf(this.tableId) + "/"));
                bs.addScanIterator(cfg);
                for (Map.Entry entry : bs) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains("/" + String.valueOf(this.tableId) + "/")) continue;
                    ++refCount;
                }
            }
        }
        catch (Exception e) {
            refCount = -1;
            log.error("Failed to scan " + MetadataTable.NAME + " looking for references to deleted table " + String.valueOf(this.tableId), (Throwable)e);
        }
        try {
            MetadataTableUtil.deleteTable((TableId)this.tableId, (refCount != 0 ? 1 : 0) != 0, (ServerContext)manager.getContext(), null);
        }
        catch (Exception e) {
            log.error("error deleting " + String.valueOf(this.tableId) + " from metadata table", (Throwable)e);
        }
        try {
            ProblemReports.getInstance((ServerContext)manager.getContext()).deleteProblemReports(this.tableId);
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + String.valueOf(this.tableId), (Throwable)e);
        }
        if (refCount == 0) {
            try {
                VolumeManager fs = manager.getVolumeManager();
                for (String dir : manager.getContext().getTablesDirs()) {
                    fs.deleteRecursively(new Path(dir, this.tableId.canonical()));
                }
            }
            catch (IOException e) {
                log.error("Unable to remove deleted table directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.error("Unable to remove deleted table directory", (Throwable)exception);
                }
                throw exception;
            }
        }
        try {
            manager.getTableManager().removeTable(this.tableId);
            manager.getContext().clearTableListCache();
        }
        catch (Exception e) {
            log.error("Failed to find table id in zookeeper", (Throwable)e);
        }
        try {
            manager.getContext().getSecurityOperation().deleteTable(manager.getContext().rpcCreds(), this.tableId, this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveTable(manager, this.tableId, tid, true);
        Utils.unreserveNamespace(manager, this.namespaceId, tid, false);
        LoggerFactory.getLogger(CleanUp.class).debug("Deleted table " + String.valueOf(this.tableId));
        return null;
    }

    @Override
    public void undo(long tid, Manager environment) {
    }
}

