/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.rename;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.slf4j.LoggerFactory;

public class RenameNamespace
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final NamespaceId namespaceId;
    private final String oldName;
    private final String newName;

    @Override
    public long isReady(long id, Manager environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceId, id, true, true, TableOperation.RENAME);
    }

    public RenameNamespace(NamespaceId namespaceId, String oldName, String newName) {
        this.namespaceId = namespaceId;
        this.oldName = oldName;
        this.newName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long id, Manager manager) throws Exception {
        ZooReaderWriter zoo = manager.getContext().getZooReaderWriter();
        Utils.getTableNameLock().lock();
        try {
            Utils.checkNamespaceDoesNotExist(manager.getContext(), this.newName, this.namespaceId, TableOperation.RENAME);
            String tap = manager.getZooKeeperRoot() + "/namespaces/" + String.valueOf(this.namespaceId) + "/name";
            zoo.mutateExisting(tap, current -> {
                String currentName = new String(current, StandardCharsets.UTF_8);
                if (currentName.equals(this.newName)) {
                    return null;
                }
                if (!currentName.equals(this.oldName)) {
                    throw new AcceptableThriftTableOperationException(null, this.oldName, TableOperation.RENAME, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Name changed while processing");
                }
                return this.newName.getBytes(StandardCharsets.UTF_8);
            });
            manager.getContext().clearTableListCache();
        }
        finally {
            Utils.getTableNameLock().unlock();
            Utils.unreserveNamespace(manager, this.namespaceId, id, true);
        }
        LoggerFactory.getLogger(RenameNamespace.class).debug("Renamed namespace {} {} {}", new Object[]{this.namespaceId, this.oldName, this.newName});
        return null;
    }

    @Override
    public void undo(long tid, Manager env) {
        Utils.unreserveNamespace(env, this.namespaceId, tid, true);
    }
}

