/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheEntry;

public class NoopCache
implements BlockCache {
    @Override
    public CacheEntry cacheBlock(String blockName, byte[] buf) {
        return null;
    }

    @Override
    public CacheEntry getBlock(String blockName) {
        return null;
    }

    @Override
    public long getMaxHeapSize() {
        return this.getMaxSize();
    }

    @Override
    public long getMaxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public BlockCache.Stats getStats() {
        return new BlockCache.Stats(){

            @Override
            public long hitCount() {
                return 0L;
            }

            @Override
            public long requestCount() {
                return 0L;
            }
        };
    }

    @Override
    public CacheEntry getBlock(String blockName, BlockCache.Loader loader) {
        Map<String, byte[]> depData;
        Map<String, BlockCache.Loader> depLoaders = loader.getDependencies();
        switch (depLoaders.size()) {
            case 0: {
                depData = Collections.emptyMap();
                break;
            }
            case 1: {
                Map.Entry<String, BlockCache.Loader> entry = depLoaders.entrySet().iterator().next();
                depData = Collections.singletonMap(entry.getKey(), this.getBlock(entry.getKey(), entry.getValue()).getBuffer());
                break;
            }
            default: {
                depData = new HashMap();
                depLoaders.forEach((k, v) -> depData.put((String)k, this.getBlock((String)k, (BlockCache.Loader)v).getBuffer()));
            }
        }
        final byte[] data = loader.load(Integer.MAX_VALUE, depData);
        return new CacheEntry(){

            @Override
            public byte[] getBuffer() {
                return data;
            }

            @Override
            public <T extends CacheEntry.Weighable> T getIndex(Supplier<T> supplier) {
                return null;
            }

            @Override
            public void indexWeightChanged() {
            }
        };
    }
}

