/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.manager.balancer;

import java.util.Objects;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.util.HostAndPort;

public class TabletServerIdImpl
implements TabletServerId {
    private final TServerInstance tServerInstance;

    public static TabletServerIdImpl fromThrift(TServerInstance tsi) {
        return tsi == null ? null : new TabletServerIdImpl(tsi);
    }

    public TabletServerIdImpl(String host, int port, String session) {
        Objects.requireNonNull(host);
        this.tServerInstance = new TServerInstance(HostAndPort.fromParts(host, port), session);
    }

    public TabletServerIdImpl(TServerInstance tServerInstance) {
        this.tServerInstance = Objects.requireNonNull(tServerInstance);
    }

    @Override
    public String getHost() {
        return this.tServerInstance.getHostAndPort().getHost();
    }

    @Override
    public int getPort() {
        return this.tServerInstance.getHostAndPort().getPort();
    }

    @Override
    public String getSession() {
        return this.tServerInstance.getSession();
    }

    @Override
    public int compareTo(TabletServerId o) {
        return this.tServerInstance.compareTo(((TabletServerIdImpl)o).tServerInstance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabletServerIdImpl that = (TabletServerIdImpl)o;
        return this.tServerInstance.equals(that.tServerInstance);
    }

    public int hashCode() {
        return this.tServerInstance.hashCode();
    }

    public String toString() {
        return this.getHost() + ":" + this.getPort() + "[" + this.getSession() + "]";
    }

    public TServerInstance toThrift() {
        return this.tServerInstance;
    }

    public static TServerInstance toThrift(TabletServerId tabletServerId) {
        if (tabletServerId instanceof TabletServerIdImpl) {
            return ((TabletServerIdImpl)tabletServerId).toThrift();
        }
        return new TServerInstance(HostAndPort.fromParts(tabletServerId.getHost(), tabletServerId.getPort()), tabletServerId.getSession());
    }
}

