/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.hadoop.fs.Path;

public class ValidationUtil {
    private static final Pattern VALID_FILE_NAME_MATCH_PATTERN = Pattern.compile("[\\dA-Za-z._-]+");

    public static String validate(String path) {
        Path p = new Path(path);
        return ValidationUtil.validate(p).toString();
    }

    public static ReferenceFile validate(ReferenceFile reference) {
        ValidationUtil.validate(new Path(reference.getMetadataEntry()));
        return reference;
    }

    public static Path validate(Path path) {
        Preconditions.checkArgument((path.toUri().getScheme() != null ? 1 : 0) != 0, (String)"Invalid path provided, no scheme in %s", (Object)path);
        return path;
    }

    public static void validateRFileName(String fileName) {
        Objects.requireNonNull(fileName);
        Preconditions.checkArgument((fileName.endsWith(".rf") || fileName.endsWith("_tmp") ? 1 : 0) != 0, (String)"Provided filename (%s) does not end with '.rf' or '_tmp'", (Object)fileName);
    }

    public static void validateFileName(String fileName) {
        Objects.requireNonNull(fileName);
        Preconditions.checkArgument((boolean)VALID_FILE_NAME_MATCH_PATTERN.matcher(fileName).matches(), (String)"Provided filename (%s) is empty or contains invalid characters", (Object)fileName);
    }
}

