/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.core.spi.scan.ScanPrioritizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintScanPrioritizer
implements ScanPrioritizer {
    private static final Logger log = LoggerFactory.getLogger(HintScanPrioritizer.class);
    private final String PRIO_PREFIX = "priority.";

    private static int getPriority(ScanInfo si, int defaultPriority, HintProblemAction hpa, Map<String, Integer> typePriorities) {
        Integer typePrio;
        String scanType;
        String prio = si.getExecutionHints().get("priority");
        if (prio != null) {
            try {
                return Integer.parseInt(prio);
            }
            catch (NumberFormatException nfe) {
                switch (hpa) {
                    case FAIL: {
                        throw nfe;
                    }
                    case LOG: {
                        log.warn("Unable to parse priority hint {}, falling back to default {}.", (Object)prio, (Object)defaultPriority);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        if (!typePriorities.isEmpty() && (scanType = si.getExecutionHints().get("scan_type")) != null && (typePrio = typePriorities.get(scanType)) != null) {
            return typePrio;
        }
        return defaultPriority;
    }

    @Override
    public Comparator<ScanInfo> createComparator(ScanPrioritizer.CreateParameters params) {
        int defaultPriority = Integer.parseInt(params.getOptions().getOrDefault("default_priority", "2147483647"));
        Map<String, Integer> typePriorities = params.getOptions().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("priority.")).collect(Collectors.toUnmodifiableMap(e -> ((String)e.getKey()).substring("priority.".length()), e -> Integer.parseInt((String)e.getValue())));
        HintProblemAction hpa = HintProblemAction.valueOf(params.getOptions().getOrDefault("bad_hint_action", HintProblemAction.LOG.name()).toUpperCase());
        Comparator<ScanInfo> cmp = Comparator.comparingInt(si -> HintScanPrioritizer.getPriority(si, defaultPriority, hpa, typePriorities));
        return cmp.thenComparingLong(si -> si.getLastRunTime().orElse(0L)).thenComparingLong(ScanInfo::getCreationTime);
    }

    private static enum HintProblemAction {
        NONE,
        LOG,
        FAIL;

    }
}

