/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.spi.compaction.DefaultCompactionPlanner;

public class CompactionServicesConfig {
    private final Map<String, String> planners = new HashMap<String, String>();
    private final Map<String, Long> rateLimits = new HashMap<String, Long>();
    private final Map<String, Map<String, String>> options = new HashMap<String, Map<String, String>>();
    long defaultRateLimit;
    private final Consumer<String> deprecationWarningConsumer;
    public static final CompactionServiceId DEFAULT_SERVICE = CompactionServiceId.of("default");

    private long getDefaultThroughput(AccumuloConfiguration aconf) {
        if (aconf.isPropertySet(Property.TSERV_MAJC_THROUGHPUT)) {
            return aconf.getAsBytes(Property.TSERV_MAJC_THROUGHPUT);
        }
        return ConfigurationTypeHelper.getMemoryAsBytes(Property.TSERV_COMPACTION_SERVICE_DEFAULT_RATE_LIMIT.getDefaultValue());
    }

    private Map<String, String> getConfiguration(AccumuloConfiguration aconf) {
        Map<String, String> configs = aconf.getAllPropertiesWithPrefix(Property.TSERV_COMPACTION_SERVICE_PREFIX);
        if (aconf.isPropertySet(Property.TSERV_MAJC_MAXCONCURRENT)) {
            String defaultServicePrefix = Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + DEFAULT_SERVICE.canonical() + ".";
            boolean defaultServicePropsSet = configs.keySet().stream().filter(key -> key.startsWith(defaultServicePrefix)).map(Property::getPropertyByKey).anyMatch(prop -> prop == null || aconf.isPropertySet((Property)((Object)prop)));
            if (defaultServicePropsSet) {
                String warning = "The deprecated property " + Property.TSERV_MAJC_MAXCONCURRENT.getKey() + " was set. Properties with the prefix " + defaultServicePrefix + " were also set which replace the deprecated properties. The deprecated property was therefore ignored.";
                this.deprecationWarningConsumer.accept(warning);
            } else {
                String numThreads = aconf.get(Property.TSERV_MAJC_MAXCONCURRENT);
                HashMap<String, String> configsCopy = new HashMap<String, String>(configs);
                Map<CallSite, CallSite> defaultServiceConfigs = Map.of(defaultServicePrefix + "planner", DefaultCompactionPlanner.class.getName(), defaultServicePrefix + "planner.opts.executors", "[{'name':'deprecated', 'numThreads':" + numThreads + "}]");
                configsCopy.putAll(defaultServiceConfigs);
                String warning = "The deprecated property " + Property.TSERV_MAJC_MAXCONCURRENT.getKey() + " was set. Properties with the prefix " + defaultServicePrefix + " were not set, these should replace the deprecated properties. The old properties were automatically mapped to the new properties in process creating : " + String.valueOf(defaultServiceConfigs) + ".";
                this.deprecationWarningConsumer.accept(warning);
                configs = Map.copyOf(configsCopy);
            }
        }
        return configs;
    }

    public CompactionServicesConfig(AccumuloConfiguration aconf, Consumer<String> deprecationWarningConsumer) {
        this.deprecationWarningConsumer = deprecationWarningConsumer;
        Map<String, String> configs = this.getConfiguration(aconf);
        configs.forEach((prop, val) -> {
            String suffix = prop.substring(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey().length());
            String[] tokens = suffix.split("\\.");
            if (tokens.length == 4 && tokens[1].equals("planner") && tokens[2].equals("opts")) {
                this.options.computeIfAbsent(tokens[0], k -> new HashMap()).put(tokens[3], val);
            } else if (tokens.length == 2 && tokens[1].equals("planner")) {
                this.planners.put(tokens[0], (String)val);
            } else if (tokens.length == 3 && tokens[1].equals("rate") && tokens[2].equals("limit")) {
                Property eprop = Property.getPropertyByKey(prop);
                if (eprop == null || aconf.isPropertySet(eprop) || !this.isDeprecatedThroughputSet(aconf)) {
                    this.rateLimits.put(tokens[0], ConfigurationTypeHelper.getFixedMemoryAsBytes(val));
                }
            } else {
                throw new IllegalArgumentException("Malformed compaction service property " + prop);
            }
        });
        this.defaultRateLimit = this.getDefaultThroughput(aconf);
        Sets.SetView diff = Sets.difference(this.options.keySet(), this.planners.keySet());
        if (!diff.isEmpty()) {
            throw new IllegalArgumentException("Incomplete compaction service definitions, missing planner class " + String.valueOf(diff));
        }
    }

    private boolean isDeprecatedThroughputSet(AccumuloConfiguration aconf) {
        return aconf.isPropertySet(Property.TSERV_MAJC_THROUGHPUT);
    }

    public long getRateLimit(String serviceName) {
        return this.getRateLimits().getOrDefault(serviceName, this.defaultRateLimit);
    }

    public boolean equals(Object o) {
        if (o instanceof CompactionServicesConfig) {
            CompactionServicesConfig oc = (CompactionServicesConfig)o;
            return this.getPlanners().equals(oc.getPlanners()) && this.getOptions().equals(oc.getOptions()) && this.getRateLimits().equals(oc.getRateLimits());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPlanners(), this.getOptions(), this.getRateLimits());
    }

    public Map<String, String> getPlanners() {
        return this.planners;
    }

    public Map<String, Long> getRateLimits() {
        return this.rateLimits;
    }

    public Map<String, Map<String, String>> getOptions() {
        return this.options;
    }
}

