/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;

public class RunningCompaction {
    private final TExternalCompactionJob job;
    private final String compactorAddress;
    private final String queueName;
    private final Map<Long, TCompactionStatusUpdate> updates = new TreeMap<Long, TCompactionStatusUpdate>();

    public RunningCompaction(TExternalCompactionJob job, String compactorAddress, String queueName) {
        this.job = job;
        this.compactorAddress = compactorAddress;
        this.queueName = queueName;
    }

    public RunningCompaction(TExternalCompaction tEC) {
        this(tEC.getJob(), tEC.getCompactor(), tEC.getQueueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, TCompactionStatusUpdate> getUpdates() {
        Map<Long, TCompactionStatusUpdate> map = this.updates;
        synchronized (map) {
            return new TreeMap<Long, TCompactionStatusUpdate>(this.updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdate(Long timestamp, TCompactionStatusUpdate update2) {
        Map<Long, TCompactionStatusUpdate> map = this.updates;
        synchronized (map) {
            this.updates.put(timestamp, update2);
        }
    }

    public TExternalCompactionJob getJob() {
        return this.job;
    }

    public String getCompactorAddress() {
        return this.compactorAddress;
    }

    public String getQueueName() {
        return this.queueName;
    }
}

