/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.threads;

import java.util.OptionalInt;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.threads.AccumuloUncaughtExceptionHandler;
import org.apache.accumulo.core.util.threads.NamedRunnable;

public class Threads {
    public static final Thread.UncaughtExceptionHandler UEH = new AccumuloUncaughtExceptionHandler();

    public static Runnable createNamedRunnable(String name, Runnable r) {
        return new NamedRunnable(name, r);
    }

    public static Thread createNonCriticalThread(String name, Runnable r) {
        return Threads.createNonCriticalThread(name, OptionalInt.empty(), r, UEH);
    }

    public static Thread createNonCriticalThread(String name, OptionalInt priority, Runnable r) {
        return Threads.createNonCriticalThread(name, priority, r, UEH);
    }

    public static Thread createNonCriticalThread(String name, OptionalInt priority, Runnable r, Thread.UncaughtExceptionHandler ueh) {
        AccumuloDaemonThread thread = new AccumuloDaemonThread(TraceUtil.wrap(r), name, ueh);
        priority.ifPresent(thread::setPriority);
        return thread;
    }

    public static Thread createCriticalThread(String name, Runnable r) {
        return Threads.createCriticalThread(name, OptionalInt.empty(), r);
    }

    public static Thread createCriticalThread(String name, OptionalInt priority, Runnable r) {
        Runnable wrapped = () -> {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                System.err.println("Critical thread " + name + " died");
                e.printStackTrace();
                Runtime.getRuntime().halt(-1);
            }
        };
        return Threads.createNonCriticalThread(name, priority, wrapped);
    }

    public static class AccumuloDaemonThread
    extends Thread {
        public AccumuloDaemonThread(Runnable target, String name, Thread.UncaughtExceptionHandler ueh) {
            super(target, name);
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(ueh);
        }

        public AccumuloDaemonThread(String name) {
            this(name, UEH);
        }

        private AccumuloDaemonThread(String name, Thread.UncaughtExceptionHandler ueh) {
            super(name);
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(ueh);
        }
    }
}

