/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.shell.commands.GrepCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class EGrepCommand
extends GrepCommand {
    private Option matchSubstringOption;

    @Override
    protected void setUpIterator(int prio, String name, String term, BatchScanner scanner, CommandLine cl, boolean negate) throws Exception {
        if (prio < 0) {
            throw new IllegalArgumentException("Priority < 0 " + prio);
        }
        IteratorSetting si = new IteratorSetting(prio, name, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)si, (String)term, (String)term, (String)term, (String)term, (boolean)true, (boolean)cl.hasOption(this.matchSubstringOption.getOpt()));
        RegExFilter.setNegate((IteratorSetting)si, (boolean)negate);
        scanner.addScanIterator(si);
    }

    @Override
    public String description() {
        return "searches each row, column family, column qualifier and value, in parallel, on the server side (using a java Matcher, so put .* before and after your term if you're not matching the whole element)";
    }

    @Override
    public String usage() {
        return this.getName() + " <regex>{ <regex>}";
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.matchSubstringOption = new Option("g", "global", false, "forces the use of the find() expression matcher, causing substring matches to return true");
        opts.addOption(this.matchSubstringOption);
        return opts;
    }
}

