/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import java.util.Locale;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.config.AbstractListenerContainerParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class JmsListenerContainerParser
extends AbstractListenerContainerParser {
    private static final String CONTAINER_TYPE_ATTRIBUTE = "container-type";
    private static final String CONTAINER_CLASS_ATTRIBUTE = "container-class";
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String CACHE_ATTRIBUTE = "cache";
    private static final String RECEIVE_TIMEOUT_ATTRIBUTE = "receive-timeout";
    private static final String RECOVERY_INTERVAL_ATTRIBUTE = "recovery-interval";
    private static final String BACK_OFF_ATTRIBUTE = "back-off";

    JmsListenerContainerParser() {
    }

    @Override
    @Nullable
    protected RootBeanDefinition createContainerFactory(String factoryId, Element containerEle, ParserContext parserContext, PropertyValues commonContainerProperties, PropertyValues specificContainerProperties) {
        RootBeanDefinition factoryDef = new RootBeanDefinition();
        String containerType = containerEle.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
        String containerClass = containerEle.getAttribute(CONTAINER_CLASS_ATTRIBUTE);
        if (StringUtils.hasLength(containerClass)) {
            return null;
        }
        if (!StringUtils.hasLength(containerType) || containerType.startsWith("default")) {
            factoryDef.setBeanClassName("org.springframework.jms.config.DefaultJmsListenerContainerFactory");
        } else if (containerType.startsWith("simple")) {
            factoryDef.setBeanClassName("org.springframework.jms.config.SimpleJmsListenerContainerFactory");
        }
        factoryDef.getPropertyValues().addPropertyValues(commonContainerProperties);
        factoryDef.getPropertyValues().addPropertyValues(specificContainerProperties);
        return factoryDef;
    }

    @Override
    protected RootBeanDefinition createContainer(Element containerEle, Element listenerEle, ParserContext parserContext, PropertyValues commonContainerProperties, PropertyValues specificContainerProperties) {
        RootBeanDefinition containerDef = new RootBeanDefinition();
        containerDef.setSource(parserContext.extractSource(containerEle));
        containerDef.getPropertyValues().addPropertyValues(commonContainerProperties);
        containerDef.getPropertyValues().addPropertyValues(specificContainerProperties);
        String containerType = containerEle.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
        String containerClass = containerEle.getAttribute(CONTAINER_CLASS_ATTRIBUTE);
        if (StringUtils.hasLength(containerClass)) {
            containerDef.setBeanClassName(containerClass);
        } else if (!StringUtils.hasLength(containerType) || containerType.startsWith("default")) {
            containerDef.setBeanClassName("org.springframework.jms.listener.DefaultMessageListenerContainer");
        } else if (containerType.startsWith("simple")) {
            containerDef.setBeanClassName("org.springframework.jms.listener.SimpleMessageListenerContainer");
        } else {
            parserContext.getReaderContext().error("Invalid 'container-type' attribute: only \"default\" and \"simple\" supported.", containerEle);
        }
        this.parseListenerConfiguration(listenerEle, parserContext, containerDef.getPropertyValues());
        return containerDef;
    }

    @Override
    protected MutablePropertyValues parseSpecificContainerProperties(Element containerEle, ParserContext parserContext) {
        String backOffBeanName;
        String receiveTimeout;
        String phase;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        Integer acknowledgeMode;
        String cache;
        String destinationResolverBeanName;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        MutablePropertyValues properties = new MutablePropertyValues();
        boolean isSimpleContainer = containerEle.getAttribute(CONTAINER_TYPE_ATTRIBUTE).startsWith("simple");
        String connectionFactoryBeanName = "connectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", containerEle);
        }
        if (StringUtils.hasText(connectionFactoryBeanName)) {
            properties.add("connectionFactory", new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (StringUtils.hasText(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE))) {
            properties.add("taskExecutor", new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE))) {
            properties.add("errorHandler", new RuntimeBeanReference(errorHandlerBeanName));
        }
        if (StringUtils.hasText(destinationResolverBeanName = containerEle.getAttribute("destination-resolver"))) {
            properties.add("destinationResolver", new RuntimeBeanReference(destinationResolverBeanName));
        }
        if (StringUtils.hasText(cache = containerEle.getAttribute(CACHE_ATTRIBUTE))) {
            if (isSimpleContainer) {
                if (!"auto".equals(cache) && !"consumer".equals(cache)) {
                    parserContext.getReaderContext().warning("'cache' attribute not actively supported for listener container of type \"simple\". Effective runtime behavior will be equivalent to \"consumer\" / \"auto\".", containerEle);
                }
            } else {
                properties.add("cacheLevelName", "CACHE_" + cache.toUpperCase(Locale.ROOT));
            }
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            if (acknowledgeMode == 0) {
                properties.add("sessionTransacted", Boolean.TRUE);
            } else {
                properties.add("sessionAcknowledgeMode", acknowledgeMode);
            }
        }
        if (StringUtils.hasText(transactionManagerBeanName = containerEle.getAttribute("transaction-manager"))) {
            if (isSimpleContainer) {
                parserContext.getReaderContext().error("'transaction-manager' attribute not supported for listener container of type \"simple\".", containerEle);
            } else {
                properties.add("transactionManager", new RuntimeBeanReference(transactionManagerBeanName));
            }
        }
        if (StringUtils.hasText(concurrency = containerEle.getAttribute("concurrency"))) {
            properties.add("concurrency", concurrency);
        }
        if (StringUtils.hasText(prefetch = containerEle.getAttribute("prefetch")) && !isSimpleContainer) {
            properties.add("maxMessagesPerTask", prefetch);
        }
        if (StringUtils.hasText(phase = containerEle.getAttribute("phase"))) {
            properties.add("phase", phase);
        }
        if (StringUtils.hasText(receiveTimeout = containerEle.getAttribute(RECEIVE_TIMEOUT_ATTRIBUTE)) && !isSimpleContainer) {
            properties.add("receiveTimeout", receiveTimeout);
        }
        if (StringUtils.hasText(backOffBeanName = containerEle.getAttribute(BACK_OFF_ATTRIBUTE))) {
            if (!isSimpleContainer) {
                properties.add("backOff", new RuntimeBeanReference(backOffBeanName));
            }
        } else {
            String recoveryInterval = containerEle.getAttribute(RECOVERY_INTERVAL_ATTRIBUTE);
            if (StringUtils.hasText(recoveryInterval) && !isSimpleContainer) {
                properties.add("recoveryInterval", recoveryInterval);
            }
        }
        return properties;
    }
}

