/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Session;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.reply.ReplyManager;

public class UseMessageIdAsCorrelationIdMessageSentCallback
implements MessageSentCallback {
    private final ReplyManager replyManager;
    private final String correlationId;
    private final long requestTimeout;

    public UseMessageIdAsCorrelationIdMessageSentCallback(ReplyManager replyManager, String correlationId, long requestTimeout) {
        this.replyManager = replyManager;
        this.correlationId = correlationId;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void sent(Session session, Message message, Destination destination) {
        String newCorrelationID = JmsMessageHelper.getJMSMessageID(message);
        if (newCorrelationID != null) {
            this.replyManager.updateCorrelationId(this.correlationId, newCorrelationID, this.requestTimeout);
        }
    }
}

