/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.Arrays;
import java.util.List;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoQueue;
import org.apache.activemq.schema.core.DtoTopic;

public class DestinationsProcessor
extends DefaultConfigurationProcessor {
    public DestinationsProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void processChanges(List current, List modified) {
        for (Object destinations : modified) {
            for (Object dto : this.getContents(destinations)) {
                try {
                    ActiveMQDestination destination = this.createDestination(dto);
                    if (this.containsDestination(destination)) continue;
                    this.plugin.addDestination(this.plugin.getBrokerService().getAdminConnectionContext(), destination, true);
                    this.plugin.info("Added destination " + String.valueOf(destination));
                }
                catch (Exception e) {
                    this.plugin.info("Failed to add a new destination for DTO: " + String.valueOf(dto), e);
                }
            }
        }
    }

    protected boolean containsDestination(ActiveMQDestination destination) throws Exception {
        return Arrays.asList(this.plugin.getBrokerService().getRegionBroker().getDestinations()).contains(destination);
    }

    @Override
    public void addNew(Object o) {
        try {
            ActiveMQDestination destination = this.createDestination(o);
            this.plugin.addDestination(this.plugin.getBrokerService().getAdminConnectionContext(), destination, true);
            this.plugin.info("Added destination " + String.valueOf(destination));
        }
        catch (Exception e) {
            this.plugin.info("Failed to add a new destination for DTO: " + String.valueOf(o), e);
        }
    }

    private ActiveMQDestination createDestination(Object dto) throws Exception {
        if (dto instanceof DtoQueue) {
            return new ActiveMQQueue(((DtoQueue)dto).getPhysicalName());
        }
        if (dto instanceof DtoTopic) {
            return new ActiveMQTopic(((DtoTopic)dto).getPhysicalName());
        }
        throw new Exception("Unknown destination type for DTO " + String.valueOf(dto));
    }
}

