/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import java.security.MessageDigest;
import java.util.Objects;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.crypto.hash.format.DefaultHashFormatFactory;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.HashFormatFactory;
import org.apache.shiro.crypto.hash.format.ParsableHashFormat;
import org.apache.shiro.crypto.hash.format.Shiro2CryptFormat;
import org.apache.shiro.lang.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPasswordService
implements HashingPasswordService {
    public static final String DEFAULT_HASH_ALGORITHM = "argon2id";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordService.class);
    private HashService hashService;
    private HashFormat hashFormat;
    private HashFormatFactory hashFormatFactory;
    private volatile boolean hashFormatWarned = false;

    public DefaultPasswordService() {
        DefaultHashService hashService = new DefaultHashService();
        hashService.setDefaultAlgorithmName(DEFAULT_HASH_ALGORITHM);
        this.hashService = hashService;
        this.hashFormat = new Shiro2CryptFormat();
        this.hashFormatFactory = new DefaultHashFormatFactory();
    }

    @Override
    public String encryptPassword(Object plaintext) {
        Hash hash = this.hashPassword(Objects.requireNonNull(plaintext));
        this.checkHashFormatDurability();
        return this.hashFormat.format(hash);
    }

    @Override
    public Hash hashPassword(Object plaintext) {
        ByteSource plaintextBytes = this.createByteSource(plaintext);
        if (plaintextBytes == null || plaintextBytes.isEmpty()) {
            return null;
        }
        HashRequest request = this.createHashRequest(plaintextBytes);
        return this.hashService.computeHash(request);
    }

    @Override
    public boolean passwordsMatch(Object plaintext, Hash saved) {
        ByteSource plaintextBytes = this.createByteSource(plaintext);
        if (saved == null || saved.isEmpty()) {
            return plaintextBytes == null || plaintextBytes.isEmpty();
        }
        if (plaintextBytes == null || plaintextBytes.isEmpty()) {
            return false;
        }
        return saved.matchesPassword(plaintextBytes);
    }

    private boolean constantEquals(String savedHash, String computedHash) {
        byte[] savedHashByteArray = savedHash.getBytes();
        byte[] computedHashByteArray = computedHash.getBytes();
        return MessageDigest.isEqual(savedHashByteArray, computedHashByteArray);
    }

    protected void checkHashFormatDurability() {
        HashFormat format;
        if (!this.hashFormatWarned && !((format = this.hashFormat) instanceof ParsableHashFormat) && LOGGER.isWarnEnabled()) {
            String msg = "The configured hashFormat instance [" + format.getClass().getName() + "] is not a " + ParsableHashFormat.class.getName() + " implementation.  This is required if you wish to support backwards compatibility for saved password checking (almost always desirable).  Without a " + ParsableHashFormat.class.getSimpleName() + " instance, any hashService configuration changes will break previously hashed/saved passwords.";
            LOGGER.warn(msg);
            this.hashFormatWarned = true;
        }
    }

    protected HashRequest createHashRequest(ByteSource plaintext) {
        return new HashRequest.Builder().setSource(plaintext).setAlgorithmName(this.getHashService().getDefaultAlgorithmName()).build();
    }

    protected ByteSource createByteSource(Object o) {
        return ByteSource.Util.bytes((Object)o);
    }

    @Override
    public boolean passwordsMatch(Object submittedPlaintext, String saved) {
        ByteSource plaintextBytes = this.createByteSource(submittedPlaintext);
        if (saved == null || saved.length() == 0) {
            return plaintextBytes == null || plaintextBytes.isEmpty();
        }
        if (plaintextBytes == null || plaintextBytes.isEmpty()) {
            return false;
        }
        HashFormat discoveredFormat = this.hashFormatFactory.getInstance(saved);
        if (discoveredFormat instanceof ParsableHashFormat) {
            ParsableHashFormat parsableHashFormat = (ParsableHashFormat)discoveredFormat;
            Hash savedHash = parsableHashFormat.parse(saved);
            return this.passwordsMatch(submittedPlaintext, savedHash);
        }
        HashRequest request = this.createHashRequest(plaintextBytes);
        Hash computed = this.hashService.computeHash(request);
        String formatted = this.hashFormat.format(computed);
        return this.constantEquals(saved, formatted);
    }

    public HashService getHashService() {
        return this.hashService;
    }

    public void setHashService(HashService hashService) {
        this.hashService = hashService;
    }

    public HashFormat getHashFormat() {
        return this.hashFormat;
    }

    public void setHashFormat(HashFormat hashFormat) {
        this.hashFormat = hashFormat;
    }

    public HashFormatFactory getHashFormatFactory() {
        return this.hashFormatFactory;
    }

    public void setHashFormatFactory(HashFormatFactory hashFormatFactory) {
        this.hashFormatFactory = hashFormatFactory;
    }
}

