/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.DeleteDefinition;
import org.apache.camel.model.rest.GetDefinition;
import org.apache.camel.model.rest.HeadDefinition;
import org.apache.camel.model.rest.OpenApiDefinition;
import org.apache.camel.model.rest.ParamDefinition;
import org.apache.camel.model.rest.PatchDefinition;
import org.apache.camel.model.rest.PostDefinition;
import org.apache.camel.model.rest.PutDefinition;
import org.apache.camel.model.rest.ResponseHeaderDefinition;
import org.apache.camel.model.rest.ResponseMessageDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Metadata(label="rest")
@XmlRootElement(name="rest")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestDefinition
extends OptionalIdentifiedDefinition<RestDefinition>
implements ResourceAware {
    public static final String MISSING_VERB = "Must add verb first, such as get/post/delete";
    @XmlAttribute
    private String path;
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String disabled;
    @XmlAttribute
    @Metadata(defaultValue="off", enums="off,auto,json,xml,json_xml")
    private String bindingMode;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String skipBindingOnErrorCode;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String clientRequestValidation;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String clientResponseValidation;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String enableCORS;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String enableNoContentResponse;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String apiDocs;
    @XmlAttribute
    @Metadata(label="advanced")
    private String tag;
    @XmlElement
    private OpenApiDefinition openApi;
    @XmlElement(name="securityDefinitions")
    @Metadata(label="security")
    private RestSecuritiesDefinition securityDefinitions;
    @XmlElement
    @Metadata(label="security")
    private List<SecurityDefinition> securityRequirements = new ArrayList<SecurityDefinition>();
    @XmlElementRef
    private List<VerbDefinition> verbs = new ArrayList<VerbDefinition>();
    @XmlTransient
    private Resource resource;

    public String getShortName() {
        return "rest";
    }

    public String getLabel() {
        return "rest";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(String bindingMode) {
        this.bindingMode = bindingMode;
    }

    public List<VerbDefinition> getVerbs() {
        return this.verbs;
    }

    public RestSecuritiesDefinition getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(RestSecuritiesDefinition securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public List<SecurityDefinition> getSecurityRequirements() {
        return this.securityRequirements;
    }

    public void setSecurityRequirements(List<SecurityDefinition> securityRequirements) {
        this.securityRequirements = securityRequirements;
    }

    public void setVerbs(List<VerbDefinition> verbs) {
        this.verbs = verbs;
    }

    public String getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(String skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(String clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public String getClientResponseValidation() {
        return this.clientResponseValidation;
    }

    public void setClientResponseValidation(String clientResponseValidation) {
        this.clientResponseValidation = clientResponseValidation;
    }

    public String getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(String enableCORS) {
        this.enableCORS = enableCORS;
    }

    public String getEnableNoContentResponse() {
        return this.enableNoContentResponse;
    }

    public void setEnableNoContentResponse(String enableNoContentResponse) {
        this.enableNoContentResponse = enableNoContentResponse;
    }

    public String getApiDocs() {
        return this.apiDocs;
    }

    public void setApiDocs(String apiDocs) {
        this.apiDocs = apiDocs;
    }

    public OpenApiDefinition getOpenApi() {
        return this.openApi;
    }

    public void setOpenApi(OpenApiDefinition openApi) {
        this.openApi = openApi;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public OpenApiDefinition openApi() {
        this.openApi = new OpenApiDefinition();
        this.openApi.setRest(this);
        return this.openApi;
    }

    public RestDefinition openApi(String specification) {
        this.openApi = new OpenApiDefinition();
        this.openApi.setRest(this);
        this.openApi.specification(specification);
        return this;
    }

    public RestDefinition path(String path) {
        this.setPath(path);
        return this;
    }

    public RestDefinition disabled() {
        this.disabled("true");
        return this;
    }

    public RestDefinition disabled(boolean disabled) {
        this.disabled(disabled ? "true" : "false");
        return this;
    }

    public RestDefinition disabled(String disabled) {
        if (this.getVerbs().isEmpty()) {
            this.disabled = disabled;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setDisabled(disabled);
        }
        return this;
    }

    public RestDefinition tag(String tag) {
        this.setTag(tag);
        return this;
    }

    public RestDefinition get() {
        return this.addVerb("get", null);
    }

    public RestDefinition get(String uri) {
        return this.addVerb("get", uri);
    }

    public RestDefinition post() {
        return this.addVerb("post", null);
    }

    public RestDefinition post(String uri) {
        return this.addVerb("post", uri);
    }

    public RestDefinition put() {
        return this.addVerb("put", null);
    }

    public RestDefinition put(String uri) {
        return this.addVerb("put", uri);
    }

    public RestDefinition patch() {
        return this.addVerb("patch", null);
    }

    public RestDefinition patch(String uri) {
        return this.addVerb("patch", uri);
    }

    public RestDefinition delete() {
        return this.addVerb("delete", null);
    }

    public RestDefinition delete(String uri) {
        return this.addVerb("delete", uri);
    }

    public RestDefinition head() {
        return this.addVerb("head", null);
    }

    public RestDefinition head(String uri) {
        return this.addVerb("head", uri);
    }

    public RestDefinition verb(String verb) {
        return this.addVerb(verb, null);
    }

    public RestDefinition verb(String verb, String uri) {
        return this.addVerb(verb, uri);
    }

    @Override
    public RestDefinition id(String id) {
        if (this.getVerbs().isEmpty()) {
            super.id(id);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.id(id);
        }
        return this;
    }

    public RestDefinition routeId(String routeId) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setRouteId(routeId);
        return this;
    }

    public RestDefinition deprecated() {
        if (!this.getVerbs().isEmpty()) {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setDeprecated("true");
        }
        return this;
    }

    @Override
    public RestDefinition description(String description) {
        if (this.getVerbs().isEmpty()) {
            super.description(description);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(description);
        }
        return this;
    }

    public RestDefinition consumes(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.consumes = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setConsumes(mediaType);
        }
        return this;
    }

    public ParamDefinition param() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.param(verb);
    }

    public RestDefinition param(ParamDefinition param) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().add(param);
        return this;
    }

    public RestDefinition params(List<ParamDefinition> params) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().addAll(params);
        return this;
    }

    public ParamDefinition param(VerbDefinition verb) {
        return new ParamDefinition(verb);
    }

    public RestDefinition responseMessage(ResponseMessageDefinition msg) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().add(msg);
        return this;
    }

    public ResponseMessageDefinition responseMessage() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.responseMessage(verb);
    }

    public ResponseMessageDefinition responseMessage(VerbDefinition verb) {
        return new ResponseMessageDefinition(verb);
    }

    public RestDefinition responseMessages(List<ResponseMessageDefinition> msgs) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().addAll(msgs);
        return this;
    }

    public RestDefinition responseMessage(int code, String message) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        ResponseMessageDefinition msg = this.responseMessage(verb);
        msg.setCode(String.valueOf(code));
        msg.setMessage(message);
        return this;
    }

    public RestDefinition responseMessage(String code, String message) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        ResponseMessageDefinition response = this.responseMessage(verb);
        response.setCode(code);
        response.setMessage(message);
        verb.getResponseMsgs().add(response);
        return this;
    }

    public RestSecuritiesDefinition securityDefinitions() {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new RestSecuritiesDefinition(this);
        }
        return this.securityDefinitions;
    }

    public RestDefinition produces(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.produces = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setProduces(mediaType);
        }
        return this;
    }

    public RestDefinition type(String classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setType(classType);
        return this;
    }

    public RestDefinition type(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTypeClass(classType);
        verb.setType(this.asTypeName(classType));
        return this;
    }

    public RestDefinition outType(String classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutType(classType);
        return this;
    }

    public RestDefinition outType(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutTypeClass(classType);
        verb.setOutType(this.asTypeName(classType));
        return this;
    }

    public RestDefinition bindingMode(RestBindingMode mode) {
        return this.bindingMode(mode.name());
    }

    public RestDefinition bindingMode(String mode) {
        if (this.getVerbs().isEmpty()) {
            this.bindingMode = mode.toLowerCase();
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setBindingMode(mode.toLowerCase());
        }
        return this;
    }

    public RestDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        if (this.getVerbs().isEmpty()) {
            this.skipBindingOnErrorCode = Boolean.toString(skipBindingOnErrorCode);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setSkipBindingOnErrorCode(Boolean.toString(skipBindingOnErrorCode));
        }
        return this;
    }

    public RestDefinition clientRequestValidation(boolean clientRequestValidation) {
        if (this.getVerbs().isEmpty()) {
            this.clientRequestValidation = Boolean.toString(clientRequestValidation);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setClientRequestValidation(Boolean.toString(clientRequestValidation));
        }
        return this;
    }

    public RestDefinition clientResponseValidation(boolean clientResponseValidation) {
        if (this.getVerbs().isEmpty()) {
            this.clientResponseValidation = Boolean.toString(clientResponseValidation);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setClientResponseValidation(Boolean.toString(clientResponseValidation));
        }
        return this;
    }

    public RestDefinition enableCORS(boolean enableCORS) {
        if (this.getVerbs().isEmpty()) {
            this.enableCORS = Boolean.toString(enableCORS);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setEnableCORS(Boolean.toString(enableCORS));
        }
        return this;
    }

    public RestDefinition enableNoContentResponse(boolean enableNoContentResponse) {
        if (this.getVerbs().isEmpty()) {
            this.enableNoContentResponse = Boolean.toString(enableNoContentResponse);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setEnableNoContentResponse(Boolean.toString(enableNoContentResponse));
        }
        return this;
    }

    public RestDefinition apiDocs(Boolean apiDocs) {
        if (this.getVerbs().isEmpty()) {
            this.apiDocs = apiDocs != null ? apiDocs.toString() : null;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setApiDocs(apiDocs != null ? apiDocs.toString() : null);
        }
        return this;
    }

    public RestDefinition security(String key) {
        return this.security(key, null);
    }

    public RestDefinition security(String key, String scopes) {
        if (this.getVerbs().isEmpty()) {
            SecurityDefinition requirement = this.securityRequirements.stream().filter(r -> key.equals(r.getKey())).findFirst().orElse(null);
            if (requirement == null) {
                requirement = new SecurityDefinition();
                this.securityRequirements.add(requirement);
                requirement.setKey(key);
            }
            requirement.setScopes(scopes);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            SecurityDefinition sd = new SecurityDefinition();
            sd.setKey(key);
            sd.setScopes(scopes);
            verb.getSecurity().add(sd);
        }
        return this;
    }

    public RestDefinition to(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        ToDefinition to = new ToDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public RestDefinition to(Endpoint endpoint) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        ToDefinition to = new ToDefinition(endpoint);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public RestDefinition to(@AsEndpointUri EndpointProducerBuilder endpoint) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException(MISSING_VERB);
        }
        ToDefinition to = new ToDefinition(endpoint);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public String buildFromUri(CamelContext camelContext, VerbDefinition verb) {
        return "rest:" + verb.asVerb() + ":" + this.buildUri(camelContext, verb);
    }

    public String buildFromUri(CamelContext camelContext, OpenApiDefinition openApi) {
        return "rest-openapi:" + CamelContextHelper.parseText((CamelContext)camelContext, (String)openApi.getSpecification());
    }

    private RestDefinition addVerb(String verb, String uri) {
        VerbDefinition answer;
        if ("get".equals(verb)) {
            answer = new GetDefinition();
        } else if ("post".equals(verb)) {
            answer = new PostDefinition();
        } else if ("delete".equals(verb)) {
            answer = new DeleteDefinition();
        } else if ("head".equals(verb)) {
            answer = new HeadDefinition();
        } else if ("put".equals(verb)) {
            answer = new PutDefinition();
        } else if ("patch".equals(verb)) {
            answer = new PatchDefinition();
        } else {
            throw new IllegalArgumentException("Verb " + verb + " not supported");
        }
        this.getVerbs().add(answer);
        answer.setRest(this);
        answer.setPath(uri);
        return this;
    }

    public List<RouteDefinition> asRouteDefinition(CamelContext camelContext) {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        Boolean disabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)this.disabled);
        if (disabled != null && disabled.booleanValue()) {
            return answer;
        }
        ArrayList<VerbDefinition> filter = new ArrayList<VerbDefinition>();
        for (VerbDefinition verb : this.verbs) {
            disabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)verb.getDisabled());
            if (disabled != null && disabled.booleanValue()) continue;
            filter.add(verb);
        }
        if (this.openApi != null && (disabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)this.openApi.getDisabled())) != null && disabled.booleanValue()) {
            this.openApi = null;
        }
        if (!filter.isEmpty() && this.openApi != null) {
            throw new IllegalArgumentException("Cannot have both code-first and contract-first in Rest DSL");
        }
        this.validateUniquePaths(filter);
        RestConfiguration config = camelContext.getRestConfiguration();
        if (config.isInlineRoutes()) {
            this.validateUniqueDirects(filter);
        }
        if (!filter.isEmpty()) {
            this.addRouteDefinition(camelContext, filter, answer, config.getComponent(), config.getProducerComponent());
        }
        if (this.openApi != null) {
            this.addRouteDefinition(camelContext, this.openApi, answer, config.getComponent(), config.getProducerComponent(), config.getApiContextPath(), config.isClientRequestValidation(), config.isClientResponseValidation());
        }
        return answer;
    }

    protected void validateUniquePaths(List<VerbDefinition> verbs) {
        HashSet<String> paths = new HashSet<String>();
        for (VerbDefinition verb : verbs) {
            Object path = verb.asVerb();
            if (verb.getPath() != null) {
                path = (String)path + ":" + verb.getPath();
            }
            if (paths.add((String)path)) continue;
            throw new IllegalArgumentException("Duplicate verb detected in rest-dsl: " + (String)path);
        }
    }

    protected void validateUniqueDirects(List<VerbDefinition> verbs) {
        HashSet<String> directs = new HashSet<String>();
        for (VerbDefinition verb : verbs) {
            String uri;
            ToDefinition to = verb.getTo();
            if (to == null || !(uri = to.getEndpointUri()).startsWith("direct:") || directs.add(uri)) continue;
            throw new IllegalArgumentException("Duplicate to in rest-dsl: " + uri);
        }
    }

    protected String asTypeName(Class<?> classType) {
        Object type = classType.isArray() ? classType.getComponentType().getName() + "[]" : classType.getName();
        return type;
    }

    public static RouteDefinition asRouteApiDefinition(CamelContext camelContext, RestConfiguration configuration) {
        RouteDefinition answer = new RouteDefinition();
        Object from = "rest-api:" + configuration.getApiContextPath();
        String routeId = configuration.getApiContextRouteId();
        if (routeId == null) {
            routeId = answer.idOrCreate((NodeIdFactory)camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
        }
        HashMap<String, String> options = new HashMap<String, String>();
        if (configuration.getComponent() != null && !configuration.getComponent().isEmpty()) {
            options.put("consumerComponentName", configuration.getComponent());
        }
        if (!options.isEmpty()) {
            try {
                from = URISupport.appendParametersToURI((String)from, options);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        String to = from;
        answer.fromRest((String)from);
        answer.id(routeId);
        answer.to(to);
        return answer;
    }

    private void addRouteDefinition(CamelContext camelContext, OpenApiDefinition openApi, List<RouteDefinition> answer, String component, String producerComponent, String apiContextPath, boolean clientRequestValidation, boolean clientResponseValidation) {
        String description;
        RouteDefinition route = new RouteDefinition();
        if (openApi.getRouteId() != null) {
            route.routeId(CamelContextHelper.parseText((CamelContext)camelContext, (String)openApi.getRouteId()));
        }
        route.getOutputs().add(new StopDefinition());
        if (this.getClientRequestValidation() != null) {
            clientRequestValidation = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)this.getClientRequestValidation());
        }
        if (this.getClientResponseValidation() != null) {
            clientResponseValidation = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)this.getClientResponseValidation());
        }
        RestBindingDefinition binding = this.getRestBindingDefinition(camelContext, component, clientRequestValidation, clientResponseValidation);
        route.setRestBindingDefinition(binding);
        HashMap<String, String> options = new HashMap<String, String>();
        if (binding.getConsumes() != null) {
            options.put("consumes", CamelContextHelper.parseText((CamelContext)camelContext, (String)binding.getConsumes()));
        }
        if (binding.getProduces() != null) {
            options.put("produces", CamelContextHelper.parseText((CamelContext)camelContext, (String)binding.getProduces()));
        }
        if (clientRequestValidation) {
            options.put("clientRequestValidation", "true");
        }
        if (clientResponseValidation) {
            options.put("clientResponseValidation", "true");
        }
        if (openApi.getMissingOperation() != null) {
            options.put("missingOperation", CamelContextHelper.parseText((CamelContext)camelContext, (String)openApi.getMissingOperation()));
        }
        if (openApi.getMockIncludePattern() != null) {
            options.put("mockIncludePattern", CamelContextHelper.parseText((CamelContext)camelContext, (String)openApi.getMockIncludePattern()));
        }
        if (openApi.getApiContextPath() != null) {
            options.put("apiContextPath", CamelContextHelper.parseText((CamelContext)camelContext, (String)openApi.getApiContextPath()));
        }
        if ((description = openApi.getDescription()) == null) {
            description = this.getDescriptionText();
        }
        if (description != null) {
            options.put("description", CamelContextHelper.parseText((CamelContext)camelContext, (String)description));
        }
        String from = this.buildFromUri(camelContext, openApi);
        if (!options.isEmpty()) {
            try {
                from = URISupport.appendParametersToURI((String)from, options);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        route.fromRest(from);
        route.setRestDefinition(this);
        answer.add(route);
    }

    private RestBindingDefinition getRestBindingDefinition(CamelContext camelContext, String component, boolean clientRequestValidation, boolean clientResponseValidation) {
        String mode = this.getBindingMode();
        if (mode == null) {
            mode = camelContext.getRestConfiguration().getBindingMode().name();
        }
        RestBindingDefinition binding = new RestBindingDefinition();
        binding.setComponent(component);
        if ("json".equals(mode)) {
            binding.setConsumes("application/json");
            binding.setProduces("application/json");
        } else if ("xml".equals(mode)) {
            binding.setConsumes("application/xml");
            binding.setProduces("application/xml");
        } else if ("json_xml".equals(mode)) {
            binding.setConsumes("application/json;application/xml");
            binding.setProduces("application/json;application/xml");
        }
        binding.setBindingMode(mode);
        binding.setSkipBindingOnErrorCode(this.getSkipBindingOnErrorCode());
        if (clientRequestValidation) {
            binding.setClientRequestValidation("true");
        }
        if (clientResponseValidation) {
            binding.setClientResponseValidation("true");
        }
        binding.setEnableCORS(this.getEnableCORS());
        binding.setEnableNoContentResponse(this.getEnableNoContentResponse());
        return binding;
    }

    private void addRouteDefinition(CamelContext camelContext, List<VerbDefinition> verbs, List<RouteDefinition> answer, String component, String producerComponent) {
        for (VerbDefinition verb : verbs) {
            String description;
            String outType;
            String inType;
            RouteDefinition route = new RouteDefinition();
            if (verb.getTo() == null) {
                throw new IllegalArgumentException("Rest service: " + String.valueOf(verb) + " must have to endpoint configured.");
            }
            if (verb.getRouteId() != null) {
                route.routeId(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getRouteId()));
            }
            if (verb.getStreamCache() != null) {
                route.streamCache(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getStreamCache()));
            }
            route.getOutputs().add(verb.getTo());
            RestBindingDefinition binding = new RestBindingDefinition();
            binding.setComponent(component);
            binding.setType(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getType()));
            binding.setTypeClass(verb.getTypeClass());
            binding.setOutType(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getOutType()));
            binding.setOutTypeClass(verb.getOutTypeClass());
            if (verb.getBindingMode() != null) {
                binding.setBindingMode(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getBindingMode()));
            } else {
                binding.setBindingMode(this.getBindingMode());
            }
            if (verb.getConsumes() != null) {
                binding.setConsumes(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getConsumes()));
            } else {
                binding.setConsumes(this.getConsumes());
            }
            if (verb.getProduces() != null) {
                binding.setProduces(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getProduces()));
            } else {
                binding.setProduces(this.getProduces());
            }
            if (binding.getType() != null || binding.getOutType() != null && binding.getBindingMode() != null) {
                String mode = binding.getBindingMode();
                if ("json".equals(mode)) {
                    if (binding.getConsumes() == null && binding.getType() != null) {
                        binding.setConsumes("application/json");
                    }
                    if (binding.getProduces() == null && binding.getOutType() != null) {
                        binding.setProduces("application/json");
                    }
                } else if ("xml".equals(mode)) {
                    if (binding.getConsumes() == null && binding.getType() != null) {
                        binding.setConsumes("application/xml");
                    }
                    if (binding.getProduces() == null && binding.getOutType() != null) {
                        binding.setProduces("application/xml");
                    }
                } else if ("json_xml".equals(mode)) {
                    if (binding.getConsumes() == null && binding.getType() != null) {
                        binding.setConsumes("application/json;application/xml");
                    }
                    if (binding.getProduces() == null && binding.getOutType() != null) {
                        binding.setProduces("application/json;application/xml");
                    }
                }
            }
            if (verb.getSkipBindingOnErrorCode() != null) {
                binding.setSkipBindingOnErrorCode(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getSkipBindingOnErrorCode()));
            } else {
                binding.setSkipBindingOnErrorCode(this.getSkipBindingOnErrorCode());
            }
            if (verb.getClientRequestValidation() != null) {
                binding.setClientRequestValidation(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getClientRequestValidation()));
            } else {
                binding.setClientRequestValidation(this.getClientRequestValidation());
            }
            if (verb.getClientResponseValidation() != null) {
                binding.setClientResponseValidation(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getClientResponseValidation()));
            } else {
                binding.setClientResponseValidation(this.getClientResponseValidation());
            }
            if (verb.getEnableCORS() != null) {
                binding.setEnableCORS(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getEnableCORS()));
            } else {
                binding.setEnableCORS(this.getEnableCORS());
            }
            if (verb.getEnableNoContentResponse() != null) {
                binding.setEnableNoContentResponse(CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getEnableNoContentResponse()));
            } else {
                binding.setEnableNoContentResponse(this.getEnableNoContentResponse());
            }
            for (ParamDefinition param : verb.getParams()) {
                Boolean required;
                RestParamType type = param.getType();
                String name = CamelContextHelper.parseText((CamelContext)camelContext, (String)param.getName());
                if ((RestParamType.query == type || RestParamType.header == type) && ObjectHelper.isNotEmpty((String)param.getDefaultValue())) {
                    binding.addDefaultValue(name, CamelContextHelper.parseText((CamelContext)camelContext, (String)param.getDefaultValue()));
                }
                if ((RestParamType.query == type || RestParamType.header == type) && param.getAllowableValues() != null) {
                    binding.addAllowedValue(name, CamelContextHelper.parseText((CamelContext)camelContext, (String)param.getAllowableValuesAsCommaString()));
                }
                if ((required = param.getRequired()) == null || !required.booleanValue()) continue;
                if (RestParamType.query == type) {
                    binding.addRequiredQueryParameter(name);
                    continue;
                }
                if (RestParamType.header == type) {
                    binding.addRequiredHeader(name);
                    continue;
                }
                if (RestParamType.body != type) continue;
                binding.setRequiredBody(true);
            }
            for (ResponseMessageDefinition rm : verb.getResponseMsgs()) {
                binding.addResponseCode(rm.getCode(), rm.getContentType());
                if (rm.getHeaders() == null) continue;
                for (ResponseHeaderDefinition header : rm.getHeaders()) {
                    String name = CamelContextHelper.parseText((CamelContext)camelContext, (String)header.getName());
                    binding.addResponseHeader(name);
                }
            }
            route.setRestBindingDefinition(binding);
            HashMap<String, String> options = new HashMap<String, String>();
            if (binding.getConsumes() != null) {
                options.put("consumes", binding.getConsumes());
            }
            if (binding.getProduces() != null) {
                options.put("produces", binding.getProduces());
            }
            if ((inType = binding.getType()) != null) {
                options.put("inType", inType);
            }
            if ((outType = binding.getOutType()) != null) {
                options.put("outType", outType);
            }
            if (component != null && !component.isEmpty()) {
                options.put("consumerComponentName", component);
            }
            if (producerComponent != null && !producerComponent.isEmpty()) {
                options.put("producerComponentName", producerComponent);
            }
            if ((description = this.getDescription(verb, route)) != null) {
                options.put("description", CamelContextHelper.parseText((CamelContext)camelContext, (String)description));
            }
            String path = CamelContextHelper.parseText((CamelContext)camelContext, (String)this.getPath());
            String s1 = FileUtil.stripTrailingSeparator((String)path);
            String s2 = FileUtil.stripLeadingSeparator((String)CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getPath()));
            Object allPath = s1 != null && s2 != null ? s1 + "/" + s2 : (path != null ? path : CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getPath()));
            Set<String> toRemove = null;
            if (allPath != null && ((String)allPath).contains("?")) {
                String path1 = StringHelper.before((String)allPath, (String)"?");
                this.uriTemplating(camelContext, verb, path1, false);
                String path2 = StringHelper.after((String)allPath, (String)"?");
                toRemove = this.uriTemplating(camelContext, verb, path2, true);
            } else {
                this.uriTemplating(camelContext, verb, (String)allPath, false);
            }
            if (verb.getType() != null) {
                String bodyType = CamelContextHelper.parseText((CamelContext)camelContext, (String)verb.getType());
                ParamDefinition param = this.findParam(verb, RestParamType.body.name());
                if (param == null) {
                    this.param(verb).name(RestParamType.body.name()).type(RestParamType.body).dataType(bodyType).endParam();
                } else {
                    param.type(RestParamType.body).dataType(bodyType);
                }
            }
            Object from = this.buildFromUri(camelContext, verb);
            if (toRemove != null && !toRemove.isEmpty()) {
                try {
                    Map query = URISupport.parseQuery((String)URISupport.extractQuery((String)from));
                    toRemove.forEach(v -> query.values().removeIf(qv -> qv.toString().equals(v)));
                    from = URISupport.stripQuery((String)from);
                    if (!query.isEmpty()) {
                        String q = URISupport.createQueryString((Map)query);
                        from = URISupport.stripQuery((String)from) + "?" + q;
                    }
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            if (!options.isEmpty()) {
                try {
                    from = URISupport.appendParametersToURI((String)from, options);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            route.fromRest((String)from);
            route.setRestDefinition(this);
            answer.add(route);
        }
    }

    private String getDescription(VerbDefinition verb, RouteDefinition route) {
        String description;
        String string = description = verb.getTo() != null ? verb.getTo().getDescriptionText() : route.getDescriptionText();
        if (description == null) {
            description = verb.getDescriptionText();
        }
        if (description == null) {
            description = this.getDescriptionText();
        }
        return description;
    }

    private Set<String> uriTemplating(CamelContext camelContext, VerbDefinition verb, String path, boolean query) {
        String[] arr;
        if (path == null) {
            return null;
        }
        HashSet<String> params = new HashSet<String>();
        for (String a : arr = path.split("\\/")) {
            try {
                a = camelContext.resolvePropertyPlaceholders(a);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            Matcher m = Pattern.compile("\\{(.*?)\\}").matcher(a);
            while (m.find()) {
                String key = m.group(1);
                params.add("{" + key + "}");
                boolean found = false;
                for (ParamDefinition param : verb.getParams()) {
                    String name = param.getName();
                    StringHelper.notEmpty((String)name, (String)"parameter name");
                    try {
                        name = camelContext.resolvePropertyPlaceholders(name);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    if (!name.equalsIgnoreCase(key)) continue;
                    param.type(query ? RestParamType.query : RestParamType.path);
                    found = true;
                    break;
                }
                if (found) continue;
                this.param(verb).name(key).type(query ? RestParamType.query : RestParamType.path).endParam();
            }
        }
        return params;
    }

    private String buildUri(CamelContext camelContext, VerbDefinition verb) {
        Object answer = this.path != null && verb.getPath() != null ? this.path + ":" + verb.getPath() : (this.path != null ? this.path : (verb.getPath() != null ? verb.getPath() : ""));
        return CamelContextHelper.parseText((CamelContext)camelContext, (String)answer);
    }

    private ParamDefinition findParam(VerbDefinition verb, String name) {
        for (ParamDefinition param : verb.getParams()) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }
}

