/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManagerControl;

public class AMQPBridgePolicyManagerControlType
extends AbstractControl
implements AMQPBridgePolicyManagerControl {
    private final AMQPBridgePolicyManager policyManager;

    public AMQPBridgePolicyManagerControlType(AMQPBridgePolicyManager policyManager) throws NotCompliantMBeanException {
        super(AMQPBridgePolicyManagerControl.class, policyManager.getBridgeManager().getServer().getStorageManager());
        this.policyManager = policyManager;
    }

    @Override
    public String getType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getType((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.policyManager);
        }
        this.clearIO();
        try {
            long l = this.policyManager.getMetrics().getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesSent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesSent((Object)this.policyManager);
        }
        this.clearIO();
        try {
            long l = this.policyManager.getMetrics().getMessagesSent();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPBridgePolicyManagerControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPBridgePolicyManagerControl.class);
    }
}

