/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.ClientIDCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;
import org.apache.activemq.artemis.utils.CertificateUtil;

public class JaasCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;
    final RemotingConnection remotingConnection;

    public JaasCallbackHandler(String username, String password, RemotingConnection remotingConnection) {
        this.username = username;
        this.password = password;
        this.remotingConnection = remotingConnection;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password != null ? this.password.toCharArray() : null);
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                CertificateCallback certificateCallback = (CertificateCallback)callback;
                certificateCallback.setCertificates(CertificateUtil.getCertsFromConnection(this.remotingConnection));
                continue;
            }
            if (callback instanceof PrincipalsCallback) {
                Principal peerPrincipalFromConnection;
                PrincipalsCallback principalsCallback = (PrincipalsCallback)callback;
                Subject peerSubject = this.remotingConnection.getSubject();
                if (peerSubject != null) {
                    Iterator<KerberosPrincipal> iterator = peerSubject.getPrivateCredentials(KerberosPrincipal.class).iterator();
                    if (iterator.hasNext()) {
                        KerberosPrincipal principal = iterator.next();
                        principalsCallback.setPeerPrincipals(new Principal[]{principal});
                        return;
                    }
                    Set<Principal> principals = peerSubject.getPrincipals();
                    if (!principals.isEmpty()) {
                        principalsCallback.setPeerPrincipals(principals.toArray(new Principal[0]));
                        return;
                    }
                }
                if ((peerPrincipalFromConnection = CertificateUtil.getPeerPrincipalFromConnection(this.remotingConnection)) == null) continue;
                principalsCallback.setPeerPrincipals(new Principal[]{peerPrincipalFromConnection});
                continue;
            }
            if (callback instanceof ClientIDCallback) {
                ClientIDCallback clientIDCallback = (ClientIDCallback)callback;
                clientIDCallback.setClientID(this.remotingConnection.getClientID());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

