/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.nio.channels.SelectableChannel;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;

public class SelectableImpl
implements Selectable {
    private Selectable.Callback readable;
    private Selectable.Callback writable;
    private Selectable.Callback error;
    private Selectable.Callback expire;
    private Selectable.Callback release;
    private Selectable.Callback free;
    private boolean reading = false;
    private boolean writing = false;
    private long deadline = 0L;
    private SelectableChannel channel;
    private Record attachments = new RecordImpl();
    private boolean registered;
    private Reactor reactor;
    private Transport transport;
    private boolean terminal;
    private boolean terminated;

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public void setReading(boolean reading) {
        this.reading = reading;
    }

    @Override
    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    @Override
    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    @Override
    public void onReadable(Selectable.Callback runnable) {
        this.readable = runnable;
    }

    @Override
    public void onWritable(Selectable.Callback runnable) {
        this.writable = runnable;
    }

    @Override
    public void onExpired(Selectable.Callback runnable) {
        this.expire = runnable;
    }

    @Override
    public void onError(Selectable.Callback runnable) {
        this.error = runnable;
    }

    @Override
    public void onRelease(Selectable.Callback runnable) {
        this.release = runnable;
    }

    @Override
    public void onFree(Selectable.Callback runnable) {
        this.free = runnable;
    }

    @Override
    public void readable() {
        if (this.readable != null) {
            this.readable.run(this);
        }
    }

    @Override
    public void writeable() {
        if (this.writable != null) {
            this.writable.run(this);
        }
    }

    @Override
    public void expired() {
        if (this.expire != null) {
            this.expire.run(this);
        }
    }

    @Override
    public void error() {
        if (this.error != null) {
            this.error.run(this);
        }
    }

    @Override
    public void release() {
        if (this.release != null) {
            this.release.run(this);
        }
    }

    @Override
    public void free() {
        if (this.free != null) {
            this.free.run(this);
        }
    }

    @Override
    public void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    @Override
    public SelectableChannel getChannel() {
        return this.channel;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    @Override
    public void setCollector(Collector collector) {
        final CollectorImpl collectorImpl = (CollectorImpl)collector;
        this.onReadable(new Selectable.Callback(){

            @Override
            public void run(Selectable selectable) {
                collectorImpl.put(Event.Type.SELECTABLE_READABLE, selectable);
            }
        });
        this.onWritable(new Selectable.Callback(){

            @Override
            public void run(Selectable selectable) {
                collectorImpl.put(Event.Type.SELECTABLE_WRITABLE, selectable);
            }
        });
        this.onExpired(new Selectable.Callback(){

            @Override
            public void run(Selectable selectable) {
                collectorImpl.put(Event.Type.SELECTABLE_EXPIRED, selectable);
            }
        });
        this.onError(new Selectable.Callback(){

            @Override
            public void run(Selectable selectable) {
                collectorImpl.put(Event.Type.SELECTABLE_ERROR, selectable);
            }
        });
    }

    @Override
    public Reactor getReactor() {
        return this.reactor;
    }

    @Override
    public void terminate() {
        this.terminal = true;
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    protected Transport getTransport() {
        return this.transport;
    }

    protected void setTransport(Transport transport) {
        this.transport = transport;
    }

    protected void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }

    @Override
    public Record attachments() {
        return this.attachments;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminated() {
        this.terminated = true;
    }
}

