/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef Airavata_H
#define Airavata_H

#include <thrift/TDispatchProcessor.h>
#include <thrift/async/TConcurrentClientSyncInfo.h>
#include "airavata_api_types.h"

namespace apache { namespace airavata { namespace api {

#ifdef _WIN32
  #pragma warning( push )
  #pragma warning (disable : 4250 ) //inheriting methods via dominance 
#endif

class AiravataIf {
 public:
  virtual ~AiravataIf() {}

  /**
   * Fetch Apache Airavata API version
   * 
   * 
   * @param authzToken
   */
  virtual void getAPIVersion(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Verify if User Exists within Airavata.
   * 
   * @param gatewayId
   * 
   *  @param userName
   * 
   * @return true/false
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   */
  virtual bool isUserExists(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName) = 0;

  /**
   * Register a Gateway with Airavata.
   * 
   * @param gateway
   *    The gateway data model.
   * 
   * @return gatewayId
   *   Th unique identifier of the  newly registered gateway.
   * 
   * 
   * 
   * @param authzToken
   * @param gateway
   */
  virtual void addGateway(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Gateway& gateway) = 0;

  /**
   * Get all users in the gateway
   * 
   * @param gatewayId
   *    The gateway data model.
   * 
   * @return users
   *   list of usernames of the users in the gateway
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllUsersInGateway(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * Update previously registered Gateway metadata.
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway which require an update.
   * 
   * @return gateway
   *    Modified gateway obejct.
   * 
   * @exception AiravataClientException
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param updatedGateway
   */
  virtual bool updateGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Gateway& updatedGateway) = 0;

  /**
   * Get Gateway details by providing gatewayId
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway.
   * 
   * @return gateway
   *    Gateway obejct.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getGateway( ::apache::airavata::model::workspace::Gateway& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * Delete a Gateway
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway to be deleted.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual bool deleteGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * Get All the Gateways Connected to Airavata.
   * 
   * 
   * @param authzToken
   */
  virtual void getAllGateways(std::vector< ::apache::airavata::model::workspace::Gateway> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Check for the Existance of a Gateway within Airavata
   * 
   * @param gatewayId
   *   Provide the gatewayId of the gateway you want to check the existancy
   * 
   * @return boolean
   *   Boolean idetifier for the existance or non-existane of the gatewayId
   * 
   * @return gatewayId
   *   return the gatewayId of the existing gateway.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual bool isGatewayExist(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   *   * API methods to retrieve notifications
   * *
   * 
   * @param authzToken
   * @param notification
   */
  virtual void createNotification(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification) = 0;
  virtual bool updateNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification) = 0;
  virtual bool deleteNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId) = 0;
  virtual void getNotification( ::apache::airavata::model::workspace::Notification& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId) = 0;
  virtual void getAllNotifications(std::vector< ::apache::airavata::model::workspace::Notification> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * Generate and Register SSH Key Pair with Airavata Credential Store.
   * 
   * @param gatewayId
   *    The identifier for the requested Gateway.
   * 
   * @param userName
   *    The User for which the credential should be registered. For community accounts, this user is the name of the
   *    community user name. For computational resources, this user name need not be the same user name on resoruces.
   * 
   * @param description
   *    The description field for a credential type, all type of credential can have a description.
   * 
   * @param credentialOwnerType
   *    The type of owner of this credential. Two possible values: GATEWAY (default) and USER
   * 
   * @return airavataCredStoreToken
   *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
   *   belonging to a Gateway.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   * @param description
   * @param credentialOwnerType
   */
  virtual void generateAndRegisterSSHKeys(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::string& description, const  ::CredentialOwnerType::type credentialOwnerType) = 0;

  /**
   * Generate and Register Username PWD Pair with Airavata Credential Store.
   * 
   * @param gatewayId
   *    The identifier for the requested Gateway.
   * 
   * @param portalUserName
   *    The User for which the credential should be registered. For community accounts, this user is the name of the
   *    community user name. For computational resources, this user name need not be the same user name on resoruces.
   * 
   * @param loginUserName
   * 
   * @param password
   * 
   * @return airavataCredStoreToken
   *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
   *   belonging to a Gateway.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param portalUserName
   * @param loginUserName
   * @param password
   * @param description
   */
  virtual void registerPwdCredential(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& portalUserName, const std::string& loginUserName, const std::string& password, const std::string& description) = 0;

  /**
   * Get a Public Key by Providing the Token
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return publicKey
   * 
   * 
   * 
   * @param authzToken
   * @param airavataCredStoreToken
   * @param gatewayId
   */
  virtual void getSSHPubKey(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Get all Public Keys of the Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return publicKey
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllGatewaySSHPubKeys(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Get all Credential summaries for the Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param credential_store_data_models.SummaryType
   *    Summary type : SSH,PASSWD or CERT
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return List of Credential Summary Objects
   * 
   * 
   * 
   * @param authzToken
   * @param type
   * @param gatewayId
   */
  virtual void getAllCredentialSummaryForGateway(std::vector< ::CredentialSummary> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId) = 0;

  /**
   * 
   * Get all Credential summaries for user in a Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param credential_store_data_models.SummaryType
   *    Summary type : SSH,PASSWD or CERT
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @param userId
   *    This is the unique identifier of user whose public keys are to be fetched.
   * 
   * @return CredentialSummary
   * 
   * 
   * 
   * @param authzToken
   * @param type
   * @param gatewayId
   * @param userId
   */
  virtual void getAllCredentialSummaryForUsersInGateway(std::vector< ::CredentialSummary> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId, const std::string& userId) = 0;
  virtual void getAllGatewayPWDCredentials(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Delete a Gateway
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway to be deleted.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param authzToken
   * @param airavataCredStoreToken
   * @param gatewayId
   */
  virtual bool deleteSSHPubKey(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId) = 0;
  virtual bool deletePWDCredential(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Creates a Project with basic metadata.
   *    A Project is a container of experiments.
   * 
   * @param gatewayId
   *    The identifier for the requested gateway.
   * 
   * @param Project
   *    The Project Object described in the workspace_model.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param project
   */
  virtual void createProject(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Project& project) = 0;

  /**
   * 
   * Update an Existing Project
   * 
   * @param projectId
   *    The projectId of the project needed an update.
   * 
   * @return void
   *    Currently this does not return any value.
   * 
   * 
   * 
   * @param authzToken
   * @param projectId
   * @param updatedProject
   */
  virtual void updateProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const  ::apache::airavata::model::workspace::Project& updatedProject) = 0;

  /**
   * 
   * Get a Project by ID
   *    This method is to obtain a project by providing a projectId.
   * 
   * @param projectId
   *    projectId of the project you require.
   * 
   * @return project
   *    project data model will be returned.
   * 
   * 
   * 
   * @param authzToken
   * @param projectId
   */
  virtual void getProject( ::apache::airavata::model::workspace::Project& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId) = 0;

  /**
   * 
   * Delete a Project
   *    This method is used to delete an existing Project.
   * 
   * @param projectId
   *    projectId of the project you want to delete.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   *    NOTE: This method is not used within gateways connected with Airavata.
   * 
   * 
   * 
   * @param authzToken
   * @param projectId
   */
  virtual bool deleteProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId) = 0;

  /**
   * 
   * Get All User Projects
   * Get all Project for the user with pagination. Results will be ordered based on creation time DESC.
   * 
   * @param gatewayId
   *    The identifier for the requested gateway.
   * 
   * @param userName
   *    The identifier of the user.
   * 
   * @param limit
   *    The amount results to be fetched.
   * 
   * @param offset
   *    The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   * @param limit
   * @param offset
   */
  virtual void getUserProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset) = 0;

  /**
   * 
   * Search User Projects
   * Search and get all Projects for user by project description or/and project name  with pagination.
   * Results will be ordered based on creation time DESC.
   * 
   * @param gatewayId
   *    The unique identifier of the gateway making the request.
   * 
   * @param userName
   *    The identifier of the user.
   * 
   * @param filters
   *    Map of multiple filter criteria. Currenlt search filters includes Project Name and Project Description
   * 
   * @param limit
   *    The amount results to be fetched.
   * 
   * @param offset
   *    The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   * @param filters
   * @param limit
   * @param offset
   */
  virtual void searchProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset) = 0;

  /**
   * Search Experiments.
   * Search Experiments by using multiple filter criteria with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param gatewayId
   *       Identifier of the requested gateway.
   * 
   * @param userName
   *       Username of the user requesting the search function.
   * 
   * @param filters
   *       Map of multiple filter criteria. Currenlt search filters includes Experiment Name, Description, Application, etc....
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * @return ExperimentSummaryModel
   *    List of experiments for the given search filter. Here only the Experiment summary will be returned.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   * @param filters
   * @param limit
   * @param offset
   */
  virtual void searchExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset) = 0;

  /**
   * 
   * Get Experiment Statistics
   * Get Experiment Statisitics for a given gateway for a specific time period. This feature is available only for admins of a particular gateway. Gateway admin access is managed by the user roles.
   * 
   * @param gatewayId
   *       Unique identifier of the gateway making the request to fetch statistics.
   * 
   * @param fromTime
   *       Starting date time.
   * 
   * @param toTime
   *       Ending data time.
   * 
   * @param userName
   *       Gateway username substring with which to further filter statistics.
   * 
   * @param applicationName
   *       Application id substring with which to further filter statistics.
   * 
   * @param resourceHostName
   *       Hostname id substring with which to further filter statistics.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param fromTime
   * @param toTime
   * @param userName
   * @param applicationName
   * @param resourceHostName
   */
  virtual void getExperimentStatistics( ::apache::airavata::model::experiment::ExperimentStatistics& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const int64_t fromTime, const int64_t toTime, const std::string& userName, const std::string& applicationName, const std::string& resourceHostName) = 0;

  /**
   * 
   * Get All Experiments of the Project
   * Get Experiments within project with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param projectId
   *       Uniqie identifier of the project.
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param authzToken
   * @param projectId
   * @param limit
   * @param offset
   */
  virtual void getExperimentsInProject(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const int32_t limit, const int32_t offset) = 0;

  /**
   * 
   * Get All Experiments of the User
   * Get experiments by user with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param gatewayId
   *       Identifier of the requesting gateway.
   * 
   * @param userName
   *       Username of the requested end user.
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param userName
   * @param limit
   * @param offset
   */
  virtual void getUserExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset) = 0;

  /**
   *   *
   *   * Create New Experiment
   *   * Create an experiment for the specified user belonging to the gateway. The gateway identity is not explicitly passed
   *   *   but inferred from the sshKeyAuthentication header. This experiment is just a persistent place holder. The client
   *   *   has to subsequently configure and launch the created experiment. No action is taken on Airavata Server except
   *   *   registering the experiment in a persistent store.
   *   *
   *   * @param gatewayId
   *   *    The unique ID of the gateway where the experiment is been created.
   *   *
   *   * @param ExperimentModel
   *   *    The create experiment will require the basic experiment metadata like the name and description, intended user,
   *   *      the gateway identifer and if the experiment should be shared public by defualt. During the creation of an experiment
   *   *      the ExperimentMetadata is a required field.
   *   *
   *   * @return
   *   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param authzToken
   * @param gatewayId
   * @param experiment
   */
  virtual void createExperiment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment) = 0;

  /**
   * 
   * Delete an Experiment
   * If the experiment is not already launched experiment can be deleted.
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you want to delete.
   * 
   * @return boolean
   *     Identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param authzToken
   * @param experimentId
   */
  virtual bool deleteExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& experimentId) = 0;

  /**
   *   *
   *   * Get Experiment
   *   * Fetch previously created experiment metadata.
   *   *
   *   * @param airavataExperimentId
   *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
   *   *
   *   * @return ExperimentModel
   *   *   This method will return the previously stored experiment metadata.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getExperiment( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   *   *
   *   * Get Experiment by an admin user
   *   *
   *   * Used by an admin user to fetch previously created experiment metadata.
   *   *
   *   * @param airavataExperimentId
   *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
   *   *
   *   * @return ExperimentModel
   *   *   This method will return the previously stored experiment metadata.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getExperimentByAdmin( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Get Complete Experiment Details
   * Fetch the completed nested tree structue of previously created experiment metadata which includes processes ->
   * tasks -> jobs information.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @return ExperimentModel
   *   This method will return the previously stored experiment metadata including application input parameters, computational resource scheduling
   *   information, special input output handling and additional quality of service parameters.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   * 
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getDetailedExperimentTree( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Update a Previously Created Experiment
   * Configure the CREATED experiment with required inputs, scheduling and other quality of service parameters. This method only updates the experiment object within the registry.
   * The experiment has to be launched to make it actionable by the server.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @param ExperimentModel
   *    The configuration information of the experiment with application input parameters, computational resource scheduling
   *      information, special input output handling and additional quality of service parameters.
   * 
   * @return
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   * @param experiment
   */
  virtual void updateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment) = 0;
  virtual void updateExperimentConfiguration(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::UserConfigurationDataModel& userConfiguration) = 0;
  virtual void updateResourceScheduleing(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& resourceScheduling) = 0;

  /**
   *  *
   *  * Validate experiment configuration.
   *  * A true in general indicates, the experiment is ready to be launched.
   *  *
   *  * @param airavataExperimentId
   *  *    Unique identifier of the experiment (Experimnent ID) of the experiment which need to be validated.
   *  *
   *  * @return boolean
   *  *      Identifier for the success or failure of the validation operation.
   *  *
   * *
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual bool validateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Launch a Previously Created & Configured Experiment.
   * Airavata Server will then start processing the request and appropriate notifications and intermediate and output data will be subsequently available for this experiment.
   * 
   * @gatewayId
   *    ID of the gateway which will launch the experiment.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @return
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   * @param gatewayId
   */
  virtual void launchExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId) = 0;

  /**
   * 
   * Get Experiment Status
   * 
   * Obtain the status of an experiment by providing the Experiment Id
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you require the status.
   * 
   * @return ExperimentStatus
   *     ExperimentStatus model with the current status will be returned.
   * 
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getExperimentStatus( ::apache::airavata::model::status::ExperimentStatus& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Get Experiment Outputs
   * This method to be used when need to obtain final outputs of a certain Experiment
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you need the outputs.
   * 
   * @return list
   *     List of experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
   * 
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getExperimentOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Get Intermediate Experiment Outputs
   * This method to be used when need to obtain intermediate outputs of a certain Experiment
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you need intermediate outputs.
   * 
   * @return list
   *     List of intermediate experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
   * 
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getIntermediateOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Get Job Statuses for an Experiment
   * This method to be used when need to get the job status of an Experiment. An experiment may have one or many jobs; there for one or many job statuses may turnup
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you need the job statuses.
   * 
   * @return JobStatus
   *     Job status (string) for all all the existing jobs for the experiment will be returned in the form of a map
   * 
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getJobStatuses(std::map<std::string,  ::apache::airavata::model::status::JobStatus> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Get Job Details for all the jobs within an Experiment.
   * This method to be used when need to get the job details for one or many jobs of an Experiment.
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you need job details.
   * 
   * @return list of JobDetails
   *     Job details.
   * 
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   */
  virtual void getJobDetails(std::vector< ::apache::airavata::model::job::JobModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId) = 0;

  /**
   * 
   * Clone an Existing Experiment
   * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
   *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
   * 
   * @param newExperimentName
   *    experiment name that should be used in the cloned experiment
   * 
   * @param updatedExperiment
   *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
   *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
   *      should be shared public by default.
   * @param newExperimentProjectId
   *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
   *      in the same project as the existing experiment.
   * 
   * @return
   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param existingExperimentID
   * @param newExperimentName
   * @param newExperimentProjectId
   */
  virtual void cloneExperiment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId) = 0;

  /**
   * 
   * Clone an Existing Experiment by an admin user
   * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
   *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
   * 
   * @param newExperimentName
   *    experiment name that should be used in the cloned experiment
   * 
   * @param updatedExperiment
   *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
   *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
   *      should be shared public by default.
   * @param newExperimentProjectId
   *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
   *      in the same project as the existing experiment.
   * 
   * @return
   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   * 
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param existingExperimentID
   * @param newExperimentName
   * @param newExperimentProjectId
   */
  virtual void cloneExperimentByAdmin(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId) = 0;

  /**
   * 
   * Terminate a running Experiment.
   * 
   * @gatewayId
   *    ID of the gateway which will terminate the running Experiment.
   * 
   * @param airavataExperimentId
   *    The identifier of the experiment required termination. This ID is returned during the create experiment step.
   * 
   * @return status
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param authzToken
   * @param airavataExperimentId
   * @param gatewayId
   */
  virtual void terminateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId) = 0;

  /**
   * 
   * Register a Application Module.
   * 
   * @gatewayId
   *    ID of the gateway which is registering the new Application Module.
   * 
   * @param applicationModule
   *    Application Module Object created from the datamodel.
   * 
   * @return appModuleId
   *   Returns the server-side generated airavata appModule globally unique identifier.
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param applicationModule
   */
  virtual void registerApplicationModule(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule) = 0;

  /**
   * 
   * Fetch a Application Module.
   * 
   * @param appModuleId
   *   The unique identifier of the application module required
   * 
   * @return applicationModule
   *   Returns an Application Module Object.
   * 
   * 
   * @param authzToken
   * @param appModuleId
   */
  virtual void getApplicationModule( ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId) = 0;

  /**
   * 
   * Update a Application Module.
   * 
   * @param appModuleId
   *   The identifier for the requested application module to be updated.
   * 
   * @param applicationModule
   *    Application Module Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param appModuleId
   * @param applicationModule
   */
  virtual bool updateApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule) = 0;

  /**
   * 
   * Fetch all Application Module Descriptions.
   * 
   * @param gatewayId
   *    ID of the gateway which need to list all available application deployment documentation.
   * 
   * @return list
   *    Returns the list of all Application Module Objects.
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllAppModules(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Delete an Application Module.
   * 
   * @param appModuleId
   *   The identifier of the Application Module to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param appModuleId
   */
  virtual bool deleteApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId) = 0;

  /**
   * 
   * Register an Application Deployment.
   * 
   * @param gatewayId
   *    ID of the gateway which is registering the new Application Deployment.
   * 
   * @param applicationDeployment
   *    Application Module Object created from the datamodel.
   * 
   * @return appDeploymentId
   *   Returns a server-side generated airavata appDeployment globally unique identifier.
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param applicationDeployment
   */
  virtual void registerApplicationDeployment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment) = 0;

  /**
   * 
   * Fetch a Application Deployment.
   * 
   * @param appDeploymentId
   *   The identifier for the requested application module
   * 
   * @return applicationDeployment
   *   Returns a application Deployment Object.
   * 
   * 
   * @param authzToken
   * @param appDeploymentId
   */
  virtual void getApplicationDeployment( ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId) = 0;

  /**
   * 
   * Update an Application Deployment.
   * 
   * @param appDeploymentId
   *   The identifier of the requested application deployment to be updated.
   * 
   * @param appDeployment
   *    Application Deployment Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param appDeploymentId
   * @param applicationDeployment
   */
  virtual bool updateApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment) = 0;

  /**
   * 
   * Delete an Application Deployment.
   * 
   * @param appDeploymentId
   *   The unique identifier of application deployment to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param appDeploymentId
   */
  virtual bool deleteApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId) = 0;

  /**
   * 
   * Fetch all Application Deployment Descriptions.
   * 
   * @param gatewayId
   *    ID of the gateway which need to list all available application deployment documentation.
   * 
   * @return list<applicationDeployment.
   *    Returns the list of all application Deployment Objects.
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllApplicationDeployments(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * Fetch a list of Deployed Compute Hosts.
   * 
   * @param appModuleId
   *   The identifier for the requested application module
   * 
   * @return list<string>
   *   Returns a list of Deployed Resources.
   * 
   * 
   * @param authzToken
   * @param appModuleId
   */
  virtual void getAppModuleDeployedResources(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId) = 0;

  /**
   * 
   * Register a Application Interface.
   * 
   * @param applicationInterface
   *    Application Module Object created from the datamodel.
   * 
   * @return appInterfaceId
   *   Returns a server-side generated airavata application interface globally unique identifier.
   * 
   * 
   * @param authzToken
   * @param gatewayId
   * @param applicationInterface
   */
  virtual void registerApplicationInterface(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface) = 0;

  /**
   * 
   * Clone an Application Interface.
   * 
   * @gatewayId
   *    The identifier for the gateway profile to be requested
   * 
   * @param existingAppInterfaceID
   *    Identifier of the existing Application interface you wich to clone.
   * 
   * @param newApplicationName
   *    Name for the new application interface.
   * 
   * @return appInterfaceId
   *    Returns a server-side generated globally unique identifier for the newly cloned application interface.
   * 
   * 
   * @param authzToken
   * @param existingAppInterfaceID
   * @param newApplicationName
   * @param gatewayId
   */
  virtual void cloneApplicationInterface(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingAppInterfaceID, const std::string& newApplicationName, const std::string& gatewayId) = 0;

  /**
   * 
   * Fetch an Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface.
   * 
   * @return applicationInterface
   *   Returns an application Interface Object.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   */
  virtual void getApplicationInterface( ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId) = 0;

  /**
   * 
   * Update a Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier of the requested application deployment to be updated.
   * 
   * @param appInterface
   *    Application Interface Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   * @param applicationInterface
   */
  virtual bool updateApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface) = 0;

  /**
   * 
   * Delete an Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   */
  virtual bool deleteApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId) = 0;

  /**
   * 
   * Fetch name and ID of  Application Interface documents.
   * 
   * 
   * @return map<applicationId, applicationInterfaceNames>
   *   Returns a list of application interfaces with corresponsing ID's
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllApplicationInterfaceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Fetch all Application Interface documents.
   * 
   * 
   * @return map<applicationId, applicationInterfaceNames>
   *   Returns a list of application interfaces documents (Application Interface ID, name, description, Inputs and Outputs objects).
   * 
   * 
   * @param authzToken
   * @param gatewayId
   */
  virtual void getAllApplicationInterfaces(std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;

  /**
   * 
   * Fetch the list of Application Inputs.
   * 
   * @param appInterfaceId
   *   The identifier of the application interface which need inputs to be fetched.
   * 
   * @return list<application_interface_model.InputDataObjectType>
   *   Returns a list of application inputs.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   */
  virtual void getApplicationInputs(std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId) = 0;

  /**
   * 
   * Fetch list of Application Outputs.
   * 
   * @param appInterfaceId
   *   The identifier of the application interface which need outputs to be fetched.
   * 
   * @return list<application_interface_model.OutputDataObjectType>
   *   Returns a list of application outputs.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   */
  virtual void getApplicationOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId) = 0;

  /**
   * 
   * Fetch a list of all deployed Compute Hosts for a given application interfaces.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface.
   * 
   * @return map<computeResourceId, computeResourceName>
   *   A map of registered compute resource id's and their corresponding hostnames.
   *   Deployments of each modules listed within the interfaces will be listed.
   * 
   * 
   * @param authzToken
   * @param appInterfaceId
   */
  virtual void getAvailableAppInterfaceComputeResources(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId) = 0;

  /**
   * Register a Compute Resource.
   * 
   * @param computeResourceDescription
   *    Compute Resource Object created from the datamodel.
   * 
   * @return computeResourceId
   *   Returns a server-side generated airavata compute resource globally unique identifier.
   * 
   * 
   * @param authzToken
   * @param computeResourceDescription
   */
  virtual void registerComputeResource(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription) = 0;

  /**
   * Fetch the given Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource
   * 
   * @return computeResourceDescription
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   */
  virtual void getComputeResource( ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId) = 0;

  /**
   * 
   * Fetch all registered Compute Resources.
   * 
   * @return A map of registered compute resource id's and thier corresponding hostnames.
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param authzToken
   */
  virtual void getAllComputeResourceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Update a Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource to be updated.
   * 
   * @param computeResourceDescription
   *    Compute Resource Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param computeResourceDescription
   */
  virtual bool updateComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription) = 0;

  /**
   * Delete a Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   */
  virtual bool deleteComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId) = 0;

  /**
   * Register a Storage Resource.
   * 
   * @param storageResourceDescription
   *    Storge Resource Object created from the datamodel.
   * 
   * @return storageResourceId
   *   Returns a server-side generated airavata storage resource globally unique identifier.
   * 
   * 
   * @param authzToken
   * @param storageResourceDescription
   */
  virtual void registerStorageResource(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& storageResourceDescription) = 0;

  /**
   * Fetch the given Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier for the requested storage resource
   * 
   * @return storageResourceDescription
   *    Storage Resource Object created from the datamodel..
   * 
   * 
   * @param authzToken
   * @param storageResourceId
   */
  virtual void getStorageResource( ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId) = 0;

  /**
   * Fetch all registered Storage Resources.
   * 
   * @return A map of registered compute resource id's and thier corresponding hostnames.
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param authzToken
   */
  virtual void getAllStorageResourceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Update a Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier for the requested compute resource to be updated.
   * 
   * @param storageResourceDescription
   *    Storage Resource Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param storageResourceId
   * @param storageResourceDescription
   */
  virtual bool updateStorageResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& storageResourceDescription) = 0;

  /**
   * Delete a Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier of the requested compute resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param storageResourceId
   */
  virtual bool deleteStorageResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId) = 0;

  /**
   * Add a Local Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param localSubmission
   *   The LOCALSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param priorityOrder
   * @param localSubmission
   */
  virtual void addLocalSubmissionDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const int32_t priorityOrder, const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& localSubmission) = 0;

  /**
   * Update the given Local Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param localSubmission
   *   The LOCALSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param jobSubmissionInterfaceId
   * @param localSubmission
   */
  virtual bool updateLocalSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionInterfaceId, const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& localSubmission) = 0;

  /**
   * This method returns localJobSubmission object
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be retrieved.
   *  @return LOCALSubmission instance
   * 
   * 
   * @param authzToken
   * @param jobSubmissionId
   */
  virtual void getLocalJobSubmission( ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionId) = 0;

  /**
   * Add a SSH Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param priorityOrder
   * @param sshJobSubmission
   */
  virtual void addSSHJobSubmissionDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const int32_t priorityOrder, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& sshJobSubmission) = 0;

  /**
   * Add a SSH_FORK Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param priorityOrder
   * @param sshJobSubmission
   */
  virtual void addSSHForkJobSubmissionDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const int32_t priorityOrder, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& sshJobSubmission) = 0;

  /**
   * This method returns SSHJobSubmission object
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be retrieved.
   *  @return SSHJobSubmission instance
   * 
   * 
   * @param authzToken
   * @param jobSubmissionId
   */
  virtual void getSSHJobSubmission( ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionId) = 0;

  /**
   * 
   * Add a UNICORE Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param unicoreJobSubmission
   *   The UnicoreJobSubmission object to be added to the resource.
   * 
   * @return status
   *  Returns the unique job submission id.
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param priorityOrder
   * @param unicoreJobSubmission
   */
  virtual void addUNICOREJobSubmissionDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const int32_t priorityOrder, const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& unicoreJobSubmission) = 0;

  /**
   *   *
   *   * This method returns UnicoreJobSubmission object
   *   *
   *   * @param jobSubmissionInterfaceId
   *   *   The identifier of the JobSubmission Interface to be retrieved.
   *   *  @return UnicoreJobSubmission instance
   *   *
   * *
   * 
   * @param authzToken
   * @param jobSubmissionId
   */
  virtual void getUnicoreJobSubmission( ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionId) = 0;

  /**
   *    *
   *    * Add a Cloud Job Submission details to a compute resource
   *    *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   *    *
   *    * @param computeResourceId
   *    *   The identifier of the compute resource to which JobSubmission protocol to be added
   *    *
   *    * @param priorityOrder
   *    *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   *    *
   *    * @param sshJobSubmission
   *    *   The SSHJobSubmission object to be added to the resource.
   *    *
   *    * @return status
   *    *   Returns the unique job submission id.
   *    *
   * *
   * 
   * @param authzToken
   * @param computeResourceId
   * @param priorityOrder
   * @param cloudSubmission
   */
  virtual void addCloudJobSubmissionDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const int32_t priorityOrder, const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& cloudSubmission) = 0;

  /**
   *    *
   *    * This method returns cloudJobSubmission object
   *    * @param jobSubmissionInterfaceI
   *        *   The identifier of the JobSubmission Interface to be retrieved.
   *    *  @return CloudJobSubmission instance
   * *
   * 
   * @param authzToken
   * @param jobSubmissionId
   */
  virtual void getCloudJobSubmission( ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionId) = 0;

  /**
   * 
   * Update the given SSH Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param jobSubmissionInterfaceId
   * @param sshJobSubmission
   */
  virtual bool updateSSHJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionInterfaceId, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& sshJobSubmission) = 0;

  /**
   * 
   * Update the cloud Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param cloudJobSubmission
   *   The CloudJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param jobSubmissionInterfaceId
   * @param sshJobSubmission
   */
  virtual bool updateCloudJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionInterfaceId, const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& sshJobSubmission) = 0;

  /**
   * 
   * Update the UNIOCRE Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param UnicoreJobSubmission
   *   The UnicoreJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param authzToken
   * @param jobSubmissionInterfaceId
   * @param unicoreJobSubmission
   */
  virtual bool updateUnicoreJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionInterfaceId, const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& unicoreJobSubmission) = 0;

  /**
   * 
   * Add a Local data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param DMType
   *   DMType object to be added to the resource.
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param localDataMovement
   *   The LOCALDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * 
   * @param authzToken
   * @param productUri
   * @param dataMoveType
   * @param priorityOrder
   * @param localDataMovement
   */
  virtual void addLocalDataMovementDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri, const  ::apache::airavata::model::data::movement::DMType::type dataMoveType, const int32_t priorityOrder, const  ::apache::airavata::model::data::movement::LOCALDataMovement& localDataMovement) = 0;

  /**
   * 
   * Update the given Local data movement details
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param localDataMovement
   *   The LOCALDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementInterfaceId
   * @param localDataMovement
   */
  virtual bool updateLocalDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementInterfaceId, const  ::apache::airavata::model::data::movement::LOCALDataMovement& localDataMovement) = 0;

  /**
   * 
   * This method returns local datamovement object.
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   *  @return LOCALDataMovement instance
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementId
   */
  virtual void getLocalDataMovement( ::apache::airavata::model::data::movement::LOCALDataMovement& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementId) = 0;

  /**
   * 
   * Add a SCP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param scpDataMovement
   *   The SCPDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param authzToken
   * @param productUri
   * @param dataMoveType
   * @param priorityOrder
   * @param scpDataMovement
   */
  virtual void addSCPDataMovementDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri, const  ::apache::airavata::model::data::movement::DMType::type dataMoveType, const int32_t priorityOrder, const  ::apache::airavata::model::data::movement::SCPDataMovement& scpDataMovement) = 0;

  /**
   * 
   * Update the given scp data movement details
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param scpDataMovement
   *   The SCPDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param dataMovementInterfaceId
   * @param scpDataMovement
   */
  virtual bool updateSCPDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementInterfaceId, const  ::apache::airavata::model::data::movement::SCPDataMovement& scpDataMovement) = 0;

  /**
   * This method returns SCP datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   * @return SCPDataMovement instance
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementId
   */
  virtual void getSCPDataMovement( ::apache::airavata::model::data::movement::SCPDataMovement& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementId) = 0;

  /**
   * 
   * Add a UNICORE data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which data movement protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param UnicoreDataMovement
   *   The UnicoreDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique data movement id.
   * 
   * 
   * @param authzToken
   * @param productUri
   * @param dataMoveType
   * @param priorityOrder
   * @param unicoreDataMovement
   */
  virtual void addUnicoreDataMovementDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri, const  ::apache::airavata::model::data::movement::DMType::type dataMoveType, const int32_t priorityOrder, const  ::apache::airavata::model::data::movement::UnicoreDataMovement& unicoreDataMovement) = 0;

  /**
   * 
   * Update a selected UNICORE data movement details
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param UnicoreDataMovement
   *   The UnicoreDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementInterfaceId
   * @param unicoreDataMovement
   */
  virtual bool updateUnicoreDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementInterfaceId, const  ::apache::airavata::model::data::movement::UnicoreDataMovement& unicoreDataMovement) = 0;

  /**
   * 
   * This method returns UNICORE datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   * @return UnicoreDataMovement instance
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementId
   */
  virtual void getUnicoreDataMovement( ::apache::airavata::model::data::movement::UnicoreDataMovement& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementId) = 0;

  /**
   * 
   * Add a GridFTP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which dataMovement protocol to be added
   * 
   * @param DMType
   *    The DMType object to be added to the resource.
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param gridFTPDataMovement
   *   The GridFTPDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique data movement id.
   * 
   * 
   * 
   * @param authzToken
   * @param productUri
   * @param dataMoveType
   * @param priorityOrder
   * @param gridFTPDataMovement
   */
  virtual void addGridFTPDataMovementDetails(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri, const  ::apache::airavata::model::data::movement::DMType::type dataMoveType, const int32_t priorityOrder, const  ::apache::airavata::model::data::movement::GridFTPDataMovement& gridFTPDataMovement) = 0;

  /**
   * Update the given GridFTP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param gridFTPDataMovement
   *   The GridFTPDataMovement object to be updated.
   * 
   * @return boolean
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementInterfaceId
   * @param gridFTPDataMovement
   */
  virtual bool updateGridFTPDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementInterfaceId, const  ::apache::airavata::model::data::movement::GridFTPDataMovement& gridFTPDataMovement) = 0;

  /**
   * This method returns GridFTP datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   *  @return GridFTPDataMovement instance
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementId
   */
  virtual void getGridFTPDataMovement( ::apache::airavata::model::data::movement::GridFTPDataMovement& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementId) = 0;

  /**
   * Change the priority of a given job submisison interface
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be changed
   * 
   * @param priorityOrder
   *   The new priority of the job manager interface.
   * 
   * @return status
   *   Returns a success/failure of the change.
   * 
   * 
   * 
   * @param authzToken
   * @param jobSubmissionInterfaceId
   * @param newPriorityOrder
   */
  virtual bool changeJobSubmissionPriority(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& jobSubmissionInterfaceId, const int32_t newPriorityOrder) = 0;

  /**
   * Change the priority of a given data movement interface
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the DataMovement Interface to be changed
   * 
   * @param priorityOrder
   *   The new priority of the data movement interface.
   * 
   * @return status
   *   Returns a success/failure of the change.
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementInterfaceId
   * @param newPriorityOrder
   */
  virtual bool changeDataMovementPriority(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataMovementInterfaceId, const int32_t newPriorityOrder) = 0;

  /**
   * Change the priorities of a given set of job submission interfaces
   * 
   * @param jobSubmissionPriorityMap
   *   A Map of identifiers of the JobSubmission Interfaces and thier associated priorities to be set.
   * 
   * @return status
   *   Returns a success/failure of the changes.
   * 
   * 
   * @param authzToken
   * @param jobSubmissionPriorityMap
   */
  virtual bool changeJobSubmissionPriorities(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::map<std::string, int32_t> & jobSubmissionPriorityMap) = 0;

  /**
   * Change the priorities of a given set of data movement interfaces
   * 
   * @param dataMovementPriorityMap
   *   A Map of identifiers of the DataMovement Interfaces and thier associated priorities to be set.
   * 
   * @return status
   *   Returns a success/failure of the changes.
   * 
   * 
   * 
   * @param authzToken
   * @param dataMovementPriorityMap
   */
  virtual bool changeDataMovementPriorities(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::map<std::string, int32_t> & dataMovementPriorityMap) = 0;

  /**
   * Delete a given job submisison interface
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be changed
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param jobSubmissionInterfaceId
   */
  virtual bool deleteJobSubmissionInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const std::string& jobSubmissionInterfaceId) = 0;

  /**
   * Delete a given data movement interface
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the DataMovement Interface to be changed
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param authzToken
   * @param productUri
   * @param dataMovementInterfaceId
   * @param dataMoveType
   */
  virtual bool deleteDataMovementInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri, const std::string& dataMovementInterfaceId, const  ::apache::airavata::model::data::movement::DMType::type dataMoveType) = 0;
  virtual void registerResourceJobManager(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& resourceJobManager) = 0;
  virtual bool updateResourceJobManager(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceJobManagerId, const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& updatedResourceJobManager) = 0;
  virtual void getResourceJobManager( ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceJobManagerId) = 0;
  virtual bool deleteResourceJobManager(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceJobManagerId) = 0;

  /**
   * Delete a Compute Resource Queue
   * 
   * @param computeResourceId
   *   The identifier of the compute resource which has the queue to be deleted
   * 
   * @param queueName
   *   Name of the queue need to be deleted. Name is the uniqueue identifier for the queue within a compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param authzToken
   * @param computeResourceId
   * @param queueName
   */
  virtual bool deleteBatchQueue(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const std::string& queueName) = 0;

  /**
   * Register a Gateway Resource Profile.
   * 
   * @param gatewayResourceProfile
   *    Gateway Resource Profile Object.
   *    The GatewayID should be obtained from Airavata gateway registration and passed to register a corresponding
   *      resource profile.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param gatewayResourceProfile
   */
  virtual void registerGatewayResourceProfile(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& gatewayResourceProfile) = 0;

  /**
   * Fetch the given Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource.
   * 
   * @return gatewayResourceProfile
   *    Gateway Resource Profile Object.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   */
  virtual void getGatewayResourceProfile( ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID) = 0;

  /**
   * Update a Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource to be updated.
   * 
   * @param gatewayResourceProfile
   *    Gateway Resource Profile Object.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param gatewayResourceProfile
   */
  virtual bool updateGatewayResourceProfile(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& gatewayResourceProfile) = 0;

  /**
   * Delete the given Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   */
  virtual bool deleteGatewayResourceProfile(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID) = 0;

  /**
   * Add a Compute Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be added.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param computeResourceId
   * @param computeResourcePreference
   */
  virtual bool addGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& computeResourceId, const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& computeResourcePreference) = 0;

  /**
   * Add a Storage Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be added.
   * 
   * @param storageResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param storageResourceId
   * @param storagePreference
   */
  virtual bool addGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& storageResourceId, const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& storagePreference) = 0;

  /**
   * 
   * Fetch a Compute Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param computeResourceId
   */
  virtual void getGatewayComputeResourcePreference( ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& computeResourceId) = 0;

  /**
   * 
   * Fetch a Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to request to fetch the particular storage resource preference.
   * 
   * @param storageResourceId
   *   Identifier of the Stprage Preference required to be fetched.
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param storageResourceId
   */
  virtual void getGatewayStoragePreference( ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& storageResourceId) = 0;

  /**
   * 
   * Fetch all Compute Resource Preferences of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   */
  virtual void getAllGatewayComputeResourcePreferences(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID) = 0;

  /**
   * Fetch all Storage Resource Preferences of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   */
  virtual void getAllGatewayStoragePreferences(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID) = 0;

  /**
   * 
   * Fetch all Gateway Profiles registered
   * 
   * @return GatewayResourceProfile
   *   Returns all the GatewayResourcePrifle list object.
   * 
   * 
   * 
   * @param authzToken
   */
  virtual void getAllGatewayResourceProfiles(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Update a Compute Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be updated.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param computeResourceId
   * @param computeResourcePreference
   */
  virtual bool updateGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& computeResourceId, const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& computeResourcePreference) = 0;

  /**
   * Update a Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be updated.
   * 
   * @param storageId
   *   The Storage resource identifier of the one that you want to update
   * 
   * @param storagePreference
   *   The storagePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param storageId
   * @param storagePreference
   */
  virtual bool updateGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& storageId, const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& storagePreference) = 0;

  /**
   * Delete the Compute Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be deleted.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param computeResourceId
   */
  virtual bool deleteGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& computeResourceId) = 0;

  /**
   * Delete the Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be deleted.
   * 
   * @param storageId
   *   ID of the storage preference you want to delete.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param gatewayID
   * @param storageId
   */
  virtual bool deleteGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayID, const std::string& storageId) = 0;

  /**
   * Register User Resource Profile.
   * 
   * @param UserResourceProfile
   *    User Resource Profile Object.
   *    The userId should be obtained from Airavata user profile data model and passed to register a corresponding
   *      resource profile.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param userResourceProfile
   */
  virtual void registerUserResourceProfile(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& userResourceProfile) = 0;

  /**
   * Fetch the given User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource profile.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @return UserResourceProfile
   *    User Resource Profile Object.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   */
  virtual void getUserResourceProfile( ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID) = 0;

  /**
   * Update a User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param UserResourceProfile
   *    User Resource Profile Object.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userResourceProfile
   */
  virtual bool updateUserResourceProfile(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& userResourceProfile) = 0;

  /**
   * Delete the given User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   */
  virtual bool deleteUserResourceProfile(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID) = 0;

  /**
   * Add a Compute Resource Preference to a registered User profile.
   * 
   * @param userId
   *   The identifier for the User resource profile to be added.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userComputeResourceId
   * @param userComputeResourcePreference
   */
  virtual bool addUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userComputeResourceId, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& userComputeResourcePreference) = 0;

  /**
   * Add a Storage Resource Preference to a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to be added.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param storageResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userStorageResourceId
   * @param userStoragePreference
   */
  virtual bool addUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userStorageResourceId, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& userStoragePreference) = 0;

  /**
   * 
   * Fetch a Compute Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user profile to be requested
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userComputeResourceId
   */
  virtual void getUserComputeResourcePreference( ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userComputeResourceId) = 0;

  /**
   * 
   * Fetch a Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageResourceId
   *   Identifier of the Stprage Preference required to be fetched.
   * 
   * @return UserStoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userStorageResourceId
   */
  virtual void getUserStoragePreference( ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userStorageResourceId) = 0;

  /**
   * 
   * Fetch all Compute Resource Preferences of a registered gateway profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   */
  virtual void getAllUserComputeResourcePreferences(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID) = 0;

  /**
   * Fetch all User Storage Resource Preferences of a registered user profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   */
  virtual void getAllUserStoragePreferences(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID) = 0;

  /**
   * 
   * Fetch all user resources Profiles registered
   * 
   * @return UserResourceProfile
   *   Returns all the UserResourcePrifle list object.
   * 
   * 
   * 
   * @param authzToken
   */
  virtual void getAllUserResourceProfiles(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * Update a Compute Resource Preference to a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user profile to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param userComputeResourcePreference
   *   The ComputeResourcePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userComputeResourceId
   * @param userComputeResourcePreference
   */
  virtual bool updateUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userComputeResourceId, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& userComputeResourcePreference) = 0;

  /**
   * Update a Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageId
   *   The Storage resource identifier of the one that you want to update
   * 
   * @param userStoragePreference
   *   The storagePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userStorageId
   * @param userStoragePreference
   */
  virtual bool updateUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userStorageId, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& userStoragePreference) = 0;

  /**
   * Delete the Compute Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user resource profile to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userComputeResourceId
   */
  virtual bool deleteUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userComputeResourceId) = 0;

  /**
   * Delete the Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user profile to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageId
   *   ID of the storage preference you want to delete.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param authzToken
   * @param userId
   * @param gatewayID
   * @param userStorageId
   */
  virtual bool deleteUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userId, const std::string& gatewayID, const std::string& userStorageId) = 0;
  virtual void getAllWorkflows(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId) = 0;
  virtual void getLatestQueueStatuses(std::vector< ::apache::airavata::model::status::QueueStatusModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken) = 0;

  /**
   * 
   * API Methods Related for Work-Flow Submission Features.
   * 
   * 
   * @param authzToken
   * @param workflowTemplateId
   */
  virtual void getWorkflow( ::WorkflowModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& workflowTemplateId) = 0;
  virtual void deleteWorkflow(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& workflowTemplateId) = 0;
  virtual void registerWorkflow(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::WorkflowModel& workflow) = 0;
  virtual void updateWorkflow(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& workflowTemplateId, const  ::WorkflowModel& workflow) = 0;
  virtual void getWorkflowTemplateId(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& workflowName) = 0;
  virtual bool isWorkflowExistWithName(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& workflowName) = 0;

  /**
   * API Methods related to replica catalog
   * 
   * 
   * @param authzToken
   * @param dataProductModel
   */
  virtual void registerDataProduct(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::data::replica::DataProductModel& dataProductModel) = 0;
  virtual void getDataProduct( ::apache::airavata::model::data::replica::DataProductModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& dataProductUri) = 0;
  virtual void registerReplicaLocation(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::data::replica::DataReplicaLocationModel& replicaLocationModel) = 0;
  virtual void getParentDataProduct( ::apache::airavata::model::data::replica::DataProductModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri) = 0;
  virtual void getChildDataProducts(std::vector< ::apache::airavata::model::data::replica::DataProductModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& productUri) = 0;

  /**
   * Group Manager and Data Sharing Related API methods
   * 
   * 
   * @param authzToken
   * @param resourceId
   * @param resourceType
   * @param userPermissionList
   */
  virtual bool shareResourceWithUsers(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceId, const  ::apache::airavata::model::group::ResourceType::type resourceType, const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & userPermissionList) = 0;
  virtual bool revokeSharingOfResourceFromUsers(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceId, const  ::apache::airavata::model::group::ResourceType::type resourceType, const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & userPermissionList) = 0;
  virtual void getAllAccessibleUsers(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& resourceId, const  ::apache::airavata::model::group::ResourceType::type resourceType, const  ::apache::airavata::model::group::ResourcePermissionType::type permissionType) = 0;
  virtual void createGroup(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::group::GroupModel& groupModel) = 0;
  virtual bool updateGroup(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::group::GroupModel& groupModel) = 0;
  virtual bool deleteGroup(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& groupId, const std::string& ownerId) = 0;
  virtual void getGroup( ::apache::airavata::model::group::GroupModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& groupId) = 0;
  virtual void getAllGroupsUserBelongs(std::vector< ::apache::airavata::model::group::GroupModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& userName) = 0;
};

class AiravataIfFactory {
 public:
  typedef AiravataIf Handler;

  virtual ~AiravataIfFactory() {}

  virtual AiravataIf* getHandler(const ::apache::thrift::TConnectionInfo& connInfo) = 0;
  virtual void releaseHandler(AiravataIf* /* handler */) = 0;
};

class AiravataIfSingletonFactory : virtual public AiravataIfFactory {
 public:
  AiravataIfSingletonFactory(const boost::shared_ptr<AiravataIf>& iface) : iface_(iface) {}
  virtual ~AiravataIfSingletonFactory() {}

  virtual AiravataIf* getHandler(const ::apache::thrift::TConnectionInfo&) {
    return iface_.get();
  }
  virtual void releaseHandler(AiravataIf* /* handler */) {}

 protected:
  boost::shared_ptr<AiravataIf> iface_;
};

class AiravataNull : virtual public AiravataIf {
 public:
  virtual ~AiravataNull() {}
  void getAPIVersion(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool isUserExists(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */) {
    bool _return = false;
    return _return;
  }
  void addGateway(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::workspace::Gateway& /* gateway */) {
    return;
  }
  void getAllUsersInGateway(std::vector<std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  bool updateGateway(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::workspace::Gateway& /* updatedGateway */) {
    bool _return = false;
    return _return;
  }
  void getGateway( ::apache::airavata::model::workspace::Gateway& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  bool deleteGateway(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    bool _return = false;
    return _return;
  }
  void getAllGateways(std::vector< ::apache::airavata::model::workspace::Gateway> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool isGatewayExist(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    bool _return = false;
    return _return;
  }
  void createNotification(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::workspace::Notification& /* notification */) {
    return;
  }
  bool updateNotification(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::workspace::Notification& /* notification */) {
    bool _return = false;
    return _return;
  }
  bool deleteNotification(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* notificationId */) {
    bool _return = false;
    return _return;
  }
  void getNotification( ::apache::airavata::model::workspace::Notification& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* notificationId */) {
    return;
  }
  void getAllNotifications(std::vector< ::apache::airavata::model::workspace::Notification> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void generateAndRegisterSSHKeys(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */, const std::string& /* description */, const  ::CredentialOwnerType::type /* credentialOwnerType */) {
    return;
  }
  void registerPwdCredential(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* portalUserName */, const std::string& /* loginUserName */, const std::string& /* password */, const std::string& /* description */) {
    return;
  }
  void getSSHPubKey(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataCredStoreToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getAllGatewaySSHPubKeys(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getAllCredentialSummaryForGateway(std::vector< ::CredentialSummary> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::SummaryType::type /* type */, const std::string& /* gatewayId */) {
    return;
  }
  void getAllCredentialSummaryForUsersInGateway(std::vector< ::CredentialSummary> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::SummaryType::type /* type */, const std::string& /* gatewayId */, const std::string& /* userId */) {
    return;
  }
  void getAllGatewayPWDCredentials(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  bool deleteSSHPubKey(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataCredStoreToken */, const std::string& /* gatewayId */) {
    bool _return = false;
    return _return;
  }
  bool deletePWDCredential(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataCredStoreToken */, const std::string& /* gatewayId */) {
    bool _return = false;
    return _return;
  }
  void createProject(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::workspace::Project& /* project */) {
    return;
  }
  void updateProject(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* projectId */, const  ::apache::airavata::model::workspace::Project& /* updatedProject */) {
    return;
  }
  void getProject( ::apache::airavata::model::workspace::Project& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* projectId */) {
    return;
  }
  bool deleteProject(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* projectId */) {
    bool _return = false;
    return _return;
  }
  void getUserProjects(std::vector< ::apache::airavata::model::workspace::Project> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */, const int32_t /* limit */, const int32_t /* offset */) {
    return;
  }
  void searchProjects(std::vector< ::apache::airavata::model::workspace::Project> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */, const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> & /* filters */, const int32_t /* limit */, const int32_t /* offset */) {
    return;
  }
  void searchExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */, const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> & /* filters */, const int32_t /* limit */, const int32_t /* offset */) {
    return;
  }
  void getExperimentStatistics( ::apache::airavata::model::experiment::ExperimentStatistics& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const int64_t /* fromTime */, const int64_t /* toTime */, const std::string& /* userName */, const std::string& /* applicationName */, const std::string& /* resourceHostName */) {
    return;
  }
  void getExperimentsInProject(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* projectId */, const int32_t /* limit */, const int32_t /* offset */) {
    return;
  }
  void getUserExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const std::string& /* userName */, const int32_t /* limit */, const int32_t /* offset */) {
    return;
  }
  void createExperiment(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::experiment::ExperimentModel& /* experiment */) {
    return;
  }
  bool deleteExperiment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* experimentId */) {
    bool _return = false;
    return _return;
  }
  void getExperiment( ::apache::airavata::model::experiment::ExperimentModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getExperimentByAdmin( ::apache::airavata::model::experiment::ExperimentModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getDetailedExperimentTree( ::apache::airavata::model::experiment::ExperimentModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void updateExperiment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */, const  ::apache::airavata::model::experiment::ExperimentModel& /* experiment */) {
    return;
  }
  void updateExperimentConfiguration(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */, const  ::apache::airavata::model::experiment::UserConfigurationDataModel& /* userConfiguration */) {
    return;
  }
  void updateResourceScheduleing(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */, const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& /* resourceScheduling */) {
    return;
  }
  bool validateExperiment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    bool _return = false;
    return _return;
  }
  void launchExperiment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */, const std::string& /* gatewayId */) {
    return;
  }
  void getExperimentStatus( ::apache::airavata::model::status::ExperimentStatus& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getExperimentOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getIntermediateOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getJobStatuses(std::map<std::string,  ::apache::airavata::model::status::JobStatus> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void getJobDetails(std::vector< ::apache::airavata::model::job::JobModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */) {
    return;
  }
  void cloneExperiment(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* existingExperimentID */, const std::string& /* newExperimentName */, const std::string& /* newExperimentProjectId */) {
    return;
  }
  void cloneExperimentByAdmin(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* existingExperimentID */, const std::string& /* newExperimentName */, const std::string& /* newExperimentProjectId */) {
    return;
  }
  void terminateExperiment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* airavataExperimentId */, const std::string& /* gatewayId */) {
    return;
  }
  void registerApplicationModule(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& /* applicationModule */) {
    return;
  }
  void getApplicationModule( ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appModuleId */) {
    return;
  }
  bool updateApplicationModule(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appModuleId */, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& /* applicationModule */) {
    bool _return = false;
    return _return;
  }
  void getAllAppModules(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  bool deleteApplicationModule(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appModuleId */) {
    bool _return = false;
    return _return;
  }
  void registerApplicationDeployment(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& /* applicationDeployment */) {
    return;
  }
  void getApplicationDeployment( ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appDeploymentId */) {
    return;
  }
  bool updateApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appDeploymentId */, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& /* applicationDeployment */) {
    bool _return = false;
    return _return;
  }
  bool deleteApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appDeploymentId */) {
    bool _return = false;
    return _return;
  }
  void getAllApplicationDeployments(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getAppModuleDeployedResources(std::vector<std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appModuleId */) {
    return;
  }
  void registerApplicationInterface(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& /* applicationInterface */) {
    return;
  }
  void cloneApplicationInterface(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* existingAppInterfaceID */, const std::string& /* newApplicationName */, const std::string& /* gatewayId */) {
    return;
  }
  void getApplicationInterface( ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */) {
    return;
  }
  bool updateApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& /* applicationInterface */) {
    bool _return = false;
    return _return;
  }
  bool deleteApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */) {
    bool _return = false;
    return _return;
  }
  void getAllApplicationInterfaceNames(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getAllApplicationInterfaces(std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getApplicationInputs(std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */) {
    return;
  }
  void getApplicationOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */) {
    return;
  }
  void getAvailableAppInterfaceComputeResources(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* appInterfaceId */) {
    return;
  }
  void registerComputeResource(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& /* computeResourceDescription */) {
    return;
  }
  void getComputeResource( ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */) {
    return;
  }
  void getAllComputeResourceNames(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool updateComputeResource(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& /* computeResourceDescription */) {
    bool _return = false;
    return _return;
  }
  bool deleteComputeResource(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */) {
    bool _return = false;
    return _return;
  }
  void registerStorageResource(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& /* storageResourceDescription */) {
    return;
  }
  void getStorageResource( ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* storageResourceId */) {
    return;
  }
  void getAllStorageResourceNames(std::map<std::string, std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool updateStorageResource(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* storageResourceId */, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& /* storageResourceDescription */) {
    bool _return = false;
    return _return;
  }
  bool deleteStorageResource(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* storageResourceId */) {
    bool _return = false;
    return _return;
  }
  void addLocalSubmissionDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& /* localSubmission */) {
    return;
  }
  bool updateLocalSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionInterfaceId */, const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& /* localSubmission */) {
    bool _return = false;
    return _return;
  }
  void getLocalJobSubmission( ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionId */) {
    return;
  }
  void addSSHJobSubmissionDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& /* sshJobSubmission */) {
    return;
  }
  void addSSHForkJobSubmissionDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& /* sshJobSubmission */) {
    return;
  }
  void getSSHJobSubmission( ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionId */) {
    return;
  }
  void addUNICOREJobSubmissionDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& /* unicoreJobSubmission */) {
    return;
  }
  void getUnicoreJobSubmission( ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionId */) {
    return;
  }
  void addCloudJobSubmissionDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& /* cloudSubmission */) {
    return;
  }
  void getCloudJobSubmission( ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionId */) {
    return;
  }
  bool updateSSHJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionInterfaceId */, const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& /* sshJobSubmission */) {
    bool _return = false;
    return _return;
  }
  bool updateCloudJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionInterfaceId */, const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& /* sshJobSubmission */) {
    bool _return = false;
    return _return;
  }
  bool updateUnicoreJobSubmissionDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionInterfaceId */, const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& /* unicoreJobSubmission */) {
    bool _return = false;
    return _return;
  }
  void addLocalDataMovementDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */, const  ::apache::airavata::model::data::movement::DMType::type /* dataMoveType */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::data::movement::LOCALDataMovement& /* localDataMovement */) {
    return;
  }
  bool updateLocalDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementInterfaceId */, const  ::apache::airavata::model::data::movement::LOCALDataMovement& /* localDataMovement */) {
    bool _return = false;
    return _return;
  }
  void getLocalDataMovement( ::apache::airavata::model::data::movement::LOCALDataMovement& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementId */) {
    return;
  }
  void addSCPDataMovementDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */, const  ::apache::airavata::model::data::movement::DMType::type /* dataMoveType */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::data::movement::SCPDataMovement& /* scpDataMovement */) {
    return;
  }
  bool updateSCPDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementInterfaceId */, const  ::apache::airavata::model::data::movement::SCPDataMovement& /* scpDataMovement */) {
    bool _return = false;
    return _return;
  }
  void getSCPDataMovement( ::apache::airavata::model::data::movement::SCPDataMovement& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementId */) {
    return;
  }
  void addUnicoreDataMovementDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */, const  ::apache::airavata::model::data::movement::DMType::type /* dataMoveType */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::data::movement::UnicoreDataMovement& /* unicoreDataMovement */) {
    return;
  }
  bool updateUnicoreDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementInterfaceId */, const  ::apache::airavata::model::data::movement::UnicoreDataMovement& /* unicoreDataMovement */) {
    bool _return = false;
    return _return;
  }
  void getUnicoreDataMovement( ::apache::airavata::model::data::movement::UnicoreDataMovement& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementId */) {
    return;
  }
  void addGridFTPDataMovementDetails(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */, const  ::apache::airavata::model::data::movement::DMType::type /* dataMoveType */, const int32_t /* priorityOrder */, const  ::apache::airavata::model::data::movement::GridFTPDataMovement& /* gridFTPDataMovement */) {
    return;
  }
  bool updateGridFTPDataMovementDetails(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementInterfaceId */, const  ::apache::airavata::model::data::movement::GridFTPDataMovement& /* gridFTPDataMovement */) {
    bool _return = false;
    return _return;
  }
  void getGridFTPDataMovement( ::apache::airavata::model::data::movement::GridFTPDataMovement& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementId */) {
    return;
  }
  bool changeJobSubmissionPriority(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* jobSubmissionInterfaceId */, const int32_t /* newPriorityOrder */) {
    bool _return = false;
    return _return;
  }
  bool changeDataMovementPriority(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataMovementInterfaceId */, const int32_t /* newPriorityOrder */) {
    bool _return = false;
    return _return;
  }
  bool changeJobSubmissionPriorities(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::map<std::string, int32_t> & /* jobSubmissionPriorityMap */) {
    bool _return = false;
    return _return;
  }
  bool changeDataMovementPriorities(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::map<std::string, int32_t> & /* dataMovementPriorityMap */) {
    bool _return = false;
    return _return;
  }
  bool deleteJobSubmissionInterface(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const std::string& /* jobSubmissionInterfaceId */) {
    bool _return = false;
    return _return;
  }
  bool deleteDataMovementInterface(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */, const std::string& /* dataMovementInterfaceId */, const  ::apache::airavata::model::data::movement::DMType::type /* dataMoveType */) {
    bool _return = false;
    return _return;
  }
  void registerResourceJobManager(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& /* resourceJobManager */) {
    return;
  }
  bool updateResourceJobManager(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceJobManagerId */, const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& /* updatedResourceJobManager */) {
    bool _return = false;
    return _return;
  }
  void getResourceJobManager( ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceJobManagerId */) {
    return;
  }
  bool deleteResourceJobManager(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceJobManagerId */) {
    bool _return = false;
    return _return;
  }
  bool deleteBatchQueue(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* computeResourceId */, const std::string& /* queueName */) {
    bool _return = false;
    return _return;
  }
  void registerGatewayResourceProfile(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& /* gatewayResourceProfile */) {
    return;
  }
  void getGatewayResourceProfile( ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */) {
    return;
  }
  bool updateGatewayResourceProfile(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& /* gatewayResourceProfile */) {
    bool _return = false;
    return _return;
  }
  bool deleteGatewayResourceProfile(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */) {
    bool _return = false;
    return _return;
  }
  bool addGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* computeResourceId */, const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& /* computeResourcePreference */) {
    bool _return = false;
    return _return;
  }
  bool addGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* storageResourceId */, const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& /* storagePreference */) {
    bool _return = false;
    return _return;
  }
  void getGatewayComputeResourcePreference( ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* computeResourceId */) {
    return;
  }
  void getGatewayStoragePreference( ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* storageResourceId */) {
    return;
  }
  void getAllGatewayComputeResourcePreferences(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */) {
    return;
  }
  void getAllGatewayStoragePreferences(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */) {
    return;
  }
  void getAllGatewayResourceProfiles(std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool updateGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* computeResourceId */, const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& /* computeResourcePreference */) {
    bool _return = false;
    return _return;
  }
  bool updateGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* storageId */, const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& /* storagePreference */) {
    bool _return = false;
    return _return;
  }
  bool deleteGatewayComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* computeResourceId */) {
    bool _return = false;
    return _return;
  }
  bool deleteGatewayStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayID */, const std::string& /* storageId */) {
    bool _return = false;
    return _return;
  }
  void registerUserResourceProfile(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& /* userResourceProfile */) {
    return;
  }
  void getUserResourceProfile( ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */) {
    return;
  }
  bool updateUserResourceProfile(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& /* userResourceProfile */) {
    bool _return = false;
    return _return;
  }
  bool deleteUserResourceProfile(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */) {
    bool _return = false;
    return _return;
  }
  bool addUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userComputeResourceId */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& /* userComputeResourcePreference */) {
    bool _return = false;
    return _return;
  }
  bool addUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userStorageResourceId */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& /* userStoragePreference */) {
    bool _return = false;
    return _return;
  }
  void getUserComputeResourcePreference( ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userComputeResourceId */) {
    return;
  }
  void getUserStoragePreference( ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userStorageResourceId */) {
    return;
  }
  void getAllUserComputeResourcePreferences(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */) {
    return;
  }
  void getAllUserStoragePreferences(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */) {
    return;
  }
  void getAllUserResourceProfiles(std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  bool updateUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userComputeResourceId */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& /* userComputeResourcePreference */) {
    bool _return = false;
    return _return;
  }
  bool updateUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userStorageId */, const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& /* userStoragePreference */) {
    bool _return = false;
    return _return;
  }
  bool deleteUserComputeResourcePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userComputeResourceId */) {
    bool _return = false;
    return _return;
  }
  bool deleteUserStoragePreference(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userId */, const std::string& /* gatewayID */, const std::string& /* userStorageId */) {
    bool _return = false;
    return _return;
  }
  void getAllWorkflows(std::vector<std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */) {
    return;
  }
  void getLatestQueueStatuses(std::vector< ::apache::airavata::model::status::QueueStatusModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */) {
    return;
  }
  void getWorkflow( ::WorkflowModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* workflowTemplateId */) {
    return;
  }
  void deleteWorkflow(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* workflowTemplateId */) {
    return;
  }
  void registerWorkflow(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* gatewayId */, const  ::WorkflowModel& /* workflow */) {
    return;
  }
  void updateWorkflow(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* workflowTemplateId */, const  ::WorkflowModel& /* workflow */) {
    return;
  }
  void getWorkflowTemplateId(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* workflowName */) {
    return;
  }
  bool isWorkflowExistWithName(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* workflowName */) {
    bool _return = false;
    return _return;
  }
  void registerDataProduct(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::data::replica::DataProductModel& /* dataProductModel */) {
    return;
  }
  void getDataProduct( ::apache::airavata::model::data::replica::DataProductModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* dataProductUri */) {
    return;
  }
  void registerReplicaLocation(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::data::replica::DataReplicaLocationModel& /* replicaLocationModel */) {
    return;
  }
  void getParentDataProduct( ::apache::airavata::model::data::replica::DataProductModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */) {
    return;
  }
  void getChildDataProducts(std::vector< ::apache::airavata::model::data::replica::DataProductModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* productUri */) {
    return;
  }
  bool shareResourceWithUsers(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceId */, const  ::apache::airavata::model::group::ResourceType::type /* resourceType */, const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & /* userPermissionList */) {
    bool _return = false;
    return _return;
  }
  bool revokeSharingOfResourceFromUsers(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceId */, const  ::apache::airavata::model::group::ResourceType::type /* resourceType */, const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & /* userPermissionList */) {
    bool _return = false;
    return _return;
  }
  void getAllAccessibleUsers(std::vector<std::string> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* resourceId */, const  ::apache::airavata::model::group::ResourceType::type /* resourceType */, const  ::apache::airavata::model::group::ResourcePermissionType::type /* permissionType */) {
    return;
  }
  void createGroup(std::string& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::group::GroupModel& /* groupModel */) {
    return;
  }
  bool updateGroup(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const  ::apache::airavata::model::group::GroupModel& /* groupModel */) {
    bool _return = false;
    return _return;
  }
  bool deleteGroup(const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* groupId */, const std::string& /* ownerId */) {
    bool _return = false;
    return _return;
  }
  void getGroup( ::apache::airavata::model::group::GroupModel& /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* groupId */) {
    return;
  }
  void getAllGroupsUserBelongs(std::vector< ::apache::airavata::model::group::GroupModel> & /* _return */, const  ::apache::airavata::model::security::AuthzToken& /* authzToken */, const std::string& /* userName */) {
    return;
  }
};


class Airavata_getAPIVersion_args {
 public:

  Airavata_getAPIVersion_args(const Airavata_getAPIVersion_args&);
  Airavata_getAPIVersion_args& operator=(const Airavata_getAPIVersion_args&);
  Airavata_getAPIVersion_args() {
  }

  virtual ~Airavata_getAPIVersion_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAPIVersion_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAPIVersion_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAPIVersion_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAPIVersion_pargs {
 public:


  virtual ~Airavata_getAPIVersion_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAPIVersion_result__isset {
  _Airavata_getAPIVersion_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAPIVersion_result__isset;

class Airavata_getAPIVersion_result {
 public:

  Airavata_getAPIVersion_result(const Airavata_getAPIVersion_result&);
  Airavata_getAPIVersion_result& operator=(const Airavata_getAPIVersion_result&);
  Airavata_getAPIVersion_result() : success() {
  }

  virtual ~Airavata_getAPIVersion_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAPIVersion_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAPIVersion_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAPIVersion_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAPIVersion_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAPIVersion_presult__isset {
  _Airavata_getAPIVersion_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAPIVersion_presult__isset;

class Airavata_getAPIVersion_presult {
 public:


  virtual ~Airavata_getAPIVersion_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAPIVersion_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_isUserExists_args {
 public:

  Airavata_isUserExists_args(const Airavata_isUserExists_args&);
  Airavata_isUserExists_args& operator=(const Airavata_isUserExists_args&);
  Airavata_isUserExists_args() : gatewayId(), userName() {
  }

  virtual ~Airavata_isUserExists_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  bool operator == (const Airavata_isUserExists_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    return true;
  }
  bool operator != (const Airavata_isUserExists_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isUserExists_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_isUserExists_pargs {
 public:


  virtual ~Airavata_isUserExists_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isUserExists_result__isset {
  _Airavata_isUserExists_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isUserExists_result__isset;

class Airavata_isUserExists_result {
 public:

  Airavata_isUserExists_result(const Airavata_isUserExists_result&);
  Airavata_isUserExists_result& operator=(const Airavata_isUserExists_result&);
  Airavata_isUserExists_result() : success(0) {
  }

  virtual ~Airavata_isUserExists_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isUserExists_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_isUserExists_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_isUserExists_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isUserExists_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isUserExists_presult__isset {
  _Airavata_isUserExists_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isUserExists_presult__isset;

class Airavata_isUserExists_presult {
 public:


  virtual ~Airavata_isUserExists_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isUserExists_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addGateway_args {
 public:

  Airavata_addGateway_args(const Airavata_addGateway_args&);
  Airavata_addGateway_args& operator=(const Airavata_addGateway_args&);
  Airavata_addGateway_args() {
  }

  virtual ~Airavata_addGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::workspace::Gateway gateway;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gateway(const  ::apache::airavata::model::workspace::Gateway& val);

  bool operator == (const Airavata_addGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gateway == rhs.gateway))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addGateway_pargs {
 public:


  virtual ~Airavata_addGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::workspace::Gateway* gateway;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGateway_result__isset {
  _Airavata_addGateway_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGateway_result__isset;

class Airavata_addGateway_result {
 public:

  Airavata_addGateway_result(const Airavata_addGateway_result&);
  Airavata_addGateway_result& operator=(const Airavata_addGateway_result&);
  Airavata_addGateway_result() : success() {
  }

  virtual ~Airavata_addGateway_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGateway_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGateway_presult__isset {
  _Airavata_addGateway_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGateway_presult__isset;

class Airavata_addGateway_presult {
 public:


  virtual ~Airavata_addGateway_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllUsersInGateway_args {
 public:

  Airavata_getAllUsersInGateway_args(const Airavata_getAllUsersInGateway_args&);
  Airavata_getAllUsersInGateway_args& operator=(const Airavata_getAllUsersInGateway_args&);
  Airavata_getAllUsersInGateway_args() : gatewayId() {
  }

  virtual ~Airavata_getAllUsersInGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllUsersInGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUsersInGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUsersInGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllUsersInGateway_pargs {
 public:


  virtual ~Airavata_getAllUsersInGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUsersInGateway_result__isset {
  _Airavata_getAllUsersInGateway_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUsersInGateway_result__isset;

class Airavata_getAllUsersInGateway_result {
 public:

  Airavata_getAllUsersInGateway_result(const Airavata_getAllUsersInGateway_result&);
  Airavata_getAllUsersInGateway_result& operator=(const Airavata_getAllUsersInGateway_result&);
  Airavata_getAllUsersInGateway_result() {
  }

  virtual ~Airavata_getAllUsersInGateway_result() throw();
  std::vector<std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUsersInGateway_result__isset __isset;

  void __set_success(const std::vector<std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllUsersInGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUsersInGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUsersInGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUsersInGateway_presult__isset {
  _Airavata_getAllUsersInGateway_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUsersInGateway_presult__isset;

class Airavata_getAllUsersInGateway_presult {
 public:


  virtual ~Airavata_getAllUsersInGateway_presult() throw();
  std::vector<std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUsersInGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGateway_args {
 public:

  Airavata_updateGateway_args(const Airavata_updateGateway_args&);
  Airavata_updateGateway_args& operator=(const Airavata_updateGateway_args&);
  Airavata_updateGateway_args() : gatewayId() {
  }

  virtual ~Airavata_updateGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::workspace::Gateway updatedGateway;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_updatedGateway(const  ::apache::airavata::model::workspace::Gateway& val);

  bool operator == (const Airavata_updateGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(updatedGateway == rhs.updatedGateway))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGateway_pargs {
 public:


  virtual ~Airavata_updateGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::workspace::Gateway* updatedGateway;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGateway_result__isset {
  _Airavata_updateGateway_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGateway_result__isset;

class Airavata_updateGateway_result {
 public:

  Airavata_updateGateway_result(const Airavata_updateGateway_result&);
  Airavata_updateGateway_result& operator=(const Airavata_updateGateway_result&);
  Airavata_updateGateway_result() : success(0) {
  }

  virtual ~Airavata_updateGateway_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGateway_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGateway_presult__isset {
  _Airavata_updateGateway_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGateway_presult__isset;

class Airavata_updateGateway_presult {
 public:


  virtual ~Airavata_updateGateway_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGateway_args {
 public:

  Airavata_getGateway_args(const Airavata_getGateway_args&);
  Airavata_getGateway_args& operator=(const Airavata_getGateway_args&);
  Airavata_getGateway_args() : gatewayId() {
  }

  virtual ~Airavata_getGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGateway_pargs {
 public:


  virtual ~Airavata_getGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGateway_result__isset {
  _Airavata_getGateway_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGateway_result__isset;

class Airavata_getGateway_result {
 public:

  Airavata_getGateway_result(const Airavata_getGateway_result&);
  Airavata_getGateway_result& operator=(const Airavata_getGateway_result&);
  Airavata_getGateway_result() {
  }

  virtual ~Airavata_getGateway_result() throw();
   ::apache::airavata::model::workspace::Gateway success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGateway_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::workspace::Gateway& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGateway_presult__isset {
  _Airavata_getGateway_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGateway_presult__isset;

class Airavata_getGateway_presult {
 public:


  virtual ~Airavata_getGateway_presult() throw();
   ::apache::airavata::model::workspace::Gateway* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteGateway_args {
 public:

  Airavata_deleteGateway_args(const Airavata_deleteGateway_args&);
  Airavata_deleteGateway_args& operator=(const Airavata_deleteGateway_args&);
  Airavata_deleteGateway_args() : gatewayId() {
  }

  virtual ~Airavata_deleteGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_deleteGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteGateway_pargs {
 public:


  virtual ~Airavata_deleteGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGateway_result__isset {
  _Airavata_deleteGateway_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGateway_result__isset;

class Airavata_deleteGateway_result {
 public:

  Airavata_deleteGateway_result(const Airavata_deleteGateway_result&);
  Airavata_deleteGateway_result& operator=(const Airavata_deleteGateway_result&);
  Airavata_deleteGateway_result() : success(0) {
  }

  virtual ~Airavata_deleteGateway_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGateway_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGateway_presult__isset {
  _Airavata_deleteGateway_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGateway_presult__isset;

class Airavata_deleteGateway_presult {
 public:


  virtual ~Airavata_deleteGateway_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGateways_args {
 public:

  Airavata_getAllGateways_args(const Airavata_getAllGateways_args&);
  Airavata_getAllGateways_args& operator=(const Airavata_getAllGateways_args&);
  Airavata_getAllGateways_args() {
  }

  virtual ~Airavata_getAllGateways_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAllGateways_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGateways_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGateways_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGateways_pargs {
 public:


  virtual ~Airavata_getAllGateways_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGateways_result__isset {
  _Airavata_getAllGateways_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGateways_result__isset;

class Airavata_getAllGateways_result {
 public:

  Airavata_getAllGateways_result(const Airavata_getAllGateways_result&);
  Airavata_getAllGateways_result& operator=(const Airavata_getAllGateways_result&);
  Airavata_getAllGateways_result() {
  }

  virtual ~Airavata_getAllGateways_result() throw();
  std::vector< ::apache::airavata::model::workspace::Gateway>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGateways_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::workspace::Gateway> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllGateways_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGateways_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGateways_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGateways_presult__isset {
  _Airavata_getAllGateways_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGateways_presult__isset;

class Airavata_getAllGateways_presult {
 public:


  virtual ~Airavata_getAllGateways_presult() throw();
  std::vector< ::apache::airavata::model::workspace::Gateway> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGateways_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_isGatewayExist_args {
 public:

  Airavata_isGatewayExist_args(const Airavata_isGatewayExist_args&);
  Airavata_isGatewayExist_args& operator=(const Airavata_isGatewayExist_args&);
  Airavata_isGatewayExist_args() : gatewayId() {
  }

  virtual ~Airavata_isGatewayExist_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_isGatewayExist_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_isGatewayExist_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isGatewayExist_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_isGatewayExist_pargs {
 public:


  virtual ~Airavata_isGatewayExist_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isGatewayExist_result__isset {
  _Airavata_isGatewayExist_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isGatewayExist_result__isset;

class Airavata_isGatewayExist_result {
 public:

  Airavata_isGatewayExist_result(const Airavata_isGatewayExist_result&);
  Airavata_isGatewayExist_result& operator=(const Airavata_isGatewayExist_result&);
  Airavata_isGatewayExist_result() : success(0) {
  }

  virtual ~Airavata_isGatewayExist_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isGatewayExist_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_isGatewayExist_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_isGatewayExist_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isGatewayExist_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isGatewayExist_presult__isset {
  _Airavata_isGatewayExist_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isGatewayExist_presult__isset;

class Airavata_isGatewayExist_presult {
 public:


  virtual ~Airavata_isGatewayExist_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isGatewayExist_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_createNotification_args {
 public:

  Airavata_createNotification_args(const Airavata_createNotification_args&);
  Airavata_createNotification_args& operator=(const Airavata_createNotification_args&);
  Airavata_createNotification_args() {
  }

  virtual ~Airavata_createNotification_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::workspace::Notification notification;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_notification(const  ::apache::airavata::model::workspace::Notification& val);

  bool operator == (const Airavata_createNotification_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(notification == rhs.notification))
      return false;
    return true;
  }
  bool operator != (const Airavata_createNotification_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createNotification_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_createNotification_pargs {
 public:


  virtual ~Airavata_createNotification_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::workspace::Notification* notification;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createNotification_result__isset {
  _Airavata_createNotification_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createNotification_result__isset;

class Airavata_createNotification_result {
 public:

  Airavata_createNotification_result(const Airavata_createNotification_result&);
  Airavata_createNotification_result& operator=(const Airavata_createNotification_result&);
  Airavata_createNotification_result() : success() {
  }

  virtual ~Airavata_createNotification_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createNotification_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_createNotification_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_createNotification_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createNotification_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createNotification_presult__isset {
  _Airavata_createNotification_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createNotification_presult__isset;

class Airavata_createNotification_presult {
 public:


  virtual ~Airavata_createNotification_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createNotification_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateNotification_args {
 public:

  Airavata_updateNotification_args(const Airavata_updateNotification_args&);
  Airavata_updateNotification_args& operator=(const Airavata_updateNotification_args&);
  Airavata_updateNotification_args() {
  }

  virtual ~Airavata_updateNotification_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::workspace::Notification notification;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_notification(const  ::apache::airavata::model::workspace::Notification& val);

  bool operator == (const Airavata_updateNotification_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(notification == rhs.notification))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateNotification_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateNotification_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateNotification_pargs {
 public:


  virtual ~Airavata_updateNotification_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::workspace::Notification* notification;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateNotification_result__isset {
  _Airavata_updateNotification_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateNotification_result__isset;

class Airavata_updateNotification_result {
 public:

  Airavata_updateNotification_result(const Airavata_updateNotification_result&);
  Airavata_updateNotification_result& operator=(const Airavata_updateNotification_result&);
  Airavata_updateNotification_result() : success(0) {
  }

  virtual ~Airavata_updateNotification_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateNotification_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateNotification_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateNotification_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateNotification_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateNotification_presult__isset {
  _Airavata_updateNotification_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateNotification_presult__isset;

class Airavata_updateNotification_presult {
 public:


  virtual ~Airavata_updateNotification_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateNotification_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteNotification_args {
 public:

  Airavata_deleteNotification_args(const Airavata_deleteNotification_args&);
  Airavata_deleteNotification_args& operator=(const Airavata_deleteNotification_args&);
  Airavata_deleteNotification_args() : gatewayId(), notificationId() {
  }

  virtual ~Airavata_deleteNotification_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string notificationId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_notificationId(const std::string& val);

  bool operator == (const Airavata_deleteNotification_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(notificationId == rhs.notificationId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteNotification_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteNotification_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteNotification_pargs {
 public:


  virtual ~Airavata_deleteNotification_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* notificationId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteNotification_result__isset {
  _Airavata_deleteNotification_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteNotification_result__isset;

class Airavata_deleteNotification_result {
 public:

  Airavata_deleteNotification_result(const Airavata_deleteNotification_result&);
  Airavata_deleteNotification_result& operator=(const Airavata_deleteNotification_result&);
  Airavata_deleteNotification_result() : success(0) {
  }

  virtual ~Airavata_deleteNotification_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteNotification_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteNotification_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteNotification_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteNotification_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteNotification_presult__isset {
  _Airavata_deleteNotification_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteNotification_presult__isset;

class Airavata_deleteNotification_presult {
 public:


  virtual ~Airavata_deleteNotification_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteNotification_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getNotification_args {
 public:

  Airavata_getNotification_args(const Airavata_getNotification_args&);
  Airavata_getNotification_args& operator=(const Airavata_getNotification_args&);
  Airavata_getNotification_args() : gatewayId(), notificationId() {
  }

  virtual ~Airavata_getNotification_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string notificationId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_notificationId(const std::string& val);

  bool operator == (const Airavata_getNotification_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(notificationId == rhs.notificationId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getNotification_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getNotification_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getNotification_pargs {
 public:


  virtual ~Airavata_getNotification_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* notificationId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getNotification_result__isset {
  _Airavata_getNotification_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getNotification_result__isset;

class Airavata_getNotification_result {
 public:

  Airavata_getNotification_result(const Airavata_getNotification_result&);
  Airavata_getNotification_result& operator=(const Airavata_getNotification_result&);
  Airavata_getNotification_result() {
  }

  virtual ~Airavata_getNotification_result() throw();
   ::apache::airavata::model::workspace::Notification success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getNotification_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::workspace::Notification& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getNotification_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getNotification_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getNotification_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getNotification_presult__isset {
  _Airavata_getNotification_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getNotification_presult__isset;

class Airavata_getNotification_presult {
 public:


  virtual ~Airavata_getNotification_presult() throw();
   ::apache::airavata::model::workspace::Notification* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getNotification_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllNotifications_args {
 public:

  Airavata_getAllNotifications_args(const Airavata_getAllNotifications_args&);
  Airavata_getAllNotifications_args& operator=(const Airavata_getAllNotifications_args&);
  Airavata_getAllNotifications_args() : gatewayId() {
  }

  virtual ~Airavata_getAllNotifications_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllNotifications_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllNotifications_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllNotifications_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllNotifications_pargs {
 public:


  virtual ~Airavata_getAllNotifications_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllNotifications_result__isset {
  _Airavata_getAllNotifications_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllNotifications_result__isset;

class Airavata_getAllNotifications_result {
 public:

  Airavata_getAllNotifications_result(const Airavata_getAllNotifications_result&);
  Airavata_getAllNotifications_result& operator=(const Airavata_getAllNotifications_result&);
  Airavata_getAllNotifications_result() {
  }

  virtual ~Airavata_getAllNotifications_result() throw();
  std::vector< ::apache::airavata::model::workspace::Notification>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllNotifications_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::workspace::Notification> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllNotifications_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllNotifications_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllNotifications_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllNotifications_presult__isset {
  _Airavata_getAllNotifications_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllNotifications_presult__isset;

class Airavata_getAllNotifications_presult {
 public:


  virtual ~Airavata_getAllNotifications_presult() throw();
  std::vector< ::apache::airavata::model::workspace::Notification> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllNotifications_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_generateAndRegisterSSHKeys_args__isset {
  _Airavata_generateAndRegisterSSHKeys_args__isset() : description(false), credentialOwnerType(false) {}
  bool description :1;
  bool credentialOwnerType :1;
} _Airavata_generateAndRegisterSSHKeys_args__isset;

class Airavata_generateAndRegisterSSHKeys_args {
 public:

  Airavata_generateAndRegisterSSHKeys_args(const Airavata_generateAndRegisterSSHKeys_args&);
  Airavata_generateAndRegisterSSHKeys_args& operator=(const Airavata_generateAndRegisterSSHKeys_args&);
  Airavata_generateAndRegisterSSHKeys_args() : gatewayId(), userName(), description(), credentialOwnerType(( ::CredentialOwnerType::type)0) {
  }

  virtual ~Airavata_generateAndRegisterSSHKeys_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;
  std::string description;
   ::CredentialOwnerType::type credentialOwnerType;

  _Airavata_generateAndRegisterSSHKeys_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  void __set_description(const std::string& val);

  void __set_credentialOwnerType(const  ::CredentialOwnerType::type val);

  bool operator == (const Airavata_generateAndRegisterSSHKeys_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(description == rhs.description))
      return false;
    if (!(credentialOwnerType == rhs.credentialOwnerType))
      return false;
    return true;
  }
  bool operator != (const Airavata_generateAndRegisterSSHKeys_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_generateAndRegisterSSHKeys_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_generateAndRegisterSSHKeys_pargs {
 public:


  virtual ~Airavata_generateAndRegisterSSHKeys_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;
  const std::string* description;
  const  ::CredentialOwnerType::type* credentialOwnerType;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_generateAndRegisterSSHKeys_result__isset {
  _Airavata_generateAndRegisterSSHKeys_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_generateAndRegisterSSHKeys_result__isset;

class Airavata_generateAndRegisterSSHKeys_result {
 public:

  Airavata_generateAndRegisterSSHKeys_result(const Airavata_generateAndRegisterSSHKeys_result&);
  Airavata_generateAndRegisterSSHKeys_result& operator=(const Airavata_generateAndRegisterSSHKeys_result&);
  Airavata_generateAndRegisterSSHKeys_result() : success() {
  }

  virtual ~Airavata_generateAndRegisterSSHKeys_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_generateAndRegisterSSHKeys_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_generateAndRegisterSSHKeys_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_generateAndRegisterSSHKeys_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_generateAndRegisterSSHKeys_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_generateAndRegisterSSHKeys_presult__isset {
  _Airavata_generateAndRegisterSSHKeys_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_generateAndRegisterSSHKeys_presult__isset;

class Airavata_generateAndRegisterSSHKeys_presult {
 public:


  virtual ~Airavata_generateAndRegisterSSHKeys_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_generateAndRegisterSSHKeys_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerPwdCredential_args {
 public:

  Airavata_registerPwdCredential_args(const Airavata_registerPwdCredential_args&);
  Airavata_registerPwdCredential_args& operator=(const Airavata_registerPwdCredential_args&);
  Airavata_registerPwdCredential_args() : gatewayId(), portalUserName(), loginUserName(), password(), description() {
  }

  virtual ~Airavata_registerPwdCredential_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string portalUserName;
  std::string loginUserName;
  std::string password;
  std::string description;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_portalUserName(const std::string& val);

  void __set_loginUserName(const std::string& val);

  void __set_password(const std::string& val);

  void __set_description(const std::string& val);

  bool operator == (const Airavata_registerPwdCredential_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(portalUserName == rhs.portalUserName))
      return false;
    if (!(loginUserName == rhs.loginUserName))
      return false;
    if (!(password == rhs.password))
      return false;
    if (!(description == rhs.description))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerPwdCredential_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerPwdCredential_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerPwdCredential_pargs {
 public:


  virtual ~Airavata_registerPwdCredential_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* portalUserName;
  const std::string* loginUserName;
  const std::string* password;
  const std::string* description;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerPwdCredential_result__isset {
  _Airavata_registerPwdCredential_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_registerPwdCredential_result__isset;

class Airavata_registerPwdCredential_result {
 public:

  Airavata_registerPwdCredential_result(const Airavata_registerPwdCredential_result&);
  Airavata_registerPwdCredential_result& operator=(const Airavata_registerPwdCredential_result&);
  Airavata_registerPwdCredential_result() : success() {
  }

  virtual ~Airavata_registerPwdCredential_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_registerPwdCredential_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_registerPwdCredential_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerPwdCredential_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerPwdCredential_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerPwdCredential_presult__isset {
  _Airavata_registerPwdCredential_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_registerPwdCredential_presult__isset;

class Airavata_registerPwdCredential_presult {
 public:


  virtual ~Airavata_registerPwdCredential_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_registerPwdCredential_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getSSHPubKey_args {
 public:

  Airavata_getSSHPubKey_args(const Airavata_getSSHPubKey_args&);
  Airavata_getSSHPubKey_args& operator=(const Airavata_getSSHPubKey_args&);
  Airavata_getSSHPubKey_args() : airavataCredStoreToken(), gatewayId() {
  }

  virtual ~Airavata_getSSHPubKey_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataCredStoreToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataCredStoreToken(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getSSHPubKey_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataCredStoreToken == rhs.airavataCredStoreToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSSHPubKey_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSSHPubKey_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getSSHPubKey_pargs {
 public:


  virtual ~Airavata_getSSHPubKey_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataCredStoreToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSSHPubKey_result__isset {
  _Airavata_getSSHPubKey_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getSSHPubKey_result__isset;

class Airavata_getSSHPubKey_result {
 public:

  Airavata_getSSHPubKey_result(const Airavata_getSSHPubKey_result&);
  Airavata_getSSHPubKey_result& operator=(const Airavata_getSSHPubKey_result&);
  Airavata_getSSHPubKey_result() : success() {
  }

  virtual ~Airavata_getSSHPubKey_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getSSHPubKey_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_getSSHPubKey_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSSHPubKey_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSSHPubKey_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSSHPubKey_presult__isset {
  _Airavata_getSSHPubKey_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getSSHPubKey_presult__isset;

class Airavata_getSSHPubKey_presult {
 public:


  virtual ~Airavata_getSSHPubKey_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getSSHPubKey_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGatewaySSHPubKeys_args {
 public:

  Airavata_getAllGatewaySSHPubKeys_args(const Airavata_getAllGatewaySSHPubKeys_args&);
  Airavata_getAllGatewaySSHPubKeys_args& operator=(const Airavata_getAllGatewaySSHPubKeys_args&);
  Airavata_getAllGatewaySSHPubKeys_args() : gatewayId() {
  }

  virtual ~Airavata_getAllGatewaySSHPubKeys_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllGatewaySSHPubKeys_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewaySSHPubKeys_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewaySSHPubKeys_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGatewaySSHPubKeys_pargs {
 public:


  virtual ~Airavata_getAllGatewaySSHPubKeys_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewaySSHPubKeys_result__isset {
  _Airavata_getAllGatewaySSHPubKeys_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllGatewaySSHPubKeys_result__isset;

class Airavata_getAllGatewaySSHPubKeys_result {
 public:

  Airavata_getAllGatewaySSHPubKeys_result(const Airavata_getAllGatewaySSHPubKeys_result&);
  Airavata_getAllGatewaySSHPubKeys_result& operator=(const Airavata_getAllGatewaySSHPubKeys_result&);
  Airavata_getAllGatewaySSHPubKeys_result() {
  }

  virtual ~Airavata_getAllGatewaySSHPubKeys_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllGatewaySSHPubKeys_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_getAllGatewaySSHPubKeys_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewaySSHPubKeys_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewaySSHPubKeys_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewaySSHPubKeys_presult__isset {
  _Airavata_getAllGatewaySSHPubKeys_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllGatewaySSHPubKeys_presult__isset;

class Airavata_getAllGatewaySSHPubKeys_presult {
 public:


  virtual ~Airavata_getAllGatewaySSHPubKeys_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllGatewaySSHPubKeys_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllCredentialSummaryForGateway_args {
 public:

  Airavata_getAllCredentialSummaryForGateway_args(const Airavata_getAllCredentialSummaryForGateway_args&);
  Airavata_getAllCredentialSummaryForGateway_args& operator=(const Airavata_getAllCredentialSummaryForGateway_args&);
  Airavata_getAllCredentialSummaryForGateway_args() : type(( ::SummaryType::type)0), gatewayId() {
  }

  virtual ~Airavata_getAllCredentialSummaryForGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::SummaryType::type type;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_type(const  ::SummaryType::type val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllCredentialSummaryForGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(type == rhs.type))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllCredentialSummaryForGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllCredentialSummaryForGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllCredentialSummaryForGateway_pargs {
 public:


  virtual ~Airavata_getAllCredentialSummaryForGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::SummaryType::type* type;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllCredentialSummaryForGateway_result__isset {
  _Airavata_getAllCredentialSummaryForGateway_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllCredentialSummaryForGateway_result__isset;

class Airavata_getAllCredentialSummaryForGateway_result {
 public:

  Airavata_getAllCredentialSummaryForGateway_result(const Airavata_getAllCredentialSummaryForGateway_result&);
  Airavata_getAllCredentialSummaryForGateway_result& operator=(const Airavata_getAllCredentialSummaryForGateway_result&);
  Airavata_getAllCredentialSummaryForGateway_result() {
  }

  virtual ~Airavata_getAllCredentialSummaryForGateway_result() throw();
  std::vector< ::CredentialSummary>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllCredentialSummaryForGateway_result__isset __isset;

  void __set_success(const std::vector< ::CredentialSummary> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_getAllCredentialSummaryForGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllCredentialSummaryForGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllCredentialSummaryForGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllCredentialSummaryForGateway_presult__isset {
  _Airavata_getAllCredentialSummaryForGateway_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllCredentialSummaryForGateway_presult__isset;

class Airavata_getAllCredentialSummaryForGateway_presult {
 public:


  virtual ~Airavata_getAllCredentialSummaryForGateway_presult() throw();
  std::vector< ::CredentialSummary> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllCredentialSummaryForGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllCredentialSummaryForUsersInGateway_args {
 public:

  Airavata_getAllCredentialSummaryForUsersInGateway_args(const Airavata_getAllCredentialSummaryForUsersInGateway_args&);
  Airavata_getAllCredentialSummaryForUsersInGateway_args& operator=(const Airavata_getAllCredentialSummaryForUsersInGateway_args&);
  Airavata_getAllCredentialSummaryForUsersInGateway_args() : type(( ::SummaryType::type)0), gatewayId(), userId() {
  }

  virtual ~Airavata_getAllCredentialSummaryForUsersInGateway_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::SummaryType::type type;
  std::string gatewayId;
  std::string userId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_type(const  ::SummaryType::type val);

  void __set_gatewayId(const std::string& val);

  void __set_userId(const std::string& val);

  bool operator == (const Airavata_getAllCredentialSummaryForUsersInGateway_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(type == rhs.type))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userId == rhs.userId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllCredentialSummaryForUsersInGateway_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllCredentialSummaryForUsersInGateway_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllCredentialSummaryForUsersInGateway_pargs {
 public:


  virtual ~Airavata_getAllCredentialSummaryForUsersInGateway_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::SummaryType::type* type;
  const std::string* gatewayId;
  const std::string* userId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllCredentialSummaryForUsersInGateway_result__isset {
  _Airavata_getAllCredentialSummaryForUsersInGateway_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllCredentialSummaryForUsersInGateway_result__isset;

class Airavata_getAllCredentialSummaryForUsersInGateway_result {
 public:

  Airavata_getAllCredentialSummaryForUsersInGateway_result(const Airavata_getAllCredentialSummaryForUsersInGateway_result&);
  Airavata_getAllCredentialSummaryForUsersInGateway_result& operator=(const Airavata_getAllCredentialSummaryForUsersInGateway_result&);
  Airavata_getAllCredentialSummaryForUsersInGateway_result() {
  }

  virtual ~Airavata_getAllCredentialSummaryForUsersInGateway_result() throw();
  std::vector< ::CredentialSummary>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllCredentialSummaryForUsersInGateway_result__isset __isset;

  void __set_success(const std::vector< ::CredentialSummary> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_getAllCredentialSummaryForUsersInGateway_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllCredentialSummaryForUsersInGateway_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllCredentialSummaryForUsersInGateway_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllCredentialSummaryForUsersInGateway_presult__isset {
  _Airavata_getAllCredentialSummaryForUsersInGateway_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllCredentialSummaryForUsersInGateway_presult__isset;

class Airavata_getAllCredentialSummaryForUsersInGateway_presult {
 public:


  virtual ~Airavata_getAllCredentialSummaryForUsersInGateway_presult() throw();
  std::vector< ::CredentialSummary> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllCredentialSummaryForUsersInGateway_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGatewayPWDCredentials_args {
 public:

  Airavata_getAllGatewayPWDCredentials_args(const Airavata_getAllGatewayPWDCredentials_args&);
  Airavata_getAllGatewayPWDCredentials_args& operator=(const Airavata_getAllGatewayPWDCredentials_args&);
  Airavata_getAllGatewayPWDCredentials_args() : gatewayId() {
  }

  virtual ~Airavata_getAllGatewayPWDCredentials_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllGatewayPWDCredentials_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayPWDCredentials_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayPWDCredentials_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGatewayPWDCredentials_pargs {
 public:


  virtual ~Airavata_getAllGatewayPWDCredentials_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayPWDCredentials_result__isset {
  _Airavata_getAllGatewayPWDCredentials_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllGatewayPWDCredentials_result__isset;

class Airavata_getAllGatewayPWDCredentials_result {
 public:

  Airavata_getAllGatewayPWDCredentials_result(const Airavata_getAllGatewayPWDCredentials_result&);
  Airavata_getAllGatewayPWDCredentials_result& operator=(const Airavata_getAllGatewayPWDCredentials_result&);
  Airavata_getAllGatewayPWDCredentials_result() {
  }

  virtual ~Airavata_getAllGatewayPWDCredentials_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllGatewayPWDCredentials_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_getAllGatewayPWDCredentials_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayPWDCredentials_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayPWDCredentials_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayPWDCredentials_presult__isset {
  _Airavata_getAllGatewayPWDCredentials_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_getAllGatewayPWDCredentials_presult__isset;

class Airavata_getAllGatewayPWDCredentials_presult {
 public:


  virtual ~Airavata_getAllGatewayPWDCredentials_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_getAllGatewayPWDCredentials_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteSSHPubKey_args {
 public:

  Airavata_deleteSSHPubKey_args(const Airavata_deleteSSHPubKey_args&);
  Airavata_deleteSSHPubKey_args& operator=(const Airavata_deleteSSHPubKey_args&);
  Airavata_deleteSSHPubKey_args() : airavataCredStoreToken(), gatewayId() {
  }

  virtual ~Airavata_deleteSSHPubKey_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataCredStoreToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataCredStoreToken(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_deleteSSHPubKey_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataCredStoreToken == rhs.airavataCredStoreToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteSSHPubKey_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteSSHPubKey_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteSSHPubKey_pargs {
 public:


  virtual ~Airavata_deleteSSHPubKey_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataCredStoreToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteSSHPubKey_result__isset {
  _Airavata_deleteSSHPubKey_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_deleteSSHPubKey_result__isset;

class Airavata_deleteSSHPubKey_result {
 public:

  Airavata_deleteSSHPubKey_result(const Airavata_deleteSSHPubKey_result&);
  Airavata_deleteSSHPubKey_result& operator=(const Airavata_deleteSSHPubKey_result&);
  Airavata_deleteSSHPubKey_result() : success(0) {
  }

  virtual ~Airavata_deleteSSHPubKey_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_deleteSSHPubKey_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_deleteSSHPubKey_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteSSHPubKey_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteSSHPubKey_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteSSHPubKey_presult__isset {
  _Airavata_deleteSSHPubKey_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_deleteSSHPubKey_presult__isset;

class Airavata_deleteSSHPubKey_presult {
 public:


  virtual ~Airavata_deleteSSHPubKey_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_deleteSSHPubKey_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deletePWDCredential_args {
 public:

  Airavata_deletePWDCredential_args(const Airavata_deletePWDCredential_args&);
  Airavata_deletePWDCredential_args& operator=(const Airavata_deletePWDCredential_args&);
  Airavata_deletePWDCredential_args() : airavataCredStoreToken(), gatewayId() {
  }

  virtual ~Airavata_deletePWDCredential_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataCredStoreToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataCredStoreToken(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_deletePWDCredential_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataCredStoreToken == rhs.airavataCredStoreToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deletePWDCredential_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deletePWDCredential_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deletePWDCredential_pargs {
 public:


  virtual ~Airavata_deletePWDCredential_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataCredStoreToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deletePWDCredential_result__isset {
  _Airavata_deletePWDCredential_result__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_deletePWDCredential_result__isset;

class Airavata_deletePWDCredential_result {
 public:

  Airavata_deletePWDCredential_result(const Airavata_deletePWDCredential_result&);
  Airavata_deletePWDCredential_result& operator=(const Airavata_deletePWDCredential_result&);
  Airavata_deletePWDCredential_result() : success(0) {
  }

  virtual ~Airavata_deletePWDCredential_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_deletePWDCredential_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  bool operator == (const Airavata_deletePWDCredential_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    return true;
  }
  bool operator != (const Airavata_deletePWDCredential_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deletePWDCredential_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deletePWDCredential_presult__isset {
  _Airavata_deletePWDCredential_presult__isset() : success(false), ire(false), ace(false), ase(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
} _Airavata_deletePWDCredential_presult__isset;

class Airavata_deletePWDCredential_presult {
 public:


  virtual ~Airavata_deletePWDCredential_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;

  _Airavata_deletePWDCredential_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_createProject_args {
 public:

  Airavata_createProject_args(const Airavata_createProject_args&);
  Airavata_createProject_args& operator=(const Airavata_createProject_args&);
  Airavata_createProject_args() : gatewayId() {
  }

  virtual ~Airavata_createProject_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::workspace::Project project;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_project(const  ::apache::airavata::model::workspace::Project& val);

  bool operator == (const Airavata_createProject_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(project == rhs.project))
      return false;
    return true;
  }
  bool operator != (const Airavata_createProject_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createProject_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_createProject_pargs {
 public:


  virtual ~Airavata_createProject_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::workspace::Project* project;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createProject_result__isset {
  _Airavata_createProject_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createProject_result__isset;

class Airavata_createProject_result {
 public:

  Airavata_createProject_result(const Airavata_createProject_result&);
  Airavata_createProject_result& operator=(const Airavata_createProject_result&);
  Airavata_createProject_result() : success() {
  }

  virtual ~Airavata_createProject_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createProject_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_createProject_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_createProject_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createProject_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createProject_presult__isset {
  _Airavata_createProject_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createProject_presult__isset;

class Airavata_createProject_presult {
 public:


  virtual ~Airavata_createProject_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createProject_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateProject_args {
 public:

  Airavata_updateProject_args(const Airavata_updateProject_args&);
  Airavata_updateProject_args& operator=(const Airavata_updateProject_args&);
  Airavata_updateProject_args() : projectId() {
  }

  virtual ~Airavata_updateProject_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string projectId;
   ::apache::airavata::model::workspace::Project updatedProject;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_projectId(const std::string& val);

  void __set_updatedProject(const  ::apache::airavata::model::workspace::Project& val);

  bool operator == (const Airavata_updateProject_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(projectId == rhs.projectId))
      return false;
    if (!(updatedProject == rhs.updatedProject))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateProject_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateProject_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateProject_pargs {
 public:


  virtual ~Airavata_updateProject_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* projectId;
  const  ::apache::airavata::model::workspace::Project* updatedProject;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateProject_result__isset {
  _Airavata_updateProject_result__isset() : ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_updateProject_result__isset;

class Airavata_updateProject_result {
 public:

  Airavata_updateProject_result(const Airavata_updateProject_result&);
  Airavata_updateProject_result& operator=(const Airavata_updateProject_result&);
  Airavata_updateProject_result() {
  }

  virtual ~Airavata_updateProject_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateProject_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateProject_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateProject_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateProject_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateProject_presult__isset {
  _Airavata_updateProject_presult__isset() : ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_updateProject_presult__isset;

class Airavata_updateProject_presult {
 public:


  virtual ~Airavata_updateProject_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateProject_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getProject_args {
 public:

  Airavata_getProject_args(const Airavata_getProject_args&);
  Airavata_getProject_args& operator=(const Airavata_getProject_args&);
  Airavata_getProject_args() : projectId() {
  }

  virtual ~Airavata_getProject_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string projectId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_projectId(const std::string& val);

  bool operator == (const Airavata_getProject_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(projectId == rhs.projectId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getProject_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getProject_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getProject_pargs {
 public:


  virtual ~Airavata_getProject_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* projectId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getProject_result__isset {
  _Airavata_getProject_result__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_getProject_result__isset;

class Airavata_getProject_result {
 public:

  Airavata_getProject_result(const Airavata_getProject_result&);
  Airavata_getProject_result& operator=(const Airavata_getProject_result&);
  Airavata_getProject_result() {
  }

  virtual ~Airavata_getProject_result() throw();
   ::apache::airavata::model::workspace::Project success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getProject_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::workspace::Project& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getProject_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getProject_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getProject_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getProject_presult__isset {
  _Airavata_getProject_presult__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_getProject_presult__isset;

class Airavata_getProject_presult {
 public:


  virtual ~Airavata_getProject_presult() throw();
   ::apache::airavata::model::workspace::Project* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getProject_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteProject_args {
 public:

  Airavata_deleteProject_args(const Airavata_deleteProject_args&);
  Airavata_deleteProject_args& operator=(const Airavata_deleteProject_args&);
  Airavata_deleteProject_args() : projectId() {
  }

  virtual ~Airavata_deleteProject_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string projectId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_projectId(const std::string& val);

  bool operator == (const Airavata_deleteProject_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(projectId == rhs.projectId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteProject_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteProject_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteProject_pargs {
 public:


  virtual ~Airavata_deleteProject_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* projectId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteProject_result__isset {
  _Airavata_deleteProject_result__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_deleteProject_result__isset;

class Airavata_deleteProject_result {
 public:

  Airavata_deleteProject_result(const Airavata_deleteProject_result&);
  Airavata_deleteProject_result& operator=(const Airavata_deleteProject_result&);
  Airavata_deleteProject_result() : success(0) {
  }

  virtual ~Airavata_deleteProject_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteProject_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteProject_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteProject_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteProject_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteProject_presult__isset {
  _Airavata_deleteProject_presult__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_deleteProject_presult__isset;

class Airavata_deleteProject_presult {
 public:


  virtual ~Airavata_deleteProject_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteProject_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUserProjects_args {
 public:

  Airavata_getUserProjects_args(const Airavata_getUserProjects_args&);
  Airavata_getUserProjects_args& operator=(const Airavata_getUserProjects_args&);
  Airavata_getUserProjects_args() : gatewayId(), userName(), limit(0), offset(0) {
  }

  virtual ~Airavata_getUserProjects_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;
  int32_t limit;
  int32_t offset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  void __set_limit(const int32_t val);

  void __set_offset(const int32_t val);

  bool operator == (const Airavata_getUserProjects_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(limit == rhs.limit))
      return false;
    if (!(offset == rhs.offset))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserProjects_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserProjects_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUserProjects_pargs {
 public:


  virtual ~Airavata_getUserProjects_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;
  const int32_t* limit;
  const int32_t* offset;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserProjects_result__isset {
  _Airavata_getUserProjects_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserProjects_result__isset;

class Airavata_getUserProjects_result {
 public:

  Airavata_getUserProjects_result(const Airavata_getUserProjects_result&);
  Airavata_getUserProjects_result& operator=(const Airavata_getUserProjects_result&);
  Airavata_getUserProjects_result() {
  }

  virtual ~Airavata_getUserProjects_result() throw();
  std::vector< ::apache::airavata::model::workspace::Project>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserProjects_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::workspace::Project> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUserProjects_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserProjects_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserProjects_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserProjects_presult__isset {
  _Airavata_getUserProjects_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserProjects_presult__isset;

class Airavata_getUserProjects_presult {
 public:


  virtual ~Airavata_getUserProjects_presult() throw();
  std::vector< ::apache::airavata::model::workspace::Project> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserProjects_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_searchProjects_args__isset {
  _Airavata_searchProjects_args__isset() : filters(false) {}
  bool filters :1;
} _Airavata_searchProjects_args__isset;

class Airavata_searchProjects_args {
 public:

  Airavata_searchProjects_args(const Airavata_searchProjects_args&);
  Airavata_searchProjects_args& operator=(const Airavata_searchProjects_args&);
  Airavata_searchProjects_args() : gatewayId(), userName(), limit(0), offset(0) {
  }

  virtual ~Airavata_searchProjects_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;
  std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string>  filters;
  int32_t limit;
  int32_t offset;

  _Airavata_searchProjects_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  void __set_filters(const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> & val);

  void __set_limit(const int32_t val);

  void __set_offset(const int32_t val);

  bool operator == (const Airavata_searchProjects_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(filters == rhs.filters))
      return false;
    if (!(limit == rhs.limit))
      return false;
    if (!(offset == rhs.offset))
      return false;
    return true;
  }
  bool operator != (const Airavata_searchProjects_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_searchProjects_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_searchProjects_pargs {
 public:


  virtual ~Airavata_searchProjects_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;
  const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> * filters;
  const int32_t* limit;
  const int32_t* offset;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_searchProjects_result__isset {
  _Airavata_searchProjects_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_searchProjects_result__isset;

class Airavata_searchProjects_result {
 public:

  Airavata_searchProjects_result(const Airavata_searchProjects_result&);
  Airavata_searchProjects_result& operator=(const Airavata_searchProjects_result&);
  Airavata_searchProjects_result() {
  }

  virtual ~Airavata_searchProjects_result() throw();
  std::vector< ::apache::airavata::model::workspace::Project>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_searchProjects_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::workspace::Project> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_searchProjects_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_searchProjects_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_searchProjects_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_searchProjects_presult__isset {
  _Airavata_searchProjects_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_searchProjects_presult__isset;

class Airavata_searchProjects_presult {
 public:


  virtual ~Airavata_searchProjects_presult() throw();
  std::vector< ::apache::airavata::model::workspace::Project> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_searchProjects_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_searchExperiments_args__isset {
  _Airavata_searchExperiments_args__isset() : filters(false) {}
  bool filters :1;
} _Airavata_searchExperiments_args__isset;

class Airavata_searchExperiments_args {
 public:

  Airavata_searchExperiments_args(const Airavata_searchExperiments_args&);
  Airavata_searchExperiments_args& operator=(const Airavata_searchExperiments_args&);
  Airavata_searchExperiments_args() : gatewayId(), userName(), limit(0), offset(0) {
  }

  virtual ~Airavata_searchExperiments_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;
  std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string>  filters;
  int32_t limit;
  int32_t offset;

  _Airavata_searchExperiments_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  void __set_filters(const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> & val);

  void __set_limit(const int32_t val);

  void __set_offset(const int32_t val);

  bool operator == (const Airavata_searchExperiments_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(filters == rhs.filters))
      return false;
    if (!(limit == rhs.limit))
      return false;
    if (!(offset == rhs.offset))
      return false;
    return true;
  }
  bool operator != (const Airavata_searchExperiments_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_searchExperiments_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_searchExperiments_pargs {
 public:


  virtual ~Airavata_searchExperiments_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;
  const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> * filters;
  const int32_t* limit;
  const int32_t* offset;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_searchExperiments_result__isset {
  _Airavata_searchExperiments_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_searchExperiments_result__isset;

class Airavata_searchExperiments_result {
 public:

  Airavata_searchExperiments_result(const Airavata_searchExperiments_result&);
  Airavata_searchExperiments_result& operator=(const Airavata_searchExperiments_result&);
  Airavata_searchExperiments_result() {
  }

  virtual ~Airavata_searchExperiments_result() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_searchExperiments_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_searchExperiments_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_searchExperiments_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_searchExperiments_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_searchExperiments_presult__isset {
  _Airavata_searchExperiments_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_searchExperiments_presult__isset;

class Airavata_searchExperiments_presult {
 public:


  virtual ~Airavata_searchExperiments_presult() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_searchExperiments_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_getExperimentStatistics_args__isset {
  _Airavata_getExperimentStatistics_args__isset() : userName(false), applicationName(false), resourceHostName(false) {}
  bool userName :1;
  bool applicationName :1;
  bool resourceHostName :1;
} _Airavata_getExperimentStatistics_args__isset;

class Airavata_getExperimentStatistics_args {
 public:

  Airavata_getExperimentStatistics_args(const Airavata_getExperimentStatistics_args&);
  Airavata_getExperimentStatistics_args& operator=(const Airavata_getExperimentStatistics_args&);
  Airavata_getExperimentStatistics_args() : gatewayId(), fromTime(0), toTime(0), userName(), applicationName(), resourceHostName() {
  }

  virtual ~Airavata_getExperimentStatistics_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  int64_t fromTime;
  int64_t toTime;
  std::string userName;
  std::string applicationName;
  std::string resourceHostName;

  _Airavata_getExperimentStatistics_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_fromTime(const int64_t val);

  void __set_toTime(const int64_t val);

  void __set_userName(const std::string& val);

  void __set_applicationName(const std::string& val);

  void __set_resourceHostName(const std::string& val);

  bool operator == (const Airavata_getExperimentStatistics_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(fromTime == rhs.fromTime))
      return false;
    if (!(toTime == rhs.toTime))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(applicationName == rhs.applicationName))
      return false;
    if (!(resourceHostName == rhs.resourceHostName))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentStatistics_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentStatistics_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperimentStatistics_pargs {
 public:


  virtual ~Airavata_getExperimentStatistics_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const int64_t* fromTime;
  const int64_t* toTime;
  const std::string* userName;
  const std::string* applicationName;
  const std::string* resourceHostName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentStatistics_result__isset {
  _Airavata_getExperimentStatistics_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentStatistics_result__isset;

class Airavata_getExperimentStatistics_result {
 public:

  Airavata_getExperimentStatistics_result(const Airavata_getExperimentStatistics_result&);
  Airavata_getExperimentStatistics_result& operator=(const Airavata_getExperimentStatistics_result&);
  Airavata_getExperimentStatistics_result() {
  }

  virtual ~Airavata_getExperimentStatistics_result() throw();
   ::apache::airavata::model::experiment::ExperimentStatistics success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentStatistics_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::experiment::ExperimentStatistics& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperimentStatistics_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentStatistics_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentStatistics_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentStatistics_presult__isset {
  _Airavata_getExperimentStatistics_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentStatistics_presult__isset;

class Airavata_getExperimentStatistics_presult {
 public:


  virtual ~Airavata_getExperimentStatistics_presult() throw();
   ::apache::airavata::model::experiment::ExperimentStatistics* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentStatistics_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getExperimentsInProject_args {
 public:

  Airavata_getExperimentsInProject_args(const Airavata_getExperimentsInProject_args&);
  Airavata_getExperimentsInProject_args& operator=(const Airavata_getExperimentsInProject_args&);
  Airavata_getExperimentsInProject_args() : projectId(), limit(0), offset(0) {
  }

  virtual ~Airavata_getExperimentsInProject_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string projectId;
  int32_t limit;
  int32_t offset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_projectId(const std::string& val);

  void __set_limit(const int32_t val);

  void __set_offset(const int32_t val);

  bool operator == (const Airavata_getExperimentsInProject_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(projectId == rhs.projectId))
      return false;
    if (!(limit == rhs.limit))
      return false;
    if (!(offset == rhs.offset))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentsInProject_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentsInProject_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperimentsInProject_pargs {
 public:


  virtual ~Airavata_getExperimentsInProject_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* projectId;
  const int32_t* limit;
  const int32_t* offset;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentsInProject_result__isset {
  _Airavata_getExperimentsInProject_result__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_getExperimentsInProject_result__isset;

class Airavata_getExperimentsInProject_result {
 public:

  Airavata_getExperimentsInProject_result(const Airavata_getExperimentsInProject_result&);
  Airavata_getExperimentsInProject_result& operator=(const Airavata_getExperimentsInProject_result&);
  Airavata_getExperimentsInProject_result() {
  }

  virtual ~Airavata_getExperimentsInProject_result() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentsInProject_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::experiment::ExperimentModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperimentsInProject_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentsInProject_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentsInProject_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentsInProject_presult__isset {
  _Airavata_getExperimentsInProject_presult__isset() : success(false), ire(false), ace(false), ase(false), pnfe(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool pnfe :1;
  bool ae :1;
} _Airavata_getExperimentsInProject_presult__isset;

class Airavata_getExperimentsInProject_presult {
 public:


  virtual ~Airavata_getExperimentsInProject_presult() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentsInProject_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUserExperiments_args {
 public:

  Airavata_getUserExperiments_args(const Airavata_getUserExperiments_args&);
  Airavata_getUserExperiments_args& operator=(const Airavata_getUserExperiments_args&);
  Airavata_getUserExperiments_args() : gatewayId(), userName(), limit(0), offset(0) {
  }

  virtual ~Airavata_getUserExperiments_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
  std::string userName;
  int32_t limit;
  int32_t offset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_userName(const std::string& val);

  void __set_limit(const int32_t val);

  void __set_offset(const int32_t val);

  bool operator == (const Airavata_getUserExperiments_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(userName == rhs.userName))
      return false;
    if (!(limit == rhs.limit))
      return false;
    if (!(offset == rhs.offset))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserExperiments_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserExperiments_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUserExperiments_pargs {
 public:


  virtual ~Airavata_getUserExperiments_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const std::string* userName;
  const int32_t* limit;
  const int32_t* offset;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserExperiments_result__isset {
  _Airavata_getUserExperiments_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserExperiments_result__isset;

class Airavata_getUserExperiments_result {
 public:

  Airavata_getUserExperiments_result(const Airavata_getUserExperiments_result&);
  Airavata_getUserExperiments_result& operator=(const Airavata_getUserExperiments_result&);
  Airavata_getUserExperiments_result() {
  }

  virtual ~Airavata_getUserExperiments_result() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserExperiments_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::experiment::ExperimentModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUserExperiments_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserExperiments_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserExperiments_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserExperiments_presult__isset {
  _Airavata_getUserExperiments_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserExperiments_presult__isset;

class Airavata_getUserExperiments_presult {
 public:


  virtual ~Airavata_getUserExperiments_presult() throw();
  std::vector< ::apache::airavata::model::experiment::ExperimentModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserExperiments_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_createExperiment_args {
 public:

  Airavata_createExperiment_args(const Airavata_createExperiment_args&);
  Airavata_createExperiment_args& operator=(const Airavata_createExperiment_args&);
  Airavata_createExperiment_args() : gatewayId() {
  }

  virtual ~Airavata_createExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::experiment::ExperimentModel experiment;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_experiment(const  ::apache::airavata::model::experiment::ExperimentModel& val);

  bool operator == (const Airavata_createExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(experiment == rhs.experiment))
      return false;
    return true;
  }
  bool operator != (const Airavata_createExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_createExperiment_pargs {
 public:


  virtual ~Airavata_createExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::experiment::ExperimentModel* experiment;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createExperiment_result__isset {
  _Airavata_createExperiment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createExperiment_result__isset;

class Airavata_createExperiment_result {
 public:

  Airavata_createExperiment_result(const Airavata_createExperiment_result&);
  Airavata_createExperiment_result& operator=(const Airavata_createExperiment_result&);
  Airavata_createExperiment_result() : success() {
  }

  virtual ~Airavata_createExperiment_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createExperiment_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_createExperiment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_createExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createExperiment_presult__isset {
  _Airavata_createExperiment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createExperiment_presult__isset;

class Airavata_createExperiment_presult {
 public:


  virtual ~Airavata_createExperiment_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteExperiment_args {
 public:

  Airavata_deleteExperiment_args(const Airavata_deleteExperiment_args&);
  Airavata_deleteExperiment_args& operator=(const Airavata_deleteExperiment_args&);
  Airavata_deleteExperiment_args() : experimentId() {
  }

  virtual ~Airavata_deleteExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string experimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_experimentId(const std::string& val);

  bool operator == (const Airavata_deleteExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteExperiment_pargs {
 public:


  virtual ~Airavata_deleteExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* experimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteExperiment_result__isset {
  _Airavata_deleteExperiment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteExperiment_result__isset;

class Airavata_deleteExperiment_result {
 public:

  Airavata_deleteExperiment_result(const Airavata_deleteExperiment_result&);
  Airavata_deleteExperiment_result& operator=(const Airavata_deleteExperiment_result&);
  Airavata_deleteExperiment_result() : success(0) {
  }

  virtual ~Airavata_deleteExperiment_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteExperiment_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteExperiment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteExperiment_presult__isset {
  _Airavata_deleteExperiment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteExperiment_presult__isset;

class Airavata_deleteExperiment_presult {
 public:


  virtual ~Airavata_deleteExperiment_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getExperiment_args {
 public:

  Airavata_getExperiment_args(const Airavata_getExperiment_args&);
  Airavata_getExperiment_args& operator=(const Airavata_getExperiment_args&);
  Airavata_getExperiment_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperiment_pargs {
 public:


  virtual ~Airavata_getExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperiment_result__isset {
  _Airavata_getExperiment_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperiment_result__isset;

class Airavata_getExperiment_result {
 public:

  Airavata_getExperiment_result(const Airavata_getExperiment_result&);
  Airavata_getExperiment_result& operator=(const Airavata_getExperiment_result&);
  Airavata_getExperiment_result() {
  }

  virtual ~Airavata_getExperiment_result() throw();
   ::apache::airavata::model::experiment::ExperimentModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperiment_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::experiment::ExperimentModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperiment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperiment_presult__isset {
  _Airavata_getExperiment_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperiment_presult__isset;

class Airavata_getExperiment_presult {
 public:


  virtual ~Airavata_getExperiment_presult() throw();
   ::apache::airavata::model::experiment::ExperimentModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getExperimentByAdmin_args {
 public:

  Airavata_getExperimentByAdmin_args(const Airavata_getExperimentByAdmin_args&);
  Airavata_getExperimentByAdmin_args& operator=(const Airavata_getExperimentByAdmin_args&);
  Airavata_getExperimentByAdmin_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getExperimentByAdmin_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getExperimentByAdmin_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentByAdmin_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentByAdmin_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperimentByAdmin_pargs {
 public:


  virtual ~Airavata_getExperimentByAdmin_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentByAdmin_result__isset {
  _Airavata_getExperimentByAdmin_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentByAdmin_result__isset;

class Airavata_getExperimentByAdmin_result {
 public:

  Airavata_getExperimentByAdmin_result(const Airavata_getExperimentByAdmin_result&);
  Airavata_getExperimentByAdmin_result& operator=(const Airavata_getExperimentByAdmin_result&);
  Airavata_getExperimentByAdmin_result() {
  }

  virtual ~Airavata_getExperimentByAdmin_result() throw();
   ::apache::airavata::model::experiment::ExperimentModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentByAdmin_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::experiment::ExperimentModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperimentByAdmin_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentByAdmin_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentByAdmin_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentByAdmin_presult__isset {
  _Airavata_getExperimentByAdmin_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentByAdmin_presult__isset;

class Airavata_getExperimentByAdmin_presult {
 public:


  virtual ~Airavata_getExperimentByAdmin_presult() throw();
   ::apache::airavata::model::experiment::ExperimentModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentByAdmin_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getDetailedExperimentTree_args {
 public:

  Airavata_getDetailedExperimentTree_args(const Airavata_getDetailedExperimentTree_args&);
  Airavata_getDetailedExperimentTree_args& operator=(const Airavata_getDetailedExperimentTree_args&);
  Airavata_getDetailedExperimentTree_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getDetailedExperimentTree_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getDetailedExperimentTree_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getDetailedExperimentTree_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getDetailedExperimentTree_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getDetailedExperimentTree_pargs {
 public:


  virtual ~Airavata_getDetailedExperimentTree_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getDetailedExperimentTree_result__isset {
  _Airavata_getDetailedExperimentTree_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getDetailedExperimentTree_result__isset;

class Airavata_getDetailedExperimentTree_result {
 public:

  Airavata_getDetailedExperimentTree_result(const Airavata_getDetailedExperimentTree_result&);
  Airavata_getDetailedExperimentTree_result& operator=(const Airavata_getDetailedExperimentTree_result&);
  Airavata_getDetailedExperimentTree_result() {
  }

  virtual ~Airavata_getDetailedExperimentTree_result() throw();
   ::apache::airavata::model::experiment::ExperimentModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getDetailedExperimentTree_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::experiment::ExperimentModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getDetailedExperimentTree_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getDetailedExperimentTree_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getDetailedExperimentTree_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getDetailedExperimentTree_presult__isset {
  _Airavata_getDetailedExperimentTree_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getDetailedExperimentTree_presult__isset;

class Airavata_getDetailedExperimentTree_presult {
 public:


  virtual ~Airavata_getDetailedExperimentTree_presult() throw();
   ::apache::airavata::model::experiment::ExperimentModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getDetailedExperimentTree_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateExperiment_args {
 public:

  Airavata_updateExperiment_args(const Airavata_updateExperiment_args&);
  Airavata_updateExperiment_args& operator=(const Airavata_updateExperiment_args&);
  Airavata_updateExperiment_args() : airavataExperimentId() {
  }

  virtual ~Airavata_updateExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;
   ::apache::airavata::model::experiment::ExperimentModel experiment;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  void __set_experiment(const  ::apache::airavata::model::experiment::ExperimentModel& val);

  bool operator == (const Airavata_updateExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    if (!(experiment == rhs.experiment))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateExperiment_pargs {
 public:


  virtual ~Airavata_updateExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;
  const  ::apache::airavata::model::experiment::ExperimentModel* experiment;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateExperiment_result__isset {
  _Airavata_updateExperiment_result__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateExperiment_result__isset;

class Airavata_updateExperiment_result {
 public:

  Airavata_updateExperiment_result(const Airavata_updateExperiment_result&);
  Airavata_updateExperiment_result& operator=(const Airavata_updateExperiment_result&);
  Airavata_updateExperiment_result() {
  }

  virtual ~Airavata_updateExperiment_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateExperiment_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateExperiment_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateExperiment_presult__isset {
  _Airavata_updateExperiment_presult__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateExperiment_presult__isset;

class Airavata_updateExperiment_presult {
 public:


  virtual ~Airavata_updateExperiment_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateExperimentConfiguration_args {
 public:

  Airavata_updateExperimentConfiguration_args(const Airavata_updateExperimentConfiguration_args&);
  Airavata_updateExperimentConfiguration_args& operator=(const Airavata_updateExperimentConfiguration_args&);
  Airavata_updateExperimentConfiguration_args() : airavataExperimentId() {
  }

  virtual ~Airavata_updateExperimentConfiguration_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;
   ::apache::airavata::model::experiment::UserConfigurationDataModel userConfiguration;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  void __set_userConfiguration(const  ::apache::airavata::model::experiment::UserConfigurationDataModel& val);

  bool operator == (const Airavata_updateExperimentConfiguration_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    if (!(userConfiguration == rhs.userConfiguration))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateExperimentConfiguration_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateExperimentConfiguration_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateExperimentConfiguration_pargs {
 public:


  virtual ~Airavata_updateExperimentConfiguration_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;
  const  ::apache::airavata::model::experiment::UserConfigurationDataModel* userConfiguration;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateExperimentConfiguration_result__isset {
  _Airavata_updateExperimentConfiguration_result__isset() : ae(false) {}
  bool ae :1;
} _Airavata_updateExperimentConfiguration_result__isset;

class Airavata_updateExperimentConfiguration_result {
 public:

  Airavata_updateExperimentConfiguration_result(const Airavata_updateExperimentConfiguration_result&);
  Airavata_updateExperimentConfiguration_result& operator=(const Airavata_updateExperimentConfiguration_result&);
  Airavata_updateExperimentConfiguration_result() {
  }

  virtual ~Airavata_updateExperimentConfiguration_result() throw();
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateExperimentConfiguration_result__isset __isset;

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateExperimentConfiguration_result & rhs) const
  {
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateExperimentConfiguration_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateExperimentConfiguration_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateExperimentConfiguration_presult__isset {
  _Airavata_updateExperimentConfiguration_presult__isset() : ae(false) {}
  bool ae :1;
} _Airavata_updateExperimentConfiguration_presult__isset;

class Airavata_updateExperimentConfiguration_presult {
 public:


  virtual ~Airavata_updateExperimentConfiguration_presult() throw();
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateExperimentConfiguration_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateResourceScheduleing_args {
 public:

  Airavata_updateResourceScheduleing_args(const Airavata_updateResourceScheduleing_args&);
  Airavata_updateResourceScheduleing_args& operator=(const Airavata_updateResourceScheduleing_args&);
  Airavata_updateResourceScheduleing_args() : airavataExperimentId() {
  }

  virtual ~Airavata_updateResourceScheduleing_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;
   ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel resourceScheduling;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  void __set_resourceScheduling(const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& val);

  bool operator == (const Airavata_updateResourceScheduleing_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    if (!(resourceScheduling == rhs.resourceScheduling))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateResourceScheduleing_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateResourceScheduleing_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateResourceScheduleing_pargs {
 public:


  virtual ~Airavata_updateResourceScheduleing_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;
  const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel* resourceScheduling;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateResourceScheduleing_result__isset {
  _Airavata_updateResourceScheduleing_result__isset() : ae(false) {}
  bool ae :1;
} _Airavata_updateResourceScheduleing_result__isset;

class Airavata_updateResourceScheduleing_result {
 public:

  Airavata_updateResourceScheduleing_result(const Airavata_updateResourceScheduleing_result&);
  Airavata_updateResourceScheduleing_result& operator=(const Airavata_updateResourceScheduleing_result&);
  Airavata_updateResourceScheduleing_result() {
  }

  virtual ~Airavata_updateResourceScheduleing_result() throw();
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateResourceScheduleing_result__isset __isset;

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateResourceScheduleing_result & rhs) const
  {
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateResourceScheduleing_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateResourceScheduleing_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateResourceScheduleing_presult__isset {
  _Airavata_updateResourceScheduleing_presult__isset() : ae(false) {}
  bool ae :1;
} _Airavata_updateResourceScheduleing_presult__isset;

class Airavata_updateResourceScheduleing_presult {
 public:


  virtual ~Airavata_updateResourceScheduleing_presult() throw();
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateResourceScheduleing_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_validateExperiment_args {
 public:

  Airavata_validateExperiment_args(const Airavata_validateExperiment_args&);
  Airavata_validateExperiment_args& operator=(const Airavata_validateExperiment_args&);
  Airavata_validateExperiment_args() : airavataExperimentId() {
  }

  virtual ~Airavata_validateExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_validateExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_validateExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_validateExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_validateExperiment_pargs {
 public:


  virtual ~Airavata_validateExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_validateExperiment_result__isset {
  _Airavata_validateExperiment_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_validateExperiment_result__isset;

class Airavata_validateExperiment_result {
 public:

  Airavata_validateExperiment_result(const Airavata_validateExperiment_result&);
  Airavata_validateExperiment_result& operator=(const Airavata_validateExperiment_result&);
  Airavata_validateExperiment_result() : success(0) {
  }

  virtual ~Airavata_validateExperiment_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_validateExperiment_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_validateExperiment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_validateExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_validateExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_validateExperiment_presult__isset {
  _Airavata_validateExperiment_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_validateExperiment_presult__isset;

class Airavata_validateExperiment_presult {
 public:


  virtual ~Airavata_validateExperiment_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_validateExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_launchExperiment_args {
 public:

  Airavata_launchExperiment_args(const Airavata_launchExperiment_args&);
  Airavata_launchExperiment_args& operator=(const Airavata_launchExperiment_args&);
  Airavata_launchExperiment_args() : airavataExperimentId(), gatewayId() {
  }

  virtual ~Airavata_launchExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_launchExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_launchExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_launchExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_launchExperiment_pargs {
 public:


  virtual ~Airavata_launchExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_launchExperiment_result__isset {
  _Airavata_launchExperiment_result__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_launchExperiment_result__isset;

class Airavata_launchExperiment_result {
 public:

  Airavata_launchExperiment_result(const Airavata_launchExperiment_result&);
  Airavata_launchExperiment_result& operator=(const Airavata_launchExperiment_result&);
  Airavata_launchExperiment_result() {
  }

  virtual ~Airavata_launchExperiment_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_launchExperiment_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_launchExperiment_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_launchExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_launchExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_launchExperiment_presult__isset {
  _Airavata_launchExperiment_presult__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_launchExperiment_presult__isset;

class Airavata_launchExperiment_presult {
 public:


  virtual ~Airavata_launchExperiment_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_launchExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getExperimentStatus_args {
 public:

  Airavata_getExperimentStatus_args(const Airavata_getExperimentStatus_args&);
  Airavata_getExperimentStatus_args& operator=(const Airavata_getExperimentStatus_args&);
  Airavata_getExperimentStatus_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getExperimentStatus_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getExperimentStatus_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentStatus_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentStatus_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperimentStatus_pargs {
 public:


  virtual ~Airavata_getExperimentStatus_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentStatus_result__isset {
  _Airavata_getExperimentStatus_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentStatus_result__isset;

class Airavata_getExperimentStatus_result {
 public:

  Airavata_getExperimentStatus_result(const Airavata_getExperimentStatus_result&);
  Airavata_getExperimentStatus_result& operator=(const Airavata_getExperimentStatus_result&);
  Airavata_getExperimentStatus_result() {
  }

  virtual ~Airavata_getExperimentStatus_result() throw();
   ::apache::airavata::model::status::ExperimentStatus success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentStatus_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::status::ExperimentStatus& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperimentStatus_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentStatus_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentStatus_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentStatus_presult__isset {
  _Airavata_getExperimentStatus_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentStatus_presult__isset;

class Airavata_getExperimentStatus_presult {
 public:


  virtual ~Airavata_getExperimentStatus_presult() throw();
   ::apache::airavata::model::status::ExperimentStatus* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentStatus_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getExperimentOutputs_args {
 public:

  Airavata_getExperimentOutputs_args(const Airavata_getExperimentOutputs_args&);
  Airavata_getExperimentOutputs_args& operator=(const Airavata_getExperimentOutputs_args&);
  Airavata_getExperimentOutputs_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getExperimentOutputs_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getExperimentOutputs_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentOutputs_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentOutputs_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getExperimentOutputs_pargs {
 public:


  virtual ~Airavata_getExperimentOutputs_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentOutputs_result__isset {
  _Airavata_getExperimentOutputs_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentOutputs_result__isset;

class Airavata_getExperimentOutputs_result {
 public:

  Airavata_getExperimentOutputs_result(const Airavata_getExperimentOutputs_result&);
  Airavata_getExperimentOutputs_result& operator=(const Airavata_getExperimentOutputs_result&);
  Airavata_getExperimentOutputs_result() {
  }

  virtual ~Airavata_getExperimentOutputs_result() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentOutputs_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getExperimentOutputs_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getExperimentOutputs_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getExperimentOutputs_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getExperimentOutputs_presult__isset {
  _Airavata_getExperimentOutputs_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getExperimentOutputs_presult__isset;

class Airavata_getExperimentOutputs_presult {
 public:


  virtual ~Airavata_getExperimentOutputs_presult() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getExperimentOutputs_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getIntermediateOutputs_args {
 public:

  Airavata_getIntermediateOutputs_args(const Airavata_getIntermediateOutputs_args&);
  Airavata_getIntermediateOutputs_args& operator=(const Airavata_getIntermediateOutputs_args&);
  Airavata_getIntermediateOutputs_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getIntermediateOutputs_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getIntermediateOutputs_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getIntermediateOutputs_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getIntermediateOutputs_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getIntermediateOutputs_pargs {
 public:


  virtual ~Airavata_getIntermediateOutputs_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getIntermediateOutputs_result__isset {
  _Airavata_getIntermediateOutputs_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getIntermediateOutputs_result__isset;

class Airavata_getIntermediateOutputs_result {
 public:

  Airavata_getIntermediateOutputs_result(const Airavata_getIntermediateOutputs_result&);
  Airavata_getIntermediateOutputs_result& operator=(const Airavata_getIntermediateOutputs_result&);
  Airavata_getIntermediateOutputs_result() {
  }

  virtual ~Airavata_getIntermediateOutputs_result() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getIntermediateOutputs_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getIntermediateOutputs_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getIntermediateOutputs_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getIntermediateOutputs_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getIntermediateOutputs_presult__isset {
  _Airavata_getIntermediateOutputs_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getIntermediateOutputs_presult__isset;

class Airavata_getIntermediateOutputs_presult {
 public:


  virtual ~Airavata_getIntermediateOutputs_presult() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getIntermediateOutputs_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getJobStatuses_args {
 public:

  Airavata_getJobStatuses_args(const Airavata_getJobStatuses_args&);
  Airavata_getJobStatuses_args& operator=(const Airavata_getJobStatuses_args&);
  Airavata_getJobStatuses_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getJobStatuses_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getJobStatuses_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getJobStatuses_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getJobStatuses_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getJobStatuses_pargs {
 public:


  virtual ~Airavata_getJobStatuses_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getJobStatuses_result__isset {
  _Airavata_getJobStatuses_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getJobStatuses_result__isset;

class Airavata_getJobStatuses_result {
 public:

  Airavata_getJobStatuses_result(const Airavata_getJobStatuses_result&);
  Airavata_getJobStatuses_result& operator=(const Airavata_getJobStatuses_result&);
  Airavata_getJobStatuses_result() {
  }

  virtual ~Airavata_getJobStatuses_result() throw();
  std::map<std::string,  ::apache::airavata::model::status::JobStatus>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getJobStatuses_result__isset __isset;

  void __set_success(const std::map<std::string,  ::apache::airavata::model::status::JobStatus> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getJobStatuses_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getJobStatuses_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getJobStatuses_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getJobStatuses_presult__isset {
  _Airavata_getJobStatuses_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getJobStatuses_presult__isset;

class Airavata_getJobStatuses_presult {
 public:


  virtual ~Airavata_getJobStatuses_presult() throw();
  std::map<std::string,  ::apache::airavata::model::status::JobStatus> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getJobStatuses_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getJobDetails_args {
 public:

  Airavata_getJobDetails_args(const Airavata_getJobDetails_args&);
  Airavata_getJobDetails_args& operator=(const Airavata_getJobDetails_args&);
  Airavata_getJobDetails_args() : airavataExperimentId() {
  }

  virtual ~Airavata_getJobDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  bool operator == (const Airavata_getJobDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getJobDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getJobDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getJobDetails_pargs {
 public:


  virtual ~Airavata_getJobDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getJobDetails_result__isset {
  _Airavata_getJobDetails_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getJobDetails_result__isset;

class Airavata_getJobDetails_result {
 public:

  Airavata_getJobDetails_result(const Airavata_getJobDetails_result&);
  Airavata_getJobDetails_result& operator=(const Airavata_getJobDetails_result&);
  Airavata_getJobDetails_result() {
  }

  virtual ~Airavata_getJobDetails_result() throw();
  std::vector< ::apache::airavata::model::job::JobModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getJobDetails_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::job::JobModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getJobDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getJobDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getJobDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getJobDetails_presult__isset {
  _Airavata_getJobDetails_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getJobDetails_presult__isset;

class Airavata_getJobDetails_presult {
 public:


  virtual ~Airavata_getJobDetails_presult() throw();
  std::vector< ::apache::airavata::model::job::JobModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getJobDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_cloneExperiment_args__isset {
  _Airavata_cloneExperiment_args__isset() : existingExperimentID(false), newExperimentName(false), newExperimentProjectId(false) {}
  bool existingExperimentID :1;
  bool newExperimentName :1;
  bool newExperimentProjectId :1;
} _Airavata_cloneExperiment_args__isset;

class Airavata_cloneExperiment_args {
 public:

  Airavata_cloneExperiment_args(const Airavata_cloneExperiment_args&);
  Airavata_cloneExperiment_args& operator=(const Airavata_cloneExperiment_args&);
  Airavata_cloneExperiment_args() : existingExperimentID(), newExperimentName(), newExperimentProjectId() {
  }

  virtual ~Airavata_cloneExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string existingExperimentID;
  std::string newExperimentName;
  std::string newExperimentProjectId;

  _Airavata_cloneExperiment_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_existingExperimentID(const std::string& val);

  void __set_newExperimentName(const std::string& val);

  void __set_newExperimentProjectId(const std::string& val);

  bool operator == (const Airavata_cloneExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(existingExperimentID == rhs.existingExperimentID))
      return false;
    if (!(newExperimentName == rhs.newExperimentName))
      return false;
    if (!(newExperimentProjectId == rhs.newExperimentProjectId))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_cloneExperiment_pargs {
 public:


  virtual ~Airavata_cloneExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* existingExperimentID;
  const std::string* newExperimentName;
  const std::string* newExperimentProjectId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneExperiment_result__isset {
  _Airavata_cloneExperiment_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false), pnfe(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
  bool pnfe :1;
} _Airavata_cloneExperiment_result__isset;

class Airavata_cloneExperiment_result {
 public:

  Airavata_cloneExperiment_result(const Airavata_cloneExperiment_result&);
  Airavata_cloneExperiment_result& operator=(const Airavata_cloneExperiment_result&);
  Airavata_cloneExperiment_result() : success() {
  }

  virtual ~Airavata_cloneExperiment_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;

  _Airavata_cloneExperiment_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  bool operator == (const Airavata_cloneExperiment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneExperiment_presult__isset {
  _Airavata_cloneExperiment_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false), pnfe(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
  bool pnfe :1;
} _Airavata_cloneExperiment_presult__isset;

class Airavata_cloneExperiment_presult {
 public:


  virtual ~Airavata_cloneExperiment_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;

  _Airavata_cloneExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_cloneExperimentByAdmin_args__isset {
  _Airavata_cloneExperimentByAdmin_args__isset() : existingExperimentID(false), newExperimentName(false), newExperimentProjectId(false) {}
  bool existingExperimentID :1;
  bool newExperimentName :1;
  bool newExperimentProjectId :1;
} _Airavata_cloneExperimentByAdmin_args__isset;

class Airavata_cloneExperimentByAdmin_args {
 public:

  Airavata_cloneExperimentByAdmin_args(const Airavata_cloneExperimentByAdmin_args&);
  Airavata_cloneExperimentByAdmin_args& operator=(const Airavata_cloneExperimentByAdmin_args&);
  Airavata_cloneExperimentByAdmin_args() : existingExperimentID(), newExperimentName(), newExperimentProjectId() {
  }

  virtual ~Airavata_cloneExperimentByAdmin_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string existingExperimentID;
  std::string newExperimentName;
  std::string newExperimentProjectId;

  _Airavata_cloneExperimentByAdmin_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_existingExperimentID(const std::string& val);

  void __set_newExperimentName(const std::string& val);

  void __set_newExperimentProjectId(const std::string& val);

  bool operator == (const Airavata_cloneExperimentByAdmin_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(existingExperimentID == rhs.existingExperimentID))
      return false;
    if (!(newExperimentName == rhs.newExperimentName))
      return false;
    if (!(newExperimentProjectId == rhs.newExperimentProjectId))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneExperimentByAdmin_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneExperimentByAdmin_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_cloneExperimentByAdmin_pargs {
 public:


  virtual ~Airavata_cloneExperimentByAdmin_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* existingExperimentID;
  const std::string* newExperimentName;
  const std::string* newExperimentProjectId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneExperimentByAdmin_result__isset {
  _Airavata_cloneExperimentByAdmin_result__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false), pnfe(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
  bool pnfe :1;
} _Airavata_cloneExperimentByAdmin_result__isset;

class Airavata_cloneExperimentByAdmin_result {
 public:

  Airavata_cloneExperimentByAdmin_result(const Airavata_cloneExperimentByAdmin_result&);
  Airavata_cloneExperimentByAdmin_result& operator=(const Airavata_cloneExperimentByAdmin_result&);
  Airavata_cloneExperimentByAdmin_result() : success() {
  }

  virtual ~Airavata_cloneExperimentByAdmin_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;

  _Airavata_cloneExperimentByAdmin_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  void __set_pnfe(const  ::apache::airavata::api::error::ProjectNotFoundException& val);

  bool operator == (const Airavata_cloneExperimentByAdmin_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    if (!(pnfe == rhs.pnfe))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneExperimentByAdmin_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneExperimentByAdmin_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneExperimentByAdmin_presult__isset {
  _Airavata_cloneExperimentByAdmin_presult__isset() : success(false), ire(false), enf(false), ace(false), ase(false), ae(false), pnfe(false) {}
  bool success :1;
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
  bool pnfe :1;
} _Airavata_cloneExperimentByAdmin_presult__isset;

class Airavata_cloneExperimentByAdmin_presult {
 public:


  virtual ~Airavata_cloneExperimentByAdmin_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;
   ::apache::airavata::api::error::ProjectNotFoundException pnfe;

  _Airavata_cloneExperimentByAdmin_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_terminateExperiment_args__isset {
  _Airavata_terminateExperiment_args__isset() : airavataExperimentId(false), gatewayId(false) {}
  bool airavataExperimentId :1;
  bool gatewayId :1;
} _Airavata_terminateExperiment_args__isset;

class Airavata_terminateExperiment_args {
 public:

  Airavata_terminateExperiment_args(const Airavata_terminateExperiment_args&);
  Airavata_terminateExperiment_args& operator=(const Airavata_terminateExperiment_args&);
  Airavata_terminateExperiment_args() : airavataExperimentId(), gatewayId() {
  }

  virtual ~Airavata_terminateExperiment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string airavataExperimentId;
  std::string gatewayId;

  _Airavata_terminateExperiment_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_airavataExperimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_terminateExperiment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(airavataExperimentId == rhs.airavataExperimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_terminateExperiment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_terminateExperiment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_terminateExperiment_pargs {
 public:


  virtual ~Airavata_terminateExperiment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* airavataExperimentId;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_terminateExperiment_result__isset {
  _Airavata_terminateExperiment_result__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_terminateExperiment_result__isset;

class Airavata_terminateExperiment_result {
 public:

  Airavata_terminateExperiment_result(const Airavata_terminateExperiment_result&);
  Airavata_terminateExperiment_result& operator=(const Airavata_terminateExperiment_result&);
  Airavata_terminateExperiment_result() {
  }

  virtual ~Airavata_terminateExperiment_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_terminateExperiment_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_enf(const  ::apache::airavata::api::error::ExperimentNotFoundException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_terminateExperiment_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(enf == rhs.enf))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_terminateExperiment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_terminateExperiment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_terminateExperiment_presult__isset {
  _Airavata_terminateExperiment_presult__isset() : ire(false), enf(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool enf :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_terminateExperiment_presult__isset;

class Airavata_terminateExperiment_presult {
 public:


  virtual ~Airavata_terminateExperiment_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::ExperimentNotFoundException enf;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_terminateExperiment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerApplicationModule_args {
 public:

  Airavata_registerApplicationModule_args(const Airavata_registerApplicationModule_args&);
  Airavata_registerApplicationModule_args& operator=(const Airavata_registerApplicationModule_args&);
  Airavata_registerApplicationModule_args() : gatewayId() {
  }

  virtual ~Airavata_registerApplicationModule_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule applicationModule;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_applicationModule(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& val);

  bool operator == (const Airavata_registerApplicationModule_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(applicationModule == rhs.applicationModule))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationModule_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationModule_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerApplicationModule_pargs {
 public:


  virtual ~Airavata_registerApplicationModule_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule* applicationModule;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationModule_result__isset {
  _Airavata_registerApplicationModule_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationModule_result__isset;

class Airavata_registerApplicationModule_result {
 public:

  Airavata_registerApplicationModule_result(const Airavata_registerApplicationModule_result&);
  Airavata_registerApplicationModule_result& operator=(const Airavata_registerApplicationModule_result&);
  Airavata_registerApplicationModule_result() : success() {
  }

  virtual ~Airavata_registerApplicationModule_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationModule_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerApplicationModule_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationModule_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationModule_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationModule_presult__isset {
  _Airavata_registerApplicationModule_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationModule_presult__isset;

class Airavata_registerApplicationModule_presult {
 public:


  virtual ~Airavata_registerApplicationModule_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationModule_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getApplicationModule_args {
 public:

  Airavata_getApplicationModule_args(const Airavata_getApplicationModule_args&);
  Airavata_getApplicationModule_args& operator=(const Airavata_getApplicationModule_args&);
  Airavata_getApplicationModule_args() : appModuleId() {
  }

  virtual ~Airavata_getApplicationModule_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appModuleId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appModuleId(const std::string& val);

  bool operator == (const Airavata_getApplicationModule_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appModuleId == rhs.appModuleId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationModule_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationModule_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getApplicationModule_pargs {
 public:


  virtual ~Airavata_getApplicationModule_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appModuleId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationModule_result__isset {
  _Airavata_getApplicationModule_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationModule_result__isset;

class Airavata_getApplicationModule_result {
 public:

  Airavata_getApplicationModule_result(const Airavata_getApplicationModule_result&);
  Airavata_getApplicationModule_result& operator=(const Airavata_getApplicationModule_result&);
  Airavata_getApplicationModule_result() {
  }

  virtual ~Airavata_getApplicationModule_result() throw();
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationModule_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getApplicationModule_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationModule_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationModule_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationModule_presult__isset {
  _Airavata_getApplicationModule_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationModule_presult__isset;

class Airavata_getApplicationModule_presult {
 public:


  virtual ~Airavata_getApplicationModule_presult() throw();
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationModule_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateApplicationModule_args {
 public:

  Airavata_updateApplicationModule_args(const Airavata_updateApplicationModule_args&);
  Airavata_updateApplicationModule_args& operator=(const Airavata_updateApplicationModule_args&);
  Airavata_updateApplicationModule_args() : appModuleId() {
  }

  virtual ~Airavata_updateApplicationModule_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appModuleId;
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule applicationModule;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appModuleId(const std::string& val);

  void __set_applicationModule(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& val);

  bool operator == (const Airavata_updateApplicationModule_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appModuleId == rhs.appModuleId))
      return false;
    if (!(applicationModule == rhs.applicationModule))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationModule_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationModule_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateApplicationModule_pargs {
 public:


  virtual ~Airavata_updateApplicationModule_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appModuleId;
  const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule* applicationModule;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationModule_result__isset {
  _Airavata_updateApplicationModule_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationModule_result__isset;

class Airavata_updateApplicationModule_result {
 public:

  Airavata_updateApplicationModule_result(const Airavata_updateApplicationModule_result&);
  Airavata_updateApplicationModule_result& operator=(const Airavata_updateApplicationModule_result&);
  Airavata_updateApplicationModule_result() : success(0) {
  }

  virtual ~Airavata_updateApplicationModule_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationModule_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateApplicationModule_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationModule_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationModule_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationModule_presult__isset {
  _Airavata_updateApplicationModule_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationModule_presult__isset;

class Airavata_updateApplicationModule_presult {
 public:


  virtual ~Airavata_updateApplicationModule_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationModule_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllAppModules_args {
 public:

  Airavata_getAllAppModules_args(const Airavata_getAllAppModules_args&);
  Airavata_getAllAppModules_args& operator=(const Airavata_getAllAppModules_args&);
  Airavata_getAllAppModules_args() : gatewayId() {
  }

  virtual ~Airavata_getAllAppModules_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllAppModules_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllAppModules_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllAppModules_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllAppModules_pargs {
 public:


  virtual ~Airavata_getAllAppModules_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllAppModules_result__isset {
  _Airavata_getAllAppModules_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllAppModules_result__isset;

class Airavata_getAllAppModules_result {
 public:

  Airavata_getAllAppModules_result(const Airavata_getAllAppModules_result&);
  Airavata_getAllAppModules_result& operator=(const Airavata_getAllAppModules_result&);
  Airavata_getAllAppModules_result() {
  }

  virtual ~Airavata_getAllAppModules_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllAppModules_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllAppModules_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllAppModules_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllAppModules_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllAppModules_presult__isset {
  _Airavata_getAllAppModules_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllAppModules_presult__isset;

class Airavata_getAllAppModules_presult {
 public:


  virtual ~Airavata_getAllAppModules_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllAppModules_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteApplicationModule_args {
 public:

  Airavata_deleteApplicationModule_args(const Airavata_deleteApplicationModule_args&);
  Airavata_deleteApplicationModule_args& operator=(const Airavata_deleteApplicationModule_args&);
  Airavata_deleteApplicationModule_args() : appModuleId() {
  }

  virtual ~Airavata_deleteApplicationModule_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appModuleId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appModuleId(const std::string& val);

  bool operator == (const Airavata_deleteApplicationModule_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appModuleId == rhs.appModuleId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationModule_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationModule_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteApplicationModule_pargs {
 public:


  virtual ~Airavata_deleteApplicationModule_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appModuleId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationModule_result__isset {
  _Airavata_deleteApplicationModule_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationModule_result__isset;

class Airavata_deleteApplicationModule_result {
 public:

  Airavata_deleteApplicationModule_result(const Airavata_deleteApplicationModule_result&);
  Airavata_deleteApplicationModule_result& operator=(const Airavata_deleteApplicationModule_result&);
  Airavata_deleteApplicationModule_result() : success(0) {
  }

  virtual ~Airavata_deleteApplicationModule_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationModule_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteApplicationModule_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationModule_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationModule_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationModule_presult__isset {
  _Airavata_deleteApplicationModule_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationModule_presult__isset;

class Airavata_deleteApplicationModule_presult {
 public:


  virtual ~Airavata_deleteApplicationModule_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationModule_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerApplicationDeployment_args {
 public:

  Airavata_registerApplicationDeployment_args(const Airavata_registerApplicationDeployment_args&);
  Airavata_registerApplicationDeployment_args& operator=(const Airavata_registerApplicationDeployment_args&);
  Airavata_registerApplicationDeployment_args() : gatewayId() {
  }

  virtual ~Airavata_registerApplicationDeployment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription applicationDeployment;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_applicationDeployment(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& val);

  bool operator == (const Airavata_registerApplicationDeployment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(applicationDeployment == rhs.applicationDeployment))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationDeployment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationDeployment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerApplicationDeployment_pargs {
 public:


  virtual ~Airavata_registerApplicationDeployment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription* applicationDeployment;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationDeployment_result__isset {
  _Airavata_registerApplicationDeployment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationDeployment_result__isset;

class Airavata_registerApplicationDeployment_result {
 public:

  Airavata_registerApplicationDeployment_result(const Airavata_registerApplicationDeployment_result&);
  Airavata_registerApplicationDeployment_result& operator=(const Airavata_registerApplicationDeployment_result&);
  Airavata_registerApplicationDeployment_result() : success() {
  }

  virtual ~Airavata_registerApplicationDeployment_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationDeployment_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerApplicationDeployment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationDeployment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationDeployment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationDeployment_presult__isset {
  _Airavata_registerApplicationDeployment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationDeployment_presult__isset;

class Airavata_registerApplicationDeployment_presult {
 public:


  virtual ~Airavata_registerApplicationDeployment_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationDeployment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getApplicationDeployment_args {
 public:

  Airavata_getApplicationDeployment_args(const Airavata_getApplicationDeployment_args&);
  Airavata_getApplicationDeployment_args& operator=(const Airavata_getApplicationDeployment_args&);
  Airavata_getApplicationDeployment_args() : appDeploymentId() {
  }

  virtual ~Airavata_getApplicationDeployment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appDeploymentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appDeploymentId(const std::string& val);

  bool operator == (const Airavata_getApplicationDeployment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appDeploymentId == rhs.appDeploymentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationDeployment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationDeployment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getApplicationDeployment_pargs {
 public:


  virtual ~Airavata_getApplicationDeployment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appDeploymentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationDeployment_result__isset {
  _Airavata_getApplicationDeployment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationDeployment_result__isset;

class Airavata_getApplicationDeployment_result {
 public:

  Airavata_getApplicationDeployment_result(const Airavata_getApplicationDeployment_result&);
  Airavata_getApplicationDeployment_result& operator=(const Airavata_getApplicationDeployment_result&);
  Airavata_getApplicationDeployment_result() {
  }

  virtual ~Airavata_getApplicationDeployment_result() throw();
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationDeployment_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getApplicationDeployment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationDeployment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationDeployment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationDeployment_presult__isset {
  _Airavata_getApplicationDeployment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationDeployment_presult__isset;

class Airavata_getApplicationDeployment_presult {
 public:


  virtual ~Airavata_getApplicationDeployment_presult() throw();
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationDeployment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateApplicationDeployment_args {
 public:

  Airavata_updateApplicationDeployment_args(const Airavata_updateApplicationDeployment_args&);
  Airavata_updateApplicationDeployment_args& operator=(const Airavata_updateApplicationDeployment_args&);
  Airavata_updateApplicationDeployment_args() : appDeploymentId() {
  }

  virtual ~Airavata_updateApplicationDeployment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appDeploymentId;
   ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription applicationDeployment;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appDeploymentId(const std::string& val);

  void __set_applicationDeployment(const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& val);

  bool operator == (const Airavata_updateApplicationDeployment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appDeploymentId == rhs.appDeploymentId))
      return false;
    if (!(applicationDeployment == rhs.applicationDeployment))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationDeployment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationDeployment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateApplicationDeployment_pargs {
 public:


  virtual ~Airavata_updateApplicationDeployment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appDeploymentId;
  const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription* applicationDeployment;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationDeployment_result__isset {
  _Airavata_updateApplicationDeployment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationDeployment_result__isset;

class Airavata_updateApplicationDeployment_result {
 public:

  Airavata_updateApplicationDeployment_result(const Airavata_updateApplicationDeployment_result&);
  Airavata_updateApplicationDeployment_result& operator=(const Airavata_updateApplicationDeployment_result&);
  Airavata_updateApplicationDeployment_result() : success(0) {
  }

  virtual ~Airavata_updateApplicationDeployment_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationDeployment_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateApplicationDeployment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationDeployment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationDeployment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationDeployment_presult__isset {
  _Airavata_updateApplicationDeployment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationDeployment_presult__isset;

class Airavata_updateApplicationDeployment_presult {
 public:


  virtual ~Airavata_updateApplicationDeployment_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationDeployment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteApplicationDeployment_args {
 public:

  Airavata_deleteApplicationDeployment_args(const Airavata_deleteApplicationDeployment_args&);
  Airavata_deleteApplicationDeployment_args& operator=(const Airavata_deleteApplicationDeployment_args&);
  Airavata_deleteApplicationDeployment_args() : appDeploymentId() {
  }

  virtual ~Airavata_deleteApplicationDeployment_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appDeploymentId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appDeploymentId(const std::string& val);

  bool operator == (const Airavata_deleteApplicationDeployment_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appDeploymentId == rhs.appDeploymentId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationDeployment_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationDeployment_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteApplicationDeployment_pargs {
 public:


  virtual ~Airavata_deleteApplicationDeployment_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appDeploymentId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationDeployment_result__isset {
  _Airavata_deleteApplicationDeployment_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationDeployment_result__isset;

class Airavata_deleteApplicationDeployment_result {
 public:

  Airavata_deleteApplicationDeployment_result(const Airavata_deleteApplicationDeployment_result&);
  Airavata_deleteApplicationDeployment_result& operator=(const Airavata_deleteApplicationDeployment_result&);
  Airavata_deleteApplicationDeployment_result() : success(0) {
  }

  virtual ~Airavata_deleteApplicationDeployment_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationDeployment_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteApplicationDeployment_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationDeployment_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationDeployment_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationDeployment_presult__isset {
  _Airavata_deleteApplicationDeployment_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationDeployment_presult__isset;

class Airavata_deleteApplicationDeployment_presult {
 public:


  virtual ~Airavata_deleteApplicationDeployment_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationDeployment_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllApplicationDeployments_args {
 public:

  Airavata_getAllApplicationDeployments_args(const Airavata_getAllApplicationDeployments_args&);
  Airavata_getAllApplicationDeployments_args& operator=(const Airavata_getAllApplicationDeployments_args&);
  Airavata_getAllApplicationDeployments_args() : gatewayId() {
  }

  virtual ~Airavata_getAllApplicationDeployments_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllApplicationDeployments_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationDeployments_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationDeployments_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllApplicationDeployments_pargs {
 public:


  virtual ~Airavata_getAllApplicationDeployments_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationDeployments_result__isset {
  _Airavata_getAllApplicationDeployments_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationDeployments_result__isset;

class Airavata_getAllApplicationDeployments_result {
 public:

  Airavata_getAllApplicationDeployments_result(const Airavata_getAllApplicationDeployments_result&);
  Airavata_getAllApplicationDeployments_result& operator=(const Airavata_getAllApplicationDeployments_result&);
  Airavata_getAllApplicationDeployments_result() {
  }

  virtual ~Airavata_getAllApplicationDeployments_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationDeployments_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllApplicationDeployments_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationDeployments_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationDeployments_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationDeployments_presult__isset {
  _Airavata_getAllApplicationDeployments_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationDeployments_presult__isset;

class Airavata_getAllApplicationDeployments_presult {
 public:


  virtual ~Airavata_getAllApplicationDeployments_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationDeployments_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAppModuleDeployedResources_args {
 public:

  Airavata_getAppModuleDeployedResources_args(const Airavata_getAppModuleDeployedResources_args&);
  Airavata_getAppModuleDeployedResources_args& operator=(const Airavata_getAppModuleDeployedResources_args&);
  Airavata_getAppModuleDeployedResources_args() : appModuleId() {
  }

  virtual ~Airavata_getAppModuleDeployedResources_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appModuleId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appModuleId(const std::string& val);

  bool operator == (const Airavata_getAppModuleDeployedResources_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appModuleId == rhs.appModuleId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAppModuleDeployedResources_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAppModuleDeployedResources_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAppModuleDeployedResources_pargs {
 public:


  virtual ~Airavata_getAppModuleDeployedResources_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appModuleId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAppModuleDeployedResources_result__isset {
  _Airavata_getAppModuleDeployedResources_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAppModuleDeployedResources_result__isset;

class Airavata_getAppModuleDeployedResources_result {
 public:

  Airavata_getAppModuleDeployedResources_result(const Airavata_getAppModuleDeployedResources_result&);
  Airavata_getAppModuleDeployedResources_result& operator=(const Airavata_getAppModuleDeployedResources_result&);
  Airavata_getAppModuleDeployedResources_result() {
  }

  virtual ~Airavata_getAppModuleDeployedResources_result() throw();
  std::vector<std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAppModuleDeployedResources_result__isset __isset;

  void __set_success(const std::vector<std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAppModuleDeployedResources_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAppModuleDeployedResources_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAppModuleDeployedResources_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAppModuleDeployedResources_presult__isset {
  _Airavata_getAppModuleDeployedResources_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAppModuleDeployedResources_presult__isset;

class Airavata_getAppModuleDeployedResources_presult {
 public:


  virtual ~Airavata_getAppModuleDeployedResources_presult() throw();
  std::vector<std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAppModuleDeployedResources_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerApplicationInterface_args {
 public:

  Airavata_registerApplicationInterface_args(const Airavata_registerApplicationInterface_args&);
  Airavata_registerApplicationInterface_args& operator=(const Airavata_registerApplicationInterface_args&);
  Airavata_registerApplicationInterface_args() : gatewayId() {
  }

  virtual ~Airavata_registerApplicationInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription applicationInterface;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_applicationInterface(const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& val);

  bool operator == (const Airavata_registerApplicationInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(applicationInterface == rhs.applicationInterface))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerApplicationInterface_pargs {
 public:


  virtual ~Airavata_registerApplicationInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription* applicationInterface;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationInterface_result__isset {
  _Airavata_registerApplicationInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationInterface_result__isset;

class Airavata_registerApplicationInterface_result {
 public:

  Airavata_registerApplicationInterface_result(const Airavata_registerApplicationInterface_result&);
  Airavata_registerApplicationInterface_result& operator=(const Airavata_registerApplicationInterface_result&);
  Airavata_registerApplicationInterface_result() : success() {
  }

  virtual ~Airavata_registerApplicationInterface_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationInterface_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerApplicationInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerApplicationInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerApplicationInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerApplicationInterface_presult__isset {
  _Airavata_registerApplicationInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerApplicationInterface_presult__isset;

class Airavata_registerApplicationInterface_presult {
 public:


  virtual ~Airavata_registerApplicationInterface_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerApplicationInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_cloneApplicationInterface_args__isset {
  _Airavata_cloneApplicationInterface_args__isset() : existingAppInterfaceID(false), newApplicationName(false), gatewayId(false) {}
  bool existingAppInterfaceID :1;
  bool newApplicationName :1;
  bool gatewayId :1;
} _Airavata_cloneApplicationInterface_args__isset;

class Airavata_cloneApplicationInterface_args {
 public:

  Airavata_cloneApplicationInterface_args(const Airavata_cloneApplicationInterface_args&);
  Airavata_cloneApplicationInterface_args& operator=(const Airavata_cloneApplicationInterface_args&);
  Airavata_cloneApplicationInterface_args() : existingAppInterfaceID(), newApplicationName(), gatewayId() {
  }

  virtual ~Airavata_cloneApplicationInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string existingAppInterfaceID;
  std::string newApplicationName;
  std::string gatewayId;

  _Airavata_cloneApplicationInterface_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_existingAppInterfaceID(const std::string& val);

  void __set_newApplicationName(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_cloneApplicationInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(existingAppInterfaceID == rhs.existingAppInterfaceID))
      return false;
    if (!(newApplicationName == rhs.newApplicationName))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneApplicationInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneApplicationInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_cloneApplicationInterface_pargs {
 public:


  virtual ~Airavata_cloneApplicationInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* existingAppInterfaceID;
  const std::string* newApplicationName;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneApplicationInterface_result__isset {
  _Airavata_cloneApplicationInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_cloneApplicationInterface_result__isset;

class Airavata_cloneApplicationInterface_result {
 public:

  Airavata_cloneApplicationInterface_result(const Airavata_cloneApplicationInterface_result&);
  Airavata_cloneApplicationInterface_result& operator=(const Airavata_cloneApplicationInterface_result&);
  Airavata_cloneApplicationInterface_result() : success() {
  }

  virtual ~Airavata_cloneApplicationInterface_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_cloneApplicationInterface_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_cloneApplicationInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_cloneApplicationInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_cloneApplicationInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_cloneApplicationInterface_presult__isset {
  _Airavata_cloneApplicationInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_cloneApplicationInterface_presult__isset;

class Airavata_cloneApplicationInterface_presult {
 public:


  virtual ~Airavata_cloneApplicationInterface_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_cloneApplicationInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getApplicationInterface_args {
 public:

  Airavata_getApplicationInterface_args(const Airavata_getApplicationInterface_args&);
  Airavata_getApplicationInterface_args& operator=(const Airavata_getApplicationInterface_args&);
  Airavata_getApplicationInterface_args() : appInterfaceId() {
  }

  virtual ~Airavata_getApplicationInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  bool operator == (const Airavata_getApplicationInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getApplicationInterface_pargs {
 public:


  virtual ~Airavata_getApplicationInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationInterface_result__isset {
  _Airavata_getApplicationInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationInterface_result__isset;

class Airavata_getApplicationInterface_result {
 public:

  Airavata_getApplicationInterface_result(const Airavata_getApplicationInterface_result&);
  Airavata_getApplicationInterface_result& operator=(const Airavata_getApplicationInterface_result&);
  Airavata_getApplicationInterface_result() {
  }

  virtual ~Airavata_getApplicationInterface_result() throw();
   ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationInterface_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getApplicationInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationInterface_presult__isset {
  _Airavata_getApplicationInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationInterface_presult__isset;

class Airavata_getApplicationInterface_presult {
 public:


  virtual ~Airavata_getApplicationInterface_presult() throw();
   ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateApplicationInterface_args {
 public:

  Airavata_updateApplicationInterface_args(const Airavata_updateApplicationInterface_args&);
  Airavata_updateApplicationInterface_args& operator=(const Airavata_updateApplicationInterface_args&);
  Airavata_updateApplicationInterface_args() : appInterfaceId() {
  }

  virtual ~Airavata_updateApplicationInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;
   ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription applicationInterface;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  void __set_applicationInterface(const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& val);

  bool operator == (const Airavata_updateApplicationInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    if (!(applicationInterface == rhs.applicationInterface))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateApplicationInterface_pargs {
 public:


  virtual ~Airavata_updateApplicationInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;
  const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription* applicationInterface;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationInterface_result__isset {
  _Airavata_updateApplicationInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationInterface_result__isset;

class Airavata_updateApplicationInterface_result {
 public:

  Airavata_updateApplicationInterface_result(const Airavata_updateApplicationInterface_result&);
  Airavata_updateApplicationInterface_result& operator=(const Airavata_updateApplicationInterface_result&);
  Airavata_updateApplicationInterface_result() : success(0) {
  }

  virtual ~Airavata_updateApplicationInterface_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationInterface_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateApplicationInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateApplicationInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateApplicationInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateApplicationInterface_presult__isset {
  _Airavata_updateApplicationInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateApplicationInterface_presult__isset;

class Airavata_updateApplicationInterface_presult {
 public:


  virtual ~Airavata_updateApplicationInterface_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateApplicationInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteApplicationInterface_args {
 public:

  Airavata_deleteApplicationInterface_args(const Airavata_deleteApplicationInterface_args&);
  Airavata_deleteApplicationInterface_args& operator=(const Airavata_deleteApplicationInterface_args&);
  Airavata_deleteApplicationInterface_args() : appInterfaceId() {
  }

  virtual ~Airavata_deleteApplicationInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  bool operator == (const Airavata_deleteApplicationInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteApplicationInterface_pargs {
 public:


  virtual ~Airavata_deleteApplicationInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationInterface_result__isset {
  _Airavata_deleteApplicationInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationInterface_result__isset;

class Airavata_deleteApplicationInterface_result {
 public:

  Airavata_deleteApplicationInterface_result(const Airavata_deleteApplicationInterface_result&);
  Airavata_deleteApplicationInterface_result& operator=(const Airavata_deleteApplicationInterface_result&);
  Airavata_deleteApplicationInterface_result() : success(0) {
  }

  virtual ~Airavata_deleteApplicationInterface_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationInterface_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteApplicationInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteApplicationInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteApplicationInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteApplicationInterface_presult__isset {
  _Airavata_deleteApplicationInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteApplicationInterface_presult__isset;

class Airavata_deleteApplicationInterface_presult {
 public:


  virtual ~Airavata_deleteApplicationInterface_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteApplicationInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllApplicationInterfaceNames_args {
 public:

  Airavata_getAllApplicationInterfaceNames_args(const Airavata_getAllApplicationInterfaceNames_args&);
  Airavata_getAllApplicationInterfaceNames_args& operator=(const Airavata_getAllApplicationInterfaceNames_args&);
  Airavata_getAllApplicationInterfaceNames_args() : gatewayId() {
  }

  virtual ~Airavata_getAllApplicationInterfaceNames_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllApplicationInterfaceNames_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationInterfaceNames_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationInterfaceNames_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllApplicationInterfaceNames_pargs {
 public:


  virtual ~Airavata_getAllApplicationInterfaceNames_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationInterfaceNames_result__isset {
  _Airavata_getAllApplicationInterfaceNames_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationInterfaceNames_result__isset;

class Airavata_getAllApplicationInterfaceNames_result {
 public:

  Airavata_getAllApplicationInterfaceNames_result(const Airavata_getAllApplicationInterfaceNames_result&);
  Airavata_getAllApplicationInterfaceNames_result& operator=(const Airavata_getAllApplicationInterfaceNames_result&);
  Airavata_getAllApplicationInterfaceNames_result() {
  }

  virtual ~Airavata_getAllApplicationInterfaceNames_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationInterfaceNames_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllApplicationInterfaceNames_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationInterfaceNames_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationInterfaceNames_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationInterfaceNames_presult__isset {
  _Airavata_getAllApplicationInterfaceNames_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationInterfaceNames_presult__isset;

class Airavata_getAllApplicationInterfaceNames_presult {
 public:


  virtual ~Airavata_getAllApplicationInterfaceNames_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationInterfaceNames_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllApplicationInterfaces_args {
 public:

  Airavata_getAllApplicationInterfaces_args(const Airavata_getAllApplicationInterfaces_args&);
  Airavata_getAllApplicationInterfaces_args& operator=(const Airavata_getAllApplicationInterfaces_args&);
  Airavata_getAllApplicationInterfaces_args() : gatewayId() {
  }

  virtual ~Airavata_getAllApplicationInterfaces_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllApplicationInterfaces_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationInterfaces_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationInterfaces_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllApplicationInterfaces_pargs {
 public:


  virtual ~Airavata_getAllApplicationInterfaces_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationInterfaces_result__isset {
  _Airavata_getAllApplicationInterfaces_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationInterfaces_result__isset;

class Airavata_getAllApplicationInterfaces_result {
 public:

  Airavata_getAllApplicationInterfaces_result(const Airavata_getAllApplicationInterfaces_result&);
  Airavata_getAllApplicationInterfaces_result& operator=(const Airavata_getAllApplicationInterfaces_result&);
  Airavata_getAllApplicationInterfaces_result() {
  }

  virtual ~Airavata_getAllApplicationInterfaces_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationInterfaces_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllApplicationInterfaces_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllApplicationInterfaces_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllApplicationInterfaces_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllApplicationInterfaces_presult__isset {
  _Airavata_getAllApplicationInterfaces_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllApplicationInterfaces_presult__isset;

class Airavata_getAllApplicationInterfaces_presult {
 public:


  virtual ~Airavata_getAllApplicationInterfaces_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllApplicationInterfaces_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getApplicationInputs_args {
 public:

  Airavata_getApplicationInputs_args(const Airavata_getApplicationInputs_args&);
  Airavata_getApplicationInputs_args& operator=(const Airavata_getApplicationInputs_args&);
  Airavata_getApplicationInputs_args() : appInterfaceId() {
  }

  virtual ~Airavata_getApplicationInputs_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  bool operator == (const Airavata_getApplicationInputs_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationInputs_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationInputs_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getApplicationInputs_pargs {
 public:


  virtual ~Airavata_getApplicationInputs_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationInputs_result__isset {
  _Airavata_getApplicationInputs_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationInputs_result__isset;

class Airavata_getApplicationInputs_result {
 public:

  Airavata_getApplicationInputs_result(const Airavata_getApplicationInputs_result&);
  Airavata_getApplicationInputs_result& operator=(const Airavata_getApplicationInputs_result&);
  Airavata_getApplicationInputs_result() {
  }

  virtual ~Airavata_getApplicationInputs_result() throw();
  std::vector< ::apache::airavata::model::application::io::InputDataObjectType>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationInputs_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getApplicationInputs_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationInputs_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationInputs_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationInputs_presult__isset {
  _Airavata_getApplicationInputs_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationInputs_presult__isset;

class Airavata_getApplicationInputs_presult {
 public:


  virtual ~Airavata_getApplicationInputs_presult() throw();
  std::vector< ::apache::airavata::model::application::io::InputDataObjectType> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationInputs_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getApplicationOutputs_args {
 public:

  Airavata_getApplicationOutputs_args(const Airavata_getApplicationOutputs_args&);
  Airavata_getApplicationOutputs_args& operator=(const Airavata_getApplicationOutputs_args&);
  Airavata_getApplicationOutputs_args() : appInterfaceId() {
  }

  virtual ~Airavata_getApplicationOutputs_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  bool operator == (const Airavata_getApplicationOutputs_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationOutputs_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationOutputs_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getApplicationOutputs_pargs {
 public:


  virtual ~Airavata_getApplicationOutputs_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationOutputs_result__isset {
  _Airavata_getApplicationOutputs_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationOutputs_result__isset;

class Airavata_getApplicationOutputs_result {
 public:

  Airavata_getApplicationOutputs_result(const Airavata_getApplicationOutputs_result&);
  Airavata_getApplicationOutputs_result& operator=(const Airavata_getApplicationOutputs_result&);
  Airavata_getApplicationOutputs_result() {
  }

  virtual ~Airavata_getApplicationOutputs_result() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationOutputs_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getApplicationOutputs_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getApplicationOutputs_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getApplicationOutputs_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getApplicationOutputs_presult__isset {
  _Airavata_getApplicationOutputs_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getApplicationOutputs_presult__isset;

class Airavata_getApplicationOutputs_presult {
 public:


  virtual ~Airavata_getApplicationOutputs_presult() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getApplicationOutputs_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAvailableAppInterfaceComputeResources_args {
 public:

  Airavata_getAvailableAppInterfaceComputeResources_args(const Airavata_getAvailableAppInterfaceComputeResources_args&);
  Airavata_getAvailableAppInterfaceComputeResources_args& operator=(const Airavata_getAvailableAppInterfaceComputeResources_args&);
  Airavata_getAvailableAppInterfaceComputeResources_args() : appInterfaceId() {
  }

  virtual ~Airavata_getAvailableAppInterfaceComputeResources_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string appInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_appInterfaceId(const std::string& val);

  bool operator == (const Airavata_getAvailableAppInterfaceComputeResources_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(appInterfaceId == rhs.appInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAvailableAppInterfaceComputeResources_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAvailableAppInterfaceComputeResources_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAvailableAppInterfaceComputeResources_pargs {
 public:


  virtual ~Airavata_getAvailableAppInterfaceComputeResources_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* appInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAvailableAppInterfaceComputeResources_result__isset {
  _Airavata_getAvailableAppInterfaceComputeResources_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAvailableAppInterfaceComputeResources_result__isset;

class Airavata_getAvailableAppInterfaceComputeResources_result {
 public:

  Airavata_getAvailableAppInterfaceComputeResources_result(const Airavata_getAvailableAppInterfaceComputeResources_result&);
  Airavata_getAvailableAppInterfaceComputeResources_result& operator=(const Airavata_getAvailableAppInterfaceComputeResources_result&);
  Airavata_getAvailableAppInterfaceComputeResources_result() {
  }

  virtual ~Airavata_getAvailableAppInterfaceComputeResources_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAvailableAppInterfaceComputeResources_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAvailableAppInterfaceComputeResources_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAvailableAppInterfaceComputeResources_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAvailableAppInterfaceComputeResources_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAvailableAppInterfaceComputeResources_presult__isset {
  _Airavata_getAvailableAppInterfaceComputeResources_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAvailableAppInterfaceComputeResources_presult__isset;

class Airavata_getAvailableAppInterfaceComputeResources_presult {
 public:


  virtual ~Airavata_getAvailableAppInterfaceComputeResources_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAvailableAppInterfaceComputeResources_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerComputeResource_args {
 public:

  Airavata_registerComputeResource_args(const Airavata_registerComputeResource_args&);
  Airavata_registerComputeResource_args& operator=(const Airavata_registerComputeResource_args&);
  Airavata_registerComputeResource_args() {
  }

  virtual ~Airavata_registerComputeResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription computeResourceDescription;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceDescription(const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& val);

  bool operator == (const Airavata_registerComputeResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceDescription == rhs.computeResourceDescription))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerComputeResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerComputeResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerComputeResource_pargs {
 public:


  virtual ~Airavata_registerComputeResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription* computeResourceDescription;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerComputeResource_result__isset {
  _Airavata_registerComputeResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerComputeResource_result__isset;

class Airavata_registerComputeResource_result {
 public:

  Airavata_registerComputeResource_result(const Airavata_registerComputeResource_result&);
  Airavata_registerComputeResource_result& operator=(const Airavata_registerComputeResource_result&);
  Airavata_registerComputeResource_result() : success() {
  }

  virtual ~Airavata_registerComputeResource_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerComputeResource_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerComputeResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerComputeResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerComputeResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerComputeResource_presult__isset {
  _Airavata_registerComputeResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerComputeResource_presult__isset;

class Airavata_registerComputeResource_presult {
 public:


  virtual ~Airavata_registerComputeResource_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerComputeResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getComputeResource_args {
 public:

  Airavata_getComputeResource_args(const Airavata_getComputeResource_args&);
  Airavata_getComputeResource_args& operator=(const Airavata_getComputeResource_args&);
  Airavata_getComputeResource_args() : computeResourceId() {
  }

  virtual ~Airavata_getComputeResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  bool operator == (const Airavata_getComputeResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getComputeResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getComputeResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getComputeResource_pargs {
 public:


  virtual ~Airavata_getComputeResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getComputeResource_result__isset {
  _Airavata_getComputeResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getComputeResource_result__isset;

class Airavata_getComputeResource_result {
 public:

  Airavata_getComputeResource_result(const Airavata_getComputeResource_result&);
  Airavata_getComputeResource_result& operator=(const Airavata_getComputeResource_result&);
  Airavata_getComputeResource_result() {
  }

  virtual ~Airavata_getComputeResource_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getComputeResource_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getComputeResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getComputeResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getComputeResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getComputeResource_presult__isset {
  _Airavata_getComputeResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getComputeResource_presult__isset;

class Airavata_getComputeResource_presult {
 public:


  virtual ~Airavata_getComputeResource_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getComputeResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllComputeResourceNames_args {
 public:

  Airavata_getAllComputeResourceNames_args(const Airavata_getAllComputeResourceNames_args&);
  Airavata_getAllComputeResourceNames_args& operator=(const Airavata_getAllComputeResourceNames_args&);
  Airavata_getAllComputeResourceNames_args() {
  }

  virtual ~Airavata_getAllComputeResourceNames_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAllComputeResourceNames_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllComputeResourceNames_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllComputeResourceNames_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllComputeResourceNames_pargs {
 public:


  virtual ~Airavata_getAllComputeResourceNames_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllComputeResourceNames_result__isset {
  _Airavata_getAllComputeResourceNames_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllComputeResourceNames_result__isset;

class Airavata_getAllComputeResourceNames_result {
 public:

  Airavata_getAllComputeResourceNames_result(const Airavata_getAllComputeResourceNames_result&);
  Airavata_getAllComputeResourceNames_result& operator=(const Airavata_getAllComputeResourceNames_result&);
  Airavata_getAllComputeResourceNames_result() {
  }

  virtual ~Airavata_getAllComputeResourceNames_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllComputeResourceNames_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllComputeResourceNames_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllComputeResourceNames_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllComputeResourceNames_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllComputeResourceNames_presult__isset {
  _Airavata_getAllComputeResourceNames_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllComputeResourceNames_presult__isset;

class Airavata_getAllComputeResourceNames_presult {
 public:


  virtual ~Airavata_getAllComputeResourceNames_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllComputeResourceNames_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateComputeResource_args {
 public:

  Airavata_updateComputeResource_args(const Airavata_updateComputeResource_args&);
  Airavata_updateComputeResource_args& operator=(const Airavata_updateComputeResource_args&);
  Airavata_updateComputeResource_args() : computeResourceId() {
  }

  virtual ~Airavata_updateComputeResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
   ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription computeResourceDescription;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_computeResourceDescription(const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& val);

  bool operator == (const Airavata_updateComputeResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(computeResourceDescription == rhs.computeResourceDescription))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateComputeResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateComputeResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateComputeResource_pargs {
 public:


  virtual ~Airavata_updateComputeResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription* computeResourceDescription;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateComputeResource_result__isset {
  _Airavata_updateComputeResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateComputeResource_result__isset;

class Airavata_updateComputeResource_result {
 public:

  Airavata_updateComputeResource_result(const Airavata_updateComputeResource_result&);
  Airavata_updateComputeResource_result& operator=(const Airavata_updateComputeResource_result&);
  Airavata_updateComputeResource_result() : success(0) {
  }

  virtual ~Airavata_updateComputeResource_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateComputeResource_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateComputeResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateComputeResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateComputeResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateComputeResource_presult__isset {
  _Airavata_updateComputeResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateComputeResource_presult__isset;

class Airavata_updateComputeResource_presult {
 public:


  virtual ~Airavata_updateComputeResource_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateComputeResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteComputeResource_args {
 public:

  Airavata_deleteComputeResource_args(const Airavata_deleteComputeResource_args&);
  Airavata_deleteComputeResource_args& operator=(const Airavata_deleteComputeResource_args&);
  Airavata_deleteComputeResource_args() : computeResourceId() {
  }

  virtual ~Airavata_deleteComputeResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  bool operator == (const Airavata_deleteComputeResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteComputeResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteComputeResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteComputeResource_pargs {
 public:


  virtual ~Airavata_deleteComputeResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteComputeResource_result__isset {
  _Airavata_deleteComputeResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteComputeResource_result__isset;

class Airavata_deleteComputeResource_result {
 public:

  Airavata_deleteComputeResource_result(const Airavata_deleteComputeResource_result&);
  Airavata_deleteComputeResource_result& operator=(const Airavata_deleteComputeResource_result&);
  Airavata_deleteComputeResource_result() : success(0) {
  }

  virtual ~Airavata_deleteComputeResource_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteComputeResource_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteComputeResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteComputeResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteComputeResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteComputeResource_presult__isset {
  _Airavata_deleteComputeResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteComputeResource_presult__isset;

class Airavata_deleteComputeResource_presult {
 public:


  virtual ~Airavata_deleteComputeResource_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteComputeResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerStorageResource_args {
 public:

  Airavata_registerStorageResource_args(const Airavata_registerStorageResource_args&);
  Airavata_registerStorageResource_args& operator=(const Airavata_registerStorageResource_args&);
  Airavata_registerStorageResource_args() {
  }

  virtual ~Airavata_registerStorageResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription storageResourceDescription;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_storageResourceDescription(const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& val);

  bool operator == (const Airavata_registerStorageResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(storageResourceDescription == rhs.storageResourceDescription))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerStorageResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerStorageResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerStorageResource_pargs {
 public:


  virtual ~Airavata_registerStorageResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription* storageResourceDescription;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerStorageResource_result__isset {
  _Airavata_registerStorageResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerStorageResource_result__isset;

class Airavata_registerStorageResource_result {
 public:

  Airavata_registerStorageResource_result(const Airavata_registerStorageResource_result&);
  Airavata_registerStorageResource_result& operator=(const Airavata_registerStorageResource_result&);
  Airavata_registerStorageResource_result() : success() {
  }

  virtual ~Airavata_registerStorageResource_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerStorageResource_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerStorageResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerStorageResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerStorageResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerStorageResource_presult__isset {
  _Airavata_registerStorageResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerStorageResource_presult__isset;

class Airavata_registerStorageResource_presult {
 public:


  virtual ~Airavata_registerStorageResource_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerStorageResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getStorageResource_args {
 public:

  Airavata_getStorageResource_args(const Airavata_getStorageResource_args&);
  Airavata_getStorageResource_args& operator=(const Airavata_getStorageResource_args&);
  Airavata_getStorageResource_args() : storageResourceId() {
  }

  virtual ~Airavata_getStorageResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string storageResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_storageResourceId(const std::string& val);

  bool operator == (const Airavata_getStorageResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(storageResourceId == rhs.storageResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getStorageResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getStorageResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getStorageResource_pargs {
 public:


  virtual ~Airavata_getStorageResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* storageResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getStorageResource_result__isset {
  _Airavata_getStorageResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getStorageResource_result__isset;

class Airavata_getStorageResource_result {
 public:

  Airavata_getStorageResource_result(const Airavata_getStorageResource_result&);
  Airavata_getStorageResource_result& operator=(const Airavata_getStorageResource_result&);
  Airavata_getStorageResource_result() {
  }

  virtual ~Airavata_getStorageResource_result() throw();
   ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getStorageResource_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getStorageResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getStorageResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getStorageResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getStorageResource_presult__isset {
  _Airavata_getStorageResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getStorageResource_presult__isset;

class Airavata_getStorageResource_presult {
 public:


  virtual ~Airavata_getStorageResource_presult() throw();
   ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getStorageResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllStorageResourceNames_args {
 public:

  Airavata_getAllStorageResourceNames_args(const Airavata_getAllStorageResourceNames_args&);
  Airavata_getAllStorageResourceNames_args& operator=(const Airavata_getAllStorageResourceNames_args&);
  Airavata_getAllStorageResourceNames_args() {
  }

  virtual ~Airavata_getAllStorageResourceNames_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAllStorageResourceNames_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllStorageResourceNames_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllStorageResourceNames_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllStorageResourceNames_pargs {
 public:


  virtual ~Airavata_getAllStorageResourceNames_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllStorageResourceNames_result__isset {
  _Airavata_getAllStorageResourceNames_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllStorageResourceNames_result__isset;

class Airavata_getAllStorageResourceNames_result {
 public:

  Airavata_getAllStorageResourceNames_result(const Airavata_getAllStorageResourceNames_result&);
  Airavata_getAllStorageResourceNames_result& operator=(const Airavata_getAllStorageResourceNames_result&);
  Airavata_getAllStorageResourceNames_result() {
  }

  virtual ~Airavata_getAllStorageResourceNames_result() throw();
  std::map<std::string, std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllStorageResourceNames_result__isset __isset;

  void __set_success(const std::map<std::string, std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllStorageResourceNames_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllStorageResourceNames_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllStorageResourceNames_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllStorageResourceNames_presult__isset {
  _Airavata_getAllStorageResourceNames_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllStorageResourceNames_presult__isset;

class Airavata_getAllStorageResourceNames_presult {
 public:


  virtual ~Airavata_getAllStorageResourceNames_presult() throw();
  std::map<std::string, std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllStorageResourceNames_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateStorageResource_args {
 public:

  Airavata_updateStorageResource_args(const Airavata_updateStorageResource_args&);
  Airavata_updateStorageResource_args& operator=(const Airavata_updateStorageResource_args&);
  Airavata_updateStorageResource_args() : storageResourceId() {
  }

  virtual ~Airavata_updateStorageResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string storageResourceId;
   ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription storageResourceDescription;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_storageResourceId(const std::string& val);

  void __set_storageResourceDescription(const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& val);

  bool operator == (const Airavata_updateStorageResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(storageResourceId == rhs.storageResourceId))
      return false;
    if (!(storageResourceDescription == rhs.storageResourceDescription))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateStorageResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateStorageResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateStorageResource_pargs {
 public:


  virtual ~Airavata_updateStorageResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* storageResourceId;
  const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription* storageResourceDescription;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateStorageResource_result__isset {
  _Airavata_updateStorageResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateStorageResource_result__isset;

class Airavata_updateStorageResource_result {
 public:

  Airavata_updateStorageResource_result(const Airavata_updateStorageResource_result&);
  Airavata_updateStorageResource_result& operator=(const Airavata_updateStorageResource_result&);
  Airavata_updateStorageResource_result() : success(0) {
  }

  virtual ~Airavata_updateStorageResource_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateStorageResource_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateStorageResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateStorageResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateStorageResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateStorageResource_presult__isset {
  _Airavata_updateStorageResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateStorageResource_presult__isset;

class Airavata_updateStorageResource_presult {
 public:


  virtual ~Airavata_updateStorageResource_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateStorageResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteStorageResource_args {
 public:

  Airavata_deleteStorageResource_args(const Airavata_deleteStorageResource_args&);
  Airavata_deleteStorageResource_args& operator=(const Airavata_deleteStorageResource_args&);
  Airavata_deleteStorageResource_args() : storageResourceId() {
  }

  virtual ~Airavata_deleteStorageResource_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string storageResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_storageResourceId(const std::string& val);

  bool operator == (const Airavata_deleteStorageResource_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(storageResourceId == rhs.storageResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteStorageResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteStorageResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteStorageResource_pargs {
 public:


  virtual ~Airavata_deleteStorageResource_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* storageResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteStorageResource_result__isset {
  _Airavata_deleteStorageResource_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteStorageResource_result__isset;

class Airavata_deleteStorageResource_result {
 public:

  Airavata_deleteStorageResource_result(const Airavata_deleteStorageResource_result&);
  Airavata_deleteStorageResource_result& operator=(const Airavata_deleteStorageResource_result&);
  Airavata_deleteStorageResource_result() : success(0) {
  }

  virtual ~Airavata_deleteStorageResource_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteStorageResource_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteStorageResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteStorageResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteStorageResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteStorageResource_presult__isset {
  _Airavata_deleteStorageResource_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteStorageResource_presult__isset;

class Airavata_deleteStorageResource_presult {
 public:


  virtual ~Airavata_deleteStorageResource_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteStorageResource_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addLocalSubmissionDetails_args {
 public:

  Airavata_addLocalSubmissionDetails_args(const Airavata_addLocalSubmissionDetails_args&);
  Airavata_addLocalSubmissionDetails_args& operator=(const Airavata_addLocalSubmissionDetails_args&);
  Airavata_addLocalSubmissionDetails_args() : computeResourceId(), priorityOrder(0) {
  }

  virtual ~Airavata_addLocalSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  int32_t priorityOrder;
   ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission localSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_priorityOrder(const int32_t val);

  void __set_localSubmission(const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& val);

  bool operator == (const Airavata_addLocalSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(localSubmission == rhs.localSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_addLocalSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addLocalSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addLocalSubmissionDetails_pargs {
 public:


  virtual ~Airavata_addLocalSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission* localSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addLocalSubmissionDetails_result__isset {
  _Airavata_addLocalSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addLocalSubmissionDetails_result__isset;

class Airavata_addLocalSubmissionDetails_result {
 public:

  Airavata_addLocalSubmissionDetails_result(const Airavata_addLocalSubmissionDetails_result&);
  Airavata_addLocalSubmissionDetails_result& operator=(const Airavata_addLocalSubmissionDetails_result&);
  Airavata_addLocalSubmissionDetails_result() : success() {
  }

  virtual ~Airavata_addLocalSubmissionDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addLocalSubmissionDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addLocalSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addLocalSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addLocalSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addLocalSubmissionDetails_presult__isset {
  _Airavata_addLocalSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addLocalSubmissionDetails_presult__isset;

class Airavata_addLocalSubmissionDetails_presult {
 public:


  virtual ~Airavata_addLocalSubmissionDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addLocalSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateLocalSubmissionDetails_args {
 public:

  Airavata_updateLocalSubmissionDetails_args(const Airavata_updateLocalSubmissionDetails_args&);
  Airavata_updateLocalSubmissionDetails_args& operator=(const Airavata_updateLocalSubmissionDetails_args&);
  Airavata_updateLocalSubmissionDetails_args() : jobSubmissionInterfaceId() {
  }

  virtual ~Airavata_updateLocalSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionInterfaceId;
   ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission localSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  void __set_localSubmission(const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& val);

  bool operator == (const Airavata_updateLocalSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(localSubmission == rhs.localSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateLocalSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateLocalSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateLocalSubmissionDetails_pargs {
 public:


  virtual ~Airavata_updateLocalSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionInterfaceId;
  const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission* localSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateLocalSubmissionDetails_result__isset {
  _Airavata_updateLocalSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateLocalSubmissionDetails_result__isset;

class Airavata_updateLocalSubmissionDetails_result {
 public:

  Airavata_updateLocalSubmissionDetails_result(const Airavata_updateLocalSubmissionDetails_result&);
  Airavata_updateLocalSubmissionDetails_result& operator=(const Airavata_updateLocalSubmissionDetails_result&);
  Airavata_updateLocalSubmissionDetails_result() : success(0) {
  }

  virtual ~Airavata_updateLocalSubmissionDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateLocalSubmissionDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateLocalSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateLocalSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateLocalSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateLocalSubmissionDetails_presult__isset {
  _Airavata_updateLocalSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateLocalSubmissionDetails_presult__isset;

class Airavata_updateLocalSubmissionDetails_presult {
 public:


  virtual ~Airavata_updateLocalSubmissionDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateLocalSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getLocalJobSubmission_args {
 public:

  Airavata_getLocalJobSubmission_args(const Airavata_getLocalJobSubmission_args&);
  Airavata_getLocalJobSubmission_args& operator=(const Airavata_getLocalJobSubmission_args&);
  Airavata_getLocalJobSubmission_args() : jobSubmissionId() {
  }

  virtual ~Airavata_getLocalJobSubmission_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionId(const std::string& val);

  bool operator == (const Airavata_getLocalJobSubmission_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionId == rhs.jobSubmissionId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLocalJobSubmission_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLocalJobSubmission_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getLocalJobSubmission_pargs {
 public:


  virtual ~Airavata_getLocalJobSubmission_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLocalJobSubmission_result__isset {
  _Airavata_getLocalJobSubmission_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLocalJobSubmission_result__isset;

class Airavata_getLocalJobSubmission_result {
 public:

  Airavata_getLocalJobSubmission_result(const Airavata_getLocalJobSubmission_result&);
  Airavata_getLocalJobSubmission_result& operator=(const Airavata_getLocalJobSubmission_result&);
  Airavata_getLocalJobSubmission_result() {
  }

  virtual ~Airavata_getLocalJobSubmission_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLocalJobSubmission_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getLocalJobSubmission_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLocalJobSubmission_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLocalJobSubmission_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLocalJobSubmission_presult__isset {
  _Airavata_getLocalJobSubmission_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLocalJobSubmission_presult__isset;

class Airavata_getLocalJobSubmission_presult {
 public:


  virtual ~Airavata_getLocalJobSubmission_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::LOCALSubmission* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLocalJobSubmission_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addSSHJobSubmissionDetails_args {
 public:

  Airavata_addSSHJobSubmissionDetails_args(const Airavata_addSSHJobSubmissionDetails_args&);
  Airavata_addSSHJobSubmissionDetails_args& operator=(const Airavata_addSSHJobSubmissionDetails_args&);
  Airavata_addSSHJobSubmissionDetails_args() : computeResourceId(), priorityOrder(0) {
  }

  virtual ~Airavata_addSSHJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  int32_t priorityOrder;
   ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission sshJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_priorityOrder(const int32_t val);

  void __set_sshJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& val);

  bool operator == (const Airavata_addSSHJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(sshJobSubmission == rhs.sshJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSSHJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSSHJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addSSHJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_addSSHJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission* sshJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSSHJobSubmissionDetails_result__isset {
  _Airavata_addSSHJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSSHJobSubmissionDetails_result__isset;

class Airavata_addSSHJobSubmissionDetails_result {
 public:

  Airavata_addSSHJobSubmissionDetails_result(const Airavata_addSSHJobSubmissionDetails_result&);
  Airavata_addSSHJobSubmissionDetails_result& operator=(const Airavata_addSSHJobSubmissionDetails_result&);
  Airavata_addSSHJobSubmissionDetails_result() : success() {
  }

  virtual ~Airavata_addSSHJobSubmissionDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSSHJobSubmissionDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addSSHJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSSHJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSSHJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSSHJobSubmissionDetails_presult__isset {
  _Airavata_addSSHJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSSHJobSubmissionDetails_presult__isset;

class Airavata_addSSHJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_addSSHJobSubmissionDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSSHJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addSSHForkJobSubmissionDetails_args {
 public:

  Airavata_addSSHForkJobSubmissionDetails_args(const Airavata_addSSHForkJobSubmissionDetails_args&);
  Airavata_addSSHForkJobSubmissionDetails_args& operator=(const Airavata_addSSHForkJobSubmissionDetails_args&);
  Airavata_addSSHForkJobSubmissionDetails_args() : computeResourceId(), priorityOrder(0) {
  }

  virtual ~Airavata_addSSHForkJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  int32_t priorityOrder;
   ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission sshJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_priorityOrder(const int32_t val);

  void __set_sshJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& val);

  bool operator == (const Airavata_addSSHForkJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(sshJobSubmission == rhs.sshJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSSHForkJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSSHForkJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addSSHForkJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_addSSHForkJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission* sshJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSSHForkJobSubmissionDetails_result__isset {
  _Airavata_addSSHForkJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSSHForkJobSubmissionDetails_result__isset;

class Airavata_addSSHForkJobSubmissionDetails_result {
 public:

  Airavata_addSSHForkJobSubmissionDetails_result(const Airavata_addSSHForkJobSubmissionDetails_result&);
  Airavata_addSSHForkJobSubmissionDetails_result& operator=(const Airavata_addSSHForkJobSubmissionDetails_result&);
  Airavata_addSSHForkJobSubmissionDetails_result() : success() {
  }

  virtual ~Airavata_addSSHForkJobSubmissionDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSSHForkJobSubmissionDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addSSHForkJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSSHForkJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSSHForkJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSSHForkJobSubmissionDetails_presult__isset {
  _Airavata_addSSHForkJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSSHForkJobSubmissionDetails_presult__isset;

class Airavata_addSSHForkJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_addSSHForkJobSubmissionDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSSHForkJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getSSHJobSubmission_args {
 public:

  Airavata_getSSHJobSubmission_args(const Airavata_getSSHJobSubmission_args&);
  Airavata_getSSHJobSubmission_args& operator=(const Airavata_getSSHJobSubmission_args&);
  Airavata_getSSHJobSubmission_args() : jobSubmissionId() {
  }

  virtual ~Airavata_getSSHJobSubmission_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionId(const std::string& val);

  bool operator == (const Airavata_getSSHJobSubmission_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionId == rhs.jobSubmissionId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSSHJobSubmission_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSSHJobSubmission_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getSSHJobSubmission_pargs {
 public:


  virtual ~Airavata_getSSHJobSubmission_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSSHJobSubmission_result__isset {
  _Airavata_getSSHJobSubmission_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getSSHJobSubmission_result__isset;

class Airavata_getSSHJobSubmission_result {
 public:

  Airavata_getSSHJobSubmission_result(const Airavata_getSSHJobSubmission_result&);
  Airavata_getSSHJobSubmission_result& operator=(const Airavata_getSSHJobSubmission_result&);
  Airavata_getSSHJobSubmission_result() {
  }

  virtual ~Airavata_getSSHJobSubmission_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getSSHJobSubmission_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getSSHJobSubmission_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSSHJobSubmission_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSSHJobSubmission_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSSHJobSubmission_presult__isset {
  _Airavata_getSSHJobSubmission_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getSSHJobSubmission_presult__isset;

class Airavata_getSSHJobSubmission_presult {
 public:


  virtual ~Airavata_getSSHJobSubmission_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getSSHJobSubmission_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addUNICOREJobSubmissionDetails_args {
 public:

  Airavata_addUNICOREJobSubmissionDetails_args(const Airavata_addUNICOREJobSubmissionDetails_args&);
  Airavata_addUNICOREJobSubmissionDetails_args& operator=(const Airavata_addUNICOREJobSubmissionDetails_args&);
  Airavata_addUNICOREJobSubmissionDetails_args() : computeResourceId(), priorityOrder(0) {
  }

  virtual ~Airavata_addUNICOREJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  int32_t priorityOrder;
   ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission unicoreJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_priorityOrder(const int32_t val);

  void __set_unicoreJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& val);

  bool operator == (const Airavata_addUNICOREJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(unicoreJobSubmission == rhs.unicoreJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUNICOREJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUNICOREJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addUNICOREJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_addUNICOREJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission* unicoreJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUNICOREJobSubmissionDetails_result__isset {
  _Airavata_addUNICOREJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUNICOREJobSubmissionDetails_result__isset;

class Airavata_addUNICOREJobSubmissionDetails_result {
 public:

  Airavata_addUNICOREJobSubmissionDetails_result(const Airavata_addUNICOREJobSubmissionDetails_result&);
  Airavata_addUNICOREJobSubmissionDetails_result& operator=(const Airavata_addUNICOREJobSubmissionDetails_result&);
  Airavata_addUNICOREJobSubmissionDetails_result() : success() {
  }

  virtual ~Airavata_addUNICOREJobSubmissionDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUNICOREJobSubmissionDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addUNICOREJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUNICOREJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUNICOREJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUNICOREJobSubmissionDetails_presult__isset {
  _Airavata_addUNICOREJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUNICOREJobSubmissionDetails_presult__isset;

class Airavata_addUNICOREJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_addUNICOREJobSubmissionDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUNICOREJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUnicoreJobSubmission_args {
 public:

  Airavata_getUnicoreJobSubmission_args(const Airavata_getUnicoreJobSubmission_args&);
  Airavata_getUnicoreJobSubmission_args& operator=(const Airavata_getUnicoreJobSubmission_args&);
  Airavata_getUnicoreJobSubmission_args() : jobSubmissionId() {
  }

  virtual ~Airavata_getUnicoreJobSubmission_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionId(const std::string& val);

  bool operator == (const Airavata_getUnicoreJobSubmission_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionId == rhs.jobSubmissionId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUnicoreJobSubmission_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUnicoreJobSubmission_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUnicoreJobSubmission_pargs {
 public:


  virtual ~Airavata_getUnicoreJobSubmission_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUnicoreJobSubmission_result__isset {
  _Airavata_getUnicoreJobSubmission_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUnicoreJobSubmission_result__isset;

class Airavata_getUnicoreJobSubmission_result {
 public:

  Airavata_getUnicoreJobSubmission_result(const Airavata_getUnicoreJobSubmission_result&);
  Airavata_getUnicoreJobSubmission_result& operator=(const Airavata_getUnicoreJobSubmission_result&);
  Airavata_getUnicoreJobSubmission_result() {
  }

  virtual ~Airavata_getUnicoreJobSubmission_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUnicoreJobSubmission_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUnicoreJobSubmission_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUnicoreJobSubmission_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUnicoreJobSubmission_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUnicoreJobSubmission_presult__isset {
  _Airavata_getUnicoreJobSubmission_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUnicoreJobSubmission_presult__isset;

class Airavata_getUnicoreJobSubmission_presult {
 public:


  virtual ~Airavata_getUnicoreJobSubmission_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUnicoreJobSubmission_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addCloudJobSubmissionDetails_args {
 public:

  Airavata_addCloudJobSubmissionDetails_args(const Airavata_addCloudJobSubmissionDetails_args&);
  Airavata_addCloudJobSubmissionDetails_args& operator=(const Airavata_addCloudJobSubmissionDetails_args&);
  Airavata_addCloudJobSubmissionDetails_args() : computeResourceId(), priorityOrder(0) {
  }

  virtual ~Airavata_addCloudJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  int32_t priorityOrder;
   ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission cloudSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_priorityOrder(const int32_t val);

  void __set_cloudSubmission(const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& val);

  bool operator == (const Airavata_addCloudJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(cloudSubmission == rhs.cloudSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_addCloudJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addCloudJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addCloudJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_addCloudJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission* cloudSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addCloudJobSubmissionDetails_result__isset {
  _Airavata_addCloudJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addCloudJobSubmissionDetails_result__isset;

class Airavata_addCloudJobSubmissionDetails_result {
 public:

  Airavata_addCloudJobSubmissionDetails_result(const Airavata_addCloudJobSubmissionDetails_result&);
  Airavata_addCloudJobSubmissionDetails_result& operator=(const Airavata_addCloudJobSubmissionDetails_result&);
  Airavata_addCloudJobSubmissionDetails_result() : success() {
  }

  virtual ~Airavata_addCloudJobSubmissionDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addCloudJobSubmissionDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addCloudJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addCloudJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addCloudJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addCloudJobSubmissionDetails_presult__isset {
  _Airavata_addCloudJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addCloudJobSubmissionDetails_presult__isset;

class Airavata_addCloudJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_addCloudJobSubmissionDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addCloudJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getCloudJobSubmission_args {
 public:

  Airavata_getCloudJobSubmission_args(const Airavata_getCloudJobSubmission_args&);
  Airavata_getCloudJobSubmission_args& operator=(const Airavata_getCloudJobSubmission_args&);
  Airavata_getCloudJobSubmission_args() : jobSubmissionId() {
  }

  virtual ~Airavata_getCloudJobSubmission_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionId(const std::string& val);

  bool operator == (const Airavata_getCloudJobSubmission_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionId == rhs.jobSubmissionId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getCloudJobSubmission_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getCloudJobSubmission_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getCloudJobSubmission_pargs {
 public:


  virtual ~Airavata_getCloudJobSubmission_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getCloudJobSubmission_result__isset {
  _Airavata_getCloudJobSubmission_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getCloudJobSubmission_result__isset;

class Airavata_getCloudJobSubmission_result {
 public:

  Airavata_getCloudJobSubmission_result(const Airavata_getCloudJobSubmission_result&);
  Airavata_getCloudJobSubmission_result& operator=(const Airavata_getCloudJobSubmission_result&);
  Airavata_getCloudJobSubmission_result() {
  }

  virtual ~Airavata_getCloudJobSubmission_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getCloudJobSubmission_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getCloudJobSubmission_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getCloudJobSubmission_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getCloudJobSubmission_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getCloudJobSubmission_presult__isset {
  _Airavata_getCloudJobSubmission_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getCloudJobSubmission_presult__isset;

class Airavata_getCloudJobSubmission_presult {
 public:


  virtual ~Airavata_getCloudJobSubmission_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getCloudJobSubmission_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateSSHJobSubmissionDetails_args {
 public:

  Airavata_updateSSHJobSubmissionDetails_args(const Airavata_updateSSHJobSubmissionDetails_args&);
  Airavata_updateSSHJobSubmissionDetails_args& operator=(const Airavata_updateSSHJobSubmissionDetails_args&);
  Airavata_updateSSHJobSubmissionDetails_args() : jobSubmissionInterfaceId() {
  }

  virtual ~Airavata_updateSSHJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionInterfaceId;
   ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission sshJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  void __set_sshJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission& val);

  bool operator == (const Airavata_updateSSHJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(sshJobSubmission == rhs.sshJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateSSHJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateSSHJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateSSHJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_updateSSHJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionInterfaceId;
  const  ::apache::airavata::model::appcatalog::computeresource::SSHJobSubmission* sshJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateSSHJobSubmissionDetails_result__isset {
  _Airavata_updateSSHJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateSSHJobSubmissionDetails_result__isset;

class Airavata_updateSSHJobSubmissionDetails_result {
 public:

  Airavata_updateSSHJobSubmissionDetails_result(const Airavata_updateSSHJobSubmissionDetails_result&);
  Airavata_updateSSHJobSubmissionDetails_result& operator=(const Airavata_updateSSHJobSubmissionDetails_result&);
  Airavata_updateSSHJobSubmissionDetails_result() : success(0) {
  }

  virtual ~Airavata_updateSSHJobSubmissionDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateSSHJobSubmissionDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateSSHJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateSSHJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateSSHJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateSSHJobSubmissionDetails_presult__isset {
  _Airavata_updateSSHJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateSSHJobSubmissionDetails_presult__isset;

class Airavata_updateSSHJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_updateSSHJobSubmissionDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateSSHJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateCloudJobSubmissionDetails_args {
 public:

  Airavata_updateCloudJobSubmissionDetails_args(const Airavata_updateCloudJobSubmissionDetails_args&);
  Airavata_updateCloudJobSubmissionDetails_args& operator=(const Airavata_updateCloudJobSubmissionDetails_args&);
  Airavata_updateCloudJobSubmissionDetails_args() : jobSubmissionInterfaceId() {
  }

  virtual ~Airavata_updateCloudJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionInterfaceId;
   ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission sshJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  void __set_sshJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission& val);

  bool operator == (const Airavata_updateCloudJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(sshJobSubmission == rhs.sshJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateCloudJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateCloudJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateCloudJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_updateCloudJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionInterfaceId;
  const  ::apache::airavata::model::appcatalog::computeresource::CloudJobSubmission* sshJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateCloudJobSubmissionDetails_result__isset {
  _Airavata_updateCloudJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateCloudJobSubmissionDetails_result__isset;

class Airavata_updateCloudJobSubmissionDetails_result {
 public:

  Airavata_updateCloudJobSubmissionDetails_result(const Airavata_updateCloudJobSubmissionDetails_result&);
  Airavata_updateCloudJobSubmissionDetails_result& operator=(const Airavata_updateCloudJobSubmissionDetails_result&);
  Airavata_updateCloudJobSubmissionDetails_result() : success(0) {
  }

  virtual ~Airavata_updateCloudJobSubmissionDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateCloudJobSubmissionDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateCloudJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateCloudJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateCloudJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateCloudJobSubmissionDetails_presult__isset {
  _Airavata_updateCloudJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateCloudJobSubmissionDetails_presult__isset;

class Airavata_updateCloudJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_updateCloudJobSubmissionDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateCloudJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateUnicoreJobSubmissionDetails_args {
 public:

  Airavata_updateUnicoreJobSubmissionDetails_args(const Airavata_updateUnicoreJobSubmissionDetails_args&);
  Airavata_updateUnicoreJobSubmissionDetails_args& operator=(const Airavata_updateUnicoreJobSubmissionDetails_args&);
  Airavata_updateUnicoreJobSubmissionDetails_args() : jobSubmissionInterfaceId() {
  }

  virtual ~Airavata_updateUnicoreJobSubmissionDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionInterfaceId;
   ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission unicoreJobSubmission;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  void __set_unicoreJobSubmission(const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission& val);

  bool operator == (const Airavata_updateUnicoreJobSubmissionDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(unicoreJobSubmission == rhs.unicoreJobSubmission))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUnicoreJobSubmissionDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUnicoreJobSubmissionDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateUnicoreJobSubmissionDetails_pargs {
 public:


  virtual ~Airavata_updateUnicoreJobSubmissionDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionInterfaceId;
  const  ::apache::airavata::model::appcatalog::computeresource::UnicoreJobSubmission* unicoreJobSubmission;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUnicoreJobSubmissionDetails_result__isset {
  _Airavata_updateUnicoreJobSubmissionDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUnicoreJobSubmissionDetails_result__isset;

class Airavata_updateUnicoreJobSubmissionDetails_result {
 public:

  Airavata_updateUnicoreJobSubmissionDetails_result(const Airavata_updateUnicoreJobSubmissionDetails_result&);
  Airavata_updateUnicoreJobSubmissionDetails_result& operator=(const Airavata_updateUnicoreJobSubmissionDetails_result&);
  Airavata_updateUnicoreJobSubmissionDetails_result() : success(0) {
  }

  virtual ~Airavata_updateUnicoreJobSubmissionDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUnicoreJobSubmissionDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateUnicoreJobSubmissionDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUnicoreJobSubmissionDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUnicoreJobSubmissionDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUnicoreJobSubmissionDetails_presult__isset {
  _Airavata_updateUnicoreJobSubmissionDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUnicoreJobSubmissionDetails_presult__isset;

class Airavata_updateUnicoreJobSubmissionDetails_presult {
 public:


  virtual ~Airavata_updateUnicoreJobSubmissionDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUnicoreJobSubmissionDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addLocalDataMovementDetails_args {
 public:

  Airavata_addLocalDataMovementDetails_args(const Airavata_addLocalDataMovementDetails_args&);
  Airavata_addLocalDataMovementDetails_args& operator=(const Airavata_addLocalDataMovementDetails_args&);
  Airavata_addLocalDataMovementDetails_args() : productUri(), dataMoveType(( ::apache::airavata::model::data::movement::DMType::type)0), priorityOrder(0) {
  }

  virtual ~Airavata_addLocalDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;
   ::apache::airavata::model::data::movement::DMType::type dataMoveType;
  int32_t priorityOrder;
   ::apache::airavata::model::data::movement::LOCALDataMovement localDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  void __set_dataMoveType(const  ::apache::airavata::model::data::movement::DMType::type val);

  void __set_priorityOrder(const int32_t val);

  void __set_localDataMovement(const  ::apache::airavata::model::data::movement::LOCALDataMovement& val);

  bool operator == (const Airavata_addLocalDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    if (!(dataMoveType == rhs.dataMoveType))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(localDataMovement == rhs.localDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_addLocalDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addLocalDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addLocalDataMovementDetails_pargs {
 public:


  virtual ~Airavata_addLocalDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;
  const  ::apache::airavata::model::data::movement::DMType::type* dataMoveType;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::data::movement::LOCALDataMovement* localDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addLocalDataMovementDetails_result__isset {
  _Airavata_addLocalDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addLocalDataMovementDetails_result__isset;

class Airavata_addLocalDataMovementDetails_result {
 public:

  Airavata_addLocalDataMovementDetails_result(const Airavata_addLocalDataMovementDetails_result&);
  Airavata_addLocalDataMovementDetails_result& operator=(const Airavata_addLocalDataMovementDetails_result&);
  Airavata_addLocalDataMovementDetails_result() : success() {
  }

  virtual ~Airavata_addLocalDataMovementDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addLocalDataMovementDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addLocalDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addLocalDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addLocalDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addLocalDataMovementDetails_presult__isset {
  _Airavata_addLocalDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addLocalDataMovementDetails_presult__isset;

class Airavata_addLocalDataMovementDetails_presult {
 public:


  virtual ~Airavata_addLocalDataMovementDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addLocalDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateLocalDataMovementDetails_args {
 public:

  Airavata_updateLocalDataMovementDetails_args(const Airavata_updateLocalDataMovementDetails_args&);
  Airavata_updateLocalDataMovementDetails_args& operator=(const Airavata_updateLocalDataMovementDetails_args&);
  Airavata_updateLocalDataMovementDetails_args() : dataMovementInterfaceId() {
  }

  virtual ~Airavata_updateLocalDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementInterfaceId;
   ::apache::airavata::model::data::movement::LOCALDataMovement localDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_localDataMovement(const  ::apache::airavata::model::data::movement::LOCALDataMovement& val);

  bool operator == (const Airavata_updateLocalDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(localDataMovement == rhs.localDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateLocalDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateLocalDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateLocalDataMovementDetails_pargs {
 public:


  virtual ~Airavata_updateLocalDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementInterfaceId;
  const  ::apache::airavata::model::data::movement::LOCALDataMovement* localDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateLocalDataMovementDetails_result__isset {
  _Airavata_updateLocalDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateLocalDataMovementDetails_result__isset;

class Airavata_updateLocalDataMovementDetails_result {
 public:

  Airavata_updateLocalDataMovementDetails_result(const Airavata_updateLocalDataMovementDetails_result&);
  Airavata_updateLocalDataMovementDetails_result& operator=(const Airavata_updateLocalDataMovementDetails_result&);
  Airavata_updateLocalDataMovementDetails_result() : success(0) {
  }

  virtual ~Airavata_updateLocalDataMovementDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateLocalDataMovementDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateLocalDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateLocalDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateLocalDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateLocalDataMovementDetails_presult__isset {
  _Airavata_updateLocalDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateLocalDataMovementDetails_presult__isset;

class Airavata_updateLocalDataMovementDetails_presult {
 public:


  virtual ~Airavata_updateLocalDataMovementDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateLocalDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getLocalDataMovement_args {
 public:

  Airavata_getLocalDataMovement_args(const Airavata_getLocalDataMovement_args&);
  Airavata_getLocalDataMovement_args& operator=(const Airavata_getLocalDataMovement_args&);
  Airavata_getLocalDataMovement_args() : dataMovementId() {
  }

  virtual ~Airavata_getLocalDataMovement_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementId(const std::string& val);

  bool operator == (const Airavata_getLocalDataMovement_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementId == rhs.dataMovementId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLocalDataMovement_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLocalDataMovement_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getLocalDataMovement_pargs {
 public:


  virtual ~Airavata_getLocalDataMovement_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLocalDataMovement_result__isset {
  _Airavata_getLocalDataMovement_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLocalDataMovement_result__isset;

class Airavata_getLocalDataMovement_result {
 public:

  Airavata_getLocalDataMovement_result(const Airavata_getLocalDataMovement_result&);
  Airavata_getLocalDataMovement_result& operator=(const Airavata_getLocalDataMovement_result&);
  Airavata_getLocalDataMovement_result() {
  }

  virtual ~Airavata_getLocalDataMovement_result() throw();
   ::apache::airavata::model::data::movement::LOCALDataMovement success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLocalDataMovement_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::movement::LOCALDataMovement& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getLocalDataMovement_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLocalDataMovement_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLocalDataMovement_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLocalDataMovement_presult__isset {
  _Airavata_getLocalDataMovement_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLocalDataMovement_presult__isset;

class Airavata_getLocalDataMovement_presult {
 public:


  virtual ~Airavata_getLocalDataMovement_presult() throw();
   ::apache::airavata::model::data::movement::LOCALDataMovement* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLocalDataMovement_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addSCPDataMovementDetails_args {
 public:

  Airavata_addSCPDataMovementDetails_args(const Airavata_addSCPDataMovementDetails_args&);
  Airavata_addSCPDataMovementDetails_args& operator=(const Airavata_addSCPDataMovementDetails_args&);
  Airavata_addSCPDataMovementDetails_args() : productUri(), dataMoveType(( ::apache::airavata::model::data::movement::DMType::type)0), priorityOrder(0) {
  }

  virtual ~Airavata_addSCPDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;
   ::apache::airavata::model::data::movement::DMType::type dataMoveType;
  int32_t priorityOrder;
   ::apache::airavata::model::data::movement::SCPDataMovement scpDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  void __set_dataMoveType(const  ::apache::airavata::model::data::movement::DMType::type val);

  void __set_priorityOrder(const int32_t val);

  void __set_scpDataMovement(const  ::apache::airavata::model::data::movement::SCPDataMovement& val);

  bool operator == (const Airavata_addSCPDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    if (!(dataMoveType == rhs.dataMoveType))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(scpDataMovement == rhs.scpDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSCPDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSCPDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addSCPDataMovementDetails_pargs {
 public:


  virtual ~Airavata_addSCPDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;
  const  ::apache::airavata::model::data::movement::DMType::type* dataMoveType;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::data::movement::SCPDataMovement* scpDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSCPDataMovementDetails_result__isset {
  _Airavata_addSCPDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSCPDataMovementDetails_result__isset;

class Airavata_addSCPDataMovementDetails_result {
 public:

  Airavata_addSCPDataMovementDetails_result(const Airavata_addSCPDataMovementDetails_result&);
  Airavata_addSCPDataMovementDetails_result& operator=(const Airavata_addSCPDataMovementDetails_result&);
  Airavata_addSCPDataMovementDetails_result() : success() {
  }

  virtual ~Airavata_addSCPDataMovementDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSCPDataMovementDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addSCPDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addSCPDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addSCPDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addSCPDataMovementDetails_presult__isset {
  _Airavata_addSCPDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addSCPDataMovementDetails_presult__isset;

class Airavata_addSCPDataMovementDetails_presult {
 public:


  virtual ~Airavata_addSCPDataMovementDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addSCPDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateSCPDataMovementDetails_args {
 public:

  Airavata_updateSCPDataMovementDetails_args(const Airavata_updateSCPDataMovementDetails_args&);
  Airavata_updateSCPDataMovementDetails_args& operator=(const Airavata_updateSCPDataMovementDetails_args&);
  Airavata_updateSCPDataMovementDetails_args() : dataMovementInterfaceId() {
  }

  virtual ~Airavata_updateSCPDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementInterfaceId;
   ::apache::airavata::model::data::movement::SCPDataMovement scpDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_scpDataMovement(const  ::apache::airavata::model::data::movement::SCPDataMovement& val);

  bool operator == (const Airavata_updateSCPDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(scpDataMovement == rhs.scpDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateSCPDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateSCPDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateSCPDataMovementDetails_pargs {
 public:


  virtual ~Airavata_updateSCPDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementInterfaceId;
  const  ::apache::airavata::model::data::movement::SCPDataMovement* scpDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateSCPDataMovementDetails_result__isset {
  _Airavata_updateSCPDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateSCPDataMovementDetails_result__isset;

class Airavata_updateSCPDataMovementDetails_result {
 public:

  Airavata_updateSCPDataMovementDetails_result(const Airavata_updateSCPDataMovementDetails_result&);
  Airavata_updateSCPDataMovementDetails_result& operator=(const Airavata_updateSCPDataMovementDetails_result&);
  Airavata_updateSCPDataMovementDetails_result() : success(0) {
  }

  virtual ~Airavata_updateSCPDataMovementDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateSCPDataMovementDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateSCPDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateSCPDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateSCPDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateSCPDataMovementDetails_presult__isset {
  _Airavata_updateSCPDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateSCPDataMovementDetails_presult__isset;

class Airavata_updateSCPDataMovementDetails_presult {
 public:


  virtual ~Airavata_updateSCPDataMovementDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateSCPDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getSCPDataMovement_args {
 public:

  Airavata_getSCPDataMovement_args(const Airavata_getSCPDataMovement_args&);
  Airavata_getSCPDataMovement_args& operator=(const Airavata_getSCPDataMovement_args&);
  Airavata_getSCPDataMovement_args() : dataMovementId() {
  }

  virtual ~Airavata_getSCPDataMovement_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementId(const std::string& val);

  bool operator == (const Airavata_getSCPDataMovement_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementId == rhs.dataMovementId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSCPDataMovement_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSCPDataMovement_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getSCPDataMovement_pargs {
 public:


  virtual ~Airavata_getSCPDataMovement_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSCPDataMovement_result__isset {
  _Airavata_getSCPDataMovement_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getSCPDataMovement_result__isset;

class Airavata_getSCPDataMovement_result {
 public:

  Airavata_getSCPDataMovement_result(const Airavata_getSCPDataMovement_result&);
  Airavata_getSCPDataMovement_result& operator=(const Airavata_getSCPDataMovement_result&);
  Airavata_getSCPDataMovement_result() {
  }

  virtual ~Airavata_getSCPDataMovement_result() throw();
   ::apache::airavata::model::data::movement::SCPDataMovement success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getSCPDataMovement_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::movement::SCPDataMovement& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getSCPDataMovement_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getSCPDataMovement_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getSCPDataMovement_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getSCPDataMovement_presult__isset {
  _Airavata_getSCPDataMovement_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getSCPDataMovement_presult__isset;

class Airavata_getSCPDataMovement_presult {
 public:


  virtual ~Airavata_getSCPDataMovement_presult() throw();
   ::apache::airavata::model::data::movement::SCPDataMovement* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getSCPDataMovement_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addUnicoreDataMovementDetails_args {
 public:

  Airavata_addUnicoreDataMovementDetails_args(const Airavata_addUnicoreDataMovementDetails_args&);
  Airavata_addUnicoreDataMovementDetails_args& operator=(const Airavata_addUnicoreDataMovementDetails_args&);
  Airavata_addUnicoreDataMovementDetails_args() : productUri(), dataMoveType(( ::apache::airavata::model::data::movement::DMType::type)0), priorityOrder(0) {
  }

  virtual ~Airavata_addUnicoreDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;
   ::apache::airavata::model::data::movement::DMType::type dataMoveType;
  int32_t priorityOrder;
   ::apache::airavata::model::data::movement::UnicoreDataMovement unicoreDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  void __set_dataMoveType(const  ::apache::airavata::model::data::movement::DMType::type val);

  void __set_priorityOrder(const int32_t val);

  void __set_unicoreDataMovement(const  ::apache::airavata::model::data::movement::UnicoreDataMovement& val);

  bool operator == (const Airavata_addUnicoreDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    if (!(dataMoveType == rhs.dataMoveType))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(unicoreDataMovement == rhs.unicoreDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUnicoreDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUnicoreDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addUnicoreDataMovementDetails_pargs {
 public:


  virtual ~Airavata_addUnicoreDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;
  const  ::apache::airavata::model::data::movement::DMType::type* dataMoveType;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::data::movement::UnicoreDataMovement* unicoreDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUnicoreDataMovementDetails_result__isset {
  _Airavata_addUnicoreDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUnicoreDataMovementDetails_result__isset;

class Airavata_addUnicoreDataMovementDetails_result {
 public:

  Airavata_addUnicoreDataMovementDetails_result(const Airavata_addUnicoreDataMovementDetails_result&);
  Airavata_addUnicoreDataMovementDetails_result& operator=(const Airavata_addUnicoreDataMovementDetails_result&);
  Airavata_addUnicoreDataMovementDetails_result() : success() {
  }

  virtual ~Airavata_addUnicoreDataMovementDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUnicoreDataMovementDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addUnicoreDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUnicoreDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUnicoreDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUnicoreDataMovementDetails_presult__isset {
  _Airavata_addUnicoreDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUnicoreDataMovementDetails_presult__isset;

class Airavata_addUnicoreDataMovementDetails_presult {
 public:


  virtual ~Airavata_addUnicoreDataMovementDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUnicoreDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateUnicoreDataMovementDetails_args {
 public:

  Airavata_updateUnicoreDataMovementDetails_args(const Airavata_updateUnicoreDataMovementDetails_args&);
  Airavata_updateUnicoreDataMovementDetails_args& operator=(const Airavata_updateUnicoreDataMovementDetails_args&);
  Airavata_updateUnicoreDataMovementDetails_args() : dataMovementInterfaceId() {
  }

  virtual ~Airavata_updateUnicoreDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementInterfaceId;
   ::apache::airavata::model::data::movement::UnicoreDataMovement unicoreDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_unicoreDataMovement(const  ::apache::airavata::model::data::movement::UnicoreDataMovement& val);

  bool operator == (const Airavata_updateUnicoreDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(unicoreDataMovement == rhs.unicoreDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUnicoreDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUnicoreDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateUnicoreDataMovementDetails_pargs {
 public:


  virtual ~Airavata_updateUnicoreDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementInterfaceId;
  const  ::apache::airavata::model::data::movement::UnicoreDataMovement* unicoreDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUnicoreDataMovementDetails_result__isset {
  _Airavata_updateUnicoreDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUnicoreDataMovementDetails_result__isset;

class Airavata_updateUnicoreDataMovementDetails_result {
 public:

  Airavata_updateUnicoreDataMovementDetails_result(const Airavata_updateUnicoreDataMovementDetails_result&);
  Airavata_updateUnicoreDataMovementDetails_result& operator=(const Airavata_updateUnicoreDataMovementDetails_result&);
  Airavata_updateUnicoreDataMovementDetails_result() : success(0) {
  }

  virtual ~Airavata_updateUnicoreDataMovementDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUnicoreDataMovementDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateUnicoreDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUnicoreDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUnicoreDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUnicoreDataMovementDetails_presult__isset {
  _Airavata_updateUnicoreDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUnicoreDataMovementDetails_presult__isset;

class Airavata_updateUnicoreDataMovementDetails_presult {
 public:


  virtual ~Airavata_updateUnicoreDataMovementDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUnicoreDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUnicoreDataMovement_args {
 public:

  Airavata_getUnicoreDataMovement_args(const Airavata_getUnicoreDataMovement_args&);
  Airavata_getUnicoreDataMovement_args& operator=(const Airavata_getUnicoreDataMovement_args&);
  Airavata_getUnicoreDataMovement_args() : dataMovementId() {
  }

  virtual ~Airavata_getUnicoreDataMovement_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementId(const std::string& val);

  bool operator == (const Airavata_getUnicoreDataMovement_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementId == rhs.dataMovementId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUnicoreDataMovement_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUnicoreDataMovement_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUnicoreDataMovement_pargs {
 public:


  virtual ~Airavata_getUnicoreDataMovement_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUnicoreDataMovement_result__isset {
  _Airavata_getUnicoreDataMovement_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUnicoreDataMovement_result__isset;

class Airavata_getUnicoreDataMovement_result {
 public:

  Airavata_getUnicoreDataMovement_result(const Airavata_getUnicoreDataMovement_result&);
  Airavata_getUnicoreDataMovement_result& operator=(const Airavata_getUnicoreDataMovement_result&);
  Airavata_getUnicoreDataMovement_result() {
  }

  virtual ~Airavata_getUnicoreDataMovement_result() throw();
   ::apache::airavata::model::data::movement::UnicoreDataMovement success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUnicoreDataMovement_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::movement::UnicoreDataMovement& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUnicoreDataMovement_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUnicoreDataMovement_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUnicoreDataMovement_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUnicoreDataMovement_presult__isset {
  _Airavata_getUnicoreDataMovement_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUnicoreDataMovement_presult__isset;

class Airavata_getUnicoreDataMovement_presult {
 public:


  virtual ~Airavata_getUnicoreDataMovement_presult() throw();
   ::apache::airavata::model::data::movement::UnicoreDataMovement* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUnicoreDataMovement_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addGridFTPDataMovementDetails_args {
 public:

  Airavata_addGridFTPDataMovementDetails_args(const Airavata_addGridFTPDataMovementDetails_args&);
  Airavata_addGridFTPDataMovementDetails_args& operator=(const Airavata_addGridFTPDataMovementDetails_args&);
  Airavata_addGridFTPDataMovementDetails_args() : productUri(), dataMoveType(( ::apache::airavata::model::data::movement::DMType::type)0), priorityOrder(0) {
  }

  virtual ~Airavata_addGridFTPDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;
   ::apache::airavata::model::data::movement::DMType::type dataMoveType;
  int32_t priorityOrder;
   ::apache::airavata::model::data::movement::GridFTPDataMovement gridFTPDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  void __set_dataMoveType(const  ::apache::airavata::model::data::movement::DMType::type val);

  void __set_priorityOrder(const int32_t val);

  void __set_gridFTPDataMovement(const  ::apache::airavata::model::data::movement::GridFTPDataMovement& val);

  bool operator == (const Airavata_addGridFTPDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    if (!(dataMoveType == rhs.dataMoveType))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    if (!(gridFTPDataMovement == rhs.gridFTPDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGridFTPDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGridFTPDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addGridFTPDataMovementDetails_pargs {
 public:


  virtual ~Airavata_addGridFTPDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;
  const  ::apache::airavata::model::data::movement::DMType::type* dataMoveType;
  const int32_t* priorityOrder;
  const  ::apache::airavata::model::data::movement::GridFTPDataMovement* gridFTPDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGridFTPDataMovementDetails_result__isset {
  _Airavata_addGridFTPDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGridFTPDataMovementDetails_result__isset;

class Airavata_addGridFTPDataMovementDetails_result {
 public:

  Airavata_addGridFTPDataMovementDetails_result(const Airavata_addGridFTPDataMovementDetails_result&);
  Airavata_addGridFTPDataMovementDetails_result& operator=(const Airavata_addGridFTPDataMovementDetails_result&);
  Airavata_addGridFTPDataMovementDetails_result() : success() {
  }

  virtual ~Airavata_addGridFTPDataMovementDetails_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGridFTPDataMovementDetails_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addGridFTPDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGridFTPDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGridFTPDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGridFTPDataMovementDetails_presult__isset {
  _Airavata_addGridFTPDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGridFTPDataMovementDetails_presult__isset;

class Airavata_addGridFTPDataMovementDetails_presult {
 public:


  virtual ~Airavata_addGridFTPDataMovementDetails_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGridFTPDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGridFTPDataMovementDetails_args {
 public:

  Airavata_updateGridFTPDataMovementDetails_args(const Airavata_updateGridFTPDataMovementDetails_args&);
  Airavata_updateGridFTPDataMovementDetails_args& operator=(const Airavata_updateGridFTPDataMovementDetails_args&);
  Airavata_updateGridFTPDataMovementDetails_args() : dataMovementInterfaceId() {
  }

  virtual ~Airavata_updateGridFTPDataMovementDetails_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementInterfaceId;
   ::apache::airavata::model::data::movement::GridFTPDataMovement gridFTPDataMovement;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_gridFTPDataMovement(const  ::apache::airavata::model::data::movement::GridFTPDataMovement& val);

  bool operator == (const Airavata_updateGridFTPDataMovementDetails_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(gridFTPDataMovement == rhs.gridFTPDataMovement))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGridFTPDataMovementDetails_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGridFTPDataMovementDetails_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGridFTPDataMovementDetails_pargs {
 public:


  virtual ~Airavata_updateGridFTPDataMovementDetails_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementInterfaceId;
  const  ::apache::airavata::model::data::movement::GridFTPDataMovement* gridFTPDataMovement;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGridFTPDataMovementDetails_result__isset {
  _Airavata_updateGridFTPDataMovementDetails_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGridFTPDataMovementDetails_result__isset;

class Airavata_updateGridFTPDataMovementDetails_result {
 public:

  Airavata_updateGridFTPDataMovementDetails_result(const Airavata_updateGridFTPDataMovementDetails_result&);
  Airavata_updateGridFTPDataMovementDetails_result& operator=(const Airavata_updateGridFTPDataMovementDetails_result&);
  Airavata_updateGridFTPDataMovementDetails_result() : success(0) {
  }

  virtual ~Airavata_updateGridFTPDataMovementDetails_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGridFTPDataMovementDetails_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGridFTPDataMovementDetails_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGridFTPDataMovementDetails_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGridFTPDataMovementDetails_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGridFTPDataMovementDetails_presult__isset {
  _Airavata_updateGridFTPDataMovementDetails_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGridFTPDataMovementDetails_presult__isset;

class Airavata_updateGridFTPDataMovementDetails_presult {
 public:


  virtual ~Airavata_updateGridFTPDataMovementDetails_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGridFTPDataMovementDetails_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGridFTPDataMovement_args {
 public:

  Airavata_getGridFTPDataMovement_args(const Airavata_getGridFTPDataMovement_args&);
  Airavata_getGridFTPDataMovement_args& operator=(const Airavata_getGridFTPDataMovement_args&);
  Airavata_getGridFTPDataMovement_args() : dataMovementId() {
  }

  virtual ~Airavata_getGridFTPDataMovement_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementId(const std::string& val);

  bool operator == (const Airavata_getGridFTPDataMovement_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementId == rhs.dataMovementId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGridFTPDataMovement_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGridFTPDataMovement_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGridFTPDataMovement_pargs {
 public:


  virtual ~Airavata_getGridFTPDataMovement_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGridFTPDataMovement_result__isset {
  _Airavata_getGridFTPDataMovement_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGridFTPDataMovement_result__isset;

class Airavata_getGridFTPDataMovement_result {
 public:

  Airavata_getGridFTPDataMovement_result(const Airavata_getGridFTPDataMovement_result&);
  Airavata_getGridFTPDataMovement_result& operator=(const Airavata_getGridFTPDataMovement_result&);
  Airavata_getGridFTPDataMovement_result() {
  }

  virtual ~Airavata_getGridFTPDataMovement_result() throw();
   ::apache::airavata::model::data::movement::GridFTPDataMovement success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGridFTPDataMovement_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::movement::GridFTPDataMovement& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGridFTPDataMovement_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGridFTPDataMovement_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGridFTPDataMovement_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGridFTPDataMovement_presult__isset {
  _Airavata_getGridFTPDataMovement_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGridFTPDataMovement_presult__isset;

class Airavata_getGridFTPDataMovement_presult {
 public:


  virtual ~Airavata_getGridFTPDataMovement_presult() throw();
   ::apache::airavata::model::data::movement::GridFTPDataMovement* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGridFTPDataMovement_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_changeJobSubmissionPriority_args {
 public:

  Airavata_changeJobSubmissionPriority_args(const Airavata_changeJobSubmissionPriority_args&);
  Airavata_changeJobSubmissionPriority_args& operator=(const Airavata_changeJobSubmissionPriority_args&);
  Airavata_changeJobSubmissionPriority_args() : jobSubmissionInterfaceId(), newPriorityOrder(0) {
  }

  virtual ~Airavata_changeJobSubmissionPriority_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string jobSubmissionInterfaceId;
  int32_t newPriorityOrder;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  void __set_newPriorityOrder(const int32_t val);

  bool operator == (const Airavata_changeJobSubmissionPriority_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(newPriorityOrder == rhs.newPriorityOrder))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeJobSubmissionPriority_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeJobSubmissionPriority_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_changeJobSubmissionPriority_pargs {
 public:


  virtual ~Airavata_changeJobSubmissionPriority_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* jobSubmissionInterfaceId;
  const int32_t* newPriorityOrder;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeJobSubmissionPriority_result__isset {
  _Airavata_changeJobSubmissionPriority_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeJobSubmissionPriority_result__isset;

class Airavata_changeJobSubmissionPriority_result {
 public:

  Airavata_changeJobSubmissionPriority_result(const Airavata_changeJobSubmissionPriority_result&);
  Airavata_changeJobSubmissionPriority_result& operator=(const Airavata_changeJobSubmissionPriority_result&);
  Airavata_changeJobSubmissionPriority_result() : success(0) {
  }

  virtual ~Airavata_changeJobSubmissionPriority_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeJobSubmissionPriority_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_changeJobSubmissionPriority_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeJobSubmissionPriority_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeJobSubmissionPriority_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeJobSubmissionPriority_presult__isset {
  _Airavata_changeJobSubmissionPriority_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeJobSubmissionPriority_presult__isset;

class Airavata_changeJobSubmissionPriority_presult {
 public:


  virtual ~Airavata_changeJobSubmissionPriority_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeJobSubmissionPriority_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_changeDataMovementPriority_args {
 public:

  Airavata_changeDataMovementPriority_args(const Airavata_changeDataMovementPriority_args&);
  Airavata_changeDataMovementPriority_args& operator=(const Airavata_changeDataMovementPriority_args&);
  Airavata_changeDataMovementPriority_args() : dataMovementInterfaceId(), newPriorityOrder(0) {
  }

  virtual ~Airavata_changeDataMovementPriority_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataMovementInterfaceId;
  int32_t newPriorityOrder;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_newPriorityOrder(const int32_t val);

  bool operator == (const Airavata_changeDataMovementPriority_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(newPriorityOrder == rhs.newPriorityOrder))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeDataMovementPriority_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeDataMovementPriority_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_changeDataMovementPriority_pargs {
 public:


  virtual ~Airavata_changeDataMovementPriority_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataMovementInterfaceId;
  const int32_t* newPriorityOrder;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeDataMovementPriority_result__isset {
  _Airavata_changeDataMovementPriority_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeDataMovementPriority_result__isset;

class Airavata_changeDataMovementPriority_result {
 public:

  Airavata_changeDataMovementPriority_result(const Airavata_changeDataMovementPriority_result&);
  Airavata_changeDataMovementPriority_result& operator=(const Airavata_changeDataMovementPriority_result&);
  Airavata_changeDataMovementPriority_result() : success(0) {
  }

  virtual ~Airavata_changeDataMovementPriority_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeDataMovementPriority_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_changeDataMovementPriority_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeDataMovementPriority_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeDataMovementPriority_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeDataMovementPriority_presult__isset {
  _Airavata_changeDataMovementPriority_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeDataMovementPriority_presult__isset;

class Airavata_changeDataMovementPriority_presult {
 public:


  virtual ~Airavata_changeDataMovementPriority_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeDataMovementPriority_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_changeJobSubmissionPriorities_args {
 public:

  Airavata_changeJobSubmissionPriorities_args(const Airavata_changeJobSubmissionPriorities_args&);
  Airavata_changeJobSubmissionPriorities_args& operator=(const Airavata_changeJobSubmissionPriorities_args&);
  Airavata_changeJobSubmissionPriorities_args() {
  }

  virtual ~Airavata_changeJobSubmissionPriorities_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::map<std::string, int32_t>  jobSubmissionPriorityMap;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_jobSubmissionPriorityMap(const std::map<std::string, int32_t> & val);

  bool operator == (const Airavata_changeJobSubmissionPriorities_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(jobSubmissionPriorityMap == rhs.jobSubmissionPriorityMap))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeJobSubmissionPriorities_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeJobSubmissionPriorities_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_changeJobSubmissionPriorities_pargs {
 public:


  virtual ~Airavata_changeJobSubmissionPriorities_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::map<std::string, int32_t> * jobSubmissionPriorityMap;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeJobSubmissionPriorities_result__isset {
  _Airavata_changeJobSubmissionPriorities_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeJobSubmissionPriorities_result__isset;

class Airavata_changeJobSubmissionPriorities_result {
 public:

  Airavata_changeJobSubmissionPriorities_result(const Airavata_changeJobSubmissionPriorities_result&);
  Airavata_changeJobSubmissionPriorities_result& operator=(const Airavata_changeJobSubmissionPriorities_result&);
  Airavata_changeJobSubmissionPriorities_result() : success(0) {
  }

  virtual ~Airavata_changeJobSubmissionPriorities_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeJobSubmissionPriorities_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_changeJobSubmissionPriorities_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeJobSubmissionPriorities_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeJobSubmissionPriorities_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeJobSubmissionPriorities_presult__isset {
  _Airavata_changeJobSubmissionPriorities_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeJobSubmissionPriorities_presult__isset;

class Airavata_changeJobSubmissionPriorities_presult {
 public:


  virtual ~Airavata_changeJobSubmissionPriorities_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeJobSubmissionPriorities_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_changeDataMovementPriorities_args {
 public:

  Airavata_changeDataMovementPriorities_args(const Airavata_changeDataMovementPriorities_args&);
  Airavata_changeDataMovementPriorities_args& operator=(const Airavata_changeDataMovementPriorities_args&);
  Airavata_changeDataMovementPriorities_args() {
  }

  virtual ~Airavata_changeDataMovementPriorities_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::map<std::string, int32_t>  dataMovementPriorityMap;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataMovementPriorityMap(const std::map<std::string, int32_t> & val);

  bool operator == (const Airavata_changeDataMovementPriorities_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataMovementPriorityMap == rhs.dataMovementPriorityMap))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeDataMovementPriorities_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeDataMovementPriorities_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_changeDataMovementPriorities_pargs {
 public:


  virtual ~Airavata_changeDataMovementPriorities_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::map<std::string, int32_t> * dataMovementPriorityMap;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeDataMovementPriorities_result__isset {
  _Airavata_changeDataMovementPriorities_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeDataMovementPriorities_result__isset;

class Airavata_changeDataMovementPriorities_result {
 public:

  Airavata_changeDataMovementPriorities_result(const Airavata_changeDataMovementPriorities_result&);
  Airavata_changeDataMovementPriorities_result& operator=(const Airavata_changeDataMovementPriorities_result&);
  Airavata_changeDataMovementPriorities_result() : success(0) {
  }

  virtual ~Airavata_changeDataMovementPriorities_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeDataMovementPriorities_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_changeDataMovementPriorities_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_changeDataMovementPriorities_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_changeDataMovementPriorities_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_changeDataMovementPriorities_presult__isset {
  _Airavata_changeDataMovementPriorities_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_changeDataMovementPriorities_presult__isset;

class Airavata_changeDataMovementPriorities_presult {
 public:


  virtual ~Airavata_changeDataMovementPriorities_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_changeDataMovementPriorities_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteJobSubmissionInterface_args {
 public:

  Airavata_deleteJobSubmissionInterface_args(const Airavata_deleteJobSubmissionInterface_args&);
  Airavata_deleteJobSubmissionInterface_args& operator=(const Airavata_deleteJobSubmissionInterface_args&);
  Airavata_deleteJobSubmissionInterface_args() : computeResourceId(), jobSubmissionInterfaceId() {
  }

  virtual ~Airavata_deleteJobSubmissionInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  std::string jobSubmissionInterfaceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_jobSubmissionInterfaceId(const std::string& val);

  bool operator == (const Airavata_deleteJobSubmissionInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteJobSubmissionInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteJobSubmissionInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteJobSubmissionInterface_pargs {
 public:


  virtual ~Airavata_deleteJobSubmissionInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const std::string* jobSubmissionInterfaceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteJobSubmissionInterface_result__isset {
  _Airavata_deleteJobSubmissionInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteJobSubmissionInterface_result__isset;

class Airavata_deleteJobSubmissionInterface_result {
 public:

  Airavata_deleteJobSubmissionInterface_result(const Airavata_deleteJobSubmissionInterface_result&);
  Airavata_deleteJobSubmissionInterface_result& operator=(const Airavata_deleteJobSubmissionInterface_result&);
  Airavata_deleteJobSubmissionInterface_result() : success(0) {
  }

  virtual ~Airavata_deleteJobSubmissionInterface_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteJobSubmissionInterface_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteJobSubmissionInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteJobSubmissionInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteJobSubmissionInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteJobSubmissionInterface_presult__isset {
  _Airavata_deleteJobSubmissionInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteJobSubmissionInterface_presult__isset;

class Airavata_deleteJobSubmissionInterface_presult {
 public:


  virtual ~Airavata_deleteJobSubmissionInterface_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteJobSubmissionInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteDataMovementInterface_args {
 public:

  Airavata_deleteDataMovementInterface_args(const Airavata_deleteDataMovementInterface_args&);
  Airavata_deleteDataMovementInterface_args& operator=(const Airavata_deleteDataMovementInterface_args&);
  Airavata_deleteDataMovementInterface_args() : productUri(), dataMovementInterfaceId(), dataMoveType(( ::apache::airavata::model::data::movement::DMType::type)0) {
  }

  virtual ~Airavata_deleteDataMovementInterface_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;
  std::string dataMovementInterfaceId;
   ::apache::airavata::model::data::movement::DMType::type dataMoveType;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  void __set_dataMovementInterfaceId(const std::string& val);

  void __set_dataMoveType(const  ::apache::airavata::model::data::movement::DMType::type val);

  bool operator == (const Airavata_deleteDataMovementInterface_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(dataMoveType == rhs.dataMoveType))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteDataMovementInterface_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteDataMovementInterface_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteDataMovementInterface_pargs {
 public:


  virtual ~Airavata_deleteDataMovementInterface_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;
  const std::string* dataMovementInterfaceId;
  const  ::apache::airavata::model::data::movement::DMType::type* dataMoveType;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteDataMovementInterface_result__isset {
  _Airavata_deleteDataMovementInterface_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteDataMovementInterface_result__isset;

class Airavata_deleteDataMovementInterface_result {
 public:

  Airavata_deleteDataMovementInterface_result(const Airavata_deleteDataMovementInterface_result&);
  Airavata_deleteDataMovementInterface_result& operator=(const Airavata_deleteDataMovementInterface_result&);
  Airavata_deleteDataMovementInterface_result() : success(0) {
  }

  virtual ~Airavata_deleteDataMovementInterface_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteDataMovementInterface_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteDataMovementInterface_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteDataMovementInterface_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteDataMovementInterface_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteDataMovementInterface_presult__isset {
  _Airavata_deleteDataMovementInterface_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteDataMovementInterface_presult__isset;

class Airavata_deleteDataMovementInterface_presult {
 public:


  virtual ~Airavata_deleteDataMovementInterface_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteDataMovementInterface_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerResourceJobManager_args {
 public:

  Airavata_registerResourceJobManager_args(const Airavata_registerResourceJobManager_args&);
  Airavata_registerResourceJobManager_args& operator=(const Airavata_registerResourceJobManager_args&);
  Airavata_registerResourceJobManager_args() {
  }

  virtual ~Airavata_registerResourceJobManager_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager resourceJobManager;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceJobManager(const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& val);

  bool operator == (const Airavata_registerResourceJobManager_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceJobManager == rhs.resourceJobManager))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerResourceJobManager_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerResourceJobManager_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerResourceJobManager_pargs {
 public:


  virtual ~Airavata_registerResourceJobManager_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager* resourceJobManager;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerResourceJobManager_result__isset {
  _Airavata_registerResourceJobManager_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerResourceJobManager_result__isset;

class Airavata_registerResourceJobManager_result {
 public:

  Airavata_registerResourceJobManager_result(const Airavata_registerResourceJobManager_result&);
  Airavata_registerResourceJobManager_result& operator=(const Airavata_registerResourceJobManager_result&);
  Airavata_registerResourceJobManager_result() : success() {
  }

  virtual ~Airavata_registerResourceJobManager_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerResourceJobManager_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerResourceJobManager_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerResourceJobManager_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerResourceJobManager_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerResourceJobManager_presult__isset {
  _Airavata_registerResourceJobManager_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerResourceJobManager_presult__isset;

class Airavata_registerResourceJobManager_presult {
 public:


  virtual ~Airavata_registerResourceJobManager_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerResourceJobManager_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateResourceJobManager_args {
 public:

  Airavata_updateResourceJobManager_args(const Airavata_updateResourceJobManager_args&);
  Airavata_updateResourceJobManager_args& operator=(const Airavata_updateResourceJobManager_args&);
  Airavata_updateResourceJobManager_args() : resourceJobManagerId() {
  }

  virtual ~Airavata_updateResourceJobManager_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceJobManagerId;
   ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager updatedResourceJobManager;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceJobManagerId(const std::string& val);

  void __set_updatedResourceJobManager(const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& val);

  bool operator == (const Airavata_updateResourceJobManager_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceJobManagerId == rhs.resourceJobManagerId))
      return false;
    if (!(updatedResourceJobManager == rhs.updatedResourceJobManager))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateResourceJobManager_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateResourceJobManager_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateResourceJobManager_pargs {
 public:


  virtual ~Airavata_updateResourceJobManager_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceJobManagerId;
  const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager* updatedResourceJobManager;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateResourceJobManager_result__isset {
  _Airavata_updateResourceJobManager_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateResourceJobManager_result__isset;

class Airavata_updateResourceJobManager_result {
 public:

  Airavata_updateResourceJobManager_result(const Airavata_updateResourceJobManager_result&);
  Airavata_updateResourceJobManager_result& operator=(const Airavata_updateResourceJobManager_result&);
  Airavata_updateResourceJobManager_result() : success(0) {
  }

  virtual ~Airavata_updateResourceJobManager_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateResourceJobManager_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateResourceJobManager_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateResourceJobManager_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateResourceJobManager_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateResourceJobManager_presult__isset {
  _Airavata_updateResourceJobManager_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateResourceJobManager_presult__isset;

class Airavata_updateResourceJobManager_presult {
 public:


  virtual ~Airavata_updateResourceJobManager_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateResourceJobManager_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getResourceJobManager_args {
 public:

  Airavata_getResourceJobManager_args(const Airavata_getResourceJobManager_args&);
  Airavata_getResourceJobManager_args& operator=(const Airavata_getResourceJobManager_args&);
  Airavata_getResourceJobManager_args() : resourceJobManagerId() {
  }

  virtual ~Airavata_getResourceJobManager_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceJobManagerId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceJobManagerId(const std::string& val);

  bool operator == (const Airavata_getResourceJobManager_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceJobManagerId == rhs.resourceJobManagerId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getResourceJobManager_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getResourceJobManager_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getResourceJobManager_pargs {
 public:


  virtual ~Airavata_getResourceJobManager_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceJobManagerId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getResourceJobManager_result__isset {
  _Airavata_getResourceJobManager_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getResourceJobManager_result__isset;

class Airavata_getResourceJobManager_result {
 public:

  Airavata_getResourceJobManager_result(const Airavata_getResourceJobManager_result&);
  Airavata_getResourceJobManager_result& operator=(const Airavata_getResourceJobManager_result&);
  Airavata_getResourceJobManager_result() {
  }

  virtual ~Airavata_getResourceJobManager_result() throw();
   ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getResourceJobManager_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getResourceJobManager_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getResourceJobManager_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getResourceJobManager_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getResourceJobManager_presult__isset {
  _Airavata_getResourceJobManager_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getResourceJobManager_presult__isset;

class Airavata_getResourceJobManager_presult {
 public:


  virtual ~Airavata_getResourceJobManager_presult() throw();
   ::apache::airavata::model::appcatalog::computeresource::ResourceJobManager* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getResourceJobManager_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteResourceJobManager_args {
 public:

  Airavata_deleteResourceJobManager_args(const Airavata_deleteResourceJobManager_args&);
  Airavata_deleteResourceJobManager_args& operator=(const Airavata_deleteResourceJobManager_args&);
  Airavata_deleteResourceJobManager_args() : resourceJobManagerId() {
  }

  virtual ~Airavata_deleteResourceJobManager_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceJobManagerId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceJobManagerId(const std::string& val);

  bool operator == (const Airavata_deleteResourceJobManager_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceJobManagerId == rhs.resourceJobManagerId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteResourceJobManager_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteResourceJobManager_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteResourceJobManager_pargs {
 public:


  virtual ~Airavata_deleteResourceJobManager_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceJobManagerId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteResourceJobManager_result__isset {
  _Airavata_deleteResourceJobManager_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteResourceJobManager_result__isset;

class Airavata_deleteResourceJobManager_result {
 public:

  Airavata_deleteResourceJobManager_result(const Airavata_deleteResourceJobManager_result&);
  Airavata_deleteResourceJobManager_result& operator=(const Airavata_deleteResourceJobManager_result&);
  Airavata_deleteResourceJobManager_result() : success(0) {
  }

  virtual ~Airavata_deleteResourceJobManager_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteResourceJobManager_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteResourceJobManager_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteResourceJobManager_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteResourceJobManager_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteResourceJobManager_presult__isset {
  _Airavata_deleteResourceJobManager_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteResourceJobManager_presult__isset;

class Airavata_deleteResourceJobManager_presult {
 public:


  virtual ~Airavata_deleteResourceJobManager_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteResourceJobManager_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteBatchQueue_args {
 public:

  Airavata_deleteBatchQueue_args(const Airavata_deleteBatchQueue_args&);
  Airavata_deleteBatchQueue_args& operator=(const Airavata_deleteBatchQueue_args&);
  Airavata_deleteBatchQueue_args() : computeResourceId(), queueName() {
  }

  virtual ~Airavata_deleteBatchQueue_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string computeResourceId;
  std::string queueName;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_computeResourceId(const std::string& val);

  void __set_queueName(const std::string& val);

  bool operator == (const Airavata_deleteBatchQueue_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(queueName == rhs.queueName))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteBatchQueue_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteBatchQueue_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteBatchQueue_pargs {
 public:


  virtual ~Airavata_deleteBatchQueue_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* computeResourceId;
  const std::string* queueName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteBatchQueue_result__isset {
  _Airavata_deleteBatchQueue_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteBatchQueue_result__isset;

class Airavata_deleteBatchQueue_result {
 public:

  Airavata_deleteBatchQueue_result(const Airavata_deleteBatchQueue_result&);
  Airavata_deleteBatchQueue_result& operator=(const Airavata_deleteBatchQueue_result&);
  Airavata_deleteBatchQueue_result() : success(0) {
  }

  virtual ~Airavata_deleteBatchQueue_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteBatchQueue_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteBatchQueue_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteBatchQueue_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteBatchQueue_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteBatchQueue_presult__isset {
  _Airavata_deleteBatchQueue_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteBatchQueue_presult__isset;

class Airavata_deleteBatchQueue_presult {
 public:


  virtual ~Airavata_deleteBatchQueue_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteBatchQueue_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerGatewayResourceProfile_args {
 public:

  Airavata_registerGatewayResourceProfile_args(const Airavata_registerGatewayResourceProfile_args&);
  Airavata_registerGatewayResourceProfile_args& operator=(const Airavata_registerGatewayResourceProfile_args&);
  Airavata_registerGatewayResourceProfile_args() {
  }

  virtual ~Airavata_registerGatewayResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile gatewayResourceProfile;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayResourceProfile(const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& val);

  bool operator == (const Airavata_registerGatewayResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayResourceProfile == rhs.gatewayResourceProfile))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerGatewayResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerGatewayResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerGatewayResourceProfile_pargs {
 public:


  virtual ~Airavata_registerGatewayResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile* gatewayResourceProfile;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerGatewayResourceProfile_result__isset {
  _Airavata_registerGatewayResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerGatewayResourceProfile_result__isset;

class Airavata_registerGatewayResourceProfile_result {
 public:

  Airavata_registerGatewayResourceProfile_result(const Airavata_registerGatewayResourceProfile_result&);
  Airavata_registerGatewayResourceProfile_result& operator=(const Airavata_registerGatewayResourceProfile_result&);
  Airavata_registerGatewayResourceProfile_result() : success() {
  }

  virtual ~Airavata_registerGatewayResourceProfile_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerGatewayResourceProfile_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerGatewayResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerGatewayResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerGatewayResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerGatewayResourceProfile_presult__isset {
  _Airavata_registerGatewayResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerGatewayResourceProfile_presult__isset;

class Airavata_registerGatewayResourceProfile_presult {
 public:


  virtual ~Airavata_registerGatewayResourceProfile_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerGatewayResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGatewayResourceProfile_args {
 public:

  Airavata_getGatewayResourceProfile_args(const Airavata_getGatewayResourceProfile_args&);
  Airavata_getGatewayResourceProfile_args& operator=(const Airavata_getGatewayResourceProfile_args&);
  Airavata_getGatewayResourceProfile_args() : gatewayID() {
  }

  virtual ~Airavata_getGatewayResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getGatewayResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGatewayResourceProfile_pargs {
 public:


  virtual ~Airavata_getGatewayResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayResourceProfile_result__isset {
  _Airavata_getGatewayResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayResourceProfile_result__isset;

class Airavata_getGatewayResourceProfile_result {
 public:

  Airavata_getGatewayResourceProfile_result(const Airavata_getGatewayResourceProfile_result&);
  Airavata_getGatewayResourceProfile_result& operator=(const Airavata_getGatewayResourceProfile_result&);
  Airavata_getGatewayResourceProfile_result() {
  }

  virtual ~Airavata_getGatewayResourceProfile_result() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayResourceProfile_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGatewayResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayResourceProfile_presult__isset {
  _Airavata_getGatewayResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayResourceProfile_presult__isset;

class Airavata_getGatewayResourceProfile_presult {
 public:


  virtual ~Airavata_getGatewayResourceProfile_presult() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGatewayResourceProfile_args {
 public:

  Airavata_updateGatewayResourceProfile_args(const Airavata_updateGatewayResourceProfile_args&);
  Airavata_updateGatewayResourceProfile_args& operator=(const Airavata_updateGatewayResourceProfile_args&);
  Airavata_updateGatewayResourceProfile_args() : gatewayID() {
  }

  virtual ~Airavata_updateGatewayResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
   ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile gatewayResourceProfile;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_gatewayResourceProfile(const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile& val);

  bool operator == (const Airavata_updateGatewayResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(gatewayResourceProfile == rhs.gatewayResourceProfile))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGatewayResourceProfile_pargs {
 public:


  virtual ~Airavata_updateGatewayResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile* gatewayResourceProfile;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayResourceProfile_result__isset {
  _Airavata_updateGatewayResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayResourceProfile_result__isset;

class Airavata_updateGatewayResourceProfile_result {
 public:

  Airavata_updateGatewayResourceProfile_result(const Airavata_updateGatewayResourceProfile_result&);
  Airavata_updateGatewayResourceProfile_result& operator=(const Airavata_updateGatewayResourceProfile_result&);
  Airavata_updateGatewayResourceProfile_result() : success(0) {
  }

  virtual ~Airavata_updateGatewayResourceProfile_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayResourceProfile_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGatewayResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayResourceProfile_presult__isset {
  _Airavata_updateGatewayResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayResourceProfile_presult__isset;

class Airavata_updateGatewayResourceProfile_presult {
 public:


  virtual ~Airavata_updateGatewayResourceProfile_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteGatewayResourceProfile_args {
 public:

  Airavata_deleteGatewayResourceProfile_args(const Airavata_deleteGatewayResourceProfile_args&);
  Airavata_deleteGatewayResourceProfile_args& operator=(const Airavata_deleteGatewayResourceProfile_args&);
  Airavata_deleteGatewayResourceProfile_args() : gatewayID() {
  }

  virtual ~Airavata_deleteGatewayResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_deleteGatewayResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteGatewayResourceProfile_pargs {
 public:


  virtual ~Airavata_deleteGatewayResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayResourceProfile_result__isset {
  _Airavata_deleteGatewayResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayResourceProfile_result__isset;

class Airavata_deleteGatewayResourceProfile_result {
 public:

  Airavata_deleteGatewayResourceProfile_result(const Airavata_deleteGatewayResourceProfile_result&);
  Airavata_deleteGatewayResourceProfile_result& operator=(const Airavata_deleteGatewayResourceProfile_result&);
  Airavata_deleteGatewayResourceProfile_result() : success(0) {
  }

  virtual ~Airavata_deleteGatewayResourceProfile_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayResourceProfile_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteGatewayResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayResourceProfile_presult__isset {
  _Airavata_deleteGatewayResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayResourceProfile_presult__isset;

class Airavata_deleteGatewayResourceProfile_presult {
 public:


  virtual ~Airavata_deleteGatewayResourceProfile_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addGatewayComputeResourcePreference_args {
 public:

  Airavata_addGatewayComputeResourcePreference_args(const Airavata_addGatewayComputeResourcePreference_args&);
  Airavata_addGatewayComputeResourcePreference_args& operator=(const Airavata_addGatewayComputeResourcePreference_args&);
  Airavata_addGatewayComputeResourcePreference_args() : gatewayID(), computeResourceId() {
  }

  virtual ~Airavata_addGatewayComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string computeResourceId;
   ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference computeResourcePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_computeResourceId(const std::string& val);

  void __set_computeResourcePreference(const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& val);

  bool operator == (const Airavata_addGatewayComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(computeResourcePreference == rhs.computeResourcePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGatewayComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGatewayComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addGatewayComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_addGatewayComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* computeResourceId;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference* computeResourcePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGatewayComputeResourcePreference_result__isset {
  _Airavata_addGatewayComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGatewayComputeResourcePreference_result__isset;

class Airavata_addGatewayComputeResourcePreference_result {
 public:

  Airavata_addGatewayComputeResourcePreference_result(const Airavata_addGatewayComputeResourcePreference_result&);
  Airavata_addGatewayComputeResourcePreference_result& operator=(const Airavata_addGatewayComputeResourcePreference_result&);
  Airavata_addGatewayComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_addGatewayComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGatewayComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addGatewayComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGatewayComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGatewayComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGatewayComputeResourcePreference_presult__isset {
  _Airavata_addGatewayComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGatewayComputeResourcePreference_presult__isset;

class Airavata_addGatewayComputeResourcePreference_presult {
 public:


  virtual ~Airavata_addGatewayComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGatewayComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addGatewayStoragePreference_args {
 public:

  Airavata_addGatewayStoragePreference_args(const Airavata_addGatewayStoragePreference_args&);
  Airavata_addGatewayStoragePreference_args& operator=(const Airavata_addGatewayStoragePreference_args&);
  Airavata_addGatewayStoragePreference_args() : gatewayID(), storageResourceId() {
  }

  virtual ~Airavata_addGatewayStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string storageResourceId;
   ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference storagePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_storageResourceId(const std::string& val);

  void __set_storagePreference(const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& val);

  bool operator == (const Airavata_addGatewayStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(storageResourceId == rhs.storageResourceId))
      return false;
    if (!(storagePreference == rhs.storagePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGatewayStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGatewayStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addGatewayStoragePreference_pargs {
 public:


  virtual ~Airavata_addGatewayStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* storageResourceId;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference* storagePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGatewayStoragePreference_result__isset {
  _Airavata_addGatewayStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGatewayStoragePreference_result__isset;

class Airavata_addGatewayStoragePreference_result {
 public:

  Airavata_addGatewayStoragePreference_result(const Airavata_addGatewayStoragePreference_result&);
  Airavata_addGatewayStoragePreference_result& operator=(const Airavata_addGatewayStoragePreference_result&);
  Airavata_addGatewayStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_addGatewayStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGatewayStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addGatewayStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addGatewayStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addGatewayStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addGatewayStoragePreference_presult__isset {
  _Airavata_addGatewayStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addGatewayStoragePreference_presult__isset;

class Airavata_addGatewayStoragePreference_presult {
 public:


  virtual ~Airavata_addGatewayStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addGatewayStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGatewayComputeResourcePreference_args {
 public:

  Airavata_getGatewayComputeResourcePreference_args(const Airavata_getGatewayComputeResourcePreference_args&);
  Airavata_getGatewayComputeResourcePreference_args& operator=(const Airavata_getGatewayComputeResourcePreference_args&);
  Airavata_getGatewayComputeResourcePreference_args() : gatewayID(), computeResourceId() {
  }

  virtual ~Airavata_getGatewayComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string computeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_computeResourceId(const std::string& val);

  bool operator == (const Airavata_getGatewayComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGatewayComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_getGatewayComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* computeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayComputeResourcePreference_result__isset {
  _Airavata_getGatewayComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayComputeResourcePreference_result__isset;

class Airavata_getGatewayComputeResourcePreference_result {
 public:

  Airavata_getGatewayComputeResourcePreference_result(const Airavata_getGatewayComputeResourcePreference_result&);
  Airavata_getGatewayComputeResourcePreference_result& operator=(const Airavata_getGatewayComputeResourcePreference_result&);
  Airavata_getGatewayComputeResourcePreference_result() {
  }

  virtual ~Airavata_getGatewayComputeResourcePreference_result() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayComputeResourcePreference_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGatewayComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayComputeResourcePreference_presult__isset {
  _Airavata_getGatewayComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayComputeResourcePreference_presult__isset;

class Airavata_getGatewayComputeResourcePreference_presult {
 public:


  virtual ~Airavata_getGatewayComputeResourcePreference_presult() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGatewayStoragePreference_args {
 public:

  Airavata_getGatewayStoragePreference_args(const Airavata_getGatewayStoragePreference_args&);
  Airavata_getGatewayStoragePreference_args& operator=(const Airavata_getGatewayStoragePreference_args&);
  Airavata_getGatewayStoragePreference_args() : gatewayID(), storageResourceId() {
  }

  virtual ~Airavata_getGatewayStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string storageResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_storageResourceId(const std::string& val);

  bool operator == (const Airavata_getGatewayStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(storageResourceId == rhs.storageResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGatewayStoragePreference_pargs {
 public:


  virtual ~Airavata_getGatewayStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* storageResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayStoragePreference_result__isset {
  _Airavata_getGatewayStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayStoragePreference_result__isset;

class Airavata_getGatewayStoragePreference_result {
 public:

  Airavata_getGatewayStoragePreference_result(const Airavata_getGatewayStoragePreference_result&);
  Airavata_getGatewayStoragePreference_result& operator=(const Airavata_getGatewayStoragePreference_result&);
  Airavata_getGatewayStoragePreference_result() {
  }

  virtual ~Airavata_getGatewayStoragePreference_result() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayStoragePreference_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGatewayStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGatewayStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGatewayStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGatewayStoragePreference_presult__isset {
  _Airavata_getGatewayStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGatewayStoragePreference_presult__isset;

class Airavata_getGatewayStoragePreference_presult {
 public:


  virtual ~Airavata_getGatewayStoragePreference_presult() throw();
   ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGatewayStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGatewayComputeResourcePreferences_args {
 public:

  Airavata_getAllGatewayComputeResourcePreferences_args(const Airavata_getAllGatewayComputeResourcePreferences_args&);
  Airavata_getAllGatewayComputeResourcePreferences_args& operator=(const Airavata_getAllGatewayComputeResourcePreferences_args&);
  Airavata_getAllGatewayComputeResourcePreferences_args() : gatewayID() {
  }

  virtual ~Airavata_getAllGatewayComputeResourcePreferences_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getAllGatewayComputeResourcePreferences_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayComputeResourcePreferences_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayComputeResourcePreferences_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGatewayComputeResourcePreferences_pargs {
 public:


  virtual ~Airavata_getAllGatewayComputeResourcePreferences_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayComputeResourcePreferences_result__isset {
  _Airavata_getAllGatewayComputeResourcePreferences_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayComputeResourcePreferences_result__isset;

class Airavata_getAllGatewayComputeResourcePreferences_result {
 public:

  Airavata_getAllGatewayComputeResourcePreferences_result(const Airavata_getAllGatewayComputeResourcePreferences_result&);
  Airavata_getAllGatewayComputeResourcePreferences_result& operator=(const Airavata_getAllGatewayComputeResourcePreferences_result&);
  Airavata_getAllGatewayComputeResourcePreferences_result() {
  }

  virtual ~Airavata_getAllGatewayComputeResourcePreferences_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayComputeResourcePreferences_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllGatewayComputeResourcePreferences_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayComputeResourcePreferences_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayComputeResourcePreferences_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayComputeResourcePreferences_presult__isset {
  _Airavata_getAllGatewayComputeResourcePreferences_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayComputeResourcePreferences_presult__isset;

class Airavata_getAllGatewayComputeResourcePreferences_presult {
 public:


  virtual ~Airavata_getAllGatewayComputeResourcePreferences_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayComputeResourcePreferences_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGatewayStoragePreferences_args {
 public:

  Airavata_getAllGatewayStoragePreferences_args(const Airavata_getAllGatewayStoragePreferences_args&);
  Airavata_getAllGatewayStoragePreferences_args& operator=(const Airavata_getAllGatewayStoragePreferences_args&);
  Airavata_getAllGatewayStoragePreferences_args() : gatewayID() {
  }

  virtual ~Airavata_getAllGatewayStoragePreferences_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getAllGatewayStoragePreferences_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayStoragePreferences_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayStoragePreferences_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGatewayStoragePreferences_pargs {
 public:


  virtual ~Airavata_getAllGatewayStoragePreferences_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayStoragePreferences_result__isset {
  _Airavata_getAllGatewayStoragePreferences_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayStoragePreferences_result__isset;

class Airavata_getAllGatewayStoragePreferences_result {
 public:

  Airavata_getAllGatewayStoragePreferences_result(const Airavata_getAllGatewayStoragePreferences_result&);
  Airavata_getAllGatewayStoragePreferences_result& operator=(const Airavata_getAllGatewayStoragePreferences_result&);
  Airavata_getAllGatewayStoragePreferences_result() {
  }

  virtual ~Airavata_getAllGatewayStoragePreferences_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayStoragePreferences_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllGatewayStoragePreferences_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayStoragePreferences_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayStoragePreferences_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayStoragePreferences_presult__isset {
  _Airavata_getAllGatewayStoragePreferences_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayStoragePreferences_presult__isset;

class Airavata_getAllGatewayStoragePreferences_presult {
 public:


  virtual ~Airavata_getAllGatewayStoragePreferences_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayStoragePreferences_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGatewayResourceProfiles_args {
 public:

  Airavata_getAllGatewayResourceProfiles_args(const Airavata_getAllGatewayResourceProfiles_args&);
  Airavata_getAllGatewayResourceProfiles_args& operator=(const Airavata_getAllGatewayResourceProfiles_args&);
  Airavata_getAllGatewayResourceProfiles_args() {
  }

  virtual ~Airavata_getAllGatewayResourceProfiles_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAllGatewayResourceProfiles_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayResourceProfiles_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayResourceProfiles_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGatewayResourceProfiles_pargs {
 public:


  virtual ~Airavata_getAllGatewayResourceProfiles_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayResourceProfiles_result__isset {
  _Airavata_getAllGatewayResourceProfiles_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayResourceProfiles_result__isset;

class Airavata_getAllGatewayResourceProfiles_result {
 public:

  Airavata_getAllGatewayResourceProfiles_result(const Airavata_getAllGatewayResourceProfiles_result&);
  Airavata_getAllGatewayResourceProfiles_result& operator=(const Airavata_getAllGatewayResourceProfiles_result&);
  Airavata_getAllGatewayResourceProfiles_result() {
  }

  virtual ~Airavata_getAllGatewayResourceProfiles_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayResourceProfiles_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllGatewayResourceProfiles_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGatewayResourceProfiles_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGatewayResourceProfiles_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGatewayResourceProfiles_presult__isset {
  _Airavata_getAllGatewayResourceProfiles_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGatewayResourceProfiles_presult__isset;

class Airavata_getAllGatewayResourceProfiles_presult {
 public:


  virtual ~Airavata_getAllGatewayResourceProfiles_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::gatewayprofile::GatewayResourceProfile> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGatewayResourceProfiles_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGatewayComputeResourcePreference_args {
 public:

  Airavata_updateGatewayComputeResourcePreference_args(const Airavata_updateGatewayComputeResourcePreference_args&);
  Airavata_updateGatewayComputeResourcePreference_args& operator=(const Airavata_updateGatewayComputeResourcePreference_args&);
  Airavata_updateGatewayComputeResourcePreference_args() : gatewayID(), computeResourceId() {
  }

  virtual ~Airavata_updateGatewayComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string computeResourceId;
   ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference computeResourcePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_computeResourceId(const std::string& val);

  void __set_computeResourcePreference(const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference& val);

  bool operator == (const Airavata_updateGatewayComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(computeResourcePreference == rhs.computeResourcePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGatewayComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_updateGatewayComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* computeResourceId;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::ComputeResourcePreference* computeResourcePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayComputeResourcePreference_result__isset {
  _Airavata_updateGatewayComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayComputeResourcePreference_result__isset;

class Airavata_updateGatewayComputeResourcePreference_result {
 public:

  Airavata_updateGatewayComputeResourcePreference_result(const Airavata_updateGatewayComputeResourcePreference_result&);
  Airavata_updateGatewayComputeResourcePreference_result& operator=(const Airavata_updateGatewayComputeResourcePreference_result&);
  Airavata_updateGatewayComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_updateGatewayComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGatewayComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayComputeResourcePreference_presult__isset {
  _Airavata_updateGatewayComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayComputeResourcePreference_presult__isset;

class Airavata_updateGatewayComputeResourcePreference_presult {
 public:


  virtual ~Airavata_updateGatewayComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGatewayStoragePreference_args {
 public:

  Airavata_updateGatewayStoragePreference_args(const Airavata_updateGatewayStoragePreference_args&);
  Airavata_updateGatewayStoragePreference_args& operator=(const Airavata_updateGatewayStoragePreference_args&);
  Airavata_updateGatewayStoragePreference_args() : gatewayID(), storageId() {
  }

  virtual ~Airavata_updateGatewayStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string storageId;
   ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference storagePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_storageId(const std::string& val);

  void __set_storagePreference(const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference& val);

  bool operator == (const Airavata_updateGatewayStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(storageId == rhs.storageId))
      return false;
    if (!(storagePreference == rhs.storagePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGatewayStoragePreference_pargs {
 public:


  virtual ~Airavata_updateGatewayStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* storageId;
  const  ::apache::airavata::model::appcatalog::gatewayprofile::StoragePreference* storagePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayStoragePreference_result__isset {
  _Airavata_updateGatewayStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayStoragePreference_result__isset;

class Airavata_updateGatewayStoragePreference_result {
 public:

  Airavata_updateGatewayStoragePreference_result(const Airavata_updateGatewayStoragePreference_result&);
  Airavata_updateGatewayStoragePreference_result& operator=(const Airavata_updateGatewayStoragePreference_result&);
  Airavata_updateGatewayStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_updateGatewayStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGatewayStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGatewayStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGatewayStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGatewayStoragePreference_presult__isset {
  _Airavata_updateGatewayStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGatewayStoragePreference_presult__isset;

class Airavata_updateGatewayStoragePreference_presult {
 public:


  virtual ~Airavata_updateGatewayStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGatewayStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteGatewayComputeResourcePreference_args {
 public:

  Airavata_deleteGatewayComputeResourcePreference_args(const Airavata_deleteGatewayComputeResourcePreference_args&);
  Airavata_deleteGatewayComputeResourcePreference_args& operator=(const Airavata_deleteGatewayComputeResourcePreference_args&);
  Airavata_deleteGatewayComputeResourcePreference_args() : gatewayID(), computeResourceId() {
  }

  virtual ~Airavata_deleteGatewayComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string computeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_computeResourceId(const std::string& val);

  bool operator == (const Airavata_deleteGatewayComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteGatewayComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_deleteGatewayComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* computeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayComputeResourcePreference_result__isset {
  _Airavata_deleteGatewayComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayComputeResourcePreference_result__isset;

class Airavata_deleteGatewayComputeResourcePreference_result {
 public:

  Airavata_deleteGatewayComputeResourcePreference_result(const Airavata_deleteGatewayComputeResourcePreference_result&);
  Airavata_deleteGatewayComputeResourcePreference_result& operator=(const Airavata_deleteGatewayComputeResourcePreference_result&);
  Airavata_deleteGatewayComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_deleteGatewayComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteGatewayComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayComputeResourcePreference_presult__isset {
  _Airavata_deleteGatewayComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayComputeResourcePreference_presult__isset;

class Airavata_deleteGatewayComputeResourcePreference_presult {
 public:


  virtual ~Airavata_deleteGatewayComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteGatewayStoragePreference_args {
 public:

  Airavata_deleteGatewayStoragePreference_args(const Airavata_deleteGatewayStoragePreference_args&);
  Airavata_deleteGatewayStoragePreference_args& operator=(const Airavata_deleteGatewayStoragePreference_args&);
  Airavata_deleteGatewayStoragePreference_args() : gatewayID(), storageId() {
  }

  virtual ~Airavata_deleteGatewayStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayID;
  std::string storageId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayID(const std::string& val);

  void __set_storageId(const std::string& val);

  bool operator == (const Airavata_deleteGatewayStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(storageId == rhs.storageId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteGatewayStoragePreference_pargs {
 public:


  virtual ~Airavata_deleteGatewayStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayID;
  const std::string* storageId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayStoragePreference_result__isset {
  _Airavata_deleteGatewayStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayStoragePreference_result__isset;

class Airavata_deleteGatewayStoragePreference_result {
 public:

  Airavata_deleteGatewayStoragePreference_result(const Airavata_deleteGatewayStoragePreference_result&);
  Airavata_deleteGatewayStoragePreference_result& operator=(const Airavata_deleteGatewayStoragePreference_result&);
  Airavata_deleteGatewayStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_deleteGatewayStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteGatewayStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGatewayStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGatewayStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGatewayStoragePreference_presult__isset {
  _Airavata_deleteGatewayStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGatewayStoragePreference_presult__isset;

class Airavata_deleteGatewayStoragePreference_presult {
 public:


  virtual ~Airavata_deleteGatewayStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGatewayStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerUserResourceProfile_args {
 public:

  Airavata_registerUserResourceProfile_args(const Airavata_registerUserResourceProfile_args&);
  Airavata_registerUserResourceProfile_args& operator=(const Airavata_registerUserResourceProfile_args&);
  Airavata_registerUserResourceProfile_args() {
  }

  virtual ~Airavata_registerUserResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile userResourceProfile;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userResourceProfile(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& val);

  bool operator == (const Airavata_registerUserResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userResourceProfile == rhs.userResourceProfile))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerUserResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerUserResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerUserResourceProfile_pargs {
 public:


  virtual ~Airavata_registerUserResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile* userResourceProfile;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerUserResourceProfile_result__isset {
  _Airavata_registerUserResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerUserResourceProfile_result__isset;

class Airavata_registerUserResourceProfile_result {
 public:

  Airavata_registerUserResourceProfile_result(const Airavata_registerUserResourceProfile_result&);
  Airavata_registerUserResourceProfile_result& operator=(const Airavata_registerUserResourceProfile_result&);
  Airavata_registerUserResourceProfile_result() : success() {
  }

  virtual ~Airavata_registerUserResourceProfile_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerUserResourceProfile_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerUserResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerUserResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerUserResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerUserResourceProfile_presult__isset {
  _Airavata_registerUserResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerUserResourceProfile_presult__isset;

class Airavata_registerUserResourceProfile_presult {
 public:


  virtual ~Airavata_registerUserResourceProfile_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerUserResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUserResourceProfile_args {
 public:

  Airavata_getUserResourceProfile_args(const Airavata_getUserResourceProfile_args&);
  Airavata_getUserResourceProfile_args& operator=(const Airavata_getUserResourceProfile_args&);
  Airavata_getUserResourceProfile_args() : userId(), gatewayID() {
  }

  virtual ~Airavata_getUserResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getUserResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUserResourceProfile_pargs {
 public:


  virtual ~Airavata_getUserResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserResourceProfile_result__isset {
  _Airavata_getUserResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserResourceProfile_result__isset;

class Airavata_getUserResourceProfile_result {
 public:

  Airavata_getUserResourceProfile_result(const Airavata_getUserResourceProfile_result&);
  Airavata_getUserResourceProfile_result& operator=(const Airavata_getUserResourceProfile_result&);
  Airavata_getUserResourceProfile_result() {
  }

  virtual ~Airavata_getUserResourceProfile_result() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserResourceProfile_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUserResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserResourceProfile_presult__isset {
  _Airavata_getUserResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserResourceProfile_presult__isset;

class Airavata_getUserResourceProfile_presult {
 public:


  virtual ~Airavata_getUserResourceProfile_presult() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateUserResourceProfile_args {
 public:

  Airavata_updateUserResourceProfile_args(const Airavata_updateUserResourceProfile_args&);
  Airavata_updateUserResourceProfile_args& operator=(const Airavata_updateUserResourceProfile_args&);
  Airavata_updateUserResourceProfile_args() : userId(), gatewayID() {
  }

  virtual ~Airavata_updateUserResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile userResourceProfile;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userResourceProfile(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile& val);

  bool operator == (const Airavata_updateUserResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userResourceProfile == rhs.userResourceProfile))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateUserResourceProfile_pargs {
 public:


  virtual ~Airavata_updateUserResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile* userResourceProfile;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserResourceProfile_result__isset {
  _Airavata_updateUserResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserResourceProfile_result__isset;

class Airavata_updateUserResourceProfile_result {
 public:

  Airavata_updateUserResourceProfile_result(const Airavata_updateUserResourceProfile_result&);
  Airavata_updateUserResourceProfile_result& operator=(const Airavata_updateUserResourceProfile_result&);
  Airavata_updateUserResourceProfile_result() : success(0) {
  }

  virtual ~Airavata_updateUserResourceProfile_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserResourceProfile_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateUserResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserResourceProfile_presult__isset {
  _Airavata_updateUserResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserResourceProfile_presult__isset;

class Airavata_updateUserResourceProfile_presult {
 public:


  virtual ~Airavata_updateUserResourceProfile_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteUserResourceProfile_args {
 public:

  Airavata_deleteUserResourceProfile_args(const Airavata_deleteUserResourceProfile_args&);
  Airavata_deleteUserResourceProfile_args& operator=(const Airavata_deleteUserResourceProfile_args&);
  Airavata_deleteUserResourceProfile_args() : userId(), gatewayID() {
  }

  virtual ~Airavata_deleteUserResourceProfile_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_deleteUserResourceProfile_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserResourceProfile_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserResourceProfile_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteUserResourceProfile_pargs {
 public:


  virtual ~Airavata_deleteUserResourceProfile_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserResourceProfile_result__isset {
  _Airavata_deleteUserResourceProfile_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserResourceProfile_result__isset;

class Airavata_deleteUserResourceProfile_result {
 public:

  Airavata_deleteUserResourceProfile_result(const Airavata_deleteUserResourceProfile_result&);
  Airavata_deleteUserResourceProfile_result& operator=(const Airavata_deleteUserResourceProfile_result&);
  Airavata_deleteUserResourceProfile_result() : success(0) {
  }

  virtual ~Airavata_deleteUserResourceProfile_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserResourceProfile_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteUserResourceProfile_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserResourceProfile_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserResourceProfile_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserResourceProfile_presult__isset {
  _Airavata_deleteUserResourceProfile_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserResourceProfile_presult__isset;

class Airavata_deleteUserResourceProfile_presult {
 public:


  virtual ~Airavata_deleteUserResourceProfile_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserResourceProfile_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addUserComputeResourcePreference_args {
 public:

  Airavata_addUserComputeResourcePreference_args(const Airavata_addUserComputeResourcePreference_args&);
  Airavata_addUserComputeResourcePreference_args& operator=(const Airavata_addUserComputeResourcePreference_args&);
  Airavata_addUserComputeResourcePreference_args() : userId(), gatewayID(), userComputeResourceId() {
  }

  virtual ~Airavata_addUserComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userComputeResourceId;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference userComputeResourcePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userComputeResourceId(const std::string& val);

  void __set_userComputeResourcePreference(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& val);

  bool operator == (const Airavata_addUserComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userComputeResourceId == rhs.userComputeResourceId))
      return false;
    if (!(userComputeResourcePreference == rhs.userComputeResourcePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUserComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUserComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addUserComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_addUserComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userComputeResourceId;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference* userComputeResourcePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUserComputeResourcePreference_result__isset {
  _Airavata_addUserComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUserComputeResourcePreference_result__isset;

class Airavata_addUserComputeResourcePreference_result {
 public:

  Airavata_addUserComputeResourcePreference_result(const Airavata_addUserComputeResourcePreference_result&);
  Airavata_addUserComputeResourcePreference_result& operator=(const Airavata_addUserComputeResourcePreference_result&);
  Airavata_addUserComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_addUserComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUserComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addUserComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUserComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUserComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUserComputeResourcePreference_presult__isset {
  _Airavata_addUserComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUserComputeResourcePreference_presult__isset;

class Airavata_addUserComputeResourcePreference_presult {
 public:


  virtual ~Airavata_addUserComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUserComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_addUserStoragePreference_args {
 public:

  Airavata_addUserStoragePreference_args(const Airavata_addUserStoragePreference_args&);
  Airavata_addUserStoragePreference_args& operator=(const Airavata_addUserStoragePreference_args&);
  Airavata_addUserStoragePreference_args() : userId(), gatewayID(), userStorageResourceId() {
  }

  virtual ~Airavata_addUserStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userStorageResourceId;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference userStoragePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userStorageResourceId(const std::string& val);

  void __set_userStoragePreference(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& val);

  bool operator == (const Airavata_addUserStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userStorageResourceId == rhs.userStorageResourceId))
      return false;
    if (!(userStoragePreference == rhs.userStoragePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUserStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUserStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_addUserStoragePreference_pargs {
 public:


  virtual ~Airavata_addUserStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userStorageResourceId;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference* userStoragePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUserStoragePreference_result__isset {
  _Airavata_addUserStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUserStoragePreference_result__isset;

class Airavata_addUserStoragePreference_result {
 public:

  Airavata_addUserStoragePreference_result(const Airavata_addUserStoragePreference_result&);
  Airavata_addUserStoragePreference_result& operator=(const Airavata_addUserStoragePreference_result&);
  Airavata_addUserStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_addUserStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUserStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_addUserStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_addUserStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_addUserStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_addUserStoragePreference_presult__isset {
  _Airavata_addUserStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_addUserStoragePreference_presult__isset;

class Airavata_addUserStoragePreference_presult {
 public:


  virtual ~Airavata_addUserStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_addUserStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUserComputeResourcePreference_args {
 public:

  Airavata_getUserComputeResourcePreference_args(const Airavata_getUserComputeResourcePreference_args&);
  Airavata_getUserComputeResourcePreference_args& operator=(const Airavata_getUserComputeResourcePreference_args&);
  Airavata_getUserComputeResourcePreference_args() : userId(), gatewayID(), userComputeResourceId() {
  }

  virtual ~Airavata_getUserComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userComputeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userComputeResourceId(const std::string& val);

  bool operator == (const Airavata_getUserComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userComputeResourceId == rhs.userComputeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUserComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_getUserComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userComputeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserComputeResourcePreference_result__isset {
  _Airavata_getUserComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserComputeResourcePreference_result__isset;

class Airavata_getUserComputeResourcePreference_result {
 public:

  Airavata_getUserComputeResourcePreference_result(const Airavata_getUserComputeResourcePreference_result&);
  Airavata_getUserComputeResourcePreference_result& operator=(const Airavata_getUserComputeResourcePreference_result&);
  Airavata_getUserComputeResourcePreference_result() {
  }

  virtual ~Airavata_getUserComputeResourcePreference_result() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserComputeResourcePreference_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUserComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserComputeResourcePreference_presult__isset {
  _Airavata_getUserComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserComputeResourcePreference_presult__isset;

class Airavata_getUserComputeResourcePreference_presult {
 public:


  virtual ~Airavata_getUserComputeResourcePreference_presult() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getUserStoragePreference_args {
 public:

  Airavata_getUserStoragePreference_args(const Airavata_getUserStoragePreference_args&);
  Airavata_getUserStoragePreference_args& operator=(const Airavata_getUserStoragePreference_args&);
  Airavata_getUserStoragePreference_args() : userId(), gatewayID(), userStorageResourceId() {
  }

  virtual ~Airavata_getUserStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userStorageResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userStorageResourceId(const std::string& val);

  bool operator == (const Airavata_getUserStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userStorageResourceId == rhs.userStorageResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getUserStoragePreference_pargs {
 public:


  virtual ~Airavata_getUserStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userStorageResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserStoragePreference_result__isset {
  _Airavata_getUserStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserStoragePreference_result__isset;

class Airavata_getUserStoragePreference_result {
 public:

  Airavata_getUserStoragePreference_result(const Airavata_getUserStoragePreference_result&);
  Airavata_getUserStoragePreference_result& operator=(const Airavata_getUserStoragePreference_result&);
  Airavata_getUserStoragePreference_result() {
  }

  virtual ~Airavata_getUserStoragePreference_result() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserStoragePreference_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getUserStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getUserStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getUserStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getUserStoragePreference_presult__isset {
  _Airavata_getUserStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getUserStoragePreference_presult__isset;

class Airavata_getUserStoragePreference_presult {
 public:


  virtual ~Airavata_getUserStoragePreference_presult() throw();
   ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getUserStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllUserComputeResourcePreferences_args {
 public:

  Airavata_getAllUserComputeResourcePreferences_args(const Airavata_getAllUserComputeResourcePreferences_args&);
  Airavata_getAllUserComputeResourcePreferences_args& operator=(const Airavata_getAllUserComputeResourcePreferences_args&);
  Airavata_getAllUserComputeResourcePreferences_args() : userId(), gatewayID() {
  }

  virtual ~Airavata_getAllUserComputeResourcePreferences_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getAllUserComputeResourcePreferences_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserComputeResourcePreferences_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserComputeResourcePreferences_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllUserComputeResourcePreferences_pargs {
 public:


  virtual ~Airavata_getAllUserComputeResourcePreferences_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserComputeResourcePreferences_result__isset {
  _Airavata_getAllUserComputeResourcePreferences_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserComputeResourcePreferences_result__isset;

class Airavata_getAllUserComputeResourcePreferences_result {
 public:

  Airavata_getAllUserComputeResourcePreferences_result(const Airavata_getAllUserComputeResourcePreferences_result&);
  Airavata_getAllUserComputeResourcePreferences_result& operator=(const Airavata_getAllUserComputeResourcePreferences_result&);
  Airavata_getAllUserComputeResourcePreferences_result() {
  }

  virtual ~Airavata_getAllUserComputeResourcePreferences_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserComputeResourcePreferences_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllUserComputeResourcePreferences_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserComputeResourcePreferences_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserComputeResourcePreferences_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserComputeResourcePreferences_presult__isset {
  _Airavata_getAllUserComputeResourcePreferences_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserComputeResourcePreferences_presult__isset;

class Airavata_getAllUserComputeResourcePreferences_presult {
 public:


  virtual ~Airavata_getAllUserComputeResourcePreferences_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserComputeResourcePreferences_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllUserStoragePreferences_args {
 public:

  Airavata_getAllUserStoragePreferences_args(const Airavata_getAllUserStoragePreferences_args&);
  Airavata_getAllUserStoragePreferences_args& operator=(const Airavata_getAllUserStoragePreferences_args&);
  Airavata_getAllUserStoragePreferences_args() : userId(), gatewayID() {
  }

  virtual ~Airavata_getAllUserStoragePreferences_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  bool operator == (const Airavata_getAllUserStoragePreferences_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserStoragePreferences_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserStoragePreferences_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllUserStoragePreferences_pargs {
 public:


  virtual ~Airavata_getAllUserStoragePreferences_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserStoragePreferences_result__isset {
  _Airavata_getAllUserStoragePreferences_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserStoragePreferences_result__isset;

class Airavata_getAllUserStoragePreferences_result {
 public:

  Airavata_getAllUserStoragePreferences_result(const Airavata_getAllUserStoragePreferences_result&);
  Airavata_getAllUserStoragePreferences_result& operator=(const Airavata_getAllUserStoragePreferences_result&);
  Airavata_getAllUserStoragePreferences_result() {
  }

  virtual ~Airavata_getAllUserStoragePreferences_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserStoragePreferences_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllUserStoragePreferences_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserStoragePreferences_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserStoragePreferences_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserStoragePreferences_presult__isset {
  _Airavata_getAllUserStoragePreferences_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserStoragePreferences_presult__isset;

class Airavata_getAllUserStoragePreferences_presult {
 public:


  virtual ~Airavata_getAllUserStoragePreferences_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserStoragePreferences_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllUserResourceProfiles_args {
 public:

  Airavata_getAllUserResourceProfiles_args(const Airavata_getAllUserResourceProfiles_args&);
  Airavata_getAllUserResourceProfiles_args& operator=(const Airavata_getAllUserResourceProfiles_args&);
  Airavata_getAllUserResourceProfiles_args() {
  }

  virtual ~Airavata_getAllUserResourceProfiles_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getAllUserResourceProfiles_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserResourceProfiles_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserResourceProfiles_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllUserResourceProfiles_pargs {
 public:


  virtual ~Airavata_getAllUserResourceProfiles_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserResourceProfiles_result__isset {
  _Airavata_getAllUserResourceProfiles_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserResourceProfiles_result__isset;

class Airavata_getAllUserResourceProfiles_result {
 public:

  Airavata_getAllUserResourceProfiles_result(const Airavata_getAllUserResourceProfiles_result&);
  Airavata_getAllUserResourceProfiles_result& operator=(const Airavata_getAllUserResourceProfiles_result&);
  Airavata_getAllUserResourceProfiles_result() {
  }

  virtual ~Airavata_getAllUserResourceProfiles_result() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserResourceProfiles_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllUserResourceProfiles_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllUserResourceProfiles_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllUserResourceProfiles_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllUserResourceProfiles_presult__isset {
  _Airavata_getAllUserResourceProfiles_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllUserResourceProfiles_presult__isset;

class Airavata_getAllUserResourceProfiles_presult {
 public:


  virtual ~Airavata_getAllUserResourceProfiles_presult() throw();
  std::vector< ::apache::airavata::model::appcatalog::userresourceprofile::UserResourceProfile> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllUserResourceProfiles_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateUserComputeResourcePreference_args {
 public:

  Airavata_updateUserComputeResourcePreference_args(const Airavata_updateUserComputeResourcePreference_args&);
  Airavata_updateUserComputeResourcePreference_args& operator=(const Airavata_updateUserComputeResourcePreference_args&);
  Airavata_updateUserComputeResourcePreference_args() : userId(), gatewayID(), userComputeResourceId() {
  }

  virtual ~Airavata_updateUserComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userComputeResourceId;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference userComputeResourcePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userComputeResourceId(const std::string& val);

  void __set_userComputeResourcePreference(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference& val);

  bool operator == (const Airavata_updateUserComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userComputeResourceId == rhs.userComputeResourceId))
      return false;
    if (!(userComputeResourcePreference == rhs.userComputeResourcePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateUserComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_updateUserComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userComputeResourceId;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserComputeResourcePreference* userComputeResourcePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserComputeResourcePreference_result__isset {
  _Airavata_updateUserComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserComputeResourcePreference_result__isset;

class Airavata_updateUserComputeResourcePreference_result {
 public:

  Airavata_updateUserComputeResourcePreference_result(const Airavata_updateUserComputeResourcePreference_result&);
  Airavata_updateUserComputeResourcePreference_result& operator=(const Airavata_updateUserComputeResourcePreference_result&);
  Airavata_updateUserComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_updateUserComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateUserComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserComputeResourcePreference_presult__isset {
  _Airavata_updateUserComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserComputeResourcePreference_presult__isset;

class Airavata_updateUserComputeResourcePreference_presult {
 public:


  virtual ~Airavata_updateUserComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateUserStoragePreference_args {
 public:

  Airavata_updateUserStoragePreference_args(const Airavata_updateUserStoragePreference_args&);
  Airavata_updateUserStoragePreference_args& operator=(const Airavata_updateUserStoragePreference_args&);
  Airavata_updateUserStoragePreference_args() : userId(), gatewayID(), userStorageId() {
  }

  virtual ~Airavata_updateUserStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userStorageId;
   ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference userStoragePreference;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userStorageId(const std::string& val);

  void __set_userStoragePreference(const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference& val);

  bool operator == (const Airavata_updateUserStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userStorageId == rhs.userStorageId))
      return false;
    if (!(userStoragePreference == rhs.userStoragePreference))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateUserStoragePreference_pargs {
 public:


  virtual ~Airavata_updateUserStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userStorageId;
  const  ::apache::airavata::model::appcatalog::userresourceprofile::UserStoragePreference* userStoragePreference;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserStoragePreference_result__isset {
  _Airavata_updateUserStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserStoragePreference_result__isset;

class Airavata_updateUserStoragePreference_result {
 public:

  Airavata_updateUserStoragePreference_result(const Airavata_updateUserStoragePreference_result&);
  Airavata_updateUserStoragePreference_result& operator=(const Airavata_updateUserStoragePreference_result&);
  Airavata_updateUserStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_updateUserStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateUserStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateUserStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateUserStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateUserStoragePreference_presult__isset {
  _Airavata_updateUserStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateUserStoragePreference_presult__isset;

class Airavata_updateUserStoragePreference_presult {
 public:


  virtual ~Airavata_updateUserStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateUserStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteUserComputeResourcePreference_args {
 public:

  Airavata_deleteUserComputeResourcePreference_args(const Airavata_deleteUserComputeResourcePreference_args&);
  Airavata_deleteUserComputeResourcePreference_args& operator=(const Airavata_deleteUserComputeResourcePreference_args&);
  Airavata_deleteUserComputeResourcePreference_args() : userId(), gatewayID(), userComputeResourceId() {
  }

  virtual ~Airavata_deleteUserComputeResourcePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userComputeResourceId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userComputeResourceId(const std::string& val);

  bool operator == (const Airavata_deleteUserComputeResourcePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userComputeResourceId == rhs.userComputeResourceId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserComputeResourcePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserComputeResourcePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteUserComputeResourcePreference_pargs {
 public:


  virtual ~Airavata_deleteUserComputeResourcePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userComputeResourceId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserComputeResourcePreference_result__isset {
  _Airavata_deleteUserComputeResourcePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserComputeResourcePreference_result__isset;

class Airavata_deleteUserComputeResourcePreference_result {
 public:

  Airavata_deleteUserComputeResourcePreference_result(const Airavata_deleteUserComputeResourcePreference_result&);
  Airavata_deleteUserComputeResourcePreference_result& operator=(const Airavata_deleteUserComputeResourcePreference_result&);
  Airavata_deleteUserComputeResourcePreference_result() : success(0) {
  }

  virtual ~Airavata_deleteUserComputeResourcePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserComputeResourcePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteUserComputeResourcePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserComputeResourcePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserComputeResourcePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserComputeResourcePreference_presult__isset {
  _Airavata_deleteUserComputeResourcePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserComputeResourcePreference_presult__isset;

class Airavata_deleteUserComputeResourcePreference_presult {
 public:


  virtual ~Airavata_deleteUserComputeResourcePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserComputeResourcePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteUserStoragePreference_args {
 public:

  Airavata_deleteUserStoragePreference_args(const Airavata_deleteUserStoragePreference_args&);
  Airavata_deleteUserStoragePreference_args& operator=(const Airavata_deleteUserStoragePreference_args&);
  Airavata_deleteUserStoragePreference_args() : userId(), gatewayID(), userStorageId() {
  }

  virtual ~Airavata_deleteUserStoragePreference_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userId;
  std::string gatewayID;
  std::string userStorageId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userId(const std::string& val);

  void __set_gatewayID(const std::string& val);

  void __set_userStorageId(const std::string& val);

  bool operator == (const Airavata_deleteUserStoragePreference_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userId == rhs.userId))
      return false;
    if (!(gatewayID == rhs.gatewayID))
      return false;
    if (!(userStorageId == rhs.userStorageId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserStoragePreference_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserStoragePreference_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteUserStoragePreference_pargs {
 public:


  virtual ~Airavata_deleteUserStoragePreference_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userId;
  const std::string* gatewayID;
  const std::string* userStorageId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserStoragePreference_result__isset {
  _Airavata_deleteUserStoragePreference_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserStoragePreference_result__isset;

class Airavata_deleteUserStoragePreference_result {
 public:

  Airavata_deleteUserStoragePreference_result(const Airavata_deleteUserStoragePreference_result&);
  Airavata_deleteUserStoragePreference_result& operator=(const Airavata_deleteUserStoragePreference_result&);
  Airavata_deleteUserStoragePreference_result() : success(0) {
  }

  virtual ~Airavata_deleteUserStoragePreference_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserStoragePreference_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteUserStoragePreference_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteUserStoragePreference_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteUserStoragePreference_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteUserStoragePreference_presult__isset {
  _Airavata_deleteUserStoragePreference_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteUserStoragePreference_presult__isset;

class Airavata_deleteUserStoragePreference_presult {
 public:


  virtual ~Airavata_deleteUserStoragePreference_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteUserStoragePreference_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllWorkflows_args {
 public:

  Airavata_getAllWorkflows_args(const Airavata_getAllWorkflows_args&);
  Airavata_getAllWorkflows_args& operator=(const Airavata_getAllWorkflows_args&);
  Airavata_getAllWorkflows_args() : gatewayId() {
  }

  virtual ~Airavata_getAllWorkflows_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const Airavata_getAllWorkflows_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllWorkflows_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllWorkflows_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllWorkflows_pargs {
 public:


  virtual ~Airavata_getAllWorkflows_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllWorkflows_result__isset {
  _Airavata_getAllWorkflows_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllWorkflows_result__isset;

class Airavata_getAllWorkflows_result {
 public:

  Airavata_getAllWorkflows_result(const Airavata_getAllWorkflows_result&);
  Airavata_getAllWorkflows_result& operator=(const Airavata_getAllWorkflows_result&);
  Airavata_getAllWorkflows_result() {
  }

  virtual ~Airavata_getAllWorkflows_result() throw();
  std::vector<std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllWorkflows_result__isset __isset;

  void __set_success(const std::vector<std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllWorkflows_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllWorkflows_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllWorkflows_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllWorkflows_presult__isset {
  _Airavata_getAllWorkflows_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllWorkflows_presult__isset;

class Airavata_getAllWorkflows_presult {
 public:


  virtual ~Airavata_getAllWorkflows_presult() throw();
  std::vector<std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllWorkflows_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getLatestQueueStatuses_args {
 public:

  Airavata_getLatestQueueStatuses_args(const Airavata_getLatestQueueStatuses_args&);
  Airavata_getLatestQueueStatuses_args& operator=(const Airavata_getLatestQueueStatuses_args&);
  Airavata_getLatestQueueStatuses_args() {
  }

  virtual ~Airavata_getLatestQueueStatuses_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  bool operator == (const Airavata_getLatestQueueStatuses_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLatestQueueStatuses_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLatestQueueStatuses_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getLatestQueueStatuses_pargs {
 public:


  virtual ~Airavata_getLatestQueueStatuses_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLatestQueueStatuses_result__isset {
  _Airavata_getLatestQueueStatuses_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLatestQueueStatuses_result__isset;

class Airavata_getLatestQueueStatuses_result {
 public:

  Airavata_getLatestQueueStatuses_result(const Airavata_getLatestQueueStatuses_result&);
  Airavata_getLatestQueueStatuses_result& operator=(const Airavata_getLatestQueueStatuses_result&);
  Airavata_getLatestQueueStatuses_result() {
  }

  virtual ~Airavata_getLatestQueueStatuses_result() throw();
  std::vector< ::apache::airavata::model::status::QueueStatusModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLatestQueueStatuses_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::status::QueueStatusModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getLatestQueueStatuses_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getLatestQueueStatuses_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getLatestQueueStatuses_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getLatestQueueStatuses_presult__isset {
  _Airavata_getLatestQueueStatuses_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getLatestQueueStatuses_presult__isset;

class Airavata_getLatestQueueStatuses_presult {
 public:


  virtual ~Airavata_getLatestQueueStatuses_presult() throw();
  std::vector< ::apache::airavata::model::status::QueueStatusModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getLatestQueueStatuses_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getWorkflow_args {
 public:

  Airavata_getWorkflow_args(const Airavata_getWorkflow_args&);
  Airavata_getWorkflow_args& operator=(const Airavata_getWorkflow_args&);
  Airavata_getWorkflow_args() : workflowTemplateId() {
  }

  virtual ~Airavata_getWorkflow_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string workflowTemplateId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_workflowTemplateId(const std::string& val);

  bool operator == (const Airavata_getWorkflow_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(workflowTemplateId == rhs.workflowTemplateId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getWorkflow_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getWorkflow_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getWorkflow_pargs {
 public:


  virtual ~Airavata_getWorkflow_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* workflowTemplateId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getWorkflow_result__isset {
  _Airavata_getWorkflow_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getWorkflow_result__isset;

class Airavata_getWorkflow_result {
 public:

  Airavata_getWorkflow_result(const Airavata_getWorkflow_result&);
  Airavata_getWorkflow_result& operator=(const Airavata_getWorkflow_result&);
  Airavata_getWorkflow_result() {
  }

  virtual ~Airavata_getWorkflow_result() throw();
   ::WorkflowModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getWorkflow_result__isset __isset;

  void __set_success(const  ::WorkflowModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getWorkflow_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getWorkflow_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getWorkflow_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getWorkflow_presult__isset {
  _Airavata_getWorkflow_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getWorkflow_presult__isset;

class Airavata_getWorkflow_presult {
 public:


  virtual ~Airavata_getWorkflow_presult() throw();
   ::WorkflowModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getWorkflow_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteWorkflow_args {
 public:

  Airavata_deleteWorkflow_args(const Airavata_deleteWorkflow_args&);
  Airavata_deleteWorkflow_args& operator=(const Airavata_deleteWorkflow_args&);
  Airavata_deleteWorkflow_args() : workflowTemplateId() {
  }

  virtual ~Airavata_deleteWorkflow_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string workflowTemplateId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_workflowTemplateId(const std::string& val);

  bool operator == (const Airavata_deleteWorkflow_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(workflowTemplateId == rhs.workflowTemplateId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteWorkflow_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteWorkflow_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteWorkflow_pargs {
 public:


  virtual ~Airavata_deleteWorkflow_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* workflowTemplateId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteWorkflow_result__isset {
  _Airavata_deleteWorkflow_result__isset() : ire(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteWorkflow_result__isset;

class Airavata_deleteWorkflow_result {
 public:

  Airavata_deleteWorkflow_result(const Airavata_deleteWorkflow_result&);
  Airavata_deleteWorkflow_result& operator=(const Airavata_deleteWorkflow_result&);
  Airavata_deleteWorkflow_result() {
  }

  virtual ~Airavata_deleteWorkflow_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteWorkflow_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteWorkflow_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteWorkflow_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteWorkflow_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteWorkflow_presult__isset {
  _Airavata_deleteWorkflow_presult__isset() : ire(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteWorkflow_presult__isset;

class Airavata_deleteWorkflow_presult {
 public:


  virtual ~Airavata_deleteWorkflow_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteWorkflow_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerWorkflow_args {
 public:

  Airavata_registerWorkflow_args(const Airavata_registerWorkflow_args&);
  Airavata_registerWorkflow_args& operator=(const Airavata_registerWorkflow_args&);
  Airavata_registerWorkflow_args() : gatewayId() {
  }

  virtual ~Airavata_registerWorkflow_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string gatewayId;
   ::WorkflowModel workflow;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_gatewayId(const std::string& val);

  void __set_workflow(const  ::WorkflowModel& val);

  bool operator == (const Airavata_registerWorkflow_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(workflow == rhs.workflow))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerWorkflow_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerWorkflow_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerWorkflow_pargs {
 public:


  virtual ~Airavata_registerWorkflow_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* gatewayId;
  const  ::WorkflowModel* workflow;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerWorkflow_result__isset {
  _Airavata_registerWorkflow_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerWorkflow_result__isset;

class Airavata_registerWorkflow_result {
 public:

  Airavata_registerWorkflow_result(const Airavata_registerWorkflow_result&);
  Airavata_registerWorkflow_result& operator=(const Airavata_registerWorkflow_result&);
  Airavata_registerWorkflow_result() : success() {
  }

  virtual ~Airavata_registerWorkflow_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerWorkflow_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerWorkflow_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerWorkflow_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerWorkflow_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerWorkflow_presult__isset {
  _Airavata_registerWorkflow_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerWorkflow_presult__isset;

class Airavata_registerWorkflow_presult {
 public:


  virtual ~Airavata_registerWorkflow_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerWorkflow_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateWorkflow_args {
 public:

  Airavata_updateWorkflow_args(const Airavata_updateWorkflow_args&);
  Airavata_updateWorkflow_args& operator=(const Airavata_updateWorkflow_args&);
  Airavata_updateWorkflow_args() : workflowTemplateId() {
  }

  virtual ~Airavata_updateWorkflow_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string workflowTemplateId;
   ::WorkflowModel workflow;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_workflowTemplateId(const std::string& val);

  void __set_workflow(const  ::WorkflowModel& val);

  bool operator == (const Airavata_updateWorkflow_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(workflowTemplateId == rhs.workflowTemplateId))
      return false;
    if (!(workflow == rhs.workflow))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateWorkflow_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateWorkflow_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateWorkflow_pargs {
 public:


  virtual ~Airavata_updateWorkflow_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* workflowTemplateId;
  const  ::WorkflowModel* workflow;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateWorkflow_result__isset {
  _Airavata_updateWorkflow_result__isset() : ire(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateWorkflow_result__isset;

class Airavata_updateWorkflow_result {
 public:

  Airavata_updateWorkflow_result(const Airavata_updateWorkflow_result&);
  Airavata_updateWorkflow_result& operator=(const Airavata_updateWorkflow_result&);
  Airavata_updateWorkflow_result() {
  }

  virtual ~Airavata_updateWorkflow_result() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateWorkflow_result__isset __isset;

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateWorkflow_result & rhs) const
  {
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateWorkflow_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateWorkflow_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateWorkflow_presult__isset {
  _Airavata_updateWorkflow_presult__isset() : ire(false), ace(false), ase(false), ae(false) {}
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateWorkflow_presult__isset;

class Airavata_updateWorkflow_presult {
 public:


  virtual ~Airavata_updateWorkflow_presult() throw();
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateWorkflow_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getWorkflowTemplateId_args {
 public:

  Airavata_getWorkflowTemplateId_args(const Airavata_getWorkflowTemplateId_args&);
  Airavata_getWorkflowTemplateId_args& operator=(const Airavata_getWorkflowTemplateId_args&);
  Airavata_getWorkflowTemplateId_args() : workflowName() {
  }

  virtual ~Airavata_getWorkflowTemplateId_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string workflowName;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_workflowName(const std::string& val);

  bool operator == (const Airavata_getWorkflowTemplateId_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(workflowName == rhs.workflowName))
      return false;
    return true;
  }
  bool operator != (const Airavata_getWorkflowTemplateId_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getWorkflowTemplateId_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getWorkflowTemplateId_pargs {
 public:


  virtual ~Airavata_getWorkflowTemplateId_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* workflowName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getWorkflowTemplateId_result__isset {
  _Airavata_getWorkflowTemplateId_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getWorkflowTemplateId_result__isset;

class Airavata_getWorkflowTemplateId_result {
 public:

  Airavata_getWorkflowTemplateId_result(const Airavata_getWorkflowTemplateId_result&);
  Airavata_getWorkflowTemplateId_result& operator=(const Airavata_getWorkflowTemplateId_result&);
  Airavata_getWorkflowTemplateId_result() : success() {
  }

  virtual ~Airavata_getWorkflowTemplateId_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getWorkflowTemplateId_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getWorkflowTemplateId_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getWorkflowTemplateId_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getWorkflowTemplateId_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getWorkflowTemplateId_presult__isset {
  _Airavata_getWorkflowTemplateId_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getWorkflowTemplateId_presult__isset;

class Airavata_getWorkflowTemplateId_presult {
 public:


  virtual ~Airavata_getWorkflowTemplateId_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getWorkflowTemplateId_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_isWorkflowExistWithName_args {
 public:

  Airavata_isWorkflowExistWithName_args(const Airavata_isWorkflowExistWithName_args&);
  Airavata_isWorkflowExistWithName_args& operator=(const Airavata_isWorkflowExistWithName_args&);
  Airavata_isWorkflowExistWithName_args() : workflowName() {
  }

  virtual ~Airavata_isWorkflowExistWithName_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string workflowName;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_workflowName(const std::string& val);

  bool operator == (const Airavata_isWorkflowExistWithName_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(workflowName == rhs.workflowName))
      return false;
    return true;
  }
  bool operator != (const Airavata_isWorkflowExistWithName_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isWorkflowExistWithName_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_isWorkflowExistWithName_pargs {
 public:


  virtual ~Airavata_isWorkflowExistWithName_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* workflowName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isWorkflowExistWithName_result__isset {
  _Airavata_isWorkflowExistWithName_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isWorkflowExistWithName_result__isset;

class Airavata_isWorkflowExistWithName_result {
 public:

  Airavata_isWorkflowExistWithName_result(const Airavata_isWorkflowExistWithName_result&);
  Airavata_isWorkflowExistWithName_result& operator=(const Airavata_isWorkflowExistWithName_result&);
  Airavata_isWorkflowExistWithName_result() : success(0) {
  }

  virtual ~Airavata_isWorkflowExistWithName_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isWorkflowExistWithName_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_isWorkflowExistWithName_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_isWorkflowExistWithName_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_isWorkflowExistWithName_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_isWorkflowExistWithName_presult__isset {
  _Airavata_isWorkflowExistWithName_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_isWorkflowExistWithName_presult__isset;

class Airavata_isWorkflowExistWithName_presult {
 public:


  virtual ~Airavata_isWorkflowExistWithName_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_isWorkflowExistWithName_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerDataProduct_args {
 public:

  Airavata_registerDataProduct_args(const Airavata_registerDataProduct_args&);
  Airavata_registerDataProduct_args& operator=(const Airavata_registerDataProduct_args&);
  Airavata_registerDataProduct_args() {
  }

  virtual ~Airavata_registerDataProduct_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::data::replica::DataProductModel dataProductModel;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataProductModel(const  ::apache::airavata::model::data::replica::DataProductModel& val);

  bool operator == (const Airavata_registerDataProduct_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataProductModel == rhs.dataProductModel))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerDataProduct_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerDataProduct_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerDataProduct_pargs {
 public:


  virtual ~Airavata_registerDataProduct_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::data::replica::DataProductModel* dataProductModel;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerDataProduct_result__isset {
  _Airavata_registerDataProduct_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerDataProduct_result__isset;

class Airavata_registerDataProduct_result {
 public:

  Airavata_registerDataProduct_result(const Airavata_registerDataProduct_result&);
  Airavata_registerDataProduct_result& operator=(const Airavata_registerDataProduct_result&);
  Airavata_registerDataProduct_result() : success() {
  }

  virtual ~Airavata_registerDataProduct_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerDataProduct_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerDataProduct_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerDataProduct_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerDataProduct_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerDataProduct_presult__isset {
  _Airavata_registerDataProduct_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerDataProduct_presult__isset;

class Airavata_registerDataProduct_presult {
 public:


  virtual ~Airavata_registerDataProduct_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerDataProduct_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getDataProduct_args {
 public:

  Airavata_getDataProduct_args(const Airavata_getDataProduct_args&);
  Airavata_getDataProduct_args& operator=(const Airavata_getDataProduct_args&);
  Airavata_getDataProduct_args() : dataProductUri() {
  }

  virtual ~Airavata_getDataProduct_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string dataProductUri;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_dataProductUri(const std::string& val);

  bool operator == (const Airavata_getDataProduct_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(dataProductUri == rhs.dataProductUri))
      return false;
    return true;
  }
  bool operator != (const Airavata_getDataProduct_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getDataProduct_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getDataProduct_pargs {
 public:


  virtual ~Airavata_getDataProduct_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* dataProductUri;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getDataProduct_result__isset {
  _Airavata_getDataProduct_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getDataProduct_result__isset;

class Airavata_getDataProduct_result {
 public:

  Airavata_getDataProduct_result(const Airavata_getDataProduct_result&);
  Airavata_getDataProduct_result& operator=(const Airavata_getDataProduct_result&);
  Airavata_getDataProduct_result() {
  }

  virtual ~Airavata_getDataProduct_result() throw();
   ::apache::airavata::model::data::replica::DataProductModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getDataProduct_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::replica::DataProductModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getDataProduct_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getDataProduct_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getDataProduct_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getDataProduct_presult__isset {
  _Airavata_getDataProduct_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getDataProduct_presult__isset;

class Airavata_getDataProduct_presult {
 public:


  virtual ~Airavata_getDataProduct_presult() throw();
   ::apache::airavata::model::data::replica::DataProductModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getDataProduct_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_registerReplicaLocation_args {
 public:

  Airavata_registerReplicaLocation_args(const Airavata_registerReplicaLocation_args&);
  Airavata_registerReplicaLocation_args& operator=(const Airavata_registerReplicaLocation_args&);
  Airavata_registerReplicaLocation_args() {
  }

  virtual ~Airavata_registerReplicaLocation_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::data::replica::DataReplicaLocationModel replicaLocationModel;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_replicaLocationModel(const  ::apache::airavata::model::data::replica::DataReplicaLocationModel& val);

  bool operator == (const Airavata_registerReplicaLocation_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(replicaLocationModel == rhs.replicaLocationModel))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerReplicaLocation_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerReplicaLocation_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_registerReplicaLocation_pargs {
 public:


  virtual ~Airavata_registerReplicaLocation_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::data::replica::DataReplicaLocationModel* replicaLocationModel;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerReplicaLocation_result__isset {
  _Airavata_registerReplicaLocation_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerReplicaLocation_result__isset;

class Airavata_registerReplicaLocation_result {
 public:

  Airavata_registerReplicaLocation_result(const Airavata_registerReplicaLocation_result&);
  Airavata_registerReplicaLocation_result& operator=(const Airavata_registerReplicaLocation_result&);
  Airavata_registerReplicaLocation_result() : success() {
  }

  virtual ~Airavata_registerReplicaLocation_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerReplicaLocation_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_registerReplicaLocation_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_registerReplicaLocation_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_registerReplicaLocation_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_registerReplicaLocation_presult__isset {
  _Airavata_registerReplicaLocation_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_registerReplicaLocation_presult__isset;

class Airavata_registerReplicaLocation_presult {
 public:


  virtual ~Airavata_registerReplicaLocation_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_registerReplicaLocation_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getParentDataProduct_args {
 public:

  Airavata_getParentDataProduct_args(const Airavata_getParentDataProduct_args&);
  Airavata_getParentDataProduct_args& operator=(const Airavata_getParentDataProduct_args&);
  Airavata_getParentDataProduct_args() : productUri() {
  }

  virtual ~Airavata_getParentDataProduct_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  bool operator == (const Airavata_getParentDataProduct_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    return true;
  }
  bool operator != (const Airavata_getParentDataProduct_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getParentDataProduct_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getParentDataProduct_pargs {
 public:


  virtual ~Airavata_getParentDataProduct_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getParentDataProduct_result__isset {
  _Airavata_getParentDataProduct_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getParentDataProduct_result__isset;

class Airavata_getParentDataProduct_result {
 public:

  Airavata_getParentDataProduct_result(const Airavata_getParentDataProduct_result&);
  Airavata_getParentDataProduct_result& operator=(const Airavata_getParentDataProduct_result&);
  Airavata_getParentDataProduct_result() {
  }

  virtual ~Airavata_getParentDataProduct_result() throw();
   ::apache::airavata::model::data::replica::DataProductModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getParentDataProduct_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::data::replica::DataProductModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getParentDataProduct_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getParentDataProduct_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getParentDataProduct_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getParentDataProduct_presult__isset {
  _Airavata_getParentDataProduct_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getParentDataProduct_presult__isset;

class Airavata_getParentDataProduct_presult {
 public:


  virtual ~Airavata_getParentDataProduct_presult() throw();
   ::apache::airavata::model::data::replica::DataProductModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getParentDataProduct_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getChildDataProducts_args {
 public:

  Airavata_getChildDataProducts_args(const Airavata_getChildDataProducts_args&);
  Airavata_getChildDataProducts_args& operator=(const Airavata_getChildDataProducts_args&);
  Airavata_getChildDataProducts_args() : productUri() {
  }

  virtual ~Airavata_getChildDataProducts_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string productUri;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_productUri(const std::string& val);

  bool operator == (const Airavata_getChildDataProducts_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(productUri == rhs.productUri))
      return false;
    return true;
  }
  bool operator != (const Airavata_getChildDataProducts_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getChildDataProducts_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getChildDataProducts_pargs {
 public:


  virtual ~Airavata_getChildDataProducts_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* productUri;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getChildDataProducts_result__isset {
  _Airavata_getChildDataProducts_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getChildDataProducts_result__isset;

class Airavata_getChildDataProducts_result {
 public:

  Airavata_getChildDataProducts_result(const Airavata_getChildDataProducts_result&);
  Airavata_getChildDataProducts_result& operator=(const Airavata_getChildDataProducts_result&);
  Airavata_getChildDataProducts_result() {
  }

  virtual ~Airavata_getChildDataProducts_result() throw();
  std::vector< ::apache::airavata::model::data::replica::DataProductModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getChildDataProducts_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::data::replica::DataProductModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getChildDataProducts_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getChildDataProducts_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getChildDataProducts_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getChildDataProducts_presult__isset {
  _Airavata_getChildDataProducts_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getChildDataProducts_presult__isset;

class Airavata_getChildDataProducts_presult {
 public:


  virtual ~Airavata_getChildDataProducts_presult() throw();
  std::vector< ::apache::airavata::model::data::replica::DataProductModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getChildDataProducts_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_shareResourceWithUsers_args__isset {
  _Airavata_shareResourceWithUsers_args__isset() : userPermissionList(false) {}
  bool userPermissionList :1;
} _Airavata_shareResourceWithUsers_args__isset;

class Airavata_shareResourceWithUsers_args {
 public:

  Airavata_shareResourceWithUsers_args(const Airavata_shareResourceWithUsers_args&);
  Airavata_shareResourceWithUsers_args& operator=(const Airavata_shareResourceWithUsers_args&);
  Airavata_shareResourceWithUsers_args() : resourceId(), resourceType(( ::apache::airavata::model::group::ResourceType::type)0) {
  }

  virtual ~Airavata_shareResourceWithUsers_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceId;
   ::apache::airavata::model::group::ResourceType::type resourceType;
  std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type>  userPermissionList;

  _Airavata_shareResourceWithUsers_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceId(const std::string& val);

  void __set_resourceType(const  ::apache::airavata::model::group::ResourceType::type val);

  void __set_userPermissionList(const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & val);

  bool operator == (const Airavata_shareResourceWithUsers_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceId == rhs.resourceId))
      return false;
    if (!(resourceType == rhs.resourceType))
      return false;
    if (!(userPermissionList == rhs.userPermissionList))
      return false;
    return true;
  }
  bool operator != (const Airavata_shareResourceWithUsers_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_shareResourceWithUsers_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_shareResourceWithUsers_pargs {
 public:


  virtual ~Airavata_shareResourceWithUsers_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceId;
  const  ::apache::airavata::model::group::ResourceType::type* resourceType;
  const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> * userPermissionList;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_shareResourceWithUsers_result__isset {
  _Airavata_shareResourceWithUsers_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_shareResourceWithUsers_result__isset;

class Airavata_shareResourceWithUsers_result {
 public:

  Airavata_shareResourceWithUsers_result(const Airavata_shareResourceWithUsers_result&);
  Airavata_shareResourceWithUsers_result& operator=(const Airavata_shareResourceWithUsers_result&);
  Airavata_shareResourceWithUsers_result() : success(0) {
  }

  virtual ~Airavata_shareResourceWithUsers_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_shareResourceWithUsers_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_shareResourceWithUsers_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_shareResourceWithUsers_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_shareResourceWithUsers_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_shareResourceWithUsers_presult__isset {
  _Airavata_shareResourceWithUsers_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_shareResourceWithUsers_presult__isset;

class Airavata_shareResourceWithUsers_presult {
 public:


  virtual ~Airavata_shareResourceWithUsers_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_shareResourceWithUsers_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct _Airavata_revokeSharingOfResourceFromUsers_args__isset {
  _Airavata_revokeSharingOfResourceFromUsers_args__isset() : userPermissionList(false) {}
  bool userPermissionList :1;
} _Airavata_revokeSharingOfResourceFromUsers_args__isset;

class Airavata_revokeSharingOfResourceFromUsers_args {
 public:

  Airavata_revokeSharingOfResourceFromUsers_args(const Airavata_revokeSharingOfResourceFromUsers_args&);
  Airavata_revokeSharingOfResourceFromUsers_args& operator=(const Airavata_revokeSharingOfResourceFromUsers_args&);
  Airavata_revokeSharingOfResourceFromUsers_args() : resourceId(), resourceType(( ::apache::airavata::model::group::ResourceType::type)0) {
  }

  virtual ~Airavata_revokeSharingOfResourceFromUsers_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceId;
   ::apache::airavata::model::group::ResourceType::type resourceType;
  std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type>  userPermissionList;

  _Airavata_revokeSharingOfResourceFromUsers_args__isset __isset;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceId(const std::string& val);

  void __set_resourceType(const  ::apache::airavata::model::group::ResourceType::type val);

  void __set_userPermissionList(const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> & val);

  bool operator == (const Airavata_revokeSharingOfResourceFromUsers_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceId == rhs.resourceId))
      return false;
    if (!(resourceType == rhs.resourceType))
      return false;
    if (!(userPermissionList == rhs.userPermissionList))
      return false;
    return true;
  }
  bool operator != (const Airavata_revokeSharingOfResourceFromUsers_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_revokeSharingOfResourceFromUsers_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_revokeSharingOfResourceFromUsers_pargs {
 public:


  virtual ~Airavata_revokeSharingOfResourceFromUsers_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceId;
  const  ::apache::airavata::model::group::ResourceType::type* resourceType;
  const std::map<std::string,  ::apache::airavata::model::group::ResourcePermissionType::type> * userPermissionList;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_revokeSharingOfResourceFromUsers_result__isset {
  _Airavata_revokeSharingOfResourceFromUsers_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_revokeSharingOfResourceFromUsers_result__isset;

class Airavata_revokeSharingOfResourceFromUsers_result {
 public:

  Airavata_revokeSharingOfResourceFromUsers_result(const Airavata_revokeSharingOfResourceFromUsers_result&);
  Airavata_revokeSharingOfResourceFromUsers_result& operator=(const Airavata_revokeSharingOfResourceFromUsers_result&);
  Airavata_revokeSharingOfResourceFromUsers_result() : success(0) {
  }

  virtual ~Airavata_revokeSharingOfResourceFromUsers_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_revokeSharingOfResourceFromUsers_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_revokeSharingOfResourceFromUsers_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_revokeSharingOfResourceFromUsers_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_revokeSharingOfResourceFromUsers_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_revokeSharingOfResourceFromUsers_presult__isset {
  _Airavata_revokeSharingOfResourceFromUsers_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_revokeSharingOfResourceFromUsers_presult__isset;

class Airavata_revokeSharingOfResourceFromUsers_presult {
 public:


  virtual ~Airavata_revokeSharingOfResourceFromUsers_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_revokeSharingOfResourceFromUsers_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllAccessibleUsers_args {
 public:

  Airavata_getAllAccessibleUsers_args(const Airavata_getAllAccessibleUsers_args&);
  Airavata_getAllAccessibleUsers_args& operator=(const Airavata_getAllAccessibleUsers_args&);
  Airavata_getAllAccessibleUsers_args() : resourceId(), resourceType(( ::apache::airavata::model::group::ResourceType::type)0), permissionType(( ::apache::airavata::model::group::ResourcePermissionType::type)0) {
  }

  virtual ~Airavata_getAllAccessibleUsers_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string resourceId;
   ::apache::airavata::model::group::ResourceType::type resourceType;
   ::apache::airavata::model::group::ResourcePermissionType::type permissionType;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_resourceId(const std::string& val);

  void __set_resourceType(const  ::apache::airavata::model::group::ResourceType::type val);

  void __set_permissionType(const  ::apache::airavata::model::group::ResourcePermissionType::type val);

  bool operator == (const Airavata_getAllAccessibleUsers_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(resourceId == rhs.resourceId))
      return false;
    if (!(resourceType == rhs.resourceType))
      return false;
    if (!(permissionType == rhs.permissionType))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllAccessibleUsers_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllAccessibleUsers_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllAccessibleUsers_pargs {
 public:


  virtual ~Airavata_getAllAccessibleUsers_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* resourceId;
  const  ::apache::airavata::model::group::ResourceType::type* resourceType;
  const  ::apache::airavata::model::group::ResourcePermissionType::type* permissionType;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllAccessibleUsers_result__isset {
  _Airavata_getAllAccessibleUsers_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllAccessibleUsers_result__isset;

class Airavata_getAllAccessibleUsers_result {
 public:

  Airavata_getAllAccessibleUsers_result(const Airavata_getAllAccessibleUsers_result&);
  Airavata_getAllAccessibleUsers_result& operator=(const Airavata_getAllAccessibleUsers_result&);
  Airavata_getAllAccessibleUsers_result() {
  }

  virtual ~Airavata_getAllAccessibleUsers_result() throw();
  std::vector<std::string>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllAccessibleUsers_result__isset __isset;

  void __set_success(const std::vector<std::string> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllAccessibleUsers_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllAccessibleUsers_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllAccessibleUsers_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllAccessibleUsers_presult__isset {
  _Airavata_getAllAccessibleUsers_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllAccessibleUsers_presult__isset;

class Airavata_getAllAccessibleUsers_presult {
 public:


  virtual ~Airavata_getAllAccessibleUsers_presult() throw();
  std::vector<std::string> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllAccessibleUsers_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_createGroup_args {
 public:

  Airavata_createGroup_args(const Airavata_createGroup_args&);
  Airavata_createGroup_args& operator=(const Airavata_createGroup_args&);
  Airavata_createGroup_args() {
  }

  virtual ~Airavata_createGroup_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::group::GroupModel groupModel;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_groupModel(const  ::apache::airavata::model::group::GroupModel& val);

  bool operator == (const Airavata_createGroup_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(groupModel == rhs.groupModel))
      return false;
    return true;
  }
  bool operator != (const Airavata_createGroup_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createGroup_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_createGroup_pargs {
 public:


  virtual ~Airavata_createGroup_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::group::GroupModel* groupModel;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createGroup_result__isset {
  _Airavata_createGroup_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createGroup_result__isset;

class Airavata_createGroup_result {
 public:

  Airavata_createGroup_result(const Airavata_createGroup_result&);
  Airavata_createGroup_result& operator=(const Airavata_createGroup_result&);
  Airavata_createGroup_result() : success() {
  }

  virtual ~Airavata_createGroup_result() throw();
  std::string success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createGroup_result__isset __isset;

  void __set_success(const std::string& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_createGroup_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_createGroup_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_createGroup_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_createGroup_presult__isset {
  _Airavata_createGroup_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_createGroup_presult__isset;

class Airavata_createGroup_presult {
 public:


  virtual ~Airavata_createGroup_presult() throw();
  std::string* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_createGroup_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_updateGroup_args {
 public:

  Airavata_updateGroup_args(const Airavata_updateGroup_args&);
  Airavata_updateGroup_args& operator=(const Airavata_updateGroup_args&);
  Airavata_updateGroup_args() {
  }

  virtual ~Airavata_updateGroup_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
   ::apache::airavata::model::group::GroupModel groupModel;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_groupModel(const  ::apache::airavata::model::group::GroupModel& val);

  bool operator == (const Airavata_updateGroup_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(groupModel == rhs.groupModel))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGroup_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGroup_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_updateGroup_pargs {
 public:


  virtual ~Airavata_updateGroup_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const  ::apache::airavata::model::group::GroupModel* groupModel;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGroup_result__isset {
  _Airavata_updateGroup_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGroup_result__isset;

class Airavata_updateGroup_result {
 public:

  Airavata_updateGroup_result(const Airavata_updateGroup_result&);
  Airavata_updateGroup_result& operator=(const Airavata_updateGroup_result&);
  Airavata_updateGroup_result() : success(0) {
  }

  virtual ~Airavata_updateGroup_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGroup_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_updateGroup_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_updateGroup_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_updateGroup_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_updateGroup_presult__isset {
  _Airavata_updateGroup_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_updateGroup_presult__isset;

class Airavata_updateGroup_presult {
 public:


  virtual ~Airavata_updateGroup_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_updateGroup_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_deleteGroup_args {
 public:

  Airavata_deleteGroup_args(const Airavata_deleteGroup_args&);
  Airavata_deleteGroup_args& operator=(const Airavata_deleteGroup_args&);
  Airavata_deleteGroup_args() : groupId(), ownerId() {
  }

  virtual ~Airavata_deleteGroup_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string groupId;
  std::string ownerId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_groupId(const std::string& val);

  void __set_ownerId(const std::string& val);

  bool operator == (const Airavata_deleteGroup_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(groupId == rhs.groupId))
      return false;
    if (!(ownerId == rhs.ownerId))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGroup_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGroup_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_deleteGroup_pargs {
 public:


  virtual ~Airavata_deleteGroup_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* groupId;
  const std::string* ownerId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGroup_result__isset {
  _Airavata_deleteGroup_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGroup_result__isset;

class Airavata_deleteGroup_result {
 public:

  Airavata_deleteGroup_result(const Airavata_deleteGroup_result&);
  Airavata_deleteGroup_result& operator=(const Airavata_deleteGroup_result&);
  Airavata_deleteGroup_result() : success(0) {
  }

  virtual ~Airavata_deleteGroup_result() throw();
  bool success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGroup_result__isset __isset;

  void __set_success(const bool val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_deleteGroup_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_deleteGroup_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_deleteGroup_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_deleteGroup_presult__isset {
  _Airavata_deleteGroup_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_deleteGroup_presult__isset;

class Airavata_deleteGroup_presult {
 public:


  virtual ~Airavata_deleteGroup_presult() throw();
  bool* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_deleteGroup_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getGroup_args {
 public:

  Airavata_getGroup_args(const Airavata_getGroup_args&);
  Airavata_getGroup_args& operator=(const Airavata_getGroup_args&);
  Airavata_getGroup_args() : groupId() {
  }

  virtual ~Airavata_getGroup_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string groupId;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_groupId(const std::string& val);

  bool operator == (const Airavata_getGroup_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(groupId == rhs.groupId))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGroup_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGroup_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getGroup_pargs {
 public:


  virtual ~Airavata_getGroup_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* groupId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGroup_result__isset {
  _Airavata_getGroup_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGroup_result__isset;

class Airavata_getGroup_result {
 public:

  Airavata_getGroup_result(const Airavata_getGroup_result&);
  Airavata_getGroup_result& operator=(const Airavata_getGroup_result&);
  Airavata_getGroup_result() {
  }

  virtual ~Airavata_getGroup_result() throw();
   ::apache::airavata::model::group::GroupModel success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGroup_result__isset __isset;

  void __set_success(const  ::apache::airavata::model::group::GroupModel& val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getGroup_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getGroup_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getGroup_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getGroup_presult__isset {
  _Airavata_getGroup_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getGroup_presult__isset;

class Airavata_getGroup_presult {
 public:


  virtual ~Airavata_getGroup_presult() throw();
   ::apache::airavata::model::group::GroupModel* success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getGroup_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};


class Airavata_getAllGroupsUserBelongs_args {
 public:

  Airavata_getAllGroupsUserBelongs_args(const Airavata_getAllGroupsUserBelongs_args&);
  Airavata_getAllGroupsUserBelongs_args& operator=(const Airavata_getAllGroupsUserBelongs_args&);
  Airavata_getAllGroupsUserBelongs_args() : userName() {
  }

  virtual ~Airavata_getAllGroupsUserBelongs_args() throw();
   ::apache::airavata::model::security::AuthzToken authzToken;
  std::string userName;

  void __set_authzToken(const  ::apache::airavata::model::security::AuthzToken& val);

  void __set_userName(const std::string& val);

  bool operator == (const Airavata_getAllGroupsUserBelongs_args & rhs) const
  {
    if (!(authzToken == rhs.authzToken))
      return false;
    if (!(userName == rhs.userName))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGroupsUserBelongs_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGroupsUserBelongs_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class Airavata_getAllGroupsUserBelongs_pargs {
 public:


  virtual ~Airavata_getAllGroupsUserBelongs_pargs() throw();
  const  ::apache::airavata::model::security::AuthzToken* authzToken;
  const std::string* userName;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGroupsUserBelongs_result__isset {
  _Airavata_getAllGroupsUserBelongs_result__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGroupsUserBelongs_result__isset;

class Airavata_getAllGroupsUserBelongs_result {
 public:

  Airavata_getAllGroupsUserBelongs_result(const Airavata_getAllGroupsUserBelongs_result&);
  Airavata_getAllGroupsUserBelongs_result& operator=(const Airavata_getAllGroupsUserBelongs_result&);
  Airavata_getAllGroupsUserBelongs_result() {
  }

  virtual ~Airavata_getAllGroupsUserBelongs_result() throw();
  std::vector< ::apache::airavata::model::group::GroupModel>  success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGroupsUserBelongs_result__isset __isset;

  void __set_success(const std::vector< ::apache::airavata::model::group::GroupModel> & val);

  void __set_ire(const  ::apache::airavata::api::error::InvalidRequestException& val);

  void __set_ace(const  ::apache::airavata::api::error::AiravataClientException& val);

  void __set_ase(const  ::apache::airavata::api::error::AiravataSystemException& val);

  void __set_ae(const  ::apache::airavata::api::error::AuthorizationException& val);

  bool operator == (const Airavata_getAllGroupsUserBelongs_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(ire == rhs.ire))
      return false;
    if (!(ace == rhs.ace))
      return false;
    if (!(ase == rhs.ase))
      return false;
    if (!(ae == rhs.ae))
      return false;
    return true;
  }
  bool operator != (const Airavata_getAllGroupsUserBelongs_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Airavata_getAllGroupsUserBelongs_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Airavata_getAllGroupsUserBelongs_presult__isset {
  _Airavata_getAllGroupsUserBelongs_presult__isset() : success(false), ire(false), ace(false), ase(false), ae(false) {}
  bool success :1;
  bool ire :1;
  bool ace :1;
  bool ase :1;
  bool ae :1;
} _Airavata_getAllGroupsUserBelongs_presult__isset;

class Airavata_getAllGroupsUserBelongs_presult {
 public:


  virtual ~Airavata_getAllGroupsUserBelongs_presult() throw();
  std::vector< ::apache::airavata::model::group::GroupModel> * success;
   ::apache::airavata::api::error::InvalidRequestException ire;
   ::apache::airavata::api::error::AiravataClientException ace;
   ::apache::airavata::api::error::AiravataSystemException ase;
   ::apache::airavata::api::error::AuthorizationException ae;

  _Airavata_getAllGroupsUserBelongs_presult__isset __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class AiravataClient : virtual public AiravataIf {
 public:
  AiravataClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
    setProtocol(prot);
  }
  AiravataClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    setProtocol(iprot,oprot);
  }
 private:
  void setProtocol(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
  setProtocol(prot,prot);
  }
  void setProtocol(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    piprot_=iprot;
    poprot_=oprot;
    iprot_ = iprot.get();
    oprot_ = oprot.get();
  }
 public:
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getInputProtocol() {
    return piprot_;
  }
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getOutputProtocol() {
    return poprot_;
  }
  void getAPIVersion(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void send_getAPIVersion(const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void recv_getAPIVersion(std::string& _return);
  bool isUserExists(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName);
  void send_isUserExists(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName);
  bool recv_isUserExists();
  void addGateway(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Gateway& gateway);
  void send_addGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Gateway& gateway);
  void recv_addGateway(std::string& _return);
  void getAllUsersInGateway(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllUsersInGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllUsersInGateway(std::vector<std::string> & _return);
  bool updateGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Gateway& updatedGateway);
  void send_updateGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Gateway& updatedGateway);
  bool recv_updateGateway();
  void getGateway( ::apache::airavata::model::workspace::Gateway& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getGateway( ::apache::airavata::model::workspace::Gateway& _return);
  bool deleteGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_deleteGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  bool recv_deleteGateway();
  void getAllGateways(std::vector< ::apache::airavata::model::workspace::Gateway> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void send_getAllGateways(const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void recv_getAllGateways(std::vector< ::apache::airavata::model::workspace::Gateway> & _return);
  bool isGatewayExist(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_isGatewayExist(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  bool recv_isGatewayExist();
  void createNotification(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification);
  void send_createNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification);
  void recv_createNotification(std::string& _return);
  bool updateNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification);
  void send_updateNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::workspace::Notification& notification);
  bool recv_updateNotification();
  bool deleteNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId);
  void send_deleteNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId);
  bool recv_deleteNotification();
  void getNotification( ::apache::airavata::model::workspace::Notification& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId);
  void send_getNotification(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& notificationId);
  void recv_getNotification( ::apache::airavata::model::workspace::Notification& _return);
  void getAllNotifications(std::vector< ::apache::airavata::model::workspace::Notification> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllNotifications(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllNotifications(std::vector< ::apache::airavata::model::workspace::Notification> & _return);
  void generateAndRegisterSSHKeys(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::string& description, const  ::CredentialOwnerType::type credentialOwnerType);
  void send_generateAndRegisterSSHKeys(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::string& description, const  ::CredentialOwnerType::type credentialOwnerType);
  void recv_generateAndRegisterSSHKeys(std::string& _return);
  void registerPwdCredential(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& portalUserName, const std::string& loginUserName, const std::string& password, const std::string& description);
  void send_registerPwdCredential(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& portalUserName, const std::string& loginUserName, const std::string& password, const std::string& description);
  void recv_registerPwdCredential(std::string& _return);
  void getSSHPubKey(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  void send_getSSHPubKey(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  void recv_getSSHPubKey(std::string& _return);
  void getAllGatewaySSHPubKeys(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllGatewaySSHPubKeys(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllGatewaySSHPubKeys(std::map<std::string, std::string> & _return);
  void getAllCredentialSummaryForGateway(std::vector< ::CredentialSummary> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId);
  void send_getAllCredentialSummaryForGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId);
  void recv_getAllCredentialSummaryForGateway(std::vector< ::CredentialSummary> & _return);
  void getAllCredentialSummaryForUsersInGateway(std::vector< ::CredentialSummary> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId, const std::string& userId);
  void send_getAllCredentialSummaryForUsersInGateway(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::SummaryType::type type, const std::string& gatewayId, const std::string& userId);
  void recv_getAllCredentialSummaryForUsersInGateway(std::vector< ::CredentialSummary> & _return);
  void getAllGatewayPWDCredentials(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllGatewayPWDCredentials(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllGatewayPWDCredentials(std::map<std::string, std::string> & _return);
  bool deleteSSHPubKey(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  void send_deleteSSHPubKey(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  bool recv_deleteSSHPubKey();
  bool deletePWDCredential(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  void send_deletePWDCredential(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataCredStoreToken, const std::string& gatewayId);
  bool recv_deletePWDCredential();
  void createProject(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Project& project);
  void send_createProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::workspace::Project& project);
  void recv_createProject(std::string& _return);
  void updateProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const  ::apache::airavata::model::workspace::Project& updatedProject);
  void send_updateProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const  ::apache::airavata::model::workspace::Project& updatedProject);
  void recv_updateProject();
  void getProject( ::apache::airavata::model::workspace::Project& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId);
  void send_getProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId);
  void recv_getProject( ::apache::airavata::model::workspace::Project& _return);
  bool deleteProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId);
  void send_deleteProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId);
  bool recv_deleteProject();
  void getUserProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset);
  void send_getUserProjects(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset);
  void recv_getUserProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return);
  void searchProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset);
  void send_searchProjects(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ProjectSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset);
  void recv_searchProjects(std::vector< ::apache::airavata::model::workspace::Project> & _return);
  void searchExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset);
  void send_searchExperiments(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const std::map< ::apache::airavata::model::experiment::ExperimentSearchFields::type, std::string> & filters, const int32_t limit, const int32_t offset);
  void recv_searchExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentSummaryModel> & _return);
  void getExperimentStatistics( ::apache::airavata::model::experiment::ExperimentStatistics& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const int64_t fromTime, const int64_t toTime, const std::string& userName, const std::string& applicationName, const std::string& resourceHostName);
  void send_getExperimentStatistics(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const int64_t fromTime, const int64_t toTime, const std::string& userName, const std::string& applicationName, const std::string& resourceHostName);
  void recv_getExperimentStatistics( ::apache::airavata::model::experiment::ExperimentStatistics& _return);
  void getExperimentsInProject(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const int32_t limit, const int32_t offset);
  void send_getExperimentsInProject(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& projectId, const int32_t limit, const int32_t offset);
  void recv_getExperimentsInProject(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return);
  void getUserExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset);
  void send_getUserExperiments(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const std::string& userName, const int32_t limit, const int32_t offset);
  void recv_getUserExperiments(std::vector< ::apache::airavata::model::experiment::ExperimentModel> & _return);
  void createExperiment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment);
  void send_createExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment);
  void recv_createExperiment(std::string& _return);
  bool deleteExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& experimentId);
  void send_deleteExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& experimentId);
  bool recv_deleteExperiment();
  void getExperiment( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getExperiment( ::apache::airavata::model::experiment::ExperimentModel& _return);
  void getExperimentByAdmin( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getExperimentByAdmin(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getExperimentByAdmin( ::apache::airavata::model::experiment::ExperimentModel& _return);
  void getDetailedExperimentTree( ::apache::airavata::model::experiment::ExperimentModel& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getDetailedExperimentTree(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getDetailedExperimentTree( ::apache::airavata::model::experiment::ExperimentModel& _return);
  void updateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment);
  void send_updateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::ExperimentModel& experiment);
  void recv_updateExperiment();
  void updateExperimentConfiguration(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::UserConfigurationDataModel& userConfiguration);
  void send_updateExperimentConfiguration(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::experiment::UserConfigurationDataModel& userConfiguration);
  void recv_updateExperimentConfiguration();
  void updateResourceScheduleing(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& resourceScheduling);
  void send_updateResourceScheduleing(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& resourceScheduling);
  void recv_updateResourceScheduleing();
  bool validateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_validateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  bool recv_validateExperiment();
  void launchExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId);
  void send_launchExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId);
  void recv_launchExperiment();
  void getExperimentStatus( ::apache::airavata::model::status::ExperimentStatus& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getExperimentStatus(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getExperimentStatus( ::apache::airavata::model::status::ExperimentStatus& _return);
  void getExperimentOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getExperimentOutputs(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getExperimentOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return);
  void getIntermediateOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getIntermediateOutputs(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getIntermediateOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return);
  void getJobStatuses(std::map<std::string,  ::apache::airavata::model::status::JobStatus> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getJobStatuses(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getJobStatuses(std::map<std::string,  ::apache::airavata::model::status::JobStatus> & _return);
  void getJobDetails(std::vector< ::apache::airavata::model::job::JobModel> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void send_getJobDetails(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId);
  void recv_getJobDetails(std::vector< ::apache::airavata::model::job::JobModel> & _return);
  void cloneExperiment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId);
  void send_cloneExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId);
  void recv_cloneExperiment(std::string& _return);
  void cloneExperimentByAdmin(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId);
  void send_cloneExperimentByAdmin(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingExperimentID, const std::string& newExperimentName, const std::string& newExperimentProjectId);
  void recv_cloneExperimentByAdmin(std::string& _return);
  void terminateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId);
  void send_terminateExperiment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& airavataExperimentId, const std::string& gatewayId);
  void recv_terminateExperiment();
  void registerApplicationModule(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule);
  void send_registerApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule);
  void recv_registerApplicationModule(std::string& _return);
  void getApplicationModule( ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  void send_getApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  void recv_getApplicationModule( ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& _return);
  bool updateApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule);
  void send_updateApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule& applicationModule);
  bool recv_updateApplicationModule();
  void getAllAppModules(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllAppModules(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllAppModules(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationModule> & _return);
  bool deleteApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  void send_deleteApplicationModule(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  bool recv_deleteApplicationModule();
  void registerApplicationDeployment(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment);
  void send_registerApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment);
  void recv_registerApplicationDeployment(std::string& _return);
  void getApplicationDeployment( ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId);
  void send_getApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId);
  void recv_getApplicationDeployment( ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& _return);
  bool updateApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment);
  void send_updateApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId, const  ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription& applicationDeployment);
  bool recv_updateApplicationDeployment();
  bool deleteApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId);
  void send_deleteApplicationDeployment(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appDeploymentId);
  bool recv_deleteApplicationDeployment();
  void getAllApplicationDeployments(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllApplicationDeployments(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllApplicationDeployments(std::vector< ::apache::airavata::model::appcatalog::appdeployment::ApplicationDeploymentDescription> & _return);
  void getAppModuleDeployedResources(std::vector<std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  void send_getAppModuleDeployedResources(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appModuleId);
  void recv_getAppModuleDeployedResources(std::vector<std::string> & _return);
  void registerApplicationInterface(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface);
  void send_registerApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface);
  void recv_registerApplicationInterface(std::string& _return);
  void cloneApplicationInterface(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingAppInterfaceID, const std::string& newApplicationName, const std::string& gatewayId);
  void send_cloneApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& existingAppInterfaceID, const std::string& newApplicationName, const std::string& gatewayId);
  void recv_cloneApplicationInterface(std::string& _return);
  void getApplicationInterface( ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void send_getApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void recv_getApplicationInterface( ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& _return);
  bool updateApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface);
  void send_updateApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId, const  ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription& applicationInterface);
  bool recv_updateApplicationInterface();
  bool deleteApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void send_deleteApplicationInterface(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  bool recv_deleteApplicationInterface();
  void getAllApplicationInterfaceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllApplicationInterfaceNames(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllApplicationInterfaceNames(std::map<std::string, std::string> & _return);
  void getAllApplicationInterfaces(std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void send_getAllApplicationInterfaces(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& gatewayId);
  void recv_getAllApplicationInterfaces(std::vector< ::apache::airavata::model::appcatalog::appinterface::ApplicationInterfaceDescription> & _return);
  void getApplicationInputs(std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void send_getApplicationInputs(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void recv_getApplicationInputs(std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & _return);
  void getApplicationOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void send_getApplicationOutputs(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void recv_getApplicationOutputs(std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & _return);
  void getAvailableAppInterfaceComputeResources(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void send_getAvailableAppInterfaceComputeResources(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& appInterfaceId);
  void recv_getAvailableAppInterfaceComputeResources(std::map<std::string, std::string> & _return);
  void registerComputeResource(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription);
  void send_registerComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription);
  void recv_registerComputeResource(std::string& _return);
  void getComputeResource( ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId);
  void send_getComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId);
  void recv_getComputeResource( ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& _return);
  void getAllComputeResourceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void send_getAllComputeResourceNames(const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void recv_getAllComputeResourceNames(std::map<std::string, std::string> & _return);
  bool updateComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription);
  void send_updateComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId, const  ::apache::airavata::model::appcatalog::computeresource::ComputeResourceDescription& computeResourceDescription);
  bool recv_updateComputeResource();
  bool deleteComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId);
  void send_deleteComputeResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& computeResourceId);
  bool recv_deleteComputeResource();
  void registerStorageResource(std::string& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& storageResourceDescription);
  void send_registerStorageResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& storageResourceDescription);
  void recv_registerStorageResource(std::string& _return);
  void getStorageResource( ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& _return, const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId);
  void send_getStorageResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId);
  void recv_getStorageResource( ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription& _return);
  void getAllStorageResourceNames(std::map<std::string, std::string> & _return, const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void send_getAllStorageResourceNames(const  ::apache::airavata::model::security::AuthzToken& authzToken);
  void recv_getAllStorageResourceNames(std::map<std::string, std::string> & _return);
  bool updateStorageResource(const  ::apache::airavata::model::security::AuthzToken& authzToken, const std::string& storageResourceId, const  ::apache::airavata::model::appcatalog::storageresource::StorageResourceDescription