/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import de.fzj.unicore.uas.client.StorageClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.common.utils.Constants;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.FileDownloader;
import org.apache.airavata.gfac.impl.task.utils.bes.FileUploader;
import org.apache.airavata.gfac.impl.task.utils.bes.Mode;
import org.apache.airavata.gfac.impl.task.utils.bes.UASDataStagingProcessor;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferrer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ProcessContext processContext;
    protected StorageClient storageClient;
    protected List<OutputDataObjectType> resultantOutputsLst;
    protected String gatewayDownloadLocation;
    protected String stdoutLocation;
    protected String stderrLocation;

    public DataTransferrer(ProcessContext processContext, StorageClient storageClient) {
        this.processContext = processContext;
        this.storageClient = storageClient;
        this.resultantOutputsLst = new ArrayList<OutputDataObjectType>();
        this.initStdoutsLocation();
    }

    private void initStdoutsLocation() {
        this.gatewayDownloadLocation = this.getDownloadLocation();
        String stdout = this.processContext.getStdoutLocation();
        String stderr = this.processContext.getStderrLocation();
        if (stdout != null) {
            stdout = stdout.substring(stdout.lastIndexOf(47) + 1);
        }
        if (stderr != null) {
            stderr = stderr.substring(stderr.lastIndexOf(47) + 1);
        }
        String stdoutFileName = stdout == null || stdout.equals("") ? "stdout" : stdout;
        String stderrFileName = stdout == null || stderr.equals("") ? "stderr" : stderr;
        this.stdoutLocation = this.gatewayDownloadLocation + File.separator + stdoutFileName;
        this.stderrLocation = this.gatewayDownloadLocation + File.separator + stderrFileName;
        List processOutputs = this.processContext.getProcessModel().getProcessOutputs();
        if (processOutputs != null && !processOutputs.isEmpty()) {
            for (OutputDataObjectType processOutput : processOutputs) {
                if (processOutput.getType().equals((Object)DataType.STDOUT)) {
                    processOutput.setValue(this.stdoutLocation);
                }
                if (!processOutput.getType().equals((Object)DataType.STDERR)) continue;
                processOutput.setValue(this.stderrLocation);
            }
        }
    }

    public void uploadLocalFiles() throws GFacException {
        ArrayList<String> inFilePrms = new ArrayList<String>();
        inFilePrms.addAll(this.extractInFileParams());
        for (String uri : inFilePrms) {
            String fileName = new File(uri).getName();
            if (!uri.startsWith("file")) continue;
            try {
                String uriWithoutProtocol = uri.substring(uri.lastIndexOf("://") + 2, uri.length());
                FileUploader fileUploader = new FileUploader(uriWithoutProtocol, fileName, Mode.overwrite, false);
                this.log.info("Uploading file {}", (Object)fileName);
                fileUploader.perform(this.storageClient);
            }
            catch (FileNotFoundException e3) {
                throw new GFacException("Error while staging-in, local file " + fileName + " not found", (Throwable)e3);
            }
            catch (Exception e) {
                throw new GFacException("Cannot upload files", (Throwable)e);
            }
        }
    }

    public List<String> extractInFileParams() {
        ArrayList<String> filePrmsList = new ArrayList<String>();
        List applicationInputs = this.processContext.getProcessModel().getProcessInputs();
        if (applicationInputs != null && !applicationInputs.isEmpty()) {
            for (InputDataObjectType output : applicationInputs) {
                if (!output.getType().equals((Object)DataType.URI)) continue;
                filePrmsList.add(output.getValue());
            }
        }
        return filePrmsList;
    }

    public void setStorageClient(StorageClient sc) {
        this.storageClient = sc;
    }

    public void downloadStdOuts() throws GFacException {
        String stdoutFileName = new File(this.stdoutLocation).getName();
        String stderrFileName = new File(this.stderrLocation).getName();
        FileDownloader f1 = null;
        this.log.info("Downloading stdout and stderr..");
        this.log.info(stdoutFileName + " -> " + this.stdoutLocation);
        f1 = new FileDownloader(stdoutFileName, this.stdoutLocation, Mode.overwrite);
        try {
            f1.perform(this.storageClient);
        }
        catch (Exception e) {
            this.log.error("Error while downloading " + stdoutFileName + " to location " + this.stdoutLocation, (Throwable)e);
        }
        this.log.info(stderrFileName + " -> " + this.stderrLocation);
        f1.setFrom(stderrFileName);
        f1.setTo(this.stderrLocation);
        try {
            f1.perform(this.storageClient);
        }
        catch (Exception e) {
            this.log.error("Error while downloading " + stderrFileName + " to location " + this.stderrLocation);
        }
        String scriptExitCodeFName = "UNICORE_SCRIPT_EXIT_CODE";
        String scriptCodeLocation = this.gatewayDownloadLocation + File.separator + scriptExitCodeFName;
        if (UASDataStagingProcessor.isUnicoreEndpoint(this.processContext)) {
            f1.setFrom(scriptExitCodeFName);
            f1.setTo(scriptCodeLocation);
            try {
                f1.perform(this.storageClient);
                OutputDataObjectType output = new OutputDataObjectType();
                output.setName(scriptExitCodeFName);
                output.setValue(scriptCodeLocation);
                output.setType(DataType.URI);
                output.setIsRequired(true);
                this.processContext.getProcessModel().getProcessOutputs().add(output);
                this.log.info("UNICORE_SCRIPT_EXIT_CODE -> " + scriptCodeLocation);
                this.log.info("EXIT CODE: " + this.readFile(scriptCodeLocation));
            }
            catch (Exception e) {
                this.log.error("Error downloading file " + scriptExitCodeFName + " to location " + scriptCodeLocation, (Throwable)e);
            }
        }
    }

    private String readFile(String localFile) throws IOException {
        BufferedReader instream = new BufferedReader(new FileReader(localFile));
        StringBuffer buff = new StringBuffer();
        String temp = null;
        while ((temp = instream.readLine()) != null) {
            buff.append(temp);
            buff.append(Constants.NEWLINE);
        }
        this.log.info("finish read file:" + localFile);
        return buff.toString();
    }

    private String getDownloadLocation() {
        File file;
        ProcessModel processModel = this.processContext.getProcessModel();
        String outputDataDir = "";
        if (this.processContext.getOutputDir() != null) {
            outputDataDir = this.processContext.getOutputDir();
            if ("".equals(outputDataDir)) {
                outputDataDir = this.getTempPath();
            } else if (outputDataDir.startsWith("scp:") || outputDataDir.startsWith("ftp:") || outputDataDir.startsWith("gsiftp:")) {
                outputDataDir = this.getTempPath();
            } else if (outputDataDir.startsWith("file:") && outputDataDir.contains("@")) {
                outputDataDir = this.getTempPath();
            } else {
                try {
                    URI u = new URI(outputDataDir);
                    outputDataDir = u.getPath();
                }
                catch (URISyntaxException e) {
                    outputDataDir = this.getTempPath();
                }
            }
        }
        if (!(file = new File(outputDataDir)).exists()) {
            file.mkdirs();
        }
        return outputDataDir;
    }

    private String getTempPath() {
        String tmpOutputDir = File.separator + "tmp" + File.separator + this.processContext.getProcessId();
        new File(tmpOutputDir).mkdirs();
        return tmpOutputDir;
    }

    public List<OutputDataObjectType> downloadRemoteFiles() throws GFacException {
        List applicationOutputs;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Download location is:" + this.gatewayDownloadLocation);
        }
        if ((applicationOutputs = this.processContext.getProcessModel().getProcessOutputs()) != null && !applicationOutputs.isEmpty()) {
            for (OutputDataObjectType output : applicationOutputs) {
                if ("".equals(output.getValue()) || output.getValue() == null) continue;
                if (output.getType().equals((Object)DataType.STDOUT)) {
                    output.setValue(this.stdoutLocation);
                    this.resultantOutputsLst.add(output);
                    continue;
                }
                if (output.getType().equals((Object)DataType.STDERR)) {
                    output.setValue(this.stderrLocation);
                    this.resultantOutputsLst.add(output);
                    continue;
                }
                if (output.getType().equals((Object)DataType.URI)) {
                    String value = null;
                    value = !output.getLocation().isEmpty() ? output.getLocation() + File.separator + output.getValue() : output.getValue();
                    String outputPath = this.gatewayDownloadLocation + File.separator + output.getValue();
                    File f = new File(this.gatewayDownloadLocation);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    FileDownloader fileDownloader = new FileDownloader(value, outputPath, Mode.overwrite);
                    try {
                        this.log.info("Downloading file {}", (Object)value);
                        fileDownloader.perform(this.storageClient);
                        output.setType(DataType.URI);
                        output.setValue(outputPath);
                        this.resultantOutputsLst.add(output);
                    }
                    catch (Exception e) {
                        this.log.error("Error downloading " + value + " from job working directory. ");
                    }
                    continue;
                }
                this.log.info("Ignore output file {}, type {}", (Object)output.getValue(), (Object)output.getType().toString());
            }
        }
        this.downloadStdOuts();
        return this.resultantOutputsLst;
    }

    public void publishFinalOutputs() throws GFacException {
        try {
            if (!this.resultantOutputsLst.isEmpty()) {
                this.log.debug("Publishing the list of outputs to the registry instance..");
                ExperimentCatalog experimentCatalog = this.processContext.getExperimentCatalog();
                experimentCatalog.add(ExpCatChildDataType.EXPERIMENT_OUTPUT, this.resultantOutputsLst, (Object)this.processContext.getExperimentId());
            }
        }
        catch (RegistryException e) {
            throw new GFacException("Cannot publish outputs to the registry.");
        }
    }
}

