/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;

class FSDatasetAsyncDiskService {
    public static final Log LOG = LogFactory.getLog(FSDatasetAsyncDiskService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 4;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final ThreadGroup threadGroup = new ThreadGroup("async disk service");
    private ThreadFactory threadFactory;
    private HashMap<File, ThreadPoolExecutor> executors = new HashMap();

    FSDatasetAsyncDiskService(File[] volumes) {
        this.threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(FSDatasetAsyncDiskService.this.threadGroup, r);
            }
        };
        for (int v = 0; v < volumes.length; ++v) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactory);
            executor.allowCoreThreadTimeOut(true);
            this.executors.put(volumes[v], executor);
        }
    }

    synchronized void execute(File root, Runnable task) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncDiskService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(root);
        if (executor == null) {
            throw new RuntimeException("Cannot find root " + root + " for execution of task " + task);
        }
        executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executors == null) {
            LOG.warn((Object)"AsyncDiskService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async disk service threads...");
            for (Map.Entry<File, ThreadPoolExecutor> e : this.executors.entrySet()) {
                e.getValue().shutdown();
            }
            this.executors = null;
            LOG.info((Object)"All async disk service threads have been shut down.");
        }
    }

    void deleteAsync(FSDataset.FSVolume volume, File blockFile, File metaFile, long dfsBytes, String blockName) {
        DataNode.LOG.info((Object)("Scheduling block " + blockName + " file " + blockFile + " for deletion"));
        ReplicaFileDeleteTask deletionTask = new ReplicaFileDeleteTask(volume, blockFile, metaFile, dfsBytes, blockName);
        this.execute(volume.getCurrentDir(), deletionTask);
    }

    static class ReplicaFileDeleteTask
    implements Runnable {
        FSDataset.FSVolume volume;
        File blockFile;
        File metaFile;
        long dfsBytes;
        String blockName;

        ReplicaFileDeleteTask(FSDataset.FSVolume volume, File blockFile, File metaFile, long dfsBytes, String blockName) {
            this.volume = volume;
            this.blockFile = blockFile;
            this.metaFile = metaFile;
            this.dfsBytes = dfsBytes;
            this.blockName = blockName;
        }

        FSDataset.FSVolume getVolume() {
            return this.volume;
        }

        public String toString() {
            return "deletion of block " + this.blockName + " with block file " + this.blockFile + " and meta file " + this.metaFile + " from volume " + this.volume;
        }

        @Override
        public void run() {
            if (!this.blockFile.delete() || !this.metaFile.delete() && this.metaFile.exists()) {
                DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + this.blockName + " at file " + this.blockFile + ". Ignored."));
            } else {
                this.volume.decDfsUsed(this.dfsBytes);
                DataNode.LOG.info((Object)("Deleted block " + this.blockName + " at file " + this.blockFile));
            }
        }
    }
}

