/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return this.getObject(string, byArray);
    }

    private DERObject getObject(String string, byte[] byArray) throws AnnotatedException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AnnotatedException("exception processing extension " + string, iOException);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i = aSN1Sequence2.size() - 1; i >= 0; --i) {
            if (aSN1Sequence2.getObjectAt(i).equals(aSN1Sequence.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    private Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    private Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    private void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i = 0; i < listArray.length; ++i) {
                listArray[i] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(dERObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    private void processCertD1ii(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator<PKIXCertPathChecker> iterator;
        int n;
        Object object;
        Object bl;
        Object object3;
        Object object4;
        Set<String> set;
        PublicKey publicKey;
        X500Principal x500Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = this.getValidDate(pKIXParameters);
        Set<String> set2 = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), certPath, list.size() - 1, pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        listArray[0].add(pKIXPolicyNode);
        Set set3 = new HashSet();
        Set set4 = new HashSet();
        Set set5 = new HashSet();
        Set set6 = new HashSet();
        Set set7 = new HashSet();
        Set set8 = new HashSet();
        HashSet hashSet4 = null;
        int n4 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = this.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n7 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List<PKIXCertPathChecker> list2 = pKIXParameters.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            try {
                PKIXPolicyNode pKIXPolicyNode2;
                Object object5;
                int n8;
                Set<String> set9;
                int n9 = n2 - n3;
                x509Certificate2 = (X509Certificate)list.get(n3);
                try {
                    x509Certificate2.verify(publicKey, "BC");
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n3);
                }
                try {
                    x509Certificate2.checkValidity(date);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n3);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n3);
                }
                if (pKIXParameters.isRevocationEnabled()) {
                    this.checkCRLs(pKIXParameters, x509Certificate2, date, x509Certificate, publicKey);
                }
                if (!this.getEncodedIssuerPrincipal(x509Certificate2).equals(x500Principal)) {
                    throw new CertPathValidatorException("IssuerName(" + this.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x500Principal + ") of signing certificate", null, certPath, n3);
                }
                if (!this.isSelfIssued(x509Certificate2) || n9 >= n2) {
                    set = this.getSubjectPrincipal(x509Certificate2);
                    object4 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)((Object)set)).getEncoded()));
                    try {
                        object3 = (ASN1Sequence)((ASN1InputStream)object4).readObject();
                    }
                    catch (IOException iOException) {
                        throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                    }
                    this.checkPermittedDN(set3, (ASN1Sequence)object3);
                    this.checkExcludedDN(set6, (ASN1Sequence)object3);
                    set9 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                    if (set9 != null) {
                        block44: for (n8 = 0; n8 < ((ASN1Sequence)((Object)set9)).size(); n8 += 1) {
                            object5 = (ASN1TaggedObject)((ASN1Sequence)((Object)set9)).getObjectAt(n8);
                            switch (((ASN1TaggedObject)object5).getTagNo()) {
                                case 1: {
                                    String string = DERIA5String.getInstance((ASN1TaggedObject)object5, true).getString();
                                    this.checkPermittedEmail(set4, string);
                                    this.checkExcludedEmail(set7, string);
                                    continue block44;
                                }
                                case 4: {
                                    bl = ASN1Sequence.getInstance((ASN1TaggedObject)object5, true);
                                    this.checkPermittedDN(set3, (ASN1Sequence)bl);
                                    this.checkExcludedDN(set6, (ASN1Sequence)bl);
                                    continue block44;
                                }
                                case 7: {
                                    object = ASN1OctetString.getInstance((ASN1TaggedObject)object5, true).getOctets();
                                    this.checkPermittedIP(set5, (byte[])object);
                                    this.checkExcludedIP(set8, (byte[])object);
                                }
                            }
                        }
                    }
                }
                if ((set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                    object4 = ((ASN1Sequence)((Object)set)).getObjects();
                    object3 = new HashSet();
                    while (object4.hasMoreElements()) {
                        boolean bl2;
                        set9 = PolicyInformation.getInstance(object4.nextElement());
                        DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)((Object)set9)).getPolicyIdentifier();
                        object3.add(dERObjectIdentifier2.getId());
                        if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (bl2 = this.processCertD1i(n9, listArray, dERObjectIdentifier2, (Set)(object5 = this.getQualifierSet(((PolicyInformation)((Object)set9)).getPolicyQualifiers()))))) continue;
                        this.processCertD1ii(n9, listArray, dERObjectIdentifier2, (Set)object5);
                    }
                    if (hashSet4 == null || hashSet4.contains(ANY_POLICY)) {
                        hashSet4 = object3;
                    } else {
                        set9 = hashSet4.iterator();
                        HashSet<Object> hashSet5 = new HashSet<Object>();
                        while (set9.hasNext()) {
                            object5 = set9.next();
                            if (!object3.contains(object5)) continue;
                            hashSet5.add(object5);
                        }
                        hashSet4 = hashSet5;
                    }
                    if (n5 > 0 || n9 < n2 && this.isSelfIssued(x509Certificate2)) {
                        object4 = ((ASN1Sequence)((Object)set)).getObjects();
                        while (object4.hasMoreElements()) {
                            void pKIXPolicyNode3;
                            set9 = PolicyInformation.getInstance(object4.nextElement());
                            if (!ANY_POLICY.equals(((PolicyInformation)((Object)set9)).getPolicyIdentifier().getId())) continue;
                            Set set10 = this.getQualifierSet(((PolicyInformation)((Object)set9)).getPolicyQualifiers());
                            object5 = listArray[n9 - 1];
                            boolean i = false;
                            while (pKIXPolicyNode3 < object5.size()) {
                                bl = (PKIXPolicyNode)object5.get((int)pKIXPolicyNode3);
                                for (Object object22 : ((PKIXPolicyNode)bl).getExpectedPolicies()) {
                                    Object bl2;
                                    String i2;
                                    if (object22 instanceof String) {
                                        i2 = (String)object22;
                                    } else {
                                        if (!(object22 instanceof DERObjectIdentifier)) continue;
                                        i2 = ((DERObjectIdentifier)object22).getId();
                                    }
                                    boolean bl3 = false;
                                    Iterator j = ((PKIXPolicyNode)bl).getChildren();
                                    while (j.hasNext()) {
                                        bl2 = (PKIXPolicyNode)j.next();
                                        if (!i2.equals(((PKIXPolicyNode)bl2).getValidPolicy())) continue;
                                        bl3 = true;
                                    }
                                    if (bl3) continue;
                                    bl2 = new HashSet();
                                    bl2.add(i2);
                                    pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n9, (Set)bl2, (PolicyNode)bl, set10, i2, false);
                                    ((PKIXPolicyNode)bl).addChild(pKIXPolicyNode2);
                                    listArray[n9].add(pKIXPolicyNode2);
                                }
                                ++pKIXPolicyNode3;
                            }
                            break block47;
                        }
                    }
                    for (int i = n9 - 1; i >= 0; --i) {
                        List list3 = listArray[i];
                        for (int j = 0; j < list3.size() && ((i = (PKIXPolicyNode)list3.get(j)).hasChildren() || (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, i)) != null); ++j) {
                        }
                    }
                    set9 = x509Certificate2.getCriticalExtensionOIDs();
                    if (set9 != null) {
                        void aSN1Sequence;
                        n8 = set9.contains(CERTIFICATE_POLICIES) ? 1 : 0;
                        List list4 = listArray[n9];
                        boolean dERObjectIdentifier4 = false;
                        while (aSN1Sequence < list4.size()) {
                            bl = (PKIXPolicyNode)list4.get((int)aSN1Sequence);
                            ((PKIXPolicyNode)bl).setCritical(n8 != 0);
                            ++aSN1Sequence;
                        }
                    }
                }
                if (set == null) {
                    pKIXPolicyNode = null;
                }
                if (n4 <= 0 && pKIXPolicyNode == null) {
                    throw new CertPathValidatorException("No valid policy tree found when one expected.");
                }
                if (n9 != n2) {
                    boolean[] j;
                    int n10;
                    BigInteger pKIXPolicyNode6;
                    BasicConstraints basicConstraints;
                    int n11;
                    DERInteger dERInteger;
                    if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                        throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                    }
                    object4 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                    if (object4 != null) {
                        object3 = (ASN1Sequence)object4;
                        for (int i = 0; i < ((ASN1Sequence)object3).size(); ++i) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object3).getObjectAt(i);
                            DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                            DERObjectIdentifier string = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                            if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                                throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                            }
                            if (!ANY_POLICY.equals(string.getId())) continue;
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                    }
                    if (object4 != null) {
                        Object object22;
                        object3 = (ASN1Sequence)object4;
                        HashMap<HashSet<String>, Object> hashMap = new HashMap<HashSet<String>, Object>();
                        HashSet<HashSet<String>> hashSet6 = new HashSet<HashSet<String>>();
                        for (int i = 0; i < ((ASN1Sequence)object3).size(); ++i) {
                            ASN1Sequence generalSubtree = (ASN1Sequence)((ASN1Sequence)object3).getObjectAt(i);
                            bl = ((DERObjectIdentifier)generalSubtree.getObjectAt(0)).getId();
                            object = ((DERObjectIdentifier)generalSubtree.getObjectAt(1)).getId();
                            if (!hashMap.containsKey(bl)) {
                                object22 = new HashSet();
                                object22.add(object);
                                hashMap.put((HashSet<String>)bl, object22);
                                hashSet6.add((HashSet<String>)bl);
                                continue;
                            }
                            object22 = (Set)hashMap.get(bl);
                            object22.add(object);
                        }
                        block56: for (String enumeration : hashSet6) {
                            Object object6;
                            if (n6 > 0) {
                                boolean generalName = false;
                                for (Object object22 : listArray[n9]) {
                                    if (!((PKIXPolicyNode)object22).getValidPolicy().equals(enumeration)) continue;
                                    generalName = true;
                                    ((PKIXPolicyNode)object22).expectedPolicies = (Set)hashMap.get(enumeration);
                                    break;
                                }
                                if (generalName) continue;
                                for (Object object22 : listArray[n9]) {
                                    if (!ANY_POLICY.equals(((PKIXPolicyNode)object22).getValidPolicy())) continue;
                                    Set set10 = null;
                                    object6 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES);
                                    Enumeration enumeration2 = ((ASN1Sequence)object6).getObjects();
                                    while (enumeration2.hasMoreElements()) {
                                        PolicyInformation pKIXPolicyNode5 = PolicyInformation.getInstance(enumeration2.nextElement());
                                        if (!ANY_POLICY.equals(pKIXPolicyNode5.getPolicyIdentifier().getId())) continue;
                                        set10 = this.getQualifierSet(pKIXPolicyNode5.getPolicyQualifiers());
                                        break;
                                    }
                                    boolean bl4 = false;
                                    if (x509Certificate2.getCriticalExtensionOIDs() != null) {
                                        bl4 = x509Certificate2.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                                    }
                                    if (!ANY_POLICY.equals((pKIXPolicyNode2 = (PKIXPolicyNode)((PKIXPolicyNode)object22).getParent()).getValidPolicy())) continue block56;
                                    PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n9, (Set)hashMap.get(enumeration), pKIXPolicyNode2, set10, enumeration, bl4);
                                    pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                                    listArray[n9].add(pKIXPolicyNode3);
                                    continue block56;
                                }
                                continue;
                            }
                            if (n6 > 0) continue;
                            Iterator generalSubtree = listArray[n9].iterator();
                            while (generalSubtree.hasNext()) {
                                object = (PKIXPolicyNode)generalSubtree.next();
                                if (!((PKIXPolicyNode)object).getValidPolicy().equals(enumeration)) continue;
                                object22 = (PKIXPolicyNode)((PKIXPolicyNode)object).getParent();
                                ((PKIXPolicyNode)object22).removeChild((PKIXPolicyNode)object);
                                generalSubtree.remove();
                                for (int i = n9 - 1; i >= 0; --i) {
                                    PKIXPolicyNode pKIXPolicyNode4;
                                    object6 = listArray[i];
                                    for (int k = 0; k < object6.size() && ((pKIXPolicyNode4 = (PKIXPolicyNode)object6.get(k)).hasChildren() || (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode4)) != null); ++k) {
                                    }
                                }
                            }
                        }
                    }
                    if ((object3 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                        ASN1Sequence aSN1Sequence;
                        NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object3);
                        ASN1Sequence aSN1Sequence2 = nameConstraints.getPermittedSubtrees();
                        if (aSN1Sequence2 != null) {
                            Enumeration enumeration = aSN1Sequence2.getObjects();
                            while (enumeration.hasMoreElements()) {
                                GeneralSubtree bigInteger = GeneralSubtree.getInstance(enumeration.nextElement());
                                GeneralName n102 = bigInteger.getBase();
                                switch (n102.getTagNo()) {
                                    case 1: {
                                        set4 = this.intersectEmail(set4, DERIA5String.getInstance(n102.getName()).getString());
                                        break;
                                    }
                                    case 4: {
                                        set3 = this.intersectDN(set3, (ASN1Sequence)n102.getName());
                                        break;
                                    }
                                    case 7: {
                                        set5 = this.intersectIP(set5, ASN1OctetString.getInstance(n102.getName()).getOctets());
                                    }
                                }
                            }
                        }
                        if ((aSN1Sequence = nameConstraints.getExcludedSubtrees()) != null) {
                            Enumeration blArray = aSN1Sequence.getObjects();
                            while (blArray.hasMoreElements()) {
                                GeneralSubtree generalSubtree = GeneralSubtree.getInstance(blArray.nextElement());
                                object = generalSubtree.getBase();
                                switch (((GeneralName)object).getTagNo()) {
                                    case 1: {
                                        set7 = this.unionEmail(set7, DERIA5String.getInstance(((GeneralName)object).getName()).getString());
                                        break;
                                    }
                                    case 4: {
                                        set6 = this.unionDN(set6, (ASN1Sequence)((GeneralName)object).getName());
                                        break;
                                    }
                                    case 7: {
                                        set8 = this.unionIP(set8, ASN1OctetString.getInstance(((GeneralName)object).getName()).getOctets());
                                    }
                                }
                            }
                        }
                    }
                    if (!this.isSelfIssued(x509Certificate2)) {
                        if (n4 != 0) {
                            --n4;
                        }
                        if (n6 != 0) {
                            --n6;
                        }
                        if (n5 != 0) {
                            --n5;
                        }
                    }
                    if ((set9 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                        Enumeration enumeration = ((ASN1Sequence)((Object)set9)).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n >= n4) break;
                                    n4 = n;
                                    break;
                                }
                                case 1: {
                                    n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n >= n6) break;
                                    n6 = n;
                                }
                            }
                        }
                    }
                    if ((dERInteger = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n11 = dERInteger.getValue().intValue()) < n5) {
                        n5 = n11;
                    }
                    if ((basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                        if (!basicConstraints.isCA()) {
                            throw new CertPathValidatorException("Not a CA certificate");
                        }
                    } else {
                        throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                    }
                    if (!this.isSelfIssued(x509Certificate2)) {
                        if (n7 <= 0) {
                            throw new CertPathValidatorException("Max path length not greater than zero");
                        }
                        --n7;
                    }
                    if (basicConstraints != null && (pKIXPolicyNode6 = basicConstraints.getPathLenConstraint()) != null && (n10 = pKIXPolicyNode6.intValue()) < n7) {
                        n7 = n10;
                    }
                    if ((j = x509Certificate2.getKeyUsage()) != null && !j[5]) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                    }
                    bl = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    bl.remove(KEY_USAGE);
                    bl.remove(CERTIFICATE_POLICIES);
                    bl.remove(POLICY_MAPPINGS);
                    bl.remove(INHIBIT_ANY_POLICY);
                    bl.remove(ISSUING_DISTRIBUTION_POINT);
                    bl.remove(DELTA_CRL_INDICATOR);
                    bl.remove(POLICY_CONSTRAINTS);
                    bl.remove(BASIC_CONSTRAINTS);
                    bl.remove(SUBJECT_ALTERNATIVE_NAME);
                    bl.remove(NAME_CONSTRAINTS);
                    iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        try {
                            iterator.next().check(x509Certificate2, (Collection<String>)bl);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
                        }
                    }
                    if (!bl.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                    }
                }
                x509Certificate = x509Certificate2;
                publicKey = x509Certificate.getPublicKey();
                try {
                    x500Principal = this.getSubjectPrincipal(x509Certificate);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
                }
                algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
                dERObjectIdentifier = algorithmIdentifier.getObjectId();
                dEREncodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (AnnotatedException annotatedException) {
                throw new CertPathValidatorException(annotatedException.getMessage(), (Throwable)annotatedException.getUnderlyingException(), certPath, n3);
            }
        }
        if (!this.isSelfIssued(x509Certificate2) && n4 != 0) {
            --n4;
        }
        try {
            set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS);
            if (set != null) {
                object4 = ((ASN1Sequence)((Object)set)).getObjects();
                while (object4.hasMoreElements()) {
                    object3 = (ASN1TaggedObject)object4.nextElement();
                    switch (((ASN1TaggedObject)object3).getTagNo()) {
                        case 0: {
                            n = DERInteger.getInstance(object3).getValue().intValue();
                            if (n != 0) break;
                            n4 = 0;
                        }
                    }
                }
            }
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), (Throwable)annotatedException.getUnderlyingException(), certPath, n3);
        }
        set = x509Certificate2.getCriticalExtensionOIDs();
        if (set != null) {
            set = new HashSet(set);
            set.remove(KEY_USAGE);
            set.remove(CERTIFICATE_POLICIES);
            set.remove(POLICY_MAPPINGS);
            set.remove(INHIBIT_ANY_POLICY);
            set.remove(ISSUING_DISTRIBUTION_POINT);
            set.remove(DELTA_CRL_INDICATOR);
            set.remove(POLICY_CONSTRAINTS);
            set.remove(BASIC_CONSTRAINTS);
            set.remove(SUBJECT_ALTERNATIVE_NAME);
            set.remove(NAME_CONSTRAINTS);
        } else {
            set = new HashSet<String>();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().check(x509Certificate2, set);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
            }
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
        }
        if (pKIXPolicyNode == null) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            object4 = null;
        } else if (this.isAnyPolicy(set2)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet4.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                object3 = new HashSet();
                for (int i = 0; i < listArray.length; ++i) {
                    ArrayList arrayList = listArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)arrayList.get(j);
                        if (!ANY_POLICY.equals(pKIXPolicyNode8.getValidPolicy())) continue;
                        bl = pKIXPolicyNode8.getChildren();
                        while (bl.hasNext()) {
                            object3.add(bl.next());
                        }
                    }
                }
                Iterator iterator5 = object3.iterator();
                while (iterator5.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)iterator5.next();
                    String string = pKIXPolicyNode7.getValidPolicy();
                    if (hashSet4.contains(string)) continue;
                }
                if (pKIXPolicyNode != null) {
                    for (int i = n2 - 1; i >= 0; --i) {
                        List list5 = listArray[i];
                        for (int j = 0; j < list5.size(); ++j) {
                            bl = (PKIXPolicyNode)list5.get(j);
                            if (((PKIXPolicyNode)bl).hasChildren()) continue;
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)bl);
                        }
                    }
                }
            }
            object4 = pKIXPolicyNode;
        } else {
            object3 = new HashSet();
            for (int i = 0; i < listArray.length; ++i) {
                ArrayList arrayList = listArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)arrayList.get(j);
                    if (!ANY_POLICY.equals(pKIXPolicyNode5.getValidPolicy())) continue;
                    bl = pKIXPolicyNode5.getChildren();
                    while (bl.hasNext()) {
                        object = (PKIXPolicyNode)bl.next();
                        if (ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) continue;
                        object3.add(object);
                    }
                }
            }
            Iterator iterator6 = object3.iterator();
            while (iterator6.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)iterator6.next();
                String string = pKIXPolicyNode9.getValidPolicy();
                if (set2.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode9);
            }
            if (pKIXPolicyNode != null) {
                for (int i = n2 - 1; i >= 0; --i) {
                    ArrayList arrayList = listArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        bl = (PKIXPolicyNode)arrayList.get(j);
                        if (((PKIXPolicyNode)bl).hasChildren()) continue;
                        pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)bl);
                    }
                }
            }
            object4 = pKIXPolicyNode;
        }
        if (n4 > 0 || object4 != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object4, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }

    private Date getValidDate(PKIXParameters pKIXParameters) {
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    private void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey) throws AnnotatedException {
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(this.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from certificate: " + iOException, iOException);
        }
        x509CRLSelector.setCertificateChecking(x509Certificate);
        Iterator iterator = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            X509CRL x509CRL = (X509CRL)iterator.next();
            if (!x509Certificate.getNotAfter().after(x509CRL.getThisUpdate())) continue;
            if (x509CRL.getNextUpdate() == null || date.before(x509CRL.getNextUpdate())) {
                bl = true;
            }
            if (!(x509Certificate2 == null || (object3 = x509Certificate2.getKeyUsage()) == null || ((boolean[])object3).length >= 7 && object3[6])) {
                throw new AnnotatedException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate2);
            }
            try {
                x509CRL.verify(publicKey, "BC");
            }
            catch (Exception exception) {
                throw new AnnotatedException("can't verify CRL: " + exception, exception);
            }
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate.getSerialNumber());
            if (x509CRLEntry != null && !date.before(x509CRLEntry.getRevocationDate())) {
                object3 = null;
                if (x509CRLEntry.hasExtensions() && (object2 = DEREnumerated.getInstance(this.getExtensionValue(x509CRLEntry, X509Extensions.ReasonCode.getId()))) != null) {
                    object3 = crlReasons[((DEREnumerated)object2).getValue().intValue()];
                }
                object2 = "Certificate revocation after " + x509CRLEntry.getRevocationDate();
                if (object3 != null) {
                    object2 = (String)object2 + ", reason: " + (String)object3;
                }
                throw new AnnotatedException((String)object2);
            }
            object3 = this.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT);
            object2 = this.getExtensionValue(x509CRL, DELTA_CRL_INDICATOR);
            if (object2 != null) {
                object = new X509CRLSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(this.getIssuerPrincipal(x509CRL).getEncoded());
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("can't extract issuer from certificate: " + iOException, iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                ((X509CRLSelector)object).setMaxCRLNumber(((DERInteger)this.getExtensionValue(x509CRL, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                boolean bl2 = false;
                for (X509CRL x509CRL2 : this.findCRLs((X509CRLSelector)object, pKIXParameters.getCertStores())) {
                    DERObject dERObject = this.getExtensionValue(x509CRL2, ISSUING_DISTRIBUTION_POINT);
                    if (object3 == null) {
                        if (dERObject != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!((DERObject)object3).equals(dERObject)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new AnnotatedException("No base CRL for delta CRL");
                }
            }
            if (object3 == null) continue;
            object = IssuingDistributionPoint.getInstance(object3);
            BasicConstraints basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                throw new AnnotatedException("CA Cert CRL only contains user certificates");
            }
            if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                throw new AnnotatedException("End CRL only contains CA certificates");
            }
            if (!((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) continue;
            throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted");
        }
        if (!bl) {
            throw new AnnotatedException("no valid CRL found");
        }
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws AnnotatedException {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        for (CertStore certStore : list) {
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("cannot extract crl: " + certStoreException, certStoreException);
            }
        }
        return hashSet;
    }

    final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, CertPath certPath, int n, Set set) throws CertPathValidatorException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(this.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = this.getEncodedIssuerPrincipal(x509Certificate);
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", exception, certPath, n);
        }
        return trustAnchor;
    }

    private X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    private X500Principal getEncodedIssuerPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerX500Principal();
    }

    private X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }
}

