/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core.context;

import java.util.ArrayList;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContext {
    private static final Logger log = LoggerFactory.getLogger(TaskContext.class);
    private TaskModel taskModel;
    private ProcessContext parentProcessContext;
    private InputDataObjectType processInput;
    private OutputDataObjectType processOutput;
    private Object subTaskModel = null;
    private boolean isCancel = false;

    public TaskModel getTaskModel() {
        return this.taskModel;
    }

    public void setTaskModel(TaskModel taskModel) {
        this.taskModel = taskModel;
    }

    public ProcessContext getParentProcessContext() {
        return this.parentProcessContext;
    }

    public void setParentProcessContext(ProcessContext parentProcessContext) {
        this.parentProcessContext = parentProcessContext;
    }

    public String getWorkingDir() {
        return this.getParentProcessContext().getWorkingDir();
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        log.info("expId: {}, processId: {}, taskId: {}, type: {} : Task status changed {} -> {}", new Object[]{this.parentProcessContext.getExperimentId(), this.parentProcessContext.getProcessId(), this.getTaskId(), this.getTaskType().name(), this.getTaskState().name(), taskStatus.getState().name()});
        ArrayList<TaskStatus> taskStatuses = new ArrayList<TaskStatus>();
        taskStatuses.add(taskStatus);
        this.taskModel.setTaskStatuses(taskStatuses);
    }

    public TaskStatus getTaskStatus() {
        if (this.taskModel.getTaskStatuses() != null) {
            return (TaskStatus)this.taskModel.getTaskStatuses().get(0);
        }
        return null;
    }

    public TaskState getTaskState() {
        if (this.taskModel.getTaskStatuses() != null) {
            return ((TaskStatus)this.taskModel.getTaskStatuses().get(0)).getState();
        }
        return null;
    }

    public TaskTypes getTaskType() {
        return this.taskModel.getTaskType();
    }

    public String getTaskId() {
        return this.taskModel.getTaskId();
    }

    public String getLocalWorkingDir() {
        return this.getParentProcessContext().getLocalWorkingDir();
    }

    public InputDataObjectType getProcessInput() {
        return this.processInput;
    }

    public void setProcessInput(InputDataObjectType processInput) {
        this.processInput = processInput;
    }

    public OutputDataObjectType getProcessOutput() {
        return this.processOutput;
    }

    public void setProcessOutput(OutputDataObjectType processOutput) {
        this.processOutput = processOutput;
    }

    public String getProcessId() {
        return this.parentProcessContext.getProcessId();
    }

    public String getExperimentId() {
        return this.parentProcessContext.getExperimentId();
    }

    public Object getSubTaskModel() throws TException {
        if (this.subTaskModel == null) {
            this.subTaskModel = ThriftUtils.getSubTaskModel((TaskModel)this.getTaskModel());
        }
        return this.subTaskModel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }
}

