/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockEvictionProcessor;
import com.hazelcast.concurrent.lock.LockReplicationOperation;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.concurrent.lock.LockStoreContainer;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.concurrent.lock.LockStoreProxy;
import com.hazelcast.concurrent.lock.UnlockOperation;
import com.hazelcast.concurrent.lock.proxy.LockProxy;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LockServiceImpl
implements ManagedService,
RemoteService,
MembershipAwareService,
MigrationAwareService,
LockService,
ClientAwareService {
    private final NodeEngine nodeEngine;
    private final LockStoreContainer[] containers;
    private final ConcurrentHashMap<ObjectNamespace, EntryTaskScheduler> evictionProcessors = new ConcurrentHashMap();
    final ConcurrentMap<String, ConstructorFunction<ObjectNamespace, LockStoreInfo>> constructors = new ConcurrentHashMap<String, ConstructorFunction<ObjectNamespace, LockStoreInfo>>();
    private final ConstructorFunction<ObjectNamespace, EntryTaskScheduler> schedulerConstructor = new ConstructorFunction<ObjectNamespace, EntryTaskScheduler>(){

        @Override
        public EntryTaskScheduler createNew(ObjectNamespace namespace) {
            return EntryTaskSchedulerFactory.newScheduler(LockServiceImpl.this.nodeEngine.getExecutionService().getScheduledExecutor(), new LockEvictionProcessor(LockServiceImpl.this.nodeEngine, namespace), true);
        }
    };

    public LockServiceImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.containers = new LockStoreContainer[nodeEngine.getPartitionService().getPartitionCount()];
        for (int i = 0; i < this.containers.length; ++i) {
            this.containers[i] = new LockStoreContainer(this, i);
        }
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.registerLockStoreConstructor("hz:impl:lockService", new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

            @Override
            public LockStoreInfo createNew(ObjectNamespace key) {
                return new LockStoreInfo(){

                    @Override
                    public ObjectNamespace getObjectNamespace() {
                        return new InternalLockNamespace();
                    }

                    @Override
                    public int getBackupCount() {
                        return 1;
                    }

                    @Override
                    public int getAsyncBackupCount() {
                        return 0;
                    }
                };
            }
        });
    }

    @Override
    public void reset() {
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                lockStore.clear();
            }
        }
    }

    @Override
    public void shutdown() {
        for (LockStoreContainer container : this.containers) {
            container.clear();
        }
    }

    @Override
    public void registerLockStoreConstructor(String serviceName, ConstructorFunction<ObjectNamespace, LockStoreInfo> constructorFunction) {
        if (this.constructors.putIfAbsent(serviceName, constructorFunction) != null) {
            throw new IllegalArgumentException("LockStore constructor for service[" + serviceName + "] is already registered!");
        }
    }

    @Override
    public LockStore createLockStore(int partitionId, ObjectNamespace namespace) {
        LockStoreContainer container = this.getLockContainer(partitionId);
        container.getOrCreateLockStore(namespace);
        return new LockStoreProxy(container, namespace);
    }

    @Override
    public void clearLockStore(int partitionId, ObjectNamespace namespace) {
        LockStoreContainer container = this.getLockContainer(partitionId);
        container.clearLockStore(namespace);
    }

    void scheduleEviction(ObjectNamespace namespace, Data key, long delay) {
        EntryTaskScheduler scheduler = ConcurrencyUtil.getOrPutSynchronized(this.evictionProcessors, namespace, this.evictionProcessors, this.schedulerConstructor);
        scheduler.schedule(delay, key, null);
    }

    void cancelEviction(ObjectNamespace namespace, Data key) {
        EntryTaskScheduler scheduler = ConcurrencyUtil.getOrPutSynchronized(this.evictionProcessors, namespace, this.evictionProcessors, this.schedulerConstructor);
        scheduler.cancel(key);
    }

    LockStoreContainer getLockContainer(int partitionId) {
        return this.containers[partitionId];
    }

    LockStoreImpl getLockStore(int partitionId, ObjectNamespace namespace) {
        return this.getLockContainer(partitionId).getOrCreateLockStore(namespace);
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        MemberImpl member = event.getMember();
        String uuid = member.getUuid();
        this.releaseLocksOf(uuid);
    }

    private void releaseLocksOf(String uuid) {
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                Collection<LockResource> locks = lockStore.getLocks();
                for (LockResource lock : locks) {
                    Data key = lock.getKey();
                    if (!uuid.equals(lock.getOwner()) || lock.isTransactional()) continue;
                    UnlockOperation op = new UnlockOperation(lockStore.getNamespace(), key, -1, true);
                    op.setAsyncBackup(true);
                    op.setNodeEngine(this.nodeEngine);
                    op.setServiceName("hz:impl:lockService");
                    op.setService(this);
                    op.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                    op.setPartitionId(container.getPartitionId());
                    this.nodeEngine.getOperationService().executeOperation(op);
                }
            }
        }
    }

    @Override
    public Collection<LockResource> getAllLocks() {
        LinkedList<LockResource> locks = new LinkedList<LockResource>();
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                locks.addAll(lockStore.getLocks());
            }
        }
        return locks;
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        LockStoreContainer container = this.containers[event.getPartitionId()];
        LockReplicationOperation op = new LockReplicationOperation(container, event.getPartitionId(), event.getReplicaIndex());
        return op.isEmpty() ? null : op;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartition(event.getPartitionId());
        }
    }

    private void clearPartition(int partitionId) {
        LockStoreContainer container = this.containers[partitionId];
        for (LockStoreImpl ls : container.getLockStores()) {
            ls.clear();
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartition(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearPartition(partitionId);
    }

    @Override
    public DistributedObject createDistributedObject(Object objectId) {
        return new LockProxy(this.nodeEngine, this, this.nodeEngine.getSerializationService().toData(objectId));
    }

    @Override
    public void destroyDistributedObject(Object objectId) {
        Data key = this.nodeEngine.getSerializationService().toData(objectId);
        for (LockStoreContainer container : this.containers) {
            LockStoreImpl lockStore = container.getOrCreateLockStore(new InternalLockNamespace());
            lockStore.forceUnlock(key);
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.releaseLocksOf(clientUuid);
    }
}

