/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.openjpa.jdbc.sql.Join;

class JoinSet {
    private final List _graph = new ArrayList();
    private int _size = 0;
    private List _sorted = null;

    public JoinSet() {
    }

    public JoinSet(JoinSet copy) {
        for (int i = 0; i < copy._graph.size(); ++i) {
            if (copy._graph.get(i) == null) {
                this._graph.add(null);
                continue;
            }
            this._graph.add(((Node)copy._graph.get(i)).clone());
        }
        this._size = copy._size;
        this._sorted = copy._sorted;
    }

    public Join getRecordedJoin(Join join) {
        if (join == null) {
            return null;
        }
        Node node = this.getNode(join, join.getIndex1());
        return node == null ? null : node.join;
    }

    private Node getNode(Join join, int idx) {
        if (this._graph.size() <= idx) {
            return null;
        }
        Node node = (Node)this._graph.get(idx);
        while (node != null) {
            if (node.join.equals(join)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public Join last() {
        if (this._size == 0) {
            return null;
        }
        Node node = (Node)this._graph.get(this._graph.size() - 1);
        while (node.next != null) {
            node = node.next;
        }
        return node.join;
    }

    public Iterator joinIterator() {
        if (this._size < 2) {
            return this.iterator();
        }
        if (this._sorted != null) {
            return this._sorted.iterator();
        }
        ArrayList<Join> sorted = new ArrayList<Join>(this._size);
        LinkedList<Node> queue = new LinkedList<Node>();
        BitSet seen = new BitSet(this._graph.size() * this._graph.size() + this._graph.size());
        for (int i = 0; i < this._graph.size(); ++i) {
            int sidx;
            Node n = (Node)this._graph.get(i);
            while (n != null) {
                sidx = this.getSeenIndex(n.join);
                if (!seen.get(sidx)) {
                    seen.set(sidx);
                    queue.add(n);
                }
                n = n.next;
            }
            if (queue.isEmpty()) continue;
            while (!queue.isEmpty()) {
                int idx;
                n = (Node)queue.removeFirst();
                int n2 = idx = n.forward ? n.join.getIndex2() : n.join.getIndex1();
                if (!seen.get(idx)) {
                    sorted.add(n.forward ? n.join : n.join.reverse());
                    seen.set(idx);
                }
                n = (Node)this._graph.get(idx);
                while (n != null) {
                    sidx = this.getSeenIndex(n.join);
                    if (!seen.get(sidx)) {
                        seen.set(sidx);
                        queue.add(n);
                    }
                    n = n.next;
                }
            }
        }
        this._sorted = sorted;
        return this._sorted.iterator();
    }

    private int getSeenIndex(Join join) {
        return join.getIndex1() * this._graph.size() + join.getIndex2() + this._graph.size();
    }

    public boolean add(Join join) {
        if (join.getType() == 1) {
            if (!this.contains(join)) {
                this.addNode(join);
                return true;
            }
            return false;
        }
        Node node = this.getNode(join, join.getIndex1());
        if (node != null) {
            node.join = join;
            this.getNode((Join)join, (int)join.getIndex2()).join = join;
            this._sorted = null;
        } else {
            this.addNode(join);
        }
        return true;
    }

    public boolean addAll(JoinSet js) {
        if (js.isEmpty()) {
            return false;
        }
        boolean added = false;
        Iterator itr = js.iterator();
        while (itr.hasNext()) {
            added = this.add((Join)itr.next()) || added;
        }
        return added;
    }

    private void addNode(Join join) {
        this._sorted = null;
        int size = Math.max(join.getIndex1(), join.getIndex2()) + 1;
        while (this._graph.size() < size) {
            this._graph.add(null);
        }
        Node node = (Node)this._graph.get(join.getIndex1());
        if (node == null) {
            this._graph.set(join.getIndex1(), new Node(join, true));
        } else {
            while (node.next != null) {
                node = node.next;
            }
            node.next = new Node(join, true);
        }
        node = (Node)this._graph.get(join.getIndex2());
        if (node == null) {
            this._graph.set(join.getIndex2(), new Node(join, false));
        } else {
            while (node.next != null) {
                node = node.next;
            }
            node.next = new Node(join, false);
        }
        ++this._size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private Node _next = null;
            private int _idx = -1;

            @Override
            public boolean hasNext() {
                if (this._next != null) {
                    return true;
                }
                while (++this._idx < JoinSet.this._graph.size()) {
                    this._next = (Node)JoinSet.this._graph.get(this._idx);
                    while (this._next != null && !this._next.forward) {
                        this._next = this._next.next;
                    }
                    if (this._next == null) continue;
                    return true;
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Join j = this._next.join;
                do {
                    this._next = this._next.next;
                } while (this._next != null && !this._next.forward);
                return j;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean remove(Join join) {
        if (join == null || this._graph.size() <= join.getIndex1()) {
            return false;
        }
        if (this.remove(join, join.getIndex1())) {
            --this._size;
            return this.remove(join, join.getIndex2());
        }
        return false;
    }

    private boolean remove(Join join, int idx) {
        Node node = (Node)this._graph.get(idx);
        Node prev = null;
        while (node != null) {
            if (node.join.equals(join)) {
                if (prev != null) {
                    prev.next = node.next;
                } else {
                    this._graph.set(idx, node.next);
                    while (!this._graph.isEmpty() && this._graph.get(idx) == null && idx == this._graph.size() - 1) {
                        this._graph.remove(idx--);
                    }
                }
                return true;
            }
            prev = node;
            node = node.next;
        }
        return false;
    }

    public boolean removeAll(JoinSet js) {
        boolean remd = false;
        Iterator itr = js.iterator();
        while (itr.hasNext()) {
            remd = this.remove((Join)itr.next()) || remd;
        }
        return remd;
    }

    public boolean retainAll(JoinSet js) {
        boolean remd = false;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Join join = (Join)itr.next();
            if (js.contains(join)) continue;
            remd = this.remove(join);
        }
        return remd;
    }

    public void clear() {
        this._graph.clear();
        this._sorted = null;
        this._size = 0;
    }

    public boolean contains(Join join) {
        return this.getRecordedJoin(join) != null;
    }

    public boolean containsAll(JoinSet js) {
        if (js._size > this._size || js._graph.size() > this._graph.size()) {
            return false;
        }
        Iterator itr = js.iterator();
        while (itr.hasNext()) {
            if (this.contains((Join)itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JoinSet)) {
            return false;
        }
        return ((Object)this._graph).equals(((JoinSet)other)._graph);
    }

    public int hashCode() {
        return ((Object)this._graph).hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            buf.append("<").append(itr.next()).append(">");
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append("]").toString();
    }

    private static class Node
    implements Cloneable {
        public Join join;
        public Node next;
        public boolean forward;

        public Node(Join join, boolean forward) {
            this.join = join;
            this.forward = forward;
        }

        public int hashCode() {
            int rs = 17;
            rs = 37 * rs + this.join.hashCode();
            if (this.next != null) {
                rs = 37 * rs + this.next.hashCode();
            }
            return rs;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            return ObjectUtils.equals(this.join, node.join) && ObjectUtils.equals(this.next, node.next);
        }

        public Object clone() {
            try {
                Node node = (Node)super.clone();
                if (node.next != null) {
                    node.next = (Node)node.next.clone();
                }
                return node;
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
        }

        public String toString() {
            return this.join + "(" + (this.forward ? "forward" : "backward") + ")" + "; next: " + this.next;
        }
    }
}

