/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.userstore;

import javax.sql.DataSource;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.security.UserStoreException;
import org.apache.airavata.security.userstore.AbstractJDBCUserStore;
import org.apache.airavata.security.util.PasswordDigester;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class JDBCUserStore
extends AbstractJDBCUserStore {
    protected static Logger log = LoggerFactory.getLogger(JDBCUserStore.class);
    private JdbcRealm jdbcRealm = new JdbcRealm();
    private PasswordDigester passwordDigester;

    @Override
    public boolean authenticate(String userName, Object credentials) throws UserStoreException {
        UsernamePasswordToken authenticationToken = new UsernamePasswordToken(userName, this.passwordDigester.getPasswordHashValue((String)credentials));
        try {
            AuthenticationInfo authenticationInfo = this.jdbcRealm.getAuthenticationInfo((AuthenticationToken)authenticationToken);
            return authenticationInfo != null;
        }
        catch (AuthenticationException e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean authenticate(Object credentials) throws UserStoreException {
        log.error("JDBC user store only supports user name, password based authentication.");
        throw new NotImplementedException();
    }

    @Override
    public void configure(Node node) throws UserStoreException {
        super.configure(node);
        NodeList databaseNodeList = node.getChildNodes();
        Node databaseNode = null;
        for (int k = 0; k < databaseNodeList.getLength(); ++k) {
            Node n = databaseNodeList.item(k);
            if (n == null || n.getNodeType() != 1) continue;
            databaseNode = n;
        }
        String userTable = null;
        String userNameColumn = null;
        String passwordColumn = null;
        String passwordHashMethod = null;
        if (databaseNode != null) {
            NodeList nodeList = databaseNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                Element element = (Element)n;
                if (element.getNodeName().equals("userTableName")) {
                    userTable = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("userNameColumnName")) {
                    userNameColumn = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("passwordColumnName")) {
                    passwordColumn = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (!element.getNodeName().equals("passwordHashMethod")) continue;
                passwordHashMethod = element.getFirstChild().getNodeValue();
            }
        }
        this.passwordDigester = new PasswordDigester(passwordHashMethod);
        try {
            this.initializeDatabaseLookup(passwordColumn, userTable, userNameColumn);
        }
        catch (Exception e) {
            log.error("Error while initializing database configurations.", (Throwable)e);
            throw new UserStoreException("Error while initializing database configurations.", e);
        }
        StringBuilder stringBuilder = new StringBuilder("Configuring DB parameters for authenticator with User name Table - ");
        stringBuilder.append(userTable).append(" User name column - ").append(userNameColumn).append(" Password column - ").append(passwordColumn);
        log.debug(stringBuilder.toString());
    }

    protected void initializeDatabaseLookup(String passwordColumn, String userTable, String userNameColumn) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        DBUtil dbUtil = new DBUtil(this.getDatabaseURL(), this.getDatabaseUserName(), this.getDatabasePassword(), this.getDatabaseDriver());
        DataSource dataSource = dbUtil.getDataSource();
        this.jdbcRealm.setDataSource(dataSource);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ").append(passwordColumn).append(" FROM ").append(userTable).append(" WHERE ").append(userNameColumn).append(" = ?");
        this.jdbcRealm.setAuthenticationQuery(stringBuilder.toString());
    }

    public PasswordDigester getPasswordDigester() {
        return this.passwordDigester;
    }
}

