/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.profile.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.builder.ProfileBuilderException;
import org.wso2.carbon.user.core.profile.dao.ProfileConfigDAO;
import org.wso2.carbon.utils.CarbonUtils;

public class ProfileConfigurationBuilder {
    private static Log log = LogFactory.getLog(ProfileConfigurationBuilder.class);
    private static final String PROFILE_CONFIG = "profile-config.xml";
    public static final String LOCAL_NAME_USER_PROFILES = "UserProfiles";
    public static final String ATTR_PROFILE_NAME = "profileName";
    public static final String ATTR_PROFILE_CONFIG_NAME = "configName";
    public static final String LOCAL_NAME_PROFILE_CONFIG = "ProfileConfiguration";
    public static final String LOCAL_NAME_CLAIM = "Claim";
    public static final String LOCAL_NAME_CLAIM_URI = "ClaimURI";
    public static final String LOCAL_NAME_ATTR_ID = "AttributeID";
    public static final String LOCAL_NAME_PROFILES = "Profiles";
    public static final String LOCAL_NAME_PROFILE = "Profile";
    public static final String LOCAL_NAME_CLAIM_BEHAVIOR = "ClaimBehavior";
    public static final String ATTR_DIALECT_URI = "dialectURI";
    private static BundleContext bundleContext;
    private InputStream inStream = null;
    int tenantId;

    public ProfileConfigurationBuilder(int tenantId) {
        this.tenantId = tenantId;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        ProfileConfigurationBuilder.bundleContext = bundleContext;
    }

    public Map<String, ProfileConfiguration> buildProfileConfigurationFromDatabase(DataSource ds, String realmName) throws ProfileBuilderException {
        try {
            ProfileConfigDAO profileDAO = new ProfileConfigDAO(ds, this.tenantId);
            Map<String, ProfileConfiguration> profileConfigs = profileDAO.loadProfileConfigs();
            return profileConfigs;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw new ProfileBuilderException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Map<String, ProfileConfiguration> buildProfileConfigurationFromConfigFile() throws ProfileBuilderException {
        OMElement element = null;
        String message = null;
        Iterator configIterator = null;
        HashMap<String, ProfileConfiguration> profileConfigs = null;
        try {
            element = this.getRootElement();
        }
        catch (Exception e) {
            message = "Error while reading profile configuration";
            log.error((Object)message, (Throwable)e);
            throw new ProfileBuilderException(message, e);
        }
        configIterator = element.getChildrenWithLocalName(LOCAL_NAME_PROFILE_CONFIG);
        profileConfigs = new HashMap<String, ProfileConfiguration>();
        while (configIterator.hasNext()) {
            OMElement profileElem = (OMElement)configIterator.next();
            String dialectName = null;
            String profileConfigName = null;
            Iterator profileIter = null;
            ArrayList<String> hidden = null;
            ArrayList<String> overridden = null;
            ArrayList<String> inherited = null;
            ProfileConfiguration profileConfiguration = null;
            profileConfigName = profileElem.getAttribute(new QName(ATTR_PROFILE_CONFIG_NAME)).getAttributeValue();
            dialectName = profileElem.getAttribute(new QName(ATTR_DIALECT_URI)).getAttributeValue();
            profileIter = profileElem.getChildrenWithLocalName(LOCAL_NAME_CLAIM);
            hidden = new ArrayList<String>();
            overridden = new ArrayList<String>();
            inherited = new ArrayList<String>();
            while (profileIter.hasNext()) {
                OMElement claimElem = null;
                String claimURI = null;
                String behavior = null;
                claimElem = (OMElement)profileIter.next();
                claimURI = claimElem.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_URI)).getText();
                behavior = claimElem.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_BEHAVIOR)).getText();
                if (behavior.equals("Hidden")) {
                    hidden.add(claimURI);
                    continue;
                }
                if (behavior.equals("Overridden")) {
                    overridden.add(claimURI);
                    continue;
                }
                inherited.add(claimURI);
            }
            profileConfiguration = new ProfileConfiguration(profileConfigName, hidden, overridden, inherited);
            profileConfiguration.setDialectName(dialectName);
            profileConfigs.put(profileConfigName, profileConfiguration);
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ProfileBuilderException(e.getMessage(), e);
        }
        return profileConfigs;
    }

    private OMElement getRootElement() throws XMLStreamException, IOException, ProfileBuilderException {
        Object carbonHome = null;
        StAXOMBuilder builder = null;
        File claimConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), PROFILE_CONFIG);
        if (claimConfigXml.exists()) {
            this.inStream = new FileInputStream(claimConfigXml);
        }
        if (this.inStream == null) {
            URL profileConfig;
            if (bundleContext != null) {
                profileConfig = this.getProfileUrl(false);
                this.inStream = profileConfig.openStream();
            } else {
                profileConfig = this.getProfileUrl(true);
            }
            this.inStream = profileConfig.openStream();
        }
        builder = new StAXOMBuilder(this.inStream);
        OMElement documentElement = builder.getDocumentElement();
        return documentElement;
    }

    private URL getProfileUrl(boolean loadFromThisClassPath) throws FileNotFoundException {
        URL resourceUrl = !loadFromThisClassPath ? bundleContext.getBundle().getResource(PROFILE_CONFIG) : this.getClass().getClassLoader().getResource(PROFILE_CONFIG);
        if (resourceUrl == null) {
            String message = "Profile configuration not found in profile-config.xml";
            log.warn((Object)message);
            throw new FileNotFoundException(message);
        }
        return resourceUrl;
    }
}

