/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetWorkflowExecutionHistoryRequestMarshaller
implements Marshaller<Request<GetWorkflowExecutionHistoryRequest>, GetWorkflowExecutionHistoryRequest> {
    public Request<GetWorkflowExecutionHistoryRequest> marshall(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) {
        if (getWorkflowExecutionHistoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getWorkflowExecutionHistoryRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.GetWorkflowExecutionHistory";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            WorkflowExecution execution;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getWorkflowExecutionHistoryRequest.getDomain() != null) {
                jsonWriter.key("domain").value((Object)getWorkflowExecutionHistoryRequest.getDomain());
            }
            if ((execution = getWorkflowExecutionHistoryRequest.getExecution()) != null) {
                jsonWriter.key("execution");
                jsonWriter.object();
                if (execution.getWorkflowId() != null) {
                    jsonWriter.key("workflowId").value((Object)execution.getWorkflowId());
                }
                if (execution.getRunId() != null) {
                    jsonWriter.key("runId").value((Object)execution.getRunId());
                }
                jsonWriter.endObject();
            }
            if (getWorkflowExecutionHistoryRequest.getNextPageToken() != null) {
                jsonWriter.key("nextPageToken").value((Object)getWorkflowExecutionHistoryRequest.getNextPageToken());
            }
            if (getWorkflowExecutionHistoryRequest.getMaximumPageSize() != null) {
                jsonWriter.key("maximumPageSize").value((Object)getWorkflowExecutionHistoryRequest.getMaximumPageSize());
            }
            if (getWorkflowExecutionHistoryRequest.isReverseOrder() != null) {
                jsonWriter.key("reverseOrder").value((Object)getWorkflowExecutionHistoryRequest.isReverseOrder());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

