/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.Filters;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.SimpleWSNTopicExpression;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class NotificationClient
extends BaseWSRFClient {
    private EndpointReferenceType consumer;
    private HashMap<QName, EndpointReferenceType> subscriptions;

    public NotificationClient(EndpointReferenceType consumer, String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
        this.init(consumer);
    }

    public NotificationClient(EndpointReferenceType consumer, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(epr, sec);
        this.init(consumer);
    }

    private void init(EndpointReferenceType consumer) {
        this.consumer = consumer;
        this.subscriptions = new HashMap();
    }

    public void subscribe(QName event) {
        this.subscribe(event, null);
    }

    public void subscribe(QName event, String xpath) {
        try {
            NotificationProducer np = this.makeProxy(NotificationProducer.class);
            SubscribeDocument sd = SubscribeDocument.Factory.newInstance();
            sd.addNewSubscribe().addNewFilter().set(new SimpleWSNTopicExpression(event).toXml());
            Filters.addXPathMessageContentFilter(sd.getSubscribe().getFilter(), xpath);
            sd.getSubscribe().setConsumerReference(this.consumer);
            SubscribeResponseDocument res = np.Subscribe(sd);
            EndpointReferenceType epr = res.getSubscribeResponse().getSubscriptionReference();
            this.subscriptions.put(event, epr);
        }
        catch (Exception e) {
            logger.fatal("Could not subscribe...", e);
        }
    }

    public void unsubscribe(QName event) {
        try {
            EndpointReferenceType sEpr = this.subscriptions.get(event);
            new BaseWSRFClient(sEpr, this.getSecurityConfiguration()).destroy();
        }
        catch (Exception e) {
            logger.fatal("Could not unsubscribe.", e);
        }
    }
}

