/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2;

import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;
import xmlbeans.org.w3.x2000.x09.xmldsig.X509DataType;

public class SAMLUtils {
    public static String genID(String prefix) {
        Random r = new Random(new Date().getTime());
        StringBuffer id = new StringBuffer(prefix);
        for (int i = 0; i < 3; ++i) {
            id.append(Long.toHexString(r.nextLong()));
        }
        return id.toString();
    }

    public static X509Certificate[] getIssuerFromSignature(SignatureType signature) {
        if (signature == null) {
            return null;
        }
        KeyInfoType ki = signature.getKeyInfo();
        if (ki == null) {
            return null;
        }
        X509DataType[] x509Data = ki.getX509DataArray();
        if (x509Data == null) {
            return null;
        }
        for (int i = 0; i < x509Data.length; ++i) {
            if (x509Data[i].getX509CertificateArray().length <= 0) continue;
            return Utils.deserializeCertificateChain(x509Data[i].getX509CertificateArray());
        }
        return null;
    }

    public static Document getDOM(XmlObject xmlO) throws DSigException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document docToSign = builder.parse(xmlO.newInputStream());
            return docToSign;
        }
        catch (ParserConfigurationException e) {
            throw new DSigException("Can't configure DOM parser", e);
        }
        catch (SAXException e) {
            throw new DSigException("DOM parse exception", e);
        }
        catch (IOException e) {
            throw new DSigException("IO Exception while parsing DOM ??", e);
        }
    }

    public static boolean compareNameIDs(NameIDType name1, NameIDType name2) {
        String format2;
        String format1 = name1.getFormat();
        if (format1 == null) {
            format1 = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if ((format2 = name2.getFormat()) == null) {
            format2 = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if (!format1.equals(format2)) {
            return false;
        }
        if (name1.getStringValue() == null && name2.getStringValue() != null) {
            return false;
        }
        return name1.getStringValue().equals(name2.getStringValue());
    }

    public static AssertionDocument[] getAssertions(ResponseType response) throws XmlException, IOException {
        Element node = (Element)response.getDomNode();
        NodeList allChildren = node.getChildNodes();
        NodeList asNodes = node.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (asNodes == null || asNodes.getLength() == 0) {
            return new AssertionDocument[0];
        }
        ArrayList<AssertionDocument> ret = new ArrayList<AssertionDocument>(asNodes.getLength());
        for (int i = 0; i < asNodes.getLength(); ++i) {
            Node asNode = asNodes.item(i);
            for (int j = 0; j < allChildren.getLength(); ++j) {
                if (!allChildren.item(j).equals(asNode)) continue;
                AssertionDocument wrapper = AssertionDocument.Factory.parse(asNode);
                ret.add(wrapper);
            }
        }
        return ret.toArray(new AssertionDocument[ret.size()]);
    }
}

