/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateIdentityPoolRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public void setIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
    }

    public CreateIdentityPoolRequest withIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
    }

    public CreateIdentityPoolRequest withAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        return this;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
    }

    public CreateIdentityPoolRequest withSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.setSupportedLoginProviders(supportedLoginProviders);
        return this;
    }

    public CreateIdentityPoolRequest addSupportedLoginProvidersEntry(String key, String value) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(key, value);
        return this;
    }

    public CreateIdentityPoolRequest clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public void setDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
    }

    public CreateIdentityPoolRequest withDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolName() != null) {
            sb.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.isAllowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: " + this.isAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            sb.append("DeveloperProviderName: " + this.getDeveloperProviderName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.isAllowUnauthenticatedIdentities() == null ? 0 : this.isAllowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLoginProviders() == null ? 0 : this.getSupportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityPoolRequest)) {
            return false;
        }
        CreateIdentityPoolRequest other = (CreateIdentityPoolRequest)obj;
        if (other.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (other.getIdentityPoolName() != null && !other.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (other.isAllowUnauthenticatedIdentities() == null ^ this.isAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.isAllowUnauthenticatedIdentities() != null && !other.isAllowUnauthenticatedIdentities().equals(this.isAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (other.getSupportedLoginProviders() != null && !other.getSupportedLoginProviders().equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (other.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        return other.getDeveloperProviderName() == null || other.getDeveloperProviderName().equals(this.getDeveloperProviderName());
    }
}

