/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class HostOrSelfAuthorization
extends GSSAuthorization {
    private static Log logger = LogFactory.getLog((String)HostOrSelfAuthorization.class.getName());
    private static HostOrSelfAuthorization authorization;
    private HostAuthorization hostAuthz;

    public static synchronized HostOrSelfAuthorization getInstance() {
        if (authorization == null) {
            authorization = new HostOrSelfAuthorization("host");
        }
        return authorization;
    }

    public HostOrSelfAuthorization(String service) {
        if (service == null) {
            service = "host";
        }
        this.hostAuthz = new HostAuthorization(service);
    }

    public GSSName getExpectedName(GSSCredential cred, String host) throws GSSException {
        return null;
    }

    public void authorize(GSSContext context, String host) throws AuthorizationException {
        logger.debug((Object)"Authorization: HOST/SELF");
        try {
            GSSName expected = this.hostAuthz.getExpectedName(null, host);
            GSSName target = null;
            target = context.isInitiator() ? context.getTargName() : context.getSrcName();
            if (!expected.equals(target)) {
                logger.debug((Object)("Host authorization failed. Expected " + expected + " target is " + target));
                if (!context.getSrcName().equals(context.getTargName())) {
                    expected = context.isInitiator() ? context.getSrcName() : context.getTargName();
                    this.generateAuthorizationException(expected, target);
                }
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException("Authorization failure", e);
        }
    }
}

