/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.client;

import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besActivity.StdErrDocument;
import org.ggf.schemas.bes.x2006.x08.besActivity.StdOutDocument;
import org.ggf.schemas.bes.x2006.x08.besActivity.WorkingDirectoryReferenceDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityLogDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ActivityClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger("unicore.client", ActivityClient.class);
    private ResumeDocument resumeDoc;
    private HoldDocument holdDoc;
    private AbortDocument abortDoc;
    private StartDocument startDoc;
    private Calendar submissionTime;
    private Integer exitCode;
    private String stdout;
    private String stderr;
    private StorageClient storageClient;
    private final BESActivity activity = this.makeProxy(BESActivity.class);

    public ActivityClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        this.holdDoc = HoldDocument.Factory.newInstance();
        this.holdDoc.addNewHold();
        this.abortDoc = AbortDocument.Factory.newInstance();
        this.abortDoc.addNewAbort();
        this.startDoc = StartDocument.Factory.newInstance();
        this.startDoc.addNewStart();
        this.resumeDoc = ResumeDocument.Factory.newInstance();
        this.resumeDoc.addNewResume();
    }

    public ActivityClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public void start() throws Exception {
        logger.info("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        this.activity.Start(this.startDoc);
    }

    public void abort() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        this.activity.Abort(this.abortDoc);
    }

    public void hold() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        this.activity.Hold(this.holdDoc);
    }

    public void resume() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        this.activity.Resume(this.resumeDoc);
    }

    public String waitUntilDone(int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (status == ActivityStateEnumeration.FINISHED || status == ActivityStateEnumeration.FAILED) break;
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public String waitUntilReady(int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (((Object)((Object)status)).equals((Object)ActivityStateEnumeration.RUNNING)) break;
            if (((Object)((Object)status)).equals((Object)ActivityStateEnumeration.FAILED) || ((Object)((Object)status)).equals((Object)ActivityStateEnumeration.FINISHED)) {
                throw new Exception("Job is already done, status is <" + status.toString() + ">");
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public ActivityStateEnumeration.Enum getStatus() throws Exception {
        return ActivityStatusDocument.Factory.parse(this.getResourceProperty(BESActivity.RPStatus)).getActivityStatus().getState();
    }

    public ActivityStatusType getStatusAsXML() throws Exception {
        return ActivityStatusDocument.Factory.parse(this.getResourceProperty(BESActivity.RPStatus)).getActivityStatus();
    }

    public Calendar getSubmissionTime() throws Exception {
        if (this.submissionTime == null) {
            this.submissionTime = SubmissionTimeDocument.Factory.parse(this.getResourceProperty(JobManagement.RPSubmissionTime)).getSubmissionTime();
        }
        return this.submissionTime;
    }

    public StorageClient getUspaceClient() throws Exception {
        if (this.storageClient == null) {
            String address = null;
            try {
                address = this.getResourceProperty(BESActivity.RPWorkingDirectory);
            }
            catch (InvalidResourcePropertyQNameFault e) {
                throw new Exception("Working directory reference property is not supported by the activity endpoint.", e);
            }
            WorkingDirectoryReferenceDocument uspaceEpr = WorkingDirectoryReferenceDocument.Factory.parse(address);
            this.storageClient = new StorageClient(uspaceEpr.getWorkingDirectoryReference(), this.getSecurityConfiguration());
        }
        return this.storageClient;
    }

    public String getStdOut() throws Exception {
        if (this.stdout == null) {
            try {
                StdOutDocument stderrDoc = StdOutDocument.Factory.parse(this.getResourceProperty(BESActivity.RPStdout));
                this.stdout = stderrDoc.getStdOut();
            }
            catch (InvalidResourcePropertyQNameFault e) {
                throw new Exception("Stdout resource property is not supported by the activity endpoint.", e);
            }
        }
        return this.stdout;
    }

    public String getStdErr() throws Exception {
        if (this.stderr == null) {
            try {
                StdErrDocument stderrDoc = StdErrDocument.Factory.parse(this.getResourceProperty(BESActivity.RPStderr));
                this.stderr = stderrDoc.getStdErr();
            }
            catch (InvalidResourcePropertyQNameFault e) {
                throw new Exception("Stderr resource property is not supported by the activity endpoint.", e);
            }
        }
        return this.stderr;
    }

    public String getActivityLog() throws Exception {
        String log = null;
        try {
            log = this.getResourceProperty(BESActivity.RPActivityLog);
        }
        catch (InvalidResourcePropertyQNameFault e) {
            throw new Exception("Activity log resource property is not supported by the activity endpoint.", e);
        }
        ActivityLogDocument logDoc = ActivityLogDocument.Factory.parse(log);
        return logDoc.getActivityLog();
    }

    public String getActivityJSDL() throws Exception {
        String aDocStr = this.getResourceProperty(BESActivity.RPActivityDocument);
        if (aDocStr == null) {
            throw new Exception("Couldn't fetch activity's jsdl instance.");
        }
        ActivityDocumentDocument1 aDoc = ActivityDocumentDocument1.Factory.parse(aDocStr);
        return aDoc.getActivityDocument().getJobDefinition().toString();
    }

    public Integer getExitCode() {
        if (this.exitCode == null) {
            try {
                String status = this.getResourceProperty(BESActivity.RPStatus);
                ActivityStatusDocument statusDoc = ActivityStatusDocument.Factory.parse(status);
                if (statusDoc.getActivityStatus().isSetExitCode()) {
                    this.exitCode = statusDoc.getActivityStatus().getExitCode();
                }
            }
            catch (Exception e) {
                Log.logException("Can't get exit code. The exit code property may not be supported by the activity endpoint", e, logger);
            }
        }
        return this.exitCode;
    }
}

