/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ProcessModel
implements TBase<ProcessModel, _Fields>,
Serializable,
Cloneable,
Comparable<ProcessModel> {
    private static final TStruct STRUCT_DESC = new TStruct("ProcessModel");
    private static final TField PROCESS_ID_FIELD_DESC = new TField("processId", 11, 1);
    private static final TField EXPERIMENT_ID_FIELD_DESC = new TField("experimentId", 11, 2);
    private static final TField CREATION_TIME_FIELD_DESC = new TField("creationTime", 10, 3);
    private static final TField LAST_UPDATE_TIME_FIELD_DESC = new TField("lastUpdateTime", 10, 4);
    private static final TField PROCESS_STATUSES_FIELD_DESC = new TField("processStatuses", 15, 5);
    private static final TField PROCESS_DETAIL_FIELD_DESC = new TField("processDetail", 11, 6);
    private static final TField APPLICATION_INTERFACE_ID_FIELD_DESC = new TField("applicationInterfaceId", 11, 7);
    private static final TField APPLICATION_DEPLOYMENT_ID_FIELD_DESC = new TField("applicationDeploymentId", 11, 8);
    private static final TField COMPUTE_RESOURCE_ID_FIELD_DESC = new TField("computeResourceId", 11, 9);
    private static final TField PROCESS_INPUTS_FIELD_DESC = new TField("processInputs", 15, 10);
    private static final TField PROCESS_OUTPUTS_FIELD_DESC = new TField("processOutputs", 15, 11);
    private static final TField PROCESS_RESOURCE_SCHEDULE_FIELD_DESC = new TField("processResourceSchedule", 12, 12);
    private static final TField TASKS_FIELD_DESC = new TField("tasks", 15, 13);
    private static final TField TASK_DAG_FIELD_DESC = new TField("taskDag", 11, 14);
    private static final TField PROCESS_ERRORS_FIELD_DESC = new TField("processErrors", 15, 15);
    private static final TField GATEWAY_EXECUTION_ID_FIELD_DESC = new TField("gatewayExecutionId", 11, 16);
    private static final TField ENABLE_EMAIL_NOTIFICATION_FIELD_DESC = new TField("enableEmailNotification", 2, 17);
    private static final TField EMAIL_ADDRESSES_FIELD_DESC = new TField("emailAddresses", 15, 18);
    private static final TField STORAGE_RESOURCE_ID_FIELD_DESC = new TField("storageResourceId", 11, 19);
    private static final TField USER_DN_FIELD_DESC = new TField("userDn", 11, 20);
    private static final TField GENERATE_CERT_FIELD_DESC = new TField("generateCert", 2, 21);
    private static final TField EXPERIMENT_DATA_DIR_FIELD_DESC = new TField("experimentDataDir", 11, 22);
    private static final TField USER_NAME_FIELD_DESC = new TField("userName", 11, 23);
    private static final TField USE_USER_CRPREF_FIELD_DESC = new TField("useUserCRPref", 2, 24);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String processId;
    private String experimentId;
    private long creationTime;
    private long lastUpdateTime;
    private List<ProcessStatus> processStatuses;
    private String processDetail;
    private String applicationInterfaceId;
    private String applicationDeploymentId;
    private String computeResourceId;
    private List<InputDataObjectType> processInputs;
    private List<OutputDataObjectType> processOutputs;
    private ComputationalResourceSchedulingModel processResourceSchedule;
    private List<TaskModel> tasks;
    private String taskDag;
    private List<ErrorModel> processErrors;
    private String gatewayExecutionId;
    private boolean enableEmailNotification;
    private List<String> emailAddresses;
    private String storageResourceId;
    private String userDn;
    private boolean generateCert;
    private String experimentDataDir;
    private String userName;
    private boolean useUserCRPref;
    private static final int __CREATIONTIME_ISSET_ID = 0;
    private static final int __LASTUPDATETIME_ISSET_ID = 1;
    private static final int __ENABLEEMAILNOTIFICATION_ISSET_ID = 2;
    private static final int __GENERATECERT_ISSET_ID = 3;
    private static final int __USEUSERCRPREF_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ProcessModel() {
        this.processId = "DO_NOT_SET_AT_CLIENTS";
        this.generateCert = false;
    }

    public ProcessModel(String processId, String experimentId) {
        this();
        this.processId = processId;
        this.experimentId = experimentId;
    }

    public ProcessModel(ProcessModel other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetProcessId()) {
            this.processId = other.processId;
        }
        if (other.isSetExperimentId()) {
            this.experimentId = other.experimentId;
        }
        this.creationTime = other.creationTime;
        this.lastUpdateTime = other.lastUpdateTime;
        if (other.isSetProcessStatuses()) {
            ArrayList<ProcessStatus> __this__processStatuses = new ArrayList<ProcessStatus>(other.processStatuses.size());
            for (ProcessStatus processStatus : other.processStatuses) {
                __this__processStatuses.add(new ProcessStatus(processStatus));
            }
            this.processStatuses = __this__processStatuses;
        }
        if (other.isSetProcessDetail()) {
            this.processDetail = other.processDetail;
        }
        if (other.isSetApplicationInterfaceId()) {
            this.applicationInterfaceId = other.applicationInterfaceId;
        }
        if (other.isSetApplicationDeploymentId()) {
            this.applicationDeploymentId = other.applicationDeploymentId;
        }
        if (other.isSetComputeResourceId()) {
            this.computeResourceId = other.computeResourceId;
        }
        if (other.isSetProcessInputs()) {
            ArrayList<InputDataObjectType> __this__processInputs = new ArrayList<InputDataObjectType>(other.processInputs.size());
            for (InputDataObjectType inputDataObjectType : other.processInputs) {
                __this__processInputs.add(new InputDataObjectType(inputDataObjectType));
            }
            this.processInputs = __this__processInputs;
        }
        if (other.isSetProcessOutputs()) {
            ArrayList<OutputDataObjectType> __this__processOutputs = new ArrayList<OutputDataObjectType>(other.processOutputs.size());
            for (OutputDataObjectType outputDataObjectType : other.processOutputs) {
                __this__processOutputs.add(new OutputDataObjectType(outputDataObjectType));
            }
            this.processOutputs = __this__processOutputs;
        }
        if (other.isSetProcessResourceSchedule()) {
            this.processResourceSchedule = new ComputationalResourceSchedulingModel(other.processResourceSchedule);
        }
        if (other.isSetTasks()) {
            ArrayList<TaskModel> __this__tasks = new ArrayList<TaskModel>(other.tasks.size());
            for (TaskModel taskModel : other.tasks) {
                __this__tasks.add(new TaskModel(taskModel));
            }
            this.tasks = __this__tasks;
        }
        if (other.isSetTaskDag()) {
            this.taskDag = other.taskDag;
        }
        if (other.isSetProcessErrors()) {
            ArrayList<ErrorModel> __this__processErrors = new ArrayList<ErrorModel>(other.processErrors.size());
            for (ErrorModel errorModel : other.processErrors) {
                __this__processErrors.add(new ErrorModel(errorModel));
            }
            this.processErrors = __this__processErrors;
        }
        if (other.isSetGatewayExecutionId()) {
            this.gatewayExecutionId = other.gatewayExecutionId;
        }
        this.enableEmailNotification = other.enableEmailNotification;
        if (other.isSetEmailAddresses()) {
            ArrayList<String> __this__emailAddresses = new ArrayList<String>(other.emailAddresses);
            this.emailAddresses = __this__emailAddresses;
        }
        if (other.isSetStorageResourceId()) {
            this.storageResourceId = other.storageResourceId;
        }
        if (other.isSetUserDn()) {
            this.userDn = other.userDn;
        }
        this.generateCert = other.generateCert;
        if (other.isSetExperimentDataDir()) {
            this.experimentDataDir = other.experimentDataDir;
        }
        if (other.isSetUserName()) {
            this.userName = other.userName;
        }
        this.useUserCRPref = other.useUserCRPref;
    }

    public ProcessModel deepCopy() {
        return new ProcessModel(this);
    }

    public void clear() {
        this.processId = "DO_NOT_SET_AT_CLIENTS";
        this.experimentId = null;
        this.setCreationTimeIsSet(false);
        this.creationTime = 0L;
        this.setLastUpdateTimeIsSet(false);
        this.lastUpdateTime = 0L;
        this.processStatuses = null;
        this.processDetail = null;
        this.applicationInterfaceId = null;
        this.applicationDeploymentId = null;
        this.computeResourceId = null;
        this.processInputs = null;
        this.processOutputs = null;
        this.processResourceSchedule = null;
        this.tasks = null;
        this.taskDag = null;
        this.processErrors = null;
        this.gatewayExecutionId = null;
        this.setEnableEmailNotificationIsSet(false);
        this.enableEmailNotification = false;
        this.emailAddresses = null;
        this.storageResourceId = null;
        this.userDn = null;
        this.generateCert = false;
        this.experimentDataDir = null;
        this.userName = null;
        this.setUseUserCRPrefIsSet(false);
        this.useUserCRPref = false;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void unsetProcessId() {
        this.processId = null;
    }

    public boolean isSetProcessId() {
        return this.processId != null;
    }

    public void setProcessIdIsSet(boolean value) {
        if (!value) {
            this.processId = null;
        }
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public void unsetExperimentId() {
        this.experimentId = null;
    }

    public boolean isSetExperimentId() {
        return this.experimentId != null;
    }

    public void setExperimentIdIsSet(boolean value) {
        if (!value) {
            this.experimentId = null;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
    }

    public void unsetCreationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        this.setLastUpdateTimeIsSet(true);
    }

    public void unsetLastUpdateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLastUpdateTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLastUpdateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getProcessStatusesSize() {
        return this.processStatuses == null ? 0 : this.processStatuses.size();
    }

    public Iterator<ProcessStatus> getProcessStatusesIterator() {
        return this.processStatuses == null ? null : this.processStatuses.iterator();
    }

    public void addToProcessStatuses(ProcessStatus elem) {
        if (this.processStatuses == null) {
            this.processStatuses = new ArrayList<ProcessStatus>();
        }
        this.processStatuses.add(elem);
    }

    public List<ProcessStatus> getProcessStatuses() {
        return this.processStatuses;
    }

    public void setProcessStatuses(List<ProcessStatus> processStatuses) {
        this.processStatuses = processStatuses;
    }

    public void unsetProcessStatuses() {
        this.processStatuses = null;
    }

    public boolean isSetProcessStatuses() {
        return this.processStatuses != null;
    }

    public void setProcessStatusesIsSet(boolean value) {
        if (!value) {
            this.processStatuses = null;
        }
    }

    public String getProcessDetail() {
        return this.processDetail;
    }

    public void setProcessDetail(String processDetail) {
        this.processDetail = processDetail;
    }

    public void unsetProcessDetail() {
        this.processDetail = null;
    }

    public boolean isSetProcessDetail() {
        return this.processDetail != null;
    }

    public void setProcessDetailIsSet(boolean value) {
        if (!value) {
            this.processDetail = null;
        }
    }

    public String getApplicationInterfaceId() {
        return this.applicationInterfaceId;
    }

    public void setApplicationInterfaceId(String applicationInterfaceId) {
        this.applicationInterfaceId = applicationInterfaceId;
    }

    public void unsetApplicationInterfaceId() {
        this.applicationInterfaceId = null;
    }

    public boolean isSetApplicationInterfaceId() {
        return this.applicationInterfaceId != null;
    }

    public void setApplicationInterfaceIdIsSet(boolean value) {
        if (!value) {
            this.applicationInterfaceId = null;
        }
    }

    public String getApplicationDeploymentId() {
        return this.applicationDeploymentId;
    }

    public void setApplicationDeploymentId(String applicationDeploymentId) {
        this.applicationDeploymentId = applicationDeploymentId;
    }

    public void unsetApplicationDeploymentId() {
        this.applicationDeploymentId = null;
    }

    public boolean isSetApplicationDeploymentId() {
        return this.applicationDeploymentId != null;
    }

    public void setApplicationDeploymentIdIsSet(boolean value) {
        if (!value) {
            this.applicationDeploymentId = null;
        }
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public void unsetComputeResourceId() {
        this.computeResourceId = null;
    }

    public boolean isSetComputeResourceId() {
        return this.computeResourceId != null;
    }

    public void setComputeResourceIdIsSet(boolean value) {
        if (!value) {
            this.computeResourceId = null;
        }
    }

    public int getProcessInputsSize() {
        return this.processInputs == null ? 0 : this.processInputs.size();
    }

    public Iterator<InputDataObjectType> getProcessInputsIterator() {
        return this.processInputs == null ? null : this.processInputs.iterator();
    }

    public void addToProcessInputs(InputDataObjectType elem) {
        if (this.processInputs == null) {
            this.processInputs = new ArrayList<InputDataObjectType>();
        }
        this.processInputs.add(elem);
    }

    public List<InputDataObjectType> getProcessInputs() {
        return this.processInputs;
    }

    public void setProcessInputs(List<InputDataObjectType> processInputs) {
        this.processInputs = processInputs;
    }

    public void unsetProcessInputs() {
        this.processInputs = null;
    }

    public boolean isSetProcessInputs() {
        return this.processInputs != null;
    }

    public void setProcessInputsIsSet(boolean value) {
        if (!value) {
            this.processInputs = null;
        }
    }

    public int getProcessOutputsSize() {
        return this.processOutputs == null ? 0 : this.processOutputs.size();
    }

    public Iterator<OutputDataObjectType> getProcessOutputsIterator() {
        return this.processOutputs == null ? null : this.processOutputs.iterator();
    }

    public void addToProcessOutputs(OutputDataObjectType elem) {
        if (this.processOutputs == null) {
            this.processOutputs = new ArrayList<OutputDataObjectType>();
        }
        this.processOutputs.add(elem);
    }

    public List<OutputDataObjectType> getProcessOutputs() {
        return this.processOutputs;
    }

    public void setProcessOutputs(List<OutputDataObjectType> processOutputs) {
        this.processOutputs = processOutputs;
    }

    public void unsetProcessOutputs() {
        this.processOutputs = null;
    }

    public boolean isSetProcessOutputs() {
        return this.processOutputs != null;
    }

    public void setProcessOutputsIsSet(boolean value) {
        if (!value) {
            this.processOutputs = null;
        }
    }

    public ComputationalResourceSchedulingModel getProcessResourceSchedule() {
        return this.processResourceSchedule;
    }

    public void setProcessResourceSchedule(ComputationalResourceSchedulingModel processResourceSchedule) {
        this.processResourceSchedule = processResourceSchedule;
    }

    public void unsetProcessResourceSchedule() {
        this.processResourceSchedule = null;
    }

    public boolean isSetProcessResourceSchedule() {
        return this.processResourceSchedule != null;
    }

    public void setProcessResourceScheduleIsSet(boolean value) {
        if (!value) {
            this.processResourceSchedule = null;
        }
    }

    public int getTasksSize() {
        return this.tasks == null ? 0 : this.tasks.size();
    }

    public Iterator<TaskModel> getTasksIterator() {
        return this.tasks == null ? null : this.tasks.iterator();
    }

    public void addToTasks(TaskModel elem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskModel>();
        }
        this.tasks.add(elem);
    }

    public List<TaskModel> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskModel> tasks) {
        this.tasks = tasks;
    }

    public void unsetTasks() {
        this.tasks = null;
    }

    public boolean isSetTasks() {
        return this.tasks != null;
    }

    public void setTasksIsSet(boolean value) {
        if (!value) {
            this.tasks = null;
        }
    }

    public String getTaskDag() {
        return this.taskDag;
    }

    public void setTaskDag(String taskDag) {
        this.taskDag = taskDag;
    }

    public void unsetTaskDag() {
        this.taskDag = null;
    }

    public boolean isSetTaskDag() {
        return this.taskDag != null;
    }

    public void setTaskDagIsSet(boolean value) {
        if (!value) {
            this.taskDag = null;
        }
    }

    public int getProcessErrorsSize() {
        return this.processErrors == null ? 0 : this.processErrors.size();
    }

    public Iterator<ErrorModel> getProcessErrorsIterator() {
        return this.processErrors == null ? null : this.processErrors.iterator();
    }

    public void addToProcessErrors(ErrorModel elem) {
        if (this.processErrors == null) {
            this.processErrors = new ArrayList<ErrorModel>();
        }
        this.processErrors.add(elem);
    }

    public List<ErrorModel> getProcessErrors() {
        return this.processErrors;
    }

    public void setProcessErrors(List<ErrorModel> processErrors) {
        this.processErrors = processErrors;
    }

    public void unsetProcessErrors() {
        this.processErrors = null;
    }

    public boolean isSetProcessErrors() {
        return this.processErrors != null;
    }

    public void setProcessErrorsIsSet(boolean value) {
        if (!value) {
            this.processErrors = null;
        }
    }

    public String getGatewayExecutionId() {
        return this.gatewayExecutionId;
    }

    public void setGatewayExecutionId(String gatewayExecutionId) {
        this.gatewayExecutionId = gatewayExecutionId;
    }

    public void unsetGatewayExecutionId() {
        this.gatewayExecutionId = null;
    }

    public boolean isSetGatewayExecutionId() {
        return this.gatewayExecutionId != null;
    }

    public void setGatewayExecutionIdIsSet(boolean value) {
        if (!value) {
            this.gatewayExecutionId = null;
        }
    }

    public boolean isEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
        this.setEnableEmailNotificationIsSet(true);
    }

    public void unsetEnableEmailNotification() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetEnableEmailNotification() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setEnableEmailNotificationIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getEmailAddressesSize() {
        return this.emailAddresses == null ? 0 : this.emailAddresses.size();
    }

    public Iterator<String> getEmailAddressesIterator() {
        return this.emailAddresses == null ? null : this.emailAddresses.iterator();
    }

    public void addToEmailAddresses(String elem) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(elem);
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public void unsetEmailAddresses() {
        this.emailAddresses = null;
    }

    public boolean isSetEmailAddresses() {
        return this.emailAddresses != null;
    }

    public void setEmailAddressesIsSet(boolean value) {
        if (!value) {
            this.emailAddresses = null;
        }
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public void unsetStorageResourceId() {
        this.storageResourceId = null;
    }

    public boolean isSetStorageResourceId() {
        return this.storageResourceId != null;
    }

    public void setStorageResourceIdIsSet(boolean value) {
        if (!value) {
            this.storageResourceId = null;
        }
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public void unsetUserDn() {
        this.userDn = null;
    }

    public boolean isSetUserDn() {
        return this.userDn != null;
    }

    public void setUserDnIsSet(boolean value) {
        if (!value) {
            this.userDn = null;
        }
    }

    public boolean isGenerateCert() {
        return this.generateCert;
    }

    public void setGenerateCert(boolean generateCert) {
        this.generateCert = generateCert;
        this.setGenerateCertIsSet(true);
    }

    public void unsetGenerateCert() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetGenerateCert() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setGenerateCertIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public String getExperimentDataDir() {
        return this.experimentDataDir;
    }

    public void setExperimentDataDir(String experimentDataDir) {
        this.experimentDataDir = experimentDataDir;
    }

    public void unsetExperimentDataDir() {
        this.experimentDataDir = null;
    }

    public boolean isSetExperimentDataDir() {
        return this.experimentDataDir != null;
    }

    public void setExperimentDataDirIsSet(boolean value) {
        if (!value) {
            this.experimentDataDir = null;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void unsetUserName() {
        this.userName = null;
    }

    public boolean isSetUserName() {
        return this.userName != null;
    }

    public void setUserNameIsSet(boolean value) {
        if (!value) {
            this.userName = null;
        }
    }

    public boolean isUseUserCRPref() {
        return this.useUserCRPref;
    }

    public void setUseUserCRPref(boolean useUserCRPref) {
        this.useUserCRPref = useUserCRPref;
        this.setUseUserCRPrefIsSet(true);
    }

    public void unsetUseUserCRPref() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetUseUserCRPref() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setUseUserCRPrefIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case PROCESS_ID: {
                if (value == null) {
                    this.unsetProcessId();
                    break;
                }
                this.setProcessId((String)value);
                break;
            }
            case EXPERIMENT_ID: {
                if (value == null) {
                    this.unsetExperimentId();
                    break;
                }
                this.setExperimentId((String)value);
                break;
            }
            case CREATION_TIME: {
                if (value == null) {
                    this.unsetCreationTime();
                    break;
                }
                this.setCreationTime((Long)value);
                break;
            }
            case LAST_UPDATE_TIME: {
                if (value == null) {
                    this.unsetLastUpdateTime();
                    break;
                }
                this.setLastUpdateTime((Long)value);
                break;
            }
            case PROCESS_STATUSES: {
                if (value == null) {
                    this.unsetProcessStatuses();
                    break;
                }
                this.setProcessStatuses((List)value);
                break;
            }
            case PROCESS_DETAIL: {
                if (value == null) {
                    this.unsetProcessDetail();
                    break;
                }
                this.setProcessDetail((String)value);
                break;
            }
            case APPLICATION_INTERFACE_ID: {
                if (value == null) {
                    this.unsetApplicationInterfaceId();
                    break;
                }
                this.setApplicationInterfaceId((String)value);
                break;
            }
            case APPLICATION_DEPLOYMENT_ID: {
                if (value == null) {
                    this.unsetApplicationDeploymentId();
                    break;
                }
                this.setApplicationDeploymentId((String)value);
                break;
            }
            case COMPUTE_RESOURCE_ID: {
                if (value == null) {
                    this.unsetComputeResourceId();
                    break;
                }
                this.setComputeResourceId((String)value);
                break;
            }
            case PROCESS_INPUTS: {
                if (value == null) {
                    this.unsetProcessInputs();
                    break;
                }
                this.setProcessInputs((List)value);
                break;
            }
            case PROCESS_OUTPUTS: {
                if (value == null) {
                    this.unsetProcessOutputs();
                    break;
                }
                this.setProcessOutputs((List)value);
                break;
            }
            case PROCESS_RESOURCE_SCHEDULE: {
                if (value == null) {
                    this.unsetProcessResourceSchedule();
                    break;
                }
                this.setProcessResourceSchedule((ComputationalResourceSchedulingModel)value);
                break;
            }
            case TASKS: {
                if (value == null) {
                    this.unsetTasks();
                    break;
                }
                this.setTasks((List)value);
                break;
            }
            case TASK_DAG: {
                if (value == null) {
                    this.unsetTaskDag();
                    break;
                }
                this.setTaskDag((String)value);
                break;
            }
            case PROCESS_ERRORS: {
                if (value == null) {
                    this.unsetProcessErrors();
                    break;
                }
                this.setProcessErrors((List)value);
                break;
            }
            case GATEWAY_EXECUTION_ID: {
                if (value == null) {
                    this.unsetGatewayExecutionId();
                    break;
                }
                this.setGatewayExecutionId((String)value);
                break;
            }
            case ENABLE_EMAIL_NOTIFICATION: {
                if (value == null) {
                    this.unsetEnableEmailNotification();
                    break;
                }
                this.setEnableEmailNotification((Boolean)value);
                break;
            }
            case EMAIL_ADDRESSES: {
                if (value == null) {
                    this.unsetEmailAddresses();
                    break;
                }
                this.setEmailAddresses((List)value);
                break;
            }
            case STORAGE_RESOURCE_ID: {
                if (value == null) {
                    this.unsetStorageResourceId();
                    break;
                }
                this.setStorageResourceId((String)value);
                break;
            }
            case USER_DN: {
                if (value == null) {
                    this.unsetUserDn();
                    break;
                }
                this.setUserDn((String)value);
                break;
            }
            case GENERATE_CERT: {
                if (value == null) {
                    this.unsetGenerateCert();
                    break;
                }
                this.setGenerateCert((Boolean)value);
                break;
            }
            case EXPERIMENT_DATA_DIR: {
                if (value == null) {
                    this.unsetExperimentDataDir();
                    break;
                }
                this.setExperimentDataDir((String)value);
                break;
            }
            case USER_NAME: {
                if (value == null) {
                    this.unsetUserName();
                    break;
                }
                this.setUserName((String)value);
                break;
            }
            case USE_USER_CRPREF: {
                if (value == null) {
                    this.unsetUseUserCRPref();
                    break;
                }
                this.setUseUserCRPref((Boolean)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PROCESS_ID: {
                return this.getProcessId();
            }
            case EXPERIMENT_ID: {
                return this.getExperimentId();
            }
            case CREATION_TIME: {
                return this.getCreationTime();
            }
            case LAST_UPDATE_TIME: {
                return this.getLastUpdateTime();
            }
            case PROCESS_STATUSES: {
                return this.getProcessStatuses();
            }
            case PROCESS_DETAIL: {
                return this.getProcessDetail();
            }
            case APPLICATION_INTERFACE_ID: {
                return this.getApplicationInterfaceId();
            }
            case APPLICATION_DEPLOYMENT_ID: {
                return this.getApplicationDeploymentId();
            }
            case COMPUTE_RESOURCE_ID: {
                return this.getComputeResourceId();
            }
            case PROCESS_INPUTS: {
                return this.getProcessInputs();
            }
            case PROCESS_OUTPUTS: {
                return this.getProcessOutputs();
            }
            case PROCESS_RESOURCE_SCHEDULE: {
                return this.getProcessResourceSchedule();
            }
            case TASKS: {
                return this.getTasks();
            }
            case TASK_DAG: {
                return this.getTaskDag();
            }
            case PROCESS_ERRORS: {
                return this.getProcessErrors();
            }
            case GATEWAY_EXECUTION_ID: {
                return this.getGatewayExecutionId();
            }
            case ENABLE_EMAIL_NOTIFICATION: {
                return this.isEnableEmailNotification();
            }
            case EMAIL_ADDRESSES: {
                return this.getEmailAddresses();
            }
            case STORAGE_RESOURCE_ID: {
                return this.getStorageResourceId();
            }
            case USER_DN: {
                return this.getUserDn();
            }
            case GENERATE_CERT: {
                return this.isGenerateCert();
            }
            case EXPERIMENT_DATA_DIR: {
                return this.getExperimentDataDir();
            }
            case USER_NAME: {
                return this.getUserName();
            }
            case USE_USER_CRPREF: {
                return this.isUseUserCRPref();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PROCESS_ID: {
                return this.isSetProcessId();
            }
            case EXPERIMENT_ID: {
                return this.isSetExperimentId();
            }
            case CREATION_TIME: {
                return this.isSetCreationTime();
            }
            case LAST_UPDATE_TIME: {
                return this.isSetLastUpdateTime();
            }
            case PROCESS_STATUSES: {
                return this.isSetProcessStatuses();
            }
            case PROCESS_DETAIL: {
                return this.isSetProcessDetail();
            }
            case APPLICATION_INTERFACE_ID: {
                return this.isSetApplicationInterfaceId();
            }
            case APPLICATION_DEPLOYMENT_ID: {
                return this.isSetApplicationDeploymentId();
            }
            case COMPUTE_RESOURCE_ID: {
                return this.isSetComputeResourceId();
            }
            case PROCESS_INPUTS: {
                return this.isSetProcessInputs();
            }
            case PROCESS_OUTPUTS: {
                return this.isSetProcessOutputs();
            }
            case PROCESS_RESOURCE_SCHEDULE: {
                return this.isSetProcessResourceSchedule();
            }
            case TASKS: {
                return this.isSetTasks();
            }
            case TASK_DAG: {
                return this.isSetTaskDag();
            }
            case PROCESS_ERRORS: {
                return this.isSetProcessErrors();
            }
            case GATEWAY_EXECUTION_ID: {
                return this.isSetGatewayExecutionId();
            }
            case ENABLE_EMAIL_NOTIFICATION: {
                return this.isSetEnableEmailNotification();
            }
            case EMAIL_ADDRESSES: {
                return this.isSetEmailAddresses();
            }
            case STORAGE_RESOURCE_ID: {
                return this.isSetStorageResourceId();
            }
            case USER_DN: {
                return this.isSetUserDn();
            }
            case GENERATE_CERT: {
                return this.isSetGenerateCert();
            }
            case EXPERIMENT_DATA_DIR: {
                return this.isSetExperimentDataDir();
            }
            case USER_NAME: {
                return this.isSetUserName();
            }
            case USE_USER_CRPREF: {
                return this.isSetUseUserCRPref();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ProcessModel) {
            return this.equals((ProcessModel)that);
        }
        return false;
    }

    public boolean equals(ProcessModel that) {
        if (that == null) {
            return false;
        }
        boolean this_present_processId = this.isSetProcessId();
        boolean that_present_processId = that.isSetProcessId();
        if (this_present_processId || that_present_processId) {
            if (!this_present_processId || !that_present_processId) {
                return false;
            }
            if (!this.processId.equals(that.processId)) {
                return false;
            }
        }
        boolean this_present_experimentId = this.isSetExperimentId();
        boolean that_present_experimentId = that.isSetExperimentId();
        if (this_present_experimentId || that_present_experimentId) {
            if (!this_present_experimentId || !that_present_experimentId) {
                return false;
            }
            if (!this.experimentId.equals(that.experimentId)) {
                return false;
            }
        }
        boolean this_present_creationTime = this.isSetCreationTime();
        boolean that_present_creationTime = that.isSetCreationTime();
        if (this_present_creationTime || that_present_creationTime) {
            if (!this_present_creationTime || !that_present_creationTime) {
                return false;
            }
            if (this.creationTime != that.creationTime) {
                return false;
            }
        }
        boolean this_present_lastUpdateTime = this.isSetLastUpdateTime();
        boolean that_present_lastUpdateTime = that.isSetLastUpdateTime();
        if (this_present_lastUpdateTime || that_present_lastUpdateTime) {
            if (!this_present_lastUpdateTime || !that_present_lastUpdateTime) {
                return false;
            }
            if (this.lastUpdateTime != that.lastUpdateTime) {
                return false;
            }
        }
        boolean this_present_processStatuses = this.isSetProcessStatuses();
        boolean that_present_processStatuses = that.isSetProcessStatuses();
        if (this_present_processStatuses || that_present_processStatuses) {
            if (!this_present_processStatuses || !that_present_processStatuses) {
                return false;
            }
            if (!this.processStatuses.equals(that.processStatuses)) {
                return false;
            }
        }
        boolean this_present_processDetail = this.isSetProcessDetail();
        boolean that_present_processDetail = that.isSetProcessDetail();
        if (this_present_processDetail || that_present_processDetail) {
            if (!this_present_processDetail || !that_present_processDetail) {
                return false;
            }
            if (!this.processDetail.equals(that.processDetail)) {
                return false;
            }
        }
        boolean this_present_applicationInterfaceId = this.isSetApplicationInterfaceId();
        boolean that_present_applicationInterfaceId = that.isSetApplicationInterfaceId();
        if (this_present_applicationInterfaceId || that_present_applicationInterfaceId) {
            if (!this_present_applicationInterfaceId || !that_present_applicationInterfaceId) {
                return false;
            }
            if (!this.applicationInterfaceId.equals(that.applicationInterfaceId)) {
                return false;
            }
        }
        boolean this_present_applicationDeploymentId = this.isSetApplicationDeploymentId();
        boolean that_present_applicationDeploymentId = that.isSetApplicationDeploymentId();
        if (this_present_applicationDeploymentId || that_present_applicationDeploymentId) {
            if (!this_present_applicationDeploymentId || !that_present_applicationDeploymentId) {
                return false;
            }
            if (!this.applicationDeploymentId.equals(that.applicationDeploymentId)) {
                return false;
            }
        }
        boolean this_present_computeResourceId = this.isSetComputeResourceId();
        boolean that_present_computeResourceId = that.isSetComputeResourceId();
        if (this_present_computeResourceId || that_present_computeResourceId) {
            if (!this_present_computeResourceId || !that_present_computeResourceId) {
                return false;
            }
            if (!this.computeResourceId.equals(that.computeResourceId)) {
                return false;
            }
        }
        boolean this_present_processInputs = this.isSetProcessInputs();
        boolean that_present_processInputs = that.isSetProcessInputs();
        if (this_present_processInputs || that_present_processInputs) {
            if (!this_present_processInputs || !that_present_processInputs) {
                return false;
            }
            if (!this.processInputs.equals(that.processInputs)) {
                return false;
            }
        }
        boolean this_present_processOutputs = this.isSetProcessOutputs();
        boolean that_present_processOutputs = that.isSetProcessOutputs();
        if (this_present_processOutputs || that_present_processOutputs) {
            if (!this_present_processOutputs || !that_present_processOutputs) {
                return false;
            }
            if (!this.processOutputs.equals(that.processOutputs)) {
                return false;
            }
        }
        boolean this_present_processResourceSchedule = this.isSetProcessResourceSchedule();
        boolean that_present_processResourceSchedule = that.isSetProcessResourceSchedule();
        if (this_present_processResourceSchedule || that_present_processResourceSchedule) {
            if (!this_present_processResourceSchedule || !that_present_processResourceSchedule) {
                return false;
            }
            if (!this.processResourceSchedule.equals(that.processResourceSchedule)) {
                return false;
            }
        }
        boolean this_present_tasks = this.isSetTasks();
        boolean that_present_tasks = that.isSetTasks();
        if (this_present_tasks || that_present_tasks) {
            if (!this_present_tasks || !that_present_tasks) {
                return false;
            }
            if (!this.tasks.equals(that.tasks)) {
                return false;
            }
        }
        boolean this_present_taskDag = this.isSetTaskDag();
        boolean that_present_taskDag = that.isSetTaskDag();
        if (this_present_taskDag || that_present_taskDag) {
            if (!this_present_taskDag || !that_present_taskDag) {
                return false;
            }
            if (!this.taskDag.equals(that.taskDag)) {
                return false;
            }
        }
        boolean this_present_processErrors = this.isSetProcessErrors();
        boolean that_present_processErrors = that.isSetProcessErrors();
        if (this_present_processErrors || that_present_processErrors) {
            if (!this_present_processErrors || !that_present_processErrors) {
                return false;
            }
            if (!this.processErrors.equals(that.processErrors)) {
                return false;
            }
        }
        boolean this_present_gatewayExecutionId = this.isSetGatewayExecutionId();
        boolean that_present_gatewayExecutionId = that.isSetGatewayExecutionId();
        if (this_present_gatewayExecutionId || that_present_gatewayExecutionId) {
            if (!this_present_gatewayExecutionId || !that_present_gatewayExecutionId) {
                return false;
            }
            if (!this.gatewayExecutionId.equals(that.gatewayExecutionId)) {
                return false;
            }
        }
        boolean this_present_enableEmailNotification = this.isSetEnableEmailNotification();
        boolean that_present_enableEmailNotification = that.isSetEnableEmailNotification();
        if (this_present_enableEmailNotification || that_present_enableEmailNotification) {
            if (!this_present_enableEmailNotification || !that_present_enableEmailNotification) {
                return false;
            }
            if (this.enableEmailNotification != that.enableEmailNotification) {
                return false;
            }
        }
        boolean this_present_emailAddresses = this.isSetEmailAddresses();
        boolean that_present_emailAddresses = that.isSetEmailAddresses();
        if (this_present_emailAddresses || that_present_emailAddresses) {
            if (!this_present_emailAddresses || !that_present_emailAddresses) {
                return false;
            }
            if (!this.emailAddresses.equals(that.emailAddresses)) {
                return false;
            }
        }
        boolean this_present_storageResourceId = this.isSetStorageResourceId();
        boolean that_present_storageResourceId = that.isSetStorageResourceId();
        if (this_present_storageResourceId || that_present_storageResourceId) {
            if (!this_present_storageResourceId || !that_present_storageResourceId) {
                return false;
            }
            if (!this.storageResourceId.equals(that.storageResourceId)) {
                return false;
            }
        }
        boolean this_present_userDn = this.isSetUserDn();
        boolean that_present_userDn = that.isSetUserDn();
        if (this_present_userDn || that_present_userDn) {
            if (!this_present_userDn || !that_present_userDn) {
                return false;
            }
            if (!this.userDn.equals(that.userDn)) {
                return false;
            }
        }
        boolean this_present_generateCert = this.isSetGenerateCert();
        boolean that_present_generateCert = that.isSetGenerateCert();
        if (this_present_generateCert || that_present_generateCert) {
            if (!this_present_generateCert || !that_present_generateCert) {
                return false;
            }
            if (this.generateCert != that.generateCert) {
                return false;
            }
        }
        boolean this_present_experimentDataDir = this.isSetExperimentDataDir();
        boolean that_present_experimentDataDir = that.isSetExperimentDataDir();
        if (this_present_experimentDataDir || that_present_experimentDataDir) {
            if (!this_present_experimentDataDir || !that_present_experimentDataDir) {
                return false;
            }
            if (!this.experimentDataDir.equals(that.experimentDataDir)) {
                return false;
            }
        }
        boolean this_present_userName = this.isSetUserName();
        boolean that_present_userName = that.isSetUserName();
        if (this_present_userName || that_present_userName) {
            if (!this_present_userName || !that_present_userName) {
                return false;
            }
            if (!this.userName.equals(that.userName)) {
                return false;
            }
        }
        boolean this_present_useUserCRPref = this.isSetUseUserCRPref();
        boolean that_present_useUserCRPref = that.isSetUseUserCRPref();
        if (this_present_useUserCRPref || that_present_useUserCRPref) {
            if (!this_present_useUserCRPref || !that_present_useUserCRPref) {
                return false;
            }
            if (this.useUserCRPref != that.useUserCRPref) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_processId = this.isSetProcessId();
        list.add(present_processId);
        if (present_processId) {
            list.add(this.processId);
        }
        boolean present_experimentId = this.isSetExperimentId();
        list.add(present_experimentId);
        if (present_experimentId) {
            list.add(this.experimentId);
        }
        boolean present_creationTime = this.isSetCreationTime();
        list.add(present_creationTime);
        if (present_creationTime) {
            list.add(this.creationTime);
        }
        boolean present_lastUpdateTime = this.isSetLastUpdateTime();
        list.add(present_lastUpdateTime);
        if (present_lastUpdateTime) {
            list.add(this.lastUpdateTime);
        }
        boolean present_processStatuses = this.isSetProcessStatuses();
        list.add(present_processStatuses);
        if (present_processStatuses) {
            list.add(this.processStatuses);
        }
        boolean present_processDetail = this.isSetProcessDetail();
        list.add(present_processDetail);
        if (present_processDetail) {
            list.add(this.processDetail);
        }
        boolean present_applicationInterfaceId = this.isSetApplicationInterfaceId();
        list.add(present_applicationInterfaceId);
        if (present_applicationInterfaceId) {
            list.add(this.applicationInterfaceId);
        }
        boolean present_applicationDeploymentId = this.isSetApplicationDeploymentId();
        list.add(present_applicationDeploymentId);
        if (present_applicationDeploymentId) {
            list.add(this.applicationDeploymentId);
        }
        boolean present_computeResourceId = this.isSetComputeResourceId();
        list.add(present_computeResourceId);
        if (present_computeResourceId) {
            list.add(this.computeResourceId);
        }
        boolean present_processInputs = this.isSetProcessInputs();
        list.add(present_processInputs);
        if (present_processInputs) {
            list.add(this.processInputs);
        }
        boolean present_processOutputs = this.isSetProcessOutputs();
        list.add(present_processOutputs);
        if (present_processOutputs) {
            list.add(this.processOutputs);
        }
        boolean present_processResourceSchedule = this.isSetProcessResourceSchedule();
        list.add(present_processResourceSchedule);
        if (present_processResourceSchedule) {
            list.add(this.processResourceSchedule);
        }
        boolean present_tasks = this.isSetTasks();
        list.add(present_tasks);
        if (present_tasks) {
            list.add(this.tasks);
        }
        boolean present_taskDag = this.isSetTaskDag();
        list.add(present_taskDag);
        if (present_taskDag) {
            list.add(this.taskDag);
        }
        boolean present_processErrors = this.isSetProcessErrors();
        list.add(present_processErrors);
        if (present_processErrors) {
            list.add(this.processErrors);
        }
        boolean present_gatewayExecutionId = this.isSetGatewayExecutionId();
        list.add(present_gatewayExecutionId);
        if (present_gatewayExecutionId) {
            list.add(this.gatewayExecutionId);
        }
        boolean present_enableEmailNotification = this.isSetEnableEmailNotification();
        list.add(present_enableEmailNotification);
        if (present_enableEmailNotification) {
            list.add(this.enableEmailNotification);
        }
        boolean present_emailAddresses = this.isSetEmailAddresses();
        list.add(present_emailAddresses);
        if (present_emailAddresses) {
            list.add(this.emailAddresses);
        }
        boolean present_storageResourceId = this.isSetStorageResourceId();
        list.add(present_storageResourceId);
        if (present_storageResourceId) {
            list.add(this.storageResourceId);
        }
        boolean present_userDn = this.isSetUserDn();
        list.add(present_userDn);
        if (present_userDn) {
            list.add(this.userDn);
        }
        boolean present_generateCert = this.isSetGenerateCert();
        list.add(present_generateCert);
        if (present_generateCert) {
            list.add(this.generateCert);
        }
        boolean present_experimentDataDir = this.isSetExperimentDataDir();
        list.add(present_experimentDataDir);
        if (present_experimentDataDir) {
            list.add(this.experimentDataDir);
        }
        boolean present_userName = this.isSetUserName();
        list.add(present_userName);
        if (present_userName) {
            list.add(this.userName);
        }
        boolean present_useUserCRPref = this.isSetUseUserCRPref();
        list.add(present_useUserCRPref);
        if (present_useUserCRPref) {
            list.add(this.useUserCRPref);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ProcessModel other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetProcessId()).compareTo(other.isSetProcessId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessId() && (lastComparison = TBaseHelper.compareTo((String)this.processId, (String)other.processId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExperimentId()).compareTo(other.isSetExperimentId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExperimentId() && (lastComparison = TBaseHelper.compareTo((String)this.experimentId, (String)other.experimentId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreationTime()).compareTo(other.isSetCreationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationTime() && (lastComparison = TBaseHelper.compareTo((long)this.creationTime, (long)other.creationTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastUpdateTime()).compareTo(other.isSetLastUpdateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastUpdateTime() && (lastComparison = TBaseHelper.compareTo((long)this.lastUpdateTime, (long)other.lastUpdateTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessStatuses()).compareTo(other.isSetProcessStatuses());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessStatuses() && (lastComparison = TBaseHelper.compareTo(this.processStatuses, other.processStatuses)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessDetail()).compareTo(other.isSetProcessDetail());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessDetail() && (lastComparison = TBaseHelper.compareTo((String)this.processDetail, (String)other.processDetail)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetApplicationInterfaceId()).compareTo(other.isSetApplicationInterfaceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetApplicationInterfaceId() && (lastComparison = TBaseHelper.compareTo((String)this.applicationInterfaceId, (String)other.applicationInterfaceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetApplicationDeploymentId()).compareTo(other.isSetApplicationDeploymentId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetApplicationDeploymentId() && (lastComparison = TBaseHelper.compareTo((String)this.applicationDeploymentId, (String)other.applicationDeploymentId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetComputeResourceId()).compareTo(other.isSetComputeResourceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetComputeResourceId() && (lastComparison = TBaseHelper.compareTo((String)this.computeResourceId, (String)other.computeResourceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessInputs()).compareTo(other.isSetProcessInputs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessInputs() && (lastComparison = TBaseHelper.compareTo(this.processInputs, other.processInputs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessOutputs()).compareTo(other.isSetProcessOutputs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessOutputs() && (lastComparison = TBaseHelper.compareTo(this.processOutputs, other.processOutputs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessResourceSchedule()).compareTo(other.isSetProcessResourceSchedule());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessResourceSchedule() && (lastComparison = TBaseHelper.compareTo((Comparable)this.processResourceSchedule, (Comparable)other.processResourceSchedule)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTasks()).compareTo(other.isSetTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTasks() && (lastComparison = TBaseHelper.compareTo(this.tasks, other.tasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskDag()).compareTo(other.isSetTaskDag());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskDag() && (lastComparison = TBaseHelper.compareTo((String)this.taskDag, (String)other.taskDag)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcessErrors()).compareTo(other.isSetProcessErrors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessErrors() && (lastComparison = TBaseHelper.compareTo(this.processErrors, other.processErrors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGatewayExecutionId()).compareTo(other.isSetGatewayExecutionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGatewayExecutionId() && (lastComparison = TBaseHelper.compareTo((String)this.gatewayExecutionId, (String)other.gatewayExecutionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEnableEmailNotification()).compareTo(other.isSetEnableEmailNotification());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnableEmailNotification() && (lastComparison = TBaseHelper.compareTo((boolean)this.enableEmailNotification, (boolean)other.enableEmailNotification)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEmailAddresses()).compareTo(other.isSetEmailAddresses());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEmailAddresses() && (lastComparison = TBaseHelper.compareTo(this.emailAddresses, other.emailAddresses)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStorageResourceId()).compareTo(other.isSetStorageResourceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStorageResourceId() && (lastComparison = TBaseHelper.compareTo((String)this.storageResourceId, (String)other.storageResourceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUserDn()).compareTo(other.isSetUserDn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUserDn() && (lastComparison = TBaseHelper.compareTo((String)this.userDn, (String)other.userDn)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGenerateCert()).compareTo(other.isSetGenerateCert());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGenerateCert() && (lastComparison = TBaseHelper.compareTo((boolean)this.generateCert, (boolean)other.generateCert)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExperimentDataDir()).compareTo(other.isSetExperimentDataDir());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExperimentDataDir() && (lastComparison = TBaseHelper.compareTo((String)this.experimentDataDir, (String)other.experimentDataDir)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUserName()).compareTo(other.isSetUserName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUserName() && (lastComparison = TBaseHelper.compareTo((String)this.userName, (String)other.userName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUseUserCRPref()).compareTo(other.isSetUseUserCRPref());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUseUserCRPref() && (lastComparison = TBaseHelper.compareTo((boolean)this.useUserCRPref, (boolean)other.useUserCRPref)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProcessModel(");
        boolean first = true;
        sb.append("processId:");
        if (this.processId == null) {
            sb.append("null");
        } else {
            sb.append(this.processId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("experimentId:");
        if (this.experimentId == null) {
            sb.append("null");
        } else {
            sb.append(this.experimentId);
        }
        first = false;
        if (this.isSetCreationTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("creationTime:");
            sb.append(this.creationTime);
            first = false;
        }
        if (this.isSetLastUpdateTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("lastUpdateTime:");
            sb.append(this.lastUpdateTime);
            first = false;
        }
        if (this.isSetProcessStatuses()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processStatuses:");
            if (this.processStatuses == null) {
                sb.append("null");
            } else {
                sb.append(this.processStatuses);
            }
            first = false;
        }
        if (this.isSetProcessDetail()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processDetail:");
            if (this.processDetail == null) {
                sb.append("null");
            } else {
                sb.append(this.processDetail);
            }
            first = false;
        }
        if (this.isSetApplicationInterfaceId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("applicationInterfaceId:");
            if (this.applicationInterfaceId == null) {
                sb.append("null");
            } else {
                sb.append(this.applicationInterfaceId);
            }
            first = false;
        }
        if (this.isSetApplicationDeploymentId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("applicationDeploymentId:");
            if (this.applicationDeploymentId == null) {
                sb.append("null");
            } else {
                sb.append(this.applicationDeploymentId);
            }
            first = false;
        }
        if (this.isSetComputeResourceId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("computeResourceId:");
            if (this.computeResourceId == null) {
                sb.append("null");
            } else {
                sb.append(this.computeResourceId);
            }
            first = false;
        }
        if (this.isSetProcessInputs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processInputs:");
            if (this.processInputs == null) {
                sb.append("null");
            } else {
                sb.append(this.processInputs);
            }
            first = false;
        }
        if (this.isSetProcessOutputs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processOutputs:");
            if (this.processOutputs == null) {
                sb.append("null");
            } else {
                sb.append(this.processOutputs);
            }
            first = false;
        }
        if (this.isSetProcessResourceSchedule()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processResourceSchedule:");
            if (this.processResourceSchedule == null) {
                sb.append("null");
            } else {
                sb.append(this.processResourceSchedule);
            }
            first = false;
        }
        if (this.isSetTasks()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tasks:");
            if (this.tasks == null) {
                sb.append("null");
            } else {
                sb.append(this.tasks);
            }
            first = false;
        }
        if (this.isSetTaskDag()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("taskDag:");
            if (this.taskDag == null) {
                sb.append("null");
            } else {
                sb.append(this.taskDag);
            }
            first = false;
        }
        if (this.isSetProcessErrors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processErrors:");
            if (this.processErrors == null) {
                sb.append("null");
            } else {
                sb.append(this.processErrors);
            }
            first = false;
        }
        if (this.isSetGatewayExecutionId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("gatewayExecutionId:");
            if (this.gatewayExecutionId == null) {
                sb.append("null");
            } else {
                sb.append(this.gatewayExecutionId);
            }
            first = false;
        }
        if (this.isSetEnableEmailNotification()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("enableEmailNotification:");
            sb.append(this.enableEmailNotification);
            first = false;
        }
        if (this.isSetEmailAddresses()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("emailAddresses:");
            if (this.emailAddresses == null) {
                sb.append("null");
            } else {
                sb.append(this.emailAddresses);
            }
            first = false;
        }
        if (this.isSetStorageResourceId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("storageResourceId:");
            if (this.storageResourceId == null) {
                sb.append("null");
            } else {
                sb.append(this.storageResourceId);
            }
            first = false;
        }
        if (this.isSetUserDn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("userDn:");
            if (this.userDn == null) {
                sb.append("null");
            } else {
                sb.append(this.userDn);
            }
            first = false;
        }
        if (this.isSetGenerateCert()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("generateCert:");
            sb.append(this.generateCert);
            first = false;
        }
        if (this.isSetExperimentDataDir()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("experimentDataDir:");
            if (this.experimentDataDir == null) {
                sb.append("null");
            } else {
                sb.append(this.experimentDataDir);
            }
            first = false;
        }
        if (this.isSetUserName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("userName:");
            if (this.userName == null) {
                sb.append("null");
            } else {
                sb.append(this.userName);
            }
            first = false;
        }
        if (this.isSetUseUserCRPref()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("useUserCRPref:");
            sb.append(this.useUserCRPref);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetProcessId()) {
            throw new TProtocolException("Required field 'processId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetExperimentId()) {
            throw new TProtocolException("Required field 'experimentId' is unset! Struct:" + this.toString());
        }
        if (this.processResourceSchedule != null) {
            this.processResourceSchedule.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ProcessModelStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ProcessModelTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.CREATION_TIME, _Fields.LAST_UPDATE_TIME, _Fields.PROCESS_STATUSES, _Fields.PROCESS_DETAIL, _Fields.APPLICATION_INTERFACE_ID, _Fields.APPLICATION_DEPLOYMENT_ID, _Fields.COMPUTE_RESOURCE_ID, _Fields.PROCESS_INPUTS, _Fields.PROCESS_OUTPUTS, _Fields.PROCESS_RESOURCE_SCHEDULE, _Fields.TASKS, _Fields.TASK_DAG, _Fields.PROCESS_ERRORS, _Fields.GATEWAY_EXECUTION_ID, _Fields.ENABLE_EMAIL_NOTIFICATION, _Fields.EMAIL_ADDRESSES, _Fields.STORAGE_RESOURCE_ID, _Fields.USER_DN, _Fields.GENERATE_CERT, _Fields.EXPERIMENT_DATA_DIR, _Fields.USER_NAME, _Fields.USE_USER_CRPREF};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PROCESS_ID, new FieldMetaData("processId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXPERIMENT_ID, new FieldMetaData("experimentId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATION_TIME, new FieldMetaData("creationTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LAST_UPDATE_TIME, new FieldMetaData("lastUpdateTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PROCESS_STATUSES, new FieldMetaData("processStatuses", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ProcessStatus.class))));
        tmpMap.put(_Fields.PROCESS_DETAIL, new FieldMetaData("processDetail", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.APPLICATION_INTERFACE_ID, new FieldMetaData("applicationInterfaceId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.APPLICATION_DEPLOYMENT_ID, new FieldMetaData("applicationDeploymentId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COMPUTE_RESOURCE_ID, new FieldMetaData("computeResourceId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROCESS_INPUTS, new FieldMetaData("processInputs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, InputDataObjectType.class))));
        tmpMap.put(_Fields.PROCESS_OUTPUTS, new FieldMetaData("processOutputs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, OutputDataObjectType.class))));
        tmpMap.put(_Fields.PROCESS_RESOURCE_SCHEDULE, new FieldMetaData("processResourceSchedule", 2, (FieldValueMetaData)new StructMetaData(12, ComputationalResourceSchedulingModel.class)));
        tmpMap.put(_Fields.TASKS, new FieldMetaData("tasks", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TaskModel.class))));
        tmpMap.put(_Fields.TASK_DAG, new FieldMetaData("taskDag", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROCESS_ERRORS, new FieldMetaData("processErrors", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ErrorModel.class))));
        tmpMap.put(_Fields.GATEWAY_EXECUTION_ID, new FieldMetaData("gatewayExecutionId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ENABLE_EMAIL_NOTIFICATION, new FieldMetaData("enableEmailNotification", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.EMAIL_ADDRESSES, new FieldMetaData("emailAddresses", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.STORAGE_RESOURCE_ID, new FieldMetaData("storageResourceId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER_DN, new FieldMetaData("userDn", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GENERATE_CERT, new FieldMetaData("generateCert", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.EXPERIMENT_DATA_DIR, new FieldMetaData("experimentDataDir", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER_NAME, new FieldMetaData("userName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USE_USER_CRPREF, new FieldMetaData("useUserCRPref", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ProcessModel.class, metaDataMap);
    }

    private static class ProcessModelTupleScheme
    extends TupleScheme<ProcessModel> {
        private ProcessModelTupleScheme() {
        }

        public void write(TProtocol prot, ProcessModel struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.processId);
            oprot.writeString(struct.experimentId);
            BitSet optionals = new BitSet();
            if (struct.isSetCreationTime()) {
                optionals.set(0);
            }
            if (struct.isSetLastUpdateTime()) {
                optionals.set(1);
            }
            if (struct.isSetProcessStatuses()) {
                optionals.set(2);
            }
            if (struct.isSetProcessDetail()) {
                optionals.set(3);
            }
            if (struct.isSetApplicationInterfaceId()) {
                optionals.set(4);
            }
            if (struct.isSetApplicationDeploymentId()) {
                optionals.set(5);
            }
            if (struct.isSetComputeResourceId()) {
                optionals.set(6);
            }
            if (struct.isSetProcessInputs()) {
                optionals.set(7);
            }
            if (struct.isSetProcessOutputs()) {
                optionals.set(8);
            }
            if (struct.isSetProcessResourceSchedule()) {
                optionals.set(9);
            }
            if (struct.isSetTasks()) {
                optionals.set(10);
            }
            if (struct.isSetTaskDag()) {
                optionals.set(11);
            }
            if (struct.isSetProcessErrors()) {
                optionals.set(12);
            }
            if (struct.isSetGatewayExecutionId()) {
                optionals.set(13);
            }
            if (struct.isSetEnableEmailNotification()) {
                optionals.set(14);
            }
            if (struct.isSetEmailAddresses()) {
                optionals.set(15);
            }
            if (struct.isSetStorageResourceId()) {
                optionals.set(16);
            }
            if (struct.isSetUserDn()) {
                optionals.set(17);
            }
            if (struct.isSetGenerateCert()) {
                optionals.set(18);
            }
            if (struct.isSetExperimentDataDir()) {
                optionals.set(19);
            }
            if (struct.isSetUserName()) {
                optionals.set(20);
            }
            if (struct.isSetUseUserCRPref()) {
                optionals.set(21);
            }
            oprot.writeBitSet(optionals, 22);
            if (struct.isSetCreationTime()) {
                oprot.writeI64(struct.creationTime);
            }
            if (struct.isSetLastUpdateTime()) {
                oprot.writeI64(struct.lastUpdateTime);
            }
            if (struct.isSetProcessStatuses()) {
                oprot.writeI32(struct.processStatuses.size());
                for (ProcessStatus _iter24 : struct.processStatuses) {
                    _iter24.write((TProtocol)oprot);
                }
            }
            if (struct.isSetProcessDetail()) {
                oprot.writeString(struct.processDetail);
            }
            if (struct.isSetApplicationInterfaceId()) {
                oprot.writeString(struct.applicationInterfaceId);
            }
            if (struct.isSetApplicationDeploymentId()) {
                oprot.writeString(struct.applicationDeploymentId);
            }
            if (struct.isSetComputeResourceId()) {
                oprot.writeString(struct.computeResourceId);
            }
            if (struct.isSetProcessInputs()) {
                oprot.writeI32(struct.processInputs.size());
                for (InputDataObjectType _iter25 : struct.processInputs) {
                    _iter25.write((TProtocol)oprot);
                }
            }
            if (struct.isSetProcessOutputs()) {
                oprot.writeI32(struct.processOutputs.size());
                for (OutputDataObjectType _iter26 : struct.processOutputs) {
                    _iter26.write((TProtocol)oprot);
                }
            }
            if (struct.isSetProcessResourceSchedule()) {
                struct.processResourceSchedule.write((TProtocol)oprot);
            }
            if (struct.isSetTasks()) {
                oprot.writeI32(struct.tasks.size());
                for (TaskModel _iter27 : struct.tasks) {
                    _iter27.write((TProtocol)oprot);
                }
            }
            if (struct.isSetTaskDag()) {
                oprot.writeString(struct.taskDag);
            }
            if (struct.isSetProcessErrors()) {
                oprot.writeI32(struct.processErrors.size());
                for (ErrorModel _iter28 : struct.processErrors) {
                    _iter28.write((TProtocol)oprot);
                }
            }
            if (struct.isSetGatewayExecutionId()) {
                oprot.writeString(struct.gatewayExecutionId);
            }
            if (struct.isSetEnableEmailNotification()) {
                oprot.writeBool(struct.enableEmailNotification);
            }
            if (struct.isSetEmailAddresses()) {
                oprot.writeI32(struct.emailAddresses.size());
                for (String _iter29 : struct.emailAddresses) {
                    oprot.writeString(_iter29);
                }
            }
            if (struct.isSetStorageResourceId()) {
                oprot.writeString(struct.storageResourceId);
            }
            if (struct.isSetUserDn()) {
                oprot.writeString(struct.userDn);
            }
            if (struct.isSetGenerateCert()) {
                oprot.writeBool(struct.generateCert);
            }
            if (struct.isSetExperimentDataDir()) {
                oprot.writeString(struct.experimentDataDir);
            }
            if (struct.isSetUserName()) {
                oprot.writeString(struct.userName);
            }
            if (struct.isSetUseUserCRPref()) {
                oprot.writeBool(struct.useUserCRPref);
            }
        }

        public void read(TProtocol prot, ProcessModel struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.processId = iprot.readString();
            struct.setProcessIdIsSet(true);
            struct.experimentId = iprot.readString();
            struct.setExperimentIdIsSet(true);
            BitSet incoming = iprot.readBitSet(22);
            if (incoming.get(0)) {
                struct.creationTime = iprot.readI64();
                struct.setCreationTimeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.lastUpdateTime = iprot.readI64();
                struct.setLastUpdateTimeIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list30 = new TList(12, iprot.readI32());
                struct.processStatuses = new ArrayList(_list30.size);
                for (int _i32 = 0; _i32 < _list30.size; ++_i32) {
                    ProcessStatus _elem31 = new ProcessStatus();
                    _elem31.read((TProtocol)iprot);
                    struct.processStatuses.add(_elem31);
                }
                struct.setProcessStatusesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.processDetail = iprot.readString();
                struct.setProcessDetailIsSet(true);
            }
            if (incoming.get(4)) {
                struct.applicationInterfaceId = iprot.readString();
                struct.setApplicationInterfaceIdIsSet(true);
            }
            if (incoming.get(5)) {
                struct.applicationDeploymentId = iprot.readString();
                struct.setApplicationDeploymentIdIsSet(true);
            }
            if (incoming.get(6)) {
                struct.computeResourceId = iprot.readString();
                struct.setComputeResourceIdIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list33 = new TList(12, iprot.readI32());
                struct.processInputs = new ArrayList(_list33.size);
                for (int _i35 = 0; _i35 < _list33.size; ++_i35) {
                    InputDataObjectType _elem34 = new InputDataObjectType();
                    _elem34.read((TProtocol)iprot);
                    struct.processInputs.add(_elem34);
                }
                struct.setProcessInputsIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list36 = new TList(12, iprot.readI32());
                struct.processOutputs = new ArrayList(_list36.size);
                for (int _i38 = 0; _i38 < _list36.size; ++_i38) {
                    OutputDataObjectType _elem37 = new OutputDataObjectType();
                    _elem37.read((TProtocol)iprot);
                    struct.processOutputs.add(_elem37);
                }
                struct.setProcessOutputsIsSet(true);
            }
            if (incoming.get(9)) {
                struct.processResourceSchedule = new ComputationalResourceSchedulingModel();
                struct.processResourceSchedule.read((TProtocol)iprot);
                struct.setProcessResourceScheduleIsSet(true);
            }
            if (incoming.get(10)) {
                TList _list39 = new TList(12, iprot.readI32());
                struct.tasks = new ArrayList(_list39.size);
                for (int _i41 = 0; _i41 < _list39.size; ++_i41) {
                    TaskModel _elem40 = new TaskModel();
                    _elem40.read((TProtocol)iprot);
                    struct.tasks.add(_elem40);
                }
                struct.setTasksIsSet(true);
            }
            if (incoming.get(11)) {
                struct.taskDag = iprot.readString();
                struct.setTaskDagIsSet(true);
            }
            if (incoming.get(12)) {
                TList _list42 = new TList(12, iprot.readI32());
                struct.processErrors = new ArrayList(_list42.size);
                for (int _i44 = 0; _i44 < _list42.size; ++_i44) {
                    ErrorModel _elem43 = new ErrorModel();
                    _elem43.read((TProtocol)iprot);
                    struct.processErrors.add(_elem43);
                }
                struct.setProcessErrorsIsSet(true);
            }
            if (incoming.get(13)) {
                struct.gatewayExecutionId = iprot.readString();
                struct.setGatewayExecutionIdIsSet(true);
            }
            if (incoming.get(14)) {
                struct.enableEmailNotification = iprot.readBool();
                struct.setEnableEmailNotificationIsSet(true);
            }
            if (incoming.get(15)) {
                TList _list45 = new TList(11, iprot.readI32());
                struct.emailAddresses = new ArrayList(_list45.size);
                for (int _i47 = 0; _i47 < _list45.size; ++_i47) {
                    String _elem46 = iprot.readString();
                    struct.emailAddresses.add(_elem46);
                }
                struct.setEmailAddressesIsSet(true);
            }
            if (incoming.get(16)) {
                struct.storageResourceId = iprot.readString();
                struct.setStorageResourceIdIsSet(true);
            }
            if (incoming.get(17)) {
                struct.userDn = iprot.readString();
                struct.setUserDnIsSet(true);
            }
            if (incoming.get(18)) {
                struct.generateCert = iprot.readBool();
                struct.setGenerateCertIsSet(true);
            }
            if (incoming.get(19)) {
                struct.experimentDataDir = iprot.readString();
                struct.setExperimentDataDirIsSet(true);
            }
            if (incoming.get(20)) {
                struct.userName = iprot.readString();
                struct.setUserNameIsSet(true);
            }
            if (incoming.get(21)) {
                struct.useUserCRPref = iprot.readBool();
                struct.setUseUserCRPrefIsSet(true);
            }
        }
    }

    private static class ProcessModelTupleSchemeFactory
    implements SchemeFactory {
        private ProcessModelTupleSchemeFactory() {
        }

        public ProcessModelTupleScheme getScheme() {
            return new ProcessModelTupleScheme();
        }
    }

    private static class ProcessModelStandardScheme
    extends StandardScheme<ProcessModel> {
        private ProcessModelStandardScheme() {
        }

        public void read(TProtocol iprot, ProcessModel struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.processId = iprot.readString();
                            struct.setProcessIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.experimentId = iprot.readString();
                            struct.setExperimentIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.creationTime = iprot.readI64();
                            struct.setCreationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.lastUpdateTime = iprot.readI64();
                            struct.setLastUpdateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.processStatuses = new ArrayList(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                ProcessStatus _elem1 = new ProcessStatus();
                                _elem1.read(iprot);
                                struct.processStatuses.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setProcessStatusesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.processDetail = iprot.readString();
                            struct.setProcessDetailIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.applicationInterfaceId = iprot.readString();
                            struct.setApplicationInterfaceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.applicationDeploymentId = iprot.readString();
                            struct.setApplicationDeploymentIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.computeResourceId = iprot.readString();
                            struct.setComputeResourceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.processInputs = new ArrayList(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                InputDataObjectType _elem4 = new InputDataObjectType();
                                _elem4.read(iprot);
                                struct.processInputs.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setProcessInputsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 15) {
                            TList _list6 = iprot.readListBegin();
                            struct.processOutputs = new ArrayList(_list6.size);
                            for (int _i8 = 0; _i8 < _list6.size; ++_i8) {
                                OutputDataObjectType _elem7 = new OutputDataObjectType();
                                _elem7.read(iprot);
                                struct.processOutputs.add(_elem7);
                            }
                            iprot.readListEnd();
                            struct.setProcessOutputsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 12) {
                            struct.processResourceSchedule = new ComputationalResourceSchedulingModel();
                            struct.processResourceSchedule.read(iprot);
                            struct.setProcessResourceScheduleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 15) {
                            TList _list9 = iprot.readListBegin();
                            struct.tasks = new ArrayList(_list9.size);
                            for (int _i11 = 0; _i11 < _list9.size; ++_i11) {
                                TaskModel _elem10 = new TaskModel();
                                _elem10.read(iprot);
                                struct.tasks.add(_elem10);
                            }
                            iprot.readListEnd();
                            struct.setTasksIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 11) {
                            struct.taskDag = iprot.readString();
                            struct.setTaskDagIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 15) {
                            TList _list12 = iprot.readListBegin();
                            struct.processErrors = new ArrayList(_list12.size);
                            for (int _i14 = 0; _i14 < _list12.size; ++_i14) {
                                ErrorModel _elem13 = new ErrorModel();
                                _elem13.read(iprot);
                                struct.processErrors.add(_elem13);
                            }
                            iprot.readListEnd();
                            struct.setProcessErrorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 11) {
                            struct.gatewayExecutionId = iprot.readString();
                            struct.setGatewayExecutionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 2) {
                            struct.enableEmailNotification = iprot.readBool();
                            struct.setEnableEmailNotificationIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 15) {
                            TList _list15 = iprot.readListBegin();
                            struct.emailAddresses = new ArrayList(_list15.size);
                            for (int _i17 = 0; _i17 < _list15.size; ++_i17) {
                                String _elem16 = iprot.readString();
                                struct.emailAddresses.add(_elem16);
                            }
                            iprot.readListEnd();
                            struct.setEmailAddressesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 19: {
                        if (schemeField.type == 11) {
                            struct.storageResourceId = iprot.readString();
                            struct.setStorageResourceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 20: {
                        if (schemeField.type == 11) {
                            struct.userDn = iprot.readString();
                            struct.setUserDnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 21: {
                        if (schemeField.type == 2) {
                            struct.generateCert = iprot.readBool();
                            struct.setGenerateCertIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 22: {
                        if (schemeField.type == 11) {
                            struct.experimentDataDir = iprot.readString();
                            struct.setExperimentDataDirIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 23: {
                        if (schemeField.type == 11) {
                            struct.userName = iprot.readString();
                            struct.setUserNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 24: {
                        if (schemeField.type == 2) {
                            struct.useUserCRPref = iprot.readBool();
                            struct.setUseUserCRPrefIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ProcessModel struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.processId != null) {
                oprot.writeFieldBegin(PROCESS_ID_FIELD_DESC);
                oprot.writeString(struct.processId);
                oprot.writeFieldEnd();
            }
            if (struct.experimentId != null) {
                oprot.writeFieldBegin(EXPERIMENT_ID_FIELD_DESC);
                oprot.writeString(struct.experimentId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCreationTime()) {
                oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
                oprot.writeI64(struct.creationTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetLastUpdateTime()) {
                oprot.writeFieldBegin(LAST_UPDATE_TIME_FIELD_DESC);
                oprot.writeI64(struct.lastUpdateTime);
                oprot.writeFieldEnd();
            }
            if (struct.processStatuses != null && struct.isSetProcessStatuses()) {
                oprot.writeFieldBegin(PROCESS_STATUSES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.processStatuses.size()));
                for (ProcessStatus _iter18 : struct.processStatuses) {
                    _iter18.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processDetail != null && struct.isSetProcessDetail()) {
                oprot.writeFieldBegin(PROCESS_DETAIL_FIELD_DESC);
                oprot.writeString(struct.processDetail);
                oprot.writeFieldEnd();
            }
            if (struct.applicationInterfaceId != null && struct.isSetApplicationInterfaceId()) {
                oprot.writeFieldBegin(APPLICATION_INTERFACE_ID_FIELD_DESC);
                oprot.writeString(struct.applicationInterfaceId);
                oprot.writeFieldEnd();
            }
            if (struct.applicationDeploymentId != null && struct.isSetApplicationDeploymentId()) {
                oprot.writeFieldBegin(APPLICATION_DEPLOYMENT_ID_FIELD_DESC);
                oprot.writeString(struct.applicationDeploymentId);
                oprot.writeFieldEnd();
            }
            if (struct.computeResourceId != null && struct.isSetComputeResourceId()) {
                oprot.writeFieldBegin(COMPUTE_RESOURCE_ID_FIELD_DESC);
                oprot.writeString(struct.computeResourceId);
                oprot.writeFieldEnd();
            }
            if (struct.processInputs != null && struct.isSetProcessInputs()) {
                oprot.writeFieldBegin(PROCESS_INPUTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.processInputs.size()));
                for (InputDataObjectType _iter19 : struct.processInputs) {
                    _iter19.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processOutputs != null && struct.isSetProcessOutputs()) {
                oprot.writeFieldBegin(PROCESS_OUTPUTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.processOutputs.size()));
                for (OutputDataObjectType _iter20 : struct.processOutputs) {
                    _iter20.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processResourceSchedule != null && struct.isSetProcessResourceSchedule()) {
                oprot.writeFieldBegin(PROCESS_RESOURCE_SCHEDULE_FIELD_DESC);
                struct.processResourceSchedule.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.tasks != null && struct.isSetTasks()) {
                oprot.writeFieldBegin(TASKS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.tasks.size()));
                for (TaskModel _iter21 : struct.tasks) {
                    _iter21.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.taskDag != null && struct.isSetTaskDag()) {
                oprot.writeFieldBegin(TASK_DAG_FIELD_DESC);
                oprot.writeString(struct.taskDag);
                oprot.writeFieldEnd();
            }
            if (struct.processErrors != null && struct.isSetProcessErrors()) {
                oprot.writeFieldBegin(PROCESS_ERRORS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.processErrors.size()));
                for (ErrorModel _iter22 : struct.processErrors) {
                    _iter22.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.gatewayExecutionId != null && struct.isSetGatewayExecutionId()) {
                oprot.writeFieldBegin(GATEWAY_EXECUTION_ID_FIELD_DESC);
                oprot.writeString(struct.gatewayExecutionId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetEnableEmailNotification()) {
                oprot.writeFieldBegin(ENABLE_EMAIL_NOTIFICATION_FIELD_DESC);
                oprot.writeBool(struct.enableEmailNotification);
                oprot.writeFieldEnd();
            }
            if (struct.emailAddresses != null && struct.isSetEmailAddresses()) {
                oprot.writeFieldBegin(EMAIL_ADDRESSES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.emailAddresses.size()));
                for (String _iter23 : struct.emailAddresses) {
                    oprot.writeString(_iter23);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.storageResourceId != null && struct.isSetStorageResourceId()) {
                oprot.writeFieldBegin(STORAGE_RESOURCE_ID_FIELD_DESC);
                oprot.writeString(struct.storageResourceId);
                oprot.writeFieldEnd();
            }
            if (struct.userDn != null && struct.isSetUserDn()) {
                oprot.writeFieldBegin(USER_DN_FIELD_DESC);
                oprot.writeString(struct.userDn);
                oprot.writeFieldEnd();
            }
            if (struct.isSetGenerateCert()) {
                oprot.writeFieldBegin(GENERATE_CERT_FIELD_DESC);
                oprot.writeBool(struct.generateCert);
                oprot.writeFieldEnd();
            }
            if (struct.experimentDataDir != null && struct.isSetExperimentDataDir()) {
                oprot.writeFieldBegin(EXPERIMENT_DATA_DIR_FIELD_DESC);
                oprot.writeString(struct.experimentDataDir);
                oprot.writeFieldEnd();
            }
            if (struct.userName != null && struct.isSetUserName()) {
                oprot.writeFieldBegin(USER_NAME_FIELD_DESC);
                oprot.writeString(struct.userName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetUseUserCRPref()) {
                oprot.writeFieldBegin(USE_USER_CRPREF_FIELD_DESC);
                oprot.writeBool(struct.useUserCRPref);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ProcessModelStandardSchemeFactory
    implements SchemeFactory {
        private ProcessModelStandardSchemeFactory() {
        }

        public ProcessModelStandardScheme getScheme() {
            return new ProcessModelStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PROCESS_ID(1, "processId"),
        EXPERIMENT_ID(2, "experimentId"),
        CREATION_TIME(3, "creationTime"),
        LAST_UPDATE_TIME(4, "lastUpdateTime"),
        PROCESS_STATUSES(5, "processStatuses"),
        PROCESS_DETAIL(6, "processDetail"),
        APPLICATION_INTERFACE_ID(7, "applicationInterfaceId"),
        APPLICATION_DEPLOYMENT_ID(8, "applicationDeploymentId"),
        COMPUTE_RESOURCE_ID(9, "computeResourceId"),
        PROCESS_INPUTS(10, "processInputs"),
        PROCESS_OUTPUTS(11, "processOutputs"),
        PROCESS_RESOURCE_SCHEDULE(12, "processResourceSchedule"),
        TASKS(13, "tasks"),
        TASK_DAG(14, "taskDag"),
        PROCESS_ERRORS(15, "processErrors"),
        GATEWAY_EXECUTION_ID(16, "gatewayExecutionId"),
        ENABLE_EMAIL_NOTIFICATION(17, "enableEmailNotification"),
        EMAIL_ADDRESSES(18, "emailAddresses"),
        STORAGE_RESOURCE_ID(19, "storageResourceId"),
        USER_DN(20, "userDn"),
        GENERATE_CERT(21, "generateCert"),
        EXPERIMENT_DATA_DIR(22, "experimentDataDir"),
        USER_NAME(23, "userName"),
        USE_USER_CRPREF(24, "useUserCRPref");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PROCESS_ID;
                }
                case 2: {
                    return EXPERIMENT_ID;
                }
                case 3: {
                    return CREATION_TIME;
                }
                case 4: {
                    return LAST_UPDATE_TIME;
                }
                case 5: {
                    return PROCESS_STATUSES;
                }
                case 6: {
                    return PROCESS_DETAIL;
                }
                case 7: {
                    return APPLICATION_INTERFACE_ID;
                }
                case 8: {
                    return APPLICATION_DEPLOYMENT_ID;
                }
                case 9: {
                    return COMPUTE_RESOURCE_ID;
                }
                case 10: {
                    return PROCESS_INPUTS;
                }
                case 11: {
                    return PROCESS_OUTPUTS;
                }
                case 12: {
                    return PROCESS_RESOURCE_SCHEDULE;
                }
                case 13: {
                    return TASKS;
                }
                case 14: {
                    return TASK_DAG;
                }
                case 15: {
                    return PROCESS_ERRORS;
                }
                case 16: {
                    return GATEWAY_EXECUTION_ID;
                }
                case 17: {
                    return ENABLE_EMAIL_NOTIFICATION;
                }
                case 18: {
                    return EMAIL_ADDRESSES;
                }
                case 19: {
                    return STORAGE_RESOURCE_ID;
                }
                case 20: {
                    return USER_DN;
                }
                case 21: {
                    return GENERATE_CERT;
                }
                case 22: {
                    return EXPERIMENT_DATA_DIR;
                }
                case 23: {
                    return USER_NAME;
                }
                case 24: {
                    return USE_USER_CRPREF;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

