/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DecisionTask
implements Serializable {
    private String taskToken;
    private Long startedEventId;
    private WorkflowExecution workflowExecution;
    private WorkflowType workflowType;
    private ListWithAutoConstructFlag<HistoryEvent> events;
    private String nextPageToken;
    private Long previousStartedEventId;

    public String getTaskToken() {
        return this.taskToken;
    }

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    public DecisionTask withTaskToken(String taskToken) {
        this.taskToken = taskToken;
        return this;
    }

    public Long getStartedEventId() {
        return this.startedEventId;
    }

    public void setStartedEventId(Long startedEventId) {
        this.startedEventId = startedEventId;
    }

    public DecisionTask withStartedEventId(Long startedEventId) {
        this.startedEventId = startedEventId;
        return this;
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public DecisionTask withWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public DecisionTask withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public List<HistoryEvent> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<HistoryEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public DecisionTask withEvents(HistoryEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<HistoryEvent>(events.length));
        }
        for (HistoryEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public DecisionTask withEvents(Collection<HistoryEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public DecisionTask withNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    public Long getPreviousStartedEventId() {
        return this.previousStartedEventId;
    }

    public void setPreviousStartedEventId(Long previousStartedEventId) {
        this.previousStartedEventId = previousStartedEventId;
    }

    public DecisionTask withPreviousStartedEventId(Long previousStartedEventId) {
        this.previousStartedEventId = previousStartedEventId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskToken() != null) {
            sb.append("TaskToken: " + this.getTaskToken() + ",");
        }
        if (this.getStartedEventId() != null) {
            sb.append("StartedEventId: " + this.getStartedEventId() + ",");
        }
        if (this.getWorkflowExecution() != null) {
            sb.append("WorkflowExecution: " + this.getWorkflowExecution() + ",");
        }
        if (this.getWorkflowType() != null) {
            sb.append("WorkflowType: " + this.getWorkflowType() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken() + ",");
        }
        if (this.getPreviousStartedEventId() != null) {
            sb.append("PreviousStartedEventId: " + this.getPreviousStartedEventId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskToken() == null ? 0 : this.getTaskToken().hashCode());
        hashCode = 31 * hashCode + (this.getStartedEventId() == null ? 0 : this.getStartedEventId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowExecution() == null ? 0 : this.getWorkflowExecution().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowType() == null ? 0 : this.getWorkflowType().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousStartedEventId() == null ? 0 : this.getPreviousStartedEventId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTask)) {
            return false;
        }
        DecisionTask other = (DecisionTask)obj;
        if (other.getTaskToken() == null ^ this.getTaskToken() == null) {
            return false;
        }
        if (other.getTaskToken() != null && !other.getTaskToken().equals(this.getTaskToken())) {
            return false;
        }
        if (other.getStartedEventId() == null ^ this.getStartedEventId() == null) {
            return false;
        }
        if (other.getStartedEventId() != null && !other.getStartedEventId().equals(this.getStartedEventId())) {
            return false;
        }
        if (other.getWorkflowExecution() == null ^ this.getWorkflowExecution() == null) {
            return false;
        }
        if (other.getWorkflowExecution() != null && !other.getWorkflowExecution().equals(this.getWorkflowExecution())) {
            return false;
        }
        if (other.getWorkflowType() == null ^ this.getWorkflowType() == null) {
            return false;
        }
        if (other.getWorkflowType() != null && !other.getWorkflowType().equals(this.getWorkflowType())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        if (other.getNextPageToken() != null && !other.getNextPageToken().equals(this.getNextPageToken())) {
            return false;
        }
        if (other.getPreviousStartedEventId() == null ^ this.getPreviousStartedEventId() == null) {
            return false;
        }
        return other.getPreviousStartedEventId() == null || other.getPreviousStartedEventId().equals(this.getPreviousStartedEventId());
    }
}

