/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.messaging.core.RabbitMQProperties;
import org.apache.airavata.messaging.core.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQSubscriber
implements Subscriber {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQSubscriber.class);
    private Connection connection;
    private Channel channel;
    private Map<String, QueueDetail> queueDetailMap = new HashMap<String, QueueDetail>();
    private RabbitMQProperties properties;

    public RabbitMQSubscriber(RabbitMQProperties properties) throws AiravataException {
        this.properties = properties;
        this.createConnection();
    }

    private void createConnection() throws AiravataException {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(this.properties.getBrokerUrl());
            connectionFactory.setAutomaticRecoveryEnabled(this.properties.isAutoRecoveryEnable());
            this.connection = connectionFactory.newConnection();
            this.addShutdownListener();
            log.info("connected to rabbitmq: " + this.connection + " for " + this.properties.getExchangeName());
            this.channel = this.connection.createChannel();
            this.channel.basicQos(this.properties.getPrefetchCount());
            this.channel.exchangeDeclare(this.properties.getExchangeName(), this.properties.getExchangeType(), true);
        }
        catch (Exception e) {
            String msg = "could not open channel for exchange " + this.properties.getExchangeName();
            log.error(msg);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    @Override
    public String listen(BiFunction<Connection, Channel, Consumer> supplier, String queueName, List<String> routingKeys) throws AiravataException {
        try {
            if (!this.channel.isOpen()) {
                this.channel = this.connection.createChannel();
                this.channel.exchangeDeclare(this.properties.getExchangeName(), this.properties.getExchangeType(), false);
            }
            if (queueName == null) {
                queueName = this.channel.queueDeclare().getQueue();
            } else {
                this.channel.queueDeclare(queueName, true, false, false, null);
            }
            String id = this.getId(routingKeys, queueName);
            if (this.queueDetailMap.containsKey(id)) {
                throw new IllegalStateException("This subscriber is already defined for this Subscriber, cannot define the same subscriber twice");
            }
            for (String key : routingKeys) {
                this.channel.queueBind(queueName, this.properties.getExchangeName(), key);
            }
            this.channel.basicConsume(queueName, this.properties.isAutoAck(), this.properties.getConsumerTag(), supplier.apply(this.connection, this.channel));
            this.queueDetailMap.put(id, new QueueDetail(queueName, routingKeys));
            return id;
        }
        catch (IOException e) {
            String msg = "could not open channel for exchange " + this.properties.getExchangeName();
            log.error(msg);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    @Override
    public void stopListen(String id) throws AiravataException {
        QueueDetail details = this.queueDetailMap.get(id);
        if (details != null) {
            try {
                for (String key : details.getRoutingKeys()) {
                    this.channel.queueUnbind(details.getQueueName(), this.properties.getExchangeName(), key);
                }
                this.channel.queueDelete(details.getQueueName(), true, true);
            }
            catch (IOException e) {
                String msg = "could not un-bind queue: " + details.getQueueName() + " for exchange " + this.properties.getExchangeName();
                log.debug(msg);
            }
        }
    }

    @Override
    public void sendAck(long deliveryTag) {
        try {
            if (this.channel.isOpen()) {
                this.channel.basicAck(deliveryTag, false);
            } else {
                this.channel = this.connection.createChannel();
                this.channel.basicQos(this.properties.getPrefetchCount());
                this.channel.basicAck(deliveryTag, false);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addShutdownListener() {
        this.connection.addShutdownListener(new ShutdownListener(){

            public void shutdownCompleted(ShutdownSignalException cause) {
                log.error("RabbitMQ connection " + RabbitMQSubscriber.this.connection + " for " + RabbitMQSubscriber.this.properties.getExchangeName() + " has been shut down", (Throwable)cause);
            }
        });
    }

    private String getId(List<String> routingKeys, String queueName) {
        String id = "";
        for (String key : routingKeys) {
            id = id + "_" + key;
        }
        return id + "_" + queueName;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class QueueDetail {
        String queueName;
        List<String> routingKeys;

        private QueueDetail(String queueName, List<String> routingKeys) {
            this.queueName = queueName;
            this.routingKeys = routingKeys;
        }

        public String getQueueName() {
            return this.queueName;
        }

        List<String> getRoutingKeys() {
            return this.routingKeys;
        }
    }
}

