/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems");
                jsonWriter.object();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    ListWithAutoConstructFlag attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.object();
                    ListWithAutoConstructFlag keysList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getKeys();
                    if (!(keysList == null || keysList.isAutoConstruct() && keysList.isEmpty())) {
                        jsonWriter.key("Keys");
                        jsonWriter.array();
                        for (Map keysListValue : keysList) {
                            if (keysListValue == null) continue;
                            jsonWriter.object();
                            for (Map.Entry memberListValue : keysListValue.entrySet()) {
                                if (memberListValue.getValue() == null) continue;
                                jsonWriter.key((String)memberListValue.getKey());
                                AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)memberListValue.getValue(), jsonWriter);
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((attributesToGetList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                        jsonWriter.key("AttributesToGet");
                        jsonWriter.array();
                        for (String attributesToGetListValue : attributesToGetList) {
                            if (attributesToGetListValue == null) continue;
                            jsonWriter.value((Object)attributesToGetListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (requestItemsListValue.getValue().isConsistentRead() != null) {
                        jsonWriter.key("ConsistentRead").value((Object)requestItemsListValue.getValue().isConsistentRead());
                    }
                    if (requestItemsListValue.getValue().getProjectionExpression() != null) {
                        jsonWriter.key("ProjectionExpression").value((Object)requestItemsListValue.getValue().getProjectionExpression());
                    }
                    if (requestItemsListValue.getValue().getExpressionAttributeNames() != null) {
                        jsonWriter.key("ExpressionAttributeNames");
                        jsonWriter.object();
                        for (Map.Entry<String, String> expressionAttributeNamesListValue : requestItemsListValue.getValue().getExpressionAttributeNames().entrySet()) {
                            if (expressionAttributeNamesListValue.getValue() == null) continue;
                            jsonWriter.key(expressionAttributeNamesListValue.getKey());
                            jsonWriter.value((Object)expressionAttributeNamesListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (batchGetItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)batchGetItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

