/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.model.MetaBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanCache
implements MetaBeanFinder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConcurrentMap<String, MetaBean> cacheById = new ConcurrentHashMap<String, MetaBean>();
    protected final ConcurrentMap<Class<?>, MetaBean> cacheByClass = new ConcurrentHashMap();

    public MetaBeanCache() {
    }

    public MetaBeanCache(Map<String, MetaBean> beans) {
        this();
        for (MetaBean bean : beans.values()) {
            this.cache(bean);
        }
    }

    public void clear() {
        this.cacheById.clear();
        this.cacheByClass.clear();
    }

    @Override
    public MetaBean findForId(String beanInfoId) {
        return (MetaBean)this.cacheById.get(beanInfoId);
    }

    @Override
    public MetaBean findForClass(Class<?> clazz) {
        return (MetaBean)this.cacheByClass.get(clazz);
    }

    public Map<String, MetaBean> findAll() {
        return this.cacheById;
    }

    public void cache(MetaBean beanInfo) {
        this.cacheById.put(beanInfo.getId(), beanInfo);
        if (beanInfo.getBeanClass() != null && beanInfo.getId().equals(beanInfo.getBeanClass().getName())) {
            this.cacheByClass.putIfAbsent(beanInfo.getBeanClass(), beanInfo);
        }
    }

    public void removeFromCache(MetaBean beanInfo) {
        this.cacheById.remove(beanInfo.getId());
        if (beanInfo.getBeanClass() != null && beanInfo.getId().equals(beanInfo.getBeanClass().getName())) {
            this.cacheByClass.remove(beanInfo.getBeanClass());
        }
    }
}

