/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.XMLStreamWriterFilter;
import org.apache.axiom.om.util.XMLStreamWriterRemoveIllegalChars;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.XOPEncodedStream;
import org.apache.axiom.util.stax.xop.XOPUtils;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.BOMOutputStreamFilter;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentMarshaller;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentUnmarshaller;
import org.apache.axis2.datasource.jaxb.XMLStreamWriterArrayFilter;
import org.apache.axis2.datasource.jaxb.XSDListUtils;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.message.OccurrenceArray;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.axis2.jaxws.utility.XmlEnumUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDSContext {
    private static final Log log = LogFactory.getLog(JAXBDSContext.class);
    public static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private TreeSet<String> contextPackages;
    private String contextPackagesKey;
    private JAXBContext customerJAXBContext;
    private WeakReference<JAXBContext> autoJAXBContext = null;
    private JAXBUtils.CONSTRUCTION_TYPE constructionType = JAXBUtils.CONSTRUCTION_TYPE.UNKNOWN;
    private MessageContext msgContext;
    private Class processType = null;
    private boolean isxmlList = false;
    private String webServiceNamespace;

    public JAXBDSContext(TreeSet<String> packages, String packagesKey) {
        this.contextPackages = packages;
        this.contextPackagesKey = packagesKey;
    }

    public JAXBDSContext(TreeSet<String> packages) {
        this(packages, packages.toString());
    }

    public JAXBDSContext(String contextPackage) {
        this.contextPackages = new TreeSet();
        this.contextPackages.add(contextPackage);
        this.contextPackagesKey = this.contextPackages.toString();
    }

    public JAXBDSContext(JAXBContext jaxbContext) {
        this.customerJAXBContext = jaxbContext;
    }

    public TreeSet<String> getContextPackages() {
        return this.contextPackages;
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        return this.getJAXBContext(null);
    }

    public JAXBContext getJAXBContext(ClassLoader cl) throws JAXBException {
        return this.getJAXBContext(cl, false);
    }

    public JAXBContext getJAXBContext(ClassLoader cl, boolean forceArrays) throws JAXBException {
        if (this.customerJAXBContext != null) {
            return this.customerJAXBContext;
        }
        JAXBContext jc = null;
        if (this.autoJAXBContext != null) {
            jc = (JAXBContext)this.autoJAXBContext.get();
        }
        if (forceArrays && jc != null && this.constructionType != JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A JAXBContext exists but it was not constructed with array class.  The JAXBContext will be rebuilt.");
            }
            jc = null;
        }
        if (jc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a JAXBContext with the context packages.");
            }
            Holder<JAXBUtils.CONSTRUCTION_TYPE> constructType = new Holder<JAXBUtils.CONSTRUCTION_TYPE>();
            HashMap<String, String> properties = null;
            if (this.webServiceNamespace != null) {
                properties = new HashMap<String, String>();
                properties.put(JAXBUtils.DEFAULT_NAMESPACE_REMAP, this.webServiceNamespace);
            }
            jc = JAXBUtils.getJAXBContext(this.contextPackages, constructType, forceArrays, this.contextPackagesKey, cl, properties);
            this.constructionType = (JAXBUtils.CONSTRUCTION_TYPE)((Object)constructType.value);
            this.autoJAXBContext = new WeakReference<JAXBContext>(jc);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using an existing JAXBContext");
        }
        return jc;
    }

    public void setWebServiceNamespace(String namespace) {
        this.webServiceNamespace = namespace;
    }

    public Class getProcessType() {
        return this.processType;
    }

    public void setProcessType(Class type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process Type set to: " + type));
        }
        this.processType = type;
    }

    public JAXBUtils.CONSTRUCTION_TYPE getConstructionType() {
        return this.constructionType;
    }

    public boolean isxmlList() {
        return this.isxmlList;
    }

    public void setIsxmlList(boolean isxmlList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("isxmlListSet to " + isxmlList));
        }
        this.isxmlList = isxmlList;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public ClassLoader getClassLoader() {
        Parameter param;
        MessageContext context = this.getMessageContext();
        if (context != null && (param = context.getParameter("CACHE_CLASSLOADER")) != null) {
            return (ClassLoader)param.getValue();
        }
        return null;
    }

    protected AttachmentMarshaller createAttachmentMarshaller(XMLStreamWriter writer) {
        return new JAXBAttachmentMarshaller(this.getMessageContext(), writer);
    }

    protected AttachmentUnmarshaller createAttachmentUnmarshaller(MimePartProvider mimePartProvider) {
        return new JAXBAttachmentUnmarshaller(mimePartProvider, this.getMessageContext());
    }

    public Object unmarshal(XMLStreamReader inputReader) throws JAXBException {
        if (DEBUG_ENABLED) {
            String clsText = inputReader != null ? inputReader.getClass().toString() : "null";
            log.debug((Object)("unmarshal with inputReader=" + clsText));
        }
        XOPEncodedStream xopEncodedStream = XOPUtils.getXOPEncodedStream((XMLStreamReader)inputReader);
        XMLStreamReader reader = XMLStreamReaderUtils.getOriginalXMLStreamReader((XMLStreamReader)xopEncodedStream.getReader());
        if (DEBUG_ENABLED) {
            String clsText = reader != null ? reader.getClass().toString() : "null";
            log.debug((Object)("  originalReader=" + clsText));
        }
        ClassLoader cl = this.getClassLoader();
        Unmarshaller u = JAXBUtils.getJAXBUnmarshaller(this.getJAXBContext(cl));
        AttachmentUnmarshaller aum = this.createAttachmentUnmarshaller(xopEncodedStream.getMimePartProvider());
        if (aum != null) {
            if (DEBUG_ENABLED) {
                log.debug((Object)"Adding JAXBAttachmentUnmarshaller to Unmarshaller");
            }
            u.setAttachmentUnmarshaller(aum);
        }
        Object jaxb = null;
        jaxb = this.getProcessType() == null ? JAXBDSContext.unmarshalByElement(u, reader) : JAXBDSContext.unmarshalByType(u, reader, this.getProcessType(), this.isxmlList(), this.getConstructionType());
        JAXBUtils.releaseJAXBUnmarshaller(this.getJAXBContext(cl), u);
        return jaxb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"enter marshal");
        }
        boolean installedFilter = false;
        try {
            AttachmentMarshaller am;
            ClassLoader cl = this.getClassLoader();
            JAXBContext jbc = this.getJAXBContext(cl);
            Marshaller m = JAXBUtils.getJAXBMarshaller(jbc);
            if (writer instanceof MTOMXMLStreamWriter && ((MTOMXMLStreamWriter)writer).getOutputFormat() != null) {
                String encoding = ((MTOMXMLStreamWriter)writer).getOutputFormat().getCharSetEncoding();
                String marshallerEncoding = (String)m.getProperty("jaxb.encoding");
                if (encoding == null && marshallerEncoding == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The encoding and the marshaller's JAXB_ENCODING are both set to the default (UTF-8)");
                    }
                } else {
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    if (!encoding.equalsIgnoreCase(marshallerEncoding)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The Marshaller.JAXB_ENCODING is " + marshallerEncoding));
                            log.debug((Object)("The Marshaller.JAXB_ENCODING is changed to the message encoding " + encoding));
                        }
                        m.setProperty("jaxb.encoding", (Object)encoding);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("The encoding and the marshaller's JAXB_ENCODING are both set to:" + marshallerEncoding));
                    }
                }
            }
            if ((am = this.createAttachmentMarshaller(writer)) != null) {
                if (DEBUG_ENABLED) {
                    log.debug((Object)"Adding JAXBAttachmentMarshaller to Marshaller");
                }
                m.setAttachmentMarshaller(am);
            }
            MessageContext mc = this.getMessageContext();
            installedFilter = this.installFilter(mc, writer);
            if (this.getProcessType() == null) {
                JAXBDSContext.marshalByElement(obj, m, writer, true);
            } else {
                this.marshalByType(obj, m, writer, this.getProcessType(), this.isxmlList(), this.getConstructionType(), true);
            }
            JAXBUtils.releaseJAXBMarshaller(jbc, m);
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit marshal");
            }
        }
        finally {
            if (installedFilter) {
                this.uninstallFilter(writer);
            }
        }
    }

    private static void marshalByElement(final Object b, final Marshaller m, final XMLStreamWriter writer, final boolean optimize) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    OutputStream os;
                    OutputStream outputStream = os = optimize ? JAXBDSContext.getOutputStream(writer, m) : null;
                    if (os != null) {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByElement.  Marshaling to an OutputStream. Object is " + JAXBDSContext.getDebugName(b)));
                        }
                        writer.flush();
                        m.marshal(b, os);
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByElement.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(b)));
                        }
                        m.marshal(b, writer);
                    }
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    private static String getDebugName(Object o) {
        String name;
        String string = name = o == null ? "null" : o.getClass().getCanonicalName();
        if (o instanceof JAXBElement) {
            name = name + " containing " + JAXBDSContext.getDebugName(((JAXBElement)o).getValue());
        }
        return name;
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer, Marshaller m) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XMLStreamWriter is " + writer));
        }
        OutputStream os = null;
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            os = ((MTOMXMLStreamWriter)writer).getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OutputStream accessible from MTOMXMLStreamWriter is " + os));
            }
        }
        if (writer.getClass() == XMLStreamWriterWithOS.class) {
            os = ((XMLStreamWriterWithOS)writer).getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("OutputStream accessible from XMLStreamWriterWithOS is " + os));
            }
        }
        if (os != null) {
            String marshallerEncoding;
            block10: {
                marshallerEncoding = null;
                try {
                    marshallerEncoding = (String)m.getProperty("jaxb.encoding");
                }
                catch (PropertyException e) {
                    if (!DEBUG_ENABLED) break block10;
                    log.debug((Object)("Could not query JAXB_ENCODING..Continuing. " + (Object)((Object)e)));
                }
            }
            if (marshallerEncoding != null && !marshallerEncoding.equalsIgnoreCase("UTF-8")) {
                if (DEBUG_ENABLED) {
                    log.debug((Object)"Wrapping output stream to remove BOM");
                }
                os = new BOMOutputStreamFilter(marshallerEncoding, os);
            }
        }
        return os;
    }

    public static Object unmarshalByType(final Unmarshaller u, final XMLStreamReader reader, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        if (DEBUG_ENABLED) {
            log.debug((Object)"Invoking unmarshalByType.");
            log.debug((Object)("  type = " + type));
            log.debug((Object)("  isList = " + isList));
            log.debug((Object)("  ctype = " + (Object)((Object)ctype)));
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object jaxb;
                    if (!isList) {
                        if (type.isArray()) {
                            if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                                if (DEBUG_ENABLED) {
                                    log.debug((Object)"Unmarshal Array via BY_CONTEXT_PATH approach");
                                }
                                jaxb = u.unmarshal(reader, type);
                            } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                                Class<?> cType = type.getComponentType();
                                while (cType.isArray()) {
                                    cType = cType.getComponentType();
                                }
                                if (cType.isPrimitive()) {
                                    if (DEBUG_ENABLED) {
                                        log.debug((Object)"Unmarshal Array of primitive via BY_CLASS_ARRAY approach");
                                    }
                                    jaxb = u.unmarshal(reader, type);
                                } else {
                                    if (DEBUG_ENABLED) {
                                        log.debug((Object)"Unmarshal Array of non-primitive via BY_CLASS_ARRAY approach");
                                    }
                                    jaxb = JAXBDSContext.unmarshalArray(reader, u, type);
                                }
                            } else {
                                if (DEBUG_ENABLED) {
                                    log.debug((Object)"Unmarshal Array");
                                }
                                jaxb = u.unmarshal(reader, type);
                            }
                        } else if (type.isEnum()) {
                            JAXBElement enumValue;
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("Unmarshalling " + type.getName() + " as Enum"));
                            }
                            jaxb = (enumValue = u.unmarshal(reader, XmlEnumUtils.getConversionType(type))) != null ? XmlEnumUtils.fromValue(type, enumValue.getValue()) : null;
                        } else {
                            if (DEBUG_ENABLED) {
                                log.debug((Object)"Unmarshalling normal case (not array, not xsd:list, not enum)");
                            }
                            jaxb = u.unmarshal(reader, type);
                        }
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)"Unmarshalling xsd:list");
                        }
                        jaxb = JAXBDSContext.unmarshalAsListOrArray(reader, u, type);
                    }
                    if (log.isDebugEnabled()) {
                        if (jaxb == null) {
                            if (DEBUG_ENABLED) {
                                log.debug((Object)"End unmarshalByType returning null object");
                            }
                        } else if (jaxb instanceof JAXBElement) {
                            JAXBElement jbe = (JAXBElement)jaxb;
                            if (DEBUG_ENABLED) {
                                log.debug((Object)"End unmarshalByType returning JAXBElement");
                                log.debug((Object)("  Class = " + jbe.getDeclaredType()));
                                log.debug((Object)("  QName = " + jbe.getName()));
                            }
                        } else if (DEBUG_ENABLED) {
                            log.debug((Object)("End unmarshalByType returning " + jaxb.getClass()));
                        }
                    }
                    return jaxb;
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
            }
        });
    }

    private static Object unmarshalArray(final XMLStreamReader reader, final Unmarshaller u, Class type) throws Exception {
        try {
            Object jaxb;
            Object typeObj;
            if (DEBUG_ENABLED) {
                log.debug((Object)"Invoking unmarshalArray");
            }
            if ((typeObj = JAXBDSContext.getTypeEnabledObject(jaxb = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader, String[].class);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            }))) instanceof String[]) {
                String[] strArray = (String[])typeObj;
                Object obj = XSDListUtils.fromStringArray(strArray, type);
                QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
                jaxb = new JAXBElement(qName, type, obj);
            }
            return jaxb;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    public static Object unmarshalAsListOrArray(final XMLStreamReader reader, final Unmarshaller u, Class type) throws IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, JAXBException {
        if (DEBUG_ENABLED) {
            log.debug((Object)"Invoking unmarshalAsListOrArray");
        }
        Object jaxb = null;
        try {
            jaxb = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader, String.class);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
        if (JAXBDSContext.getTypeEnabledObject(jaxb) instanceof String) {
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
            Object obj = XSDListUtils.fromXSDListString((String)JAXBDSContext.getTypeEnabledObject(jaxb), type);
            return new JAXBElement(qName, type, obj);
        }
        return jaxb;
    }

    static Object getTypeEnabledObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    private static boolean isOccurrenceArray(Object obj) {
        return obj instanceof JAXBElement && ((JAXBElement)obj).getValue() instanceof OccurrenceArray;
    }

    private void marshalByType(final Object b, final Marshaller m, final XMLStreamWriter writer, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype, final boolean optimize) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter marshalByType b=" + JAXBDSContext.getDebugName(b) + " type=" + type + " marshaller=" + m + " writer=" + writer + " isList=" + isList + " ctype=" + (Object)((Object)ctype) + " optimize=" + optimize));
        }
        if (JAXBDSContext.isOccurrenceArray(b)) {
            this.marshalOccurrenceArray((JAXBElement)b, m, writer);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    OutputStream os;
                    Object jbo = b;
                    if (DEBUG_ENABLED) {
                        log.debug((Object)("check if marshalling list or array object, type = " + (b != null ? b.getClass().getName() : "null")));
                    }
                    if (isList) {
                        String text;
                        QName qName;
                        if (DEBUG_ENABLED) {
                            log.debug((Object)"marshalling type which is a List");
                        }
                        if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("marshalling [context path approach] with xmllist text = " + text));
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("marshalling [class array approach] with xmllist text = " + text));
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        }
                    }
                    if (type.isEnum() && b != null) {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("marshalByType. Marshaling " + type.getName() + " as Enum"));
                        }
                        JAXBElement jbe = (JAXBElement)b;
                        String value = XMLRootElementUtil.getEnumValue((Enum)jbe.getValue());
                        jbo = new JAXBElement(jbe.getName(), String.class, (Object)value);
                    }
                    OutputStream outputStream = os = optimize ? JAXBDSContext.getOutputStream(writer, m) : null;
                    if (os == null) {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByType.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(jbo)));
                        }
                        m.marshal(jbo, writer);
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByType.  Marshaling to an OutputStream. Object is " + JAXBDSContext.getDebugName(jbo)));
                        }
                        m.marshal(jbo, os);
                    }
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    private void marshalOccurrenceArray(final JAXBElement jbe_in, final Marshaller m_in, final XMLStreamWriter writer_in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter marshalOccurrenceArray");
            log.debug((Object)("  Marshaller = " + JavaUtils.getObjectIdentity(m_in)));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Marshaller m = m_in;
                    JAXBContext newJBC = null;
                    if (JAXBDSContext.this.getConstructionType() != JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Building a JAXBContext with array capability");
                        }
                        ClassLoader cl = JAXBDSContext.this.getClassLoader();
                        newJBC = JAXBDSContext.this.getJAXBContext(cl, true);
                        m = JAXBUtils.getJAXBMarshaller(newJBC);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The new JAXBContext was constructed with " + (Object)((Object)JAXBDSContext.this.getConstructionType())));
                        }
                    }
                    OccurrenceArray occurArray = (OccurrenceArray)jbe_in.getValue();
                    JAXBElement jbe = new JAXBElement(jbe_in.getName(), Object[].class, (Object)occurArray.getAsArray());
                    XMLStreamWriterArrayFilter writer = new XMLStreamWriterArrayFilter(writer_in);
                    m.marshal((Object)jbe, (XMLStreamWriter)writer);
                    if (newJBC != null) {
                        JAXBUtils.releaseJAXBMarshaller(newJBC, m);
                    }
                    return null;
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit marshalOccurrenceArray");
        }
    }

    public static Object unmarshalByElement(final Unmarshaller u, final XMLStreamReader reader) throws WebServiceException {
        try {
            if (DEBUG_ENABLED) {
                log.debug((Object)"Invoking unMarshalByElement");
            }
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    private boolean installFilter(MessageContext mc, XMLStreamWriter writer) {
        if (!(writer instanceof MTOMXMLStreamWriter)) {
            return false;
        }
        if (!ContextUtils.isJAXBRemoveIllegalChars(mc)) {
            return false;
        }
        MTOMXMLStreamWriter mtomWriter = (MTOMXMLStreamWriter)writer;
        mtomWriter.setFilter((XMLStreamWriterFilter)new XMLStreamWriterRemoveIllegalChars());
        return true;
    }

    private void uninstallFilter(XMLStreamWriter writer) {
        MTOMXMLStreamWriter mtomWriter = (MTOMXMLStreamWriter)writer;
        mtomWriter.removeFilter();
    }
}

