/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public final class DBUtils {
    private static Log log = LogFactory.getLog(DBUtils.class);

    private DBUtils() {
    }

    public static String getConvertedAutoGeneratedColumnName(String dbProductName, String columnName) {
        String autoGeneratedColumnName = columnName;
        if ("PostgreSQL".equals(dbProductName)) {
            autoGeneratedColumnName = columnName.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Database product name is PostgreSQL. Converting column name " + columnName + " to lowercase (" + autoGeneratedColumnName + ")."));
            }
        }
        return autoGeneratedColumnName;
    }

    public static boolean canReturnGeneratedKeys(String dbProductName) {
        return !dbProductName.equals("OpenEdge RDBMS");
    }

    public static String getRegistryDBConfig() throws Exception {
        return DBUtils.extractDBConfigFromXMLConfigFile(CarbonUtils.getRegistryXMLPath());
    }

    public static String getUserManagerDBConfig() throws Exception {
        return DBUtils.extractDBConfigFromXMLConfigFile(CarbonUtils.getUserMgtXMLPath());
    }

    private static String extractDBConfigFromXMLConfigFile(String path) throws Exception {
        String dbConfigInfo = null;
        if (path != null) {
            File file = new File(path);
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                log.error((Object)("Failed pasring config file " + path + ". "), (Throwable)e);
                throw e;
            }
            NodeList dbConfig = doc.getElementsByTagName("dbConfig");
            Element inner = (Element)dbConfig.item(0);
            NodeList urlFinder = inner.getElementsByTagName("url");
            String urlValue = urlFinder.item(0).getTextContent();
            try {
                dbConfigInfo = DatabaseCreator.getDatabaseType(urlValue);
            }
            catch (Exception e) {
                log.error((Object)("Failed to extract database type for config file " + path + ". "), (Throwable)e);
                throw e;
            }
        }
        log.error((Object)"Cannot find config file; Invalide path: null");
        return dbConfigInfo;
    }
}

