/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentError;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentOutput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.Process;
import org.apache.airavata.registry.core.experiment.catalog.model.Project;
import org.apache.airavata.registry.core.experiment.catalog.model.UserConfigurationData;
import org.apache.airavata.registry.core.experiment.catalog.model.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="EXPERIMENT")
public class Experiment {
    private static final Logger logger = LoggerFactory.getLogger(Experiment.class);
    private String experimentId;
    private String projectId;
    private String gatewayId;
    private String experimentType;
    private String userName;
    private String experimentName;
    private Timestamp creationTime;
    private String description;
    private String executionId;
    private String gatewayExecutionId;
    private String gatewayInstanceId;
    private Boolean enableEmailNotification;
    private String emailAddresses;
    private Users user;
    private Project project;
    private Collection<ExperimentError> experimentErrors;
    private Collection<ExperimentInput> experimentInputs;
    private Collection<ExperimentOutput> experimentOutputs;
    private Collection<ExperimentStatus> experimentStatuses;
    private Collection<Process> processes;
    private UserConfigurationData userConfigurationData;

    @Id
    @Column(name="EXPERIMENT_ID")
    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    @Column(name="GATEWAY_ID")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    @Column(name="PROJECT_ID")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Column(name="EXPERIMENT_TYPE")
    public String getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(String experimentType) {
        this.experimentType = experimentType;
    }

    @Column(name="USER_NAME")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="EXPERIMENT_NAME")
    public String getExperimentName() {
        return this.experimentName;
    }

    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="EXECUTION_ID")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Column(name="GATEWAY_EXECUTION_ID")
    public String getGatewayExecutionId() {
        return this.gatewayExecutionId;
    }

    public void setGatewayExecutionId(String gatewayExecutionId) {
        this.gatewayExecutionId = gatewayExecutionId;
    }

    @Column(name="GATEWAY_INSTANCE_ID")
    public String getGatewayInstanceId() {
        return this.gatewayInstanceId;
    }

    public void setGatewayInstanceId(String gatewayInstanceId) {
        this.gatewayInstanceId = gatewayInstanceId;
    }

    @Column(name="ENABLE_EMAIL_NOTIFICATION")
    public Boolean getEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(Boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
    }

    @Lob
    @Column(name="EMAIL_ADDRESSES")
    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @ManyToOne
    @JoinColumn(name="PROJECT_ID", referencedColumnName="PROJECT_ID", nullable=false)
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project projectByProjectId) {
        this.project = projectByProjectId;
    }

    @OneToMany(mappedBy="experiment")
    public Collection<ExperimentError> getExperimentErrors() {
        return this.experimentErrors;
    }

    public void setExperimentErrors(Collection<ExperimentError> experimentErrorsByExperimentId) {
        this.experimentErrors = experimentErrorsByExperimentId;
    }

    @OneToMany(mappedBy="experiment")
    public Collection<ExperimentInput> getExperimentInputs() {
        return this.experimentInputs;
    }

    public void setExperimentInputs(Collection<ExperimentInput> experimentInputsByExperimentId) {
        this.experimentInputs = experimentInputsByExperimentId;
    }

    @OneToMany(mappedBy="experiment")
    public Collection<ExperimentOutput> getExperimentOutputs() {
        return this.experimentOutputs;
    }

    public void setExperimentOutputs(Collection<ExperimentOutput> experimentOutputsByExperimentId) {
        this.experimentOutputs = experimentOutputsByExperimentId;
    }

    @OneToMany(mappedBy="experiment")
    public Collection<ExperimentStatus> getExperimentStatuses() {
        return this.experimentStatuses;
    }

    public void setExperimentStatuses(Collection<ExperimentStatus> experimentStatusesByExperimentId) {
        this.experimentStatuses = experimentStatusesByExperimentId;
    }

    @OneToMany(mappedBy="experiment")
    public Collection<Process> getProcesses() {
        return this.processes;
    }

    public void setProcesses(Collection<Process> processesesByExperimentId) {
        this.processes = processesesByExperimentId;
    }

    @OneToOne(mappedBy="experiment")
    public UserConfigurationData getUserConfigurationData() {
        return this.userConfigurationData;
    }

    public void setUserConfigurationData(UserConfigurationData userConfigurationDataByExperimentId) {
        this.userConfigurationData = userConfigurationDataByExperimentId;
    }
}

