/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacEngine;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.monitor.JobMonitor;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.task.DataStreamingTask;
import org.apache.airavata.gfac.impl.task.EnvironmentSetupTask;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.DataStageType;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.EnvironmentSetupTaskModel;
import org.apache.airavata.model.task.JobSubmissionTaskModel;
import org.apache.airavata.model.task.MonitorTaskModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFacEngineImpl
implements GFacEngine {
    private static final Logger log = LoggerFactory.getLogger(GFacEngineImpl.class);

    public ProcessContext populateProcessContext(String processId, String gatewayId, String tokenId) throws GFacException, CredentialStoreException {
        ProcessContext processContext = null;
        ProcessContext.ProcessContextBuilder builder = new ProcessContext.ProcessContextBuilder(processId, gatewayId, tokenId);
        try {
            List jobModels;
            AppCatalog appCatalog = Factory.getDefaultAppCatalog();
            ExperimentCatalog expCatalog = Factory.getDefaultExpCatalog();
            ProcessModel processModel = (ProcessModel)expCatalog.get(ExperimentCatalogModelType.PROCESS, (Object)processId);
            builder.setAppCatalog(appCatalog).setExperimentCatalog(expCatalog).setCuratorClient(Factory.getCuratorClient()).setStatusPublisher(Factory.getStatusPublisher()).setProcessModel(processModel).setGatewayResourceProfile(appCatalog.getGatewayProfile().getGatewayProfile(gatewayId)).setGatewayComputeResourcePreference(appCatalog.getGatewayProfile().getComputeResourcePreference(gatewayId, processModel.getComputeResourceId())).setGatewayStorageResourcePreference(appCatalog.getGatewayProfile().getStoragePreference(gatewayId, processModel.getStorageResourceId()));
            processContext = builder.build();
            this.checkpoint(processContext);
            if (processModel.isUseUserCRPref()) {
                this.setUserResourceProfile(gatewayId, processContext);
                this.setUserComputeResourcePreference(gatewayId, processContext);
            }
            String scratchLocation = processContext.getScratchLocation();
            String workingDirectory = scratchLocation + File.separator + processId + File.separator;
            StorageResourceDescription storageResource = appCatalog.getStorageResource().getStorageResource(processModel.getStorageResourceId());
            if (storageResource == null) {
                processContext.setProcessStatus(new ProcessStatus(ProcessState.FAILED));
                GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                throw new GFacException("expId: " + processModel.getExperimentId() + ", processId: " + processId + ":- Couldn't find storage resource for storage resource id :" + processModel.getStorageResourceId());
            }
            processContext.setStorageResource(storageResource);
            processContext.setComputeResourceDescription(appCatalog.getComputeResource().getComputeResource(processContext.getComputeResourceId()));
            processContext.setApplicationDeploymentDescription(appCatalog.getApplicationDeployment().getApplicationDeployement(processModel.getApplicationDeploymentId()));
            ApplicationInterfaceDescription applicationInterface = appCatalog.getApplicationInterface().getApplicationInterface(processModel.getApplicationInterfaceId());
            processContext.setApplicationInterfaceDescription(applicationInterface);
            List applicationOutputs = applicationInterface.getApplicationOutputs();
            if (applicationOutputs != null && !applicationOutputs.isEmpty()) {
                for (OutputDataObjectType outputDataObjectType : applicationOutputs) {
                    if (outputDataObjectType.getType().equals((Object)DataType.STDOUT)) {
                        if (outputDataObjectType.getValue() == null || outputDataObjectType.getValue().equals("")) {
                            outputDataObjectType.setValue(workingDirectory + applicationInterface.getApplicationName() + ".stdout");
                            processContext.setStdoutLocation(workingDirectory + applicationInterface.getApplicationName() + ".stdout");
                        } else {
                            processContext.setStdoutLocation(outputDataObjectType.getValue());
                        }
                    }
                    if (!outputDataObjectType.getType().equals((Object)DataType.STDERR)) continue;
                    if (outputDataObjectType.getValue() == null || outputDataObjectType.getValue().equals("")) {
                        String stderrLocation = workingDirectory + applicationInterface.getApplicationName() + ".stderr";
                        outputDataObjectType.setValue(stderrLocation);
                        processContext.setStderrLocation(stderrLocation);
                        continue;
                    }
                    processContext.setStderrLocation(outputDataObjectType.getValue());
                }
            }
            expCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processId);
            processModel.setProcessOutputs(applicationOutputs);
            if (processContext.getJobSubmissionProtocol() == JobSubmissionProtocol.UNICORE) {
                processContext.setMonitorMode(MonitorMode.FORK);
            } else {
                processContext.setResourceJobManager(GFacEngineImpl.getResourceJobManager(processContext));
                processContext.setJobSubmissionRemoteCluster(Factory.getJobSubmissionRemoteCluster(processContext));
                processContext.setDataMovementRemoteCluster(Factory.getDataMovementRemoteCluster(processContext));
            }
            String inputPath = ServerSettings.getLocalDataLocation();
            if (inputPath != null) {
                processContext.setLocalWorkingDir((inputPath.endsWith("/") ? inputPath : inputPath + "/") + processContext.getProcessId());
            }
            if ((jobModels = expCatalog.get(ExperimentCatalogModelType.JOB, "processId", (Object)processId)) != null && !jobModels.isEmpty()) {
                if (jobModels.size() > 1) {
                    log.warn("Process has more than one job model, take first one");
                }
                processContext.setJobModel((JobModel)jobModels.get(0));
            }
            return processContext;
        }
        catch (AppCatalogException e) {
            String msg = "App catalog access exception ";
            this.saveErrorModel(processContext, (Exception)((Object)e), msg);
            this.updateProcessFailure(processContext, msg);
            throw new GFacException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Registry access exception";
            this.saveErrorModel(processContext, (Exception)((Object)e), msg);
            this.updateProcessFailure(processContext, msg);
            throw new GFacException(msg, (Throwable)e);
        }
        catch (AiravataException e) {
            String msg = "Remote cluster initialization error";
            this.saveErrorModel(processContext, (Exception)((Object)e), msg);
            this.updateProcessFailure(processContext, msg);
            throw new GFacException(msg, (Throwable)e);
        }
    }

    private void checkpoint(ProcessContext processContext) {
        try {
            this.checkRecoveryWithCancel(processContext);
        }
        catch (Exception e) {
            log.error("expId: {}, processId: {}, Error while checking process cancel data in zookeeper", (Object)processContext.getExperimentId(), (Object)processContext.getProcessId());
        }
    }

    private void setUserResourceProfile(String gatewayId, ProcessContext processContext) throws AppCatalogException {
        AppCatalog appCatalog = processContext.getAppCatalog();
        ProcessModel processModel = processContext.getProcessModel();
        UserResourceProfile userResourceProfile = appCatalog.getUserResourceProfile().getUserResourceProfile(processModel.getUserName(), gatewayId);
        processContext.setUserResourceProfile(userResourceProfile);
    }

    private void setUserComputeResourcePreference(String gatewayId, ProcessContext processContext) throws AppCatalogException {
        AppCatalog appCatalog = processContext.getAppCatalog();
        ProcessModel processModel = processContext.getProcessModel();
        UserComputeResourcePreference userComputeResourcePreference = appCatalog.getUserResourceProfile().getUserComputeResourcePreference(processModel.getUserName(), gatewayId, processModel.getComputeResourceId());
        processContext.setUserComputeResourcePreference(userComputeResourcePreference);
    }

    private void checkRecoveryWithCancel(ProcessContext processContext) throws Exception {
        CuratorFramework curatorClient = processContext.getCuratorClient();
        String experimentId = processContext.getExperimentId();
        String processId = processContext.getProcessId();
        String processCancelNodePath = ZKPaths.makePath((String)ZKPaths.makePath((String)ZKPaths.makePath((String)"/experiments", (String)experimentId), (String)processId), (String)"/cancelListener");
        log.info("expId: {}, processId: {}, get process cancel data from zookeeper node {}", new Object[]{experimentId, processId, processCancelNodePath});
        byte[] bytes = (byte[])curatorClient.getData().forPath(processCancelNodePath);
        if (bytes != null && new String(bytes).equalsIgnoreCase("CANCEL_REQUEST")) {
            processContext.setRecoveryWithCancel(true);
        }
    }

    public void executeProcess(ProcessContext processContext) throws GFacException {
        if (processContext.isInterrupted()) {
            GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
            return;
        }
        String taskDag = processContext.getTaskDag();
        List taskIds = GFacUtils.parseTaskDag((String)taskDag);
        processContext.setTaskExecutionOrder(taskIds);
        this.executeTaskListFrom(processContext, (String)taskIds.get(0));
    }

    private void executeTaskListFrom(ProcessContext processContext, String startingTaskId) throws GFacException {
        if (processContext.isInterrupted() && processContext.getProcessState() != ProcessState.MONITORING) {
            GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
            return;
        }
        List taskList = processContext.getTaskList();
        Map taskMap = processContext.getTaskMap();
        boolean fastForward = true;
        for (String taskId : processContext.getTaskExecutionOrder()) {
            if (fastForward) {
                if (!taskId.equalsIgnoreCase(startingTaskId)) continue;
                fastForward = false;
            }
            TaskModel taskModel = (TaskModel)taskMap.get(taskId);
            processContext.setCurrentExecutingTaskModel(taskModel);
            TaskTypes taskType = taskModel.getTaskType();
            TaskContext taskContext = this.getTaskContext(processContext);
            taskContext.setTaskModel(taskModel);
            ProcessStatus status = null;
            switch (taskType) {
                case ENV_SETUP: {
                    status = new ProcessStatus(ProcessState.CONFIGURING_WORKSPACE);
                    status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    processContext.setProcessStatus(status);
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                    if (processContext.isInterrupted()) {
                        GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
                        return;
                    }
                    this.configureWorkspace(taskContext, processContext.isRecovery());
                    if (!processContext.isInterrupted()) break;
                    GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
                    return;
                }
                case DATA_STAGING: {
                    try {
                        if (processContext.isInterrupted()) {
                            GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
                            return;
                        }
                        DataStagingTaskModel subTaskModel = (DataStagingTaskModel)taskContext.getSubTaskModel();
                        DataStageType type = subTaskModel.getType();
                        switch (type) {
                            case INPUT: {
                                status = new ProcessStatus(ProcessState.INPUT_DATA_STAGING);
                                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                                processContext.setProcessStatus(status);
                                GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                                taskContext.setProcessInput(subTaskModel.getProcessInput());
                                this.inputDataStaging(taskContext, processContext.isRecovery());
                                break;
                            }
                            case OUPUT: {
                                status = new ProcessStatus(ProcessState.OUTPUT_DATA_STAGING);
                                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                                processContext.setProcessStatus(status);
                                GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                                taskContext.setProcessOutput(subTaskModel.getProcessOutput());
                                this.outputDataStaging(taskContext, processContext.isRecovery(), false);
                                break;
                            }
                            case ARCHIVE_OUTPUT: {
                                status = new ProcessStatus(ProcessState.OUTPUT_DATA_STAGING);
                                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                                processContext.setProcessStatus(status);
                                GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                                this.outputDataStaging(taskContext, processContext.isRecovery(), true);
                            }
                        }
                        if (processContext.isInterrupted()) {
                            GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
                            return;
                        }
                        break;
                    }
                    catch (TException e) {
                        throw new GFacException((Exception)((Object)e));
                    }
                }
                case JOB_SUBMISSION: {
                    List processOutputs;
                    if (processContext.isInterrupted()) {
                        GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
                        return;
                    }
                    status = new ProcessStatus(ProcessState.EXECUTING);
                    status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    processContext.setProcessStatus(status);
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                    this.executeJobSubmission(taskContext, processContext.isRecovery());
                    JobStatus jobStatus = (JobStatus)processContext.getJobModel().getJobStatuses().get(0);
                    if (jobStatus == null || jobStatus.getJobState() != JobState.SUBMITTED && jobStatus.getJobState() != JobState.QUEUED && jobStatus.getJobState() != JobState.ACTIVE || (processOutputs = processContext.getProcessModel().getProcessOutputs()) == null || processOutputs.isEmpty()) break;
                    for (OutputDataObjectType output : processOutputs) {
                        try {
                            if (!output.isOutputStreaming()) continue;
                            TaskModel streamingTaskModel = new TaskModel();
                            streamingTaskModel.setTaskType(TaskTypes.OUTPUT_FETCHING);
                            streamingTaskModel.setTaskStatuses(Arrays.asList(new TaskStatus(TaskState.CREATED)));
                            streamingTaskModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
                            streamingTaskModel.setParentProcessId(processContext.getProcessId());
                            TaskContext streamingTaskContext = this.getTaskContext(processContext);
                            DataStagingTaskModel submodel = new DataStagingTaskModel();
                            submodel.setType(DataStageType.OUPUT);
                            submodel.setProcessOutput(output);
                            URI source = new URI(processContext.getDataMovementProtocol().name(), processContext.getComputeResourceLoginUserName(), processContext.getComputeResourceDescription().getHostName(), 22, processContext.getWorkingDir() + output.getValue(), null, null);
                            submodel.setSource(source.getPath());
                            submodel.setDestination("dummy://temp/file/location");
                            streamingTaskModel.setSubTaskModel(ThriftUtils.serializeThriftObject((TBase)submodel));
                            String streamTaskId = (String)processContext.getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)streamingTaskModel, (Object)processContext.getProcessId());
                            streamingTaskModel.setTaskId(streamTaskId);
                            streamingTaskContext.setTaskModel(streamingTaskModel);
                            this.executeDataStreaming(streamingTaskContext, processContext.isRecovery());
                        }
                        catch (URISyntaxException | RegistryException | TException e) {
                            log.error("Error while streaming output " + output.getValue());
                        }
                    }
                    break;
                }
                case MONITORING: {
                    status = new ProcessStatus(ProcessState.MONITORING);
                    status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    processContext.setProcessStatus(status);
                    GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
                    this.executeJobMonitoring(taskContext, processContext.isRecovery());
                    break;
                }
                case ENV_CLEANUP: {
                    break;
                }
                default: {
                    throw new GFacException("Unsupported Task type");
                }
            }
            if (!processContext.isPauseTaskExecution()) continue;
            return;
        }
        processContext.setComplete(true);
    }

    private void executeJobMonitoring(TaskContext taskContext, boolean recovery) throws GFacException {
        TaskStatus taskStatus;
        ProcessContext processContext = taskContext.getParentProcessContext();
        JobMonitor monitorService = null;
        try {
            taskStatus = new TaskStatus(TaskState.EXECUTING);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(taskStatus);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            MonitorTaskModel monitorTaskModel = (MonitorTaskModel)taskContext.getSubTaskModel();
            monitorService = Factory.getMonitorService(monitorTaskModel.getMonitorMode());
            if (!monitorService.isMonitoring(processContext.getJobModel().getJobId())) {
                monitorService.monitor(processContext.getJobModel().getJobId(), taskContext);
            } else {
                log.warn("Jobid: {}, already in monitoring map", (Object)processContext.getJobModel().getJobId());
            }
        }
        catch (AiravataException | TException e) {
            TaskStatus taskStatus2 = new TaskStatus(TaskState.FAILED);
            taskStatus2.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskStatus2.setReason("Couldn't handover jobId {} to monitor service, monitor service type {}");
            taskContext.setTaskStatus(taskStatus2);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            String errorMsg = "expId: " + processContext.getExperimentId() + ", processId: " + processContext.getProcessId() + ", taskId: " + taskContext.getTaskId() + ", type: " + taskContext.getTaskType().name() + " :- Input staging failed. Reason: " + taskStatus2.getReason();
            ErrorModel errorModel = new ErrorModel();
            errorModel.setUserFriendlyMessage("Error while staging output data");
            errorModel.setActualErrorMessage(errorMsg);
            GFacUtils.saveTaskError((TaskContext)taskContext, (ErrorModel)errorModel);
            throw new GFacException((Exception)e);
        }
        if (processContext.isPauseTaskExecution()) {
            return;
        }
        taskStatus = new TaskStatus(TaskState.COMPLETED);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskStatus.setReason("Successfully handed over job id to job monitor service.");
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
    }

    private boolean executeJobSubmission(TaskContext taskContext, boolean recovery) throws GFacException {
        TaskStatus taskStatus = new TaskStatus(TaskState.EXECUTING);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        try {
            JobSubmissionTaskModel jobSubmissionTaskModel = (JobSubmissionTaskModel)taskContext.getSubTaskModel();
            JobSubmissionTask jobSubmissionTask = Factory.getJobSubmissionTask(jobSubmissionTaskModel.getJobSubmissionProtocol());
            ProcessContext processContext = taskContext.getParentProcessContext();
            taskStatus = this.executeTask(taskContext, (Task)jobSubmissionTask, recovery);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(taskStatus);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            this.checkFailures(taskContext, taskStatus, (Task)jobSubmissionTask);
            return false;
        }
        catch (TException e) {
            throw new GFacException((Exception)((Object)e));
        }
    }

    private void executeDataStreaming(TaskContext taskContext, boolean recovery) throws GFacException {
        TaskStatus taskStatus = new TaskStatus(TaskState.EXECUTING);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        try {
            DataStreamingTask dataStreamingTask = new DataStreamingTask();
            taskStatus = this.executeTask(taskContext, dataStreamingTask, recovery);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(taskStatus);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        }
        catch (Exception e) {
            throw new GFacException(e);
        }
    }

    private boolean configureWorkspace(TaskContext taskContext, boolean recover) throws GFacException {
        try {
            EnvironmentSetupTaskModel subTaskModel = (EnvironmentSetupTaskModel)taskContext.getSubTaskModel();
            EnvironmentSetupTask envSetupTask = null;
            if (subTaskModel.getProtocol() != SecurityProtocol.SSH_KEYS && subTaskModel.getProtocol() != SecurityProtocol.LOCAL) {
                throw new GFacException("Unsupported security protocol, Airavata doesn't support " + subTaskModel.getProtocol().name() + " protocol yet.");
            }
            envSetupTask = new EnvironmentSetupTask();
            TaskStatus status = new TaskStatus(TaskState.EXECUTING);
            status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(status);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            TaskStatus taskStatus = this.executeTask(taskContext, envSetupTask, recover);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskContext.setTaskStatus(taskStatus);
            GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
            if (taskStatus.getState() == TaskState.FAILED) {
                log.error("expId: {}, processId: {}, taskId: {} type: {},:- Input staging failed, reason: {}", new Object[]{taskContext.getParentProcessContext().getExperimentId(), taskContext.getParentProcessContext().getProcessId(), taskContext.getTaskId(), envSetupTask.getType().name(), taskStatus.getReason()});
                ProcessContext processContext = taskContext.getParentProcessContext();
                String errorMsg = "expId: " + processContext.getExperimentId() + ", processId: " + processContext.getProcessId() + ", taskId: " + taskContext.getTaskId() + ", type: " + taskContext.getTaskType().name() + " :- Environment Setup failed. Reason: " + taskStatus.getReason();
                ErrorModel errorModel = new ErrorModel();
                errorModel.setUserFriendlyMessage("Error while environment setup");
                errorModel.setActualErrorMessage(errorMsg);
                GFacUtils.saveTaskError((TaskContext)taskContext, (ErrorModel)errorModel);
                throw new GFacException("Error while environment setup");
            }
        }
        catch (TException e) {
            throw new GFacException("Couldn't get environment setup task model", (Throwable)e);
        }
        return false;
    }

    private boolean inputDataStaging(TaskContext taskContext, boolean recover) throws GFacException, TException {
        TaskStatus taskStatus = new TaskStatus(TaskState.EXECUTING);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        ProcessContext processContext = taskContext.getParentProcessContext();
        Task dMoveTask = Factory.getDataMovementTask(processContext.getDataMovementProtocol());
        if (null == dMoveTask) {
            throw new GFacException("Unsupported security protocol, Airavata doesn't support " + processContext.getDataMovementProtocol() + " protocol yet.");
        }
        if (taskContext.getProcessInput().getType() == DataType.URI_COLLECTION) {
            String values = taskContext.getProcessInput().getValue();
            String[] multiple_inputs = values.split(",");
            DataStagingTaskModel subTaskModel = (DataStagingTaskModel)taskContext.getSubTaskModel();
            for (String input : multiple_inputs) {
                taskContext.getProcessInput().setValue(input);
                subTaskModel.setSource(input);
                taskStatus = this.executeTask(taskContext, dMoveTask, false);
            }
            taskContext.getProcessInput().setValue(values);
        } else {
            taskStatus = this.executeTask(taskContext, dMoveTask, false);
        }
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        this.checkFailures(taskContext, taskStatus, dMoveTask);
        return false;
    }

    private void checkFailures(TaskContext taskContext, TaskStatus taskStatus, Task task) throws GFacException {
        if (taskStatus.getState() == TaskState.FAILED) {
            log.error("expId: {}, processId: {}, taskId: {} type: {},:- " + task.getType().toString() + " failed, reason: {}", new Object[]{taskContext.getParentProcessContext().getExperimentId(), taskContext.getParentProcessContext().getProcessId(), taskContext.getTaskId(), task.getType().name(), taskStatus.getReason()});
            String errorMsg = "expId: " + taskContext.getParentProcessContext().getExperimentId() + ", processId: " + taskContext.getParentProcessContext().getProcessId() + ", taskId: " + taskContext.getTaskId() + ", type: " + taskContext.getTaskType().name() + (" :- " + task.getType().toString() + " failed. Reason: ") + taskStatus.getReason();
            ErrorModel errorModel = new ErrorModel();
            errorModel.setUserFriendlyMessage("Error while executing " + task.getType() + " task");
            errorModel.setActualErrorMessage(errorMsg);
            GFacUtils.saveTaskError((TaskContext)taskContext, (ErrorModel)errorModel);
            throw new GFacException("Error: userFriendly msg :" + errorModel.getUserFriendlyMessage() + ", actual msg :" + errorModel.getActualErrorMessage());
        }
    }

    public void recoverProcess(ProcessContext processContext) throws GFacException {
        processContext.setRecovery(true);
        String taskDag = processContext.getProcessModel().getTaskDag();
        List taskExecutionOrder = GFacUtils.parseTaskDag((String)taskDag);
        processContext.setTaskExecutionOrder(taskExecutionOrder);
        Map taskMap = processContext.getTaskMap();
        String recoverTaskId = null;
        String previousTaskId = null;
        TaskModel taskModel = null;
        for (String taskId : taskExecutionOrder) {
            taskModel = (TaskModel)taskMap.get(taskId);
            TaskState state = ((TaskStatus)taskModel.getTaskStatuses().get(0)).getState();
            if (state == TaskState.CREATED || state == TaskState.EXECUTING) {
                recoverTaskId = taskId;
                break;
            }
            previousTaskId = taskId;
        }
        String rTaskId = recoverTaskId;
        String pTaskId = previousTaskId;
        if (recoverTaskId != null) {
            if (processContext.isRecoveryWithCancel()) {
                this.cancelJobSubmission(processContext, rTaskId, pTaskId);
            }
            this.continueProcess(processContext, recoverTaskId);
        } else {
            log.error("expId: {}, processId: {}, couldn't find recovery task, mark this as complete ", (Object)processContext.getExperimentId(), (Object)processContext.getProcessId());
            processContext.setComplete(true);
        }
    }

    private void cancelJobSubmission(ProcessContext processContext, String rTaskId, String pTaskId) {
        new Thread(() -> {
            try {
                processContext.setCancel(true);
                ProcessState processState = processContext.getProcessState();
                List jobModels = null;
                switch (processState) {
                    case EXECUTING: {
                        jobModels = processContext.getExperimentCatalog().get(ExperimentCatalogModelType.JOB, "taskId", (Object)rTaskId);
                        break;
                    }
                    case MONITORING: {
                        if (pTaskId == null) break;
                        jobModels = processContext.getExperimentCatalog().get(ExperimentCatalogModelType.JOB, "taskId", (Object)pTaskId);
                    }
                }
                if (jobModels != null && !jobModels.isEmpty()) {
                    JobModel jobModel = (JobModel)jobModels.get(jobModels.size() - 1);
                    if (jobModel.getJobId() != null) {
                        processContext.setJobModel(jobModel);
                        log.info("expId: {}, processId: {}, Canceling jobId {}", new Object[]{processContext.getExperimentId(), processContext.getProcessId(), jobModel.getJobId()});
                        this.cancelProcess(processContext);
                        log.info("expId: {}, processId: {}, Canceled jobId {}", new Object[]{processContext.getExperimentId(), processContext.getProcessId(), jobModel.getJobId()});
                    } else {
                        log.error("expId: {}, processId: {}, Couldn't find jobId in jobModel, aborting process recovery", (Object)processContext.getExperimentId(), (Object)processContext.getProcessId());
                    }
                }
            }
            catch (GFacException e) {
                log.error("expId: {}, processId: {}, Error while canceling process which is in recovery mode", (Object)processContext.getExperimentId(), (Object)processContext.getProcessId());
            }
            catch (RegistryException e) {
                log.error("expId: {}, processId: {}, Error while getting job model for taskId {}, couldn't cancel process which is in recovery mode", new Object[]{processContext.getExperimentId(), processContext.getProcessId(), rTaskId});
            }
        }).start();
    }

    private JobModel getJobModel(ProcessContext processContext) {
        try {
            return GFacUtils.getJobModel((ProcessContext)processContext);
        }
        catch (RegistryException e) {
            log.error("Error while retrieving jobId,", (Throwable)e);
            return null;
        }
    }

    public void continueProcess(ProcessContext processContext, String taskId) throws GFacException {
        this.executeTaskListFrom(processContext, taskId);
    }

    private boolean postProcessing(ProcessContext processContext, boolean recovery) throws GFacException {
        ProcessStatus status = new ProcessStatus(ProcessState.POST_PROCESSING);
        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        processContext.setProcessStatus(status);
        GFacUtils.saveAndPublishProcessStatus((ProcessContext)processContext);
        if (processContext.isInterrupted()) {
            GFacUtils.handleProcessInterrupt((ProcessContext)processContext);
            return true;
        }
        return false;
    }

    private boolean outputDataStaging(TaskContext taskContext, boolean recovery, boolean isArchive) throws GFacException {
        TaskStatus taskStatus = new TaskStatus(TaskState.EXECUTING);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        ProcessContext processContext = taskContext.getParentProcessContext();
        Task dMoveTask = null;
        dMoveTask = isArchive ? Factory.getArchiveTask() : Factory.getDataMovementTask(processContext.getDataMovementProtocol());
        if (null == dMoveTask) {
            throw new GFacException("Unsupported security protocol, Airavata doesn't support " + processContext.getDataMovementProtocol() + " protocol yet.");
        }
        taskStatus = this.executeTask(taskContext, dMoveTask, recovery);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskContext.setTaskStatus(taskStatus);
        GFacUtils.saveAndPublishTaskStatus((TaskContext)taskContext);
        if (taskStatus.getState() == TaskState.FAILED) {
            log.error("expId: {}, processId: {}, taskId: {} type: {},:- output staging failed, reason: {}", new Object[]{taskContext.getParentProcessContext().getExperimentId(), taskContext.getParentProcessContext().getProcessId(), taskContext.getTaskId(), dMoveTask.getType().name(), taskStatus.getReason()});
            String errorMsg = "expId: " + processContext.getExperimentId() + ", processId: " + processContext.getProcessId() + ", taskId: " + taskContext.getTaskId() + ", type: " + taskContext.getTaskType().name() + " :- Output staging failed. Reason: " + taskStatus.getReason();
            ErrorModel errorModel = new ErrorModel();
            errorModel.setUserFriendlyMessage("Error while staging output data");
            errorModel.setActualErrorMessage(errorMsg);
            GFacUtils.saveTaskError((TaskContext)taskContext, (ErrorModel)errorModel);
        }
        return false;
    }

    public void cancelProcess(ProcessContext processContext) throws GFacException {
        if (processContext != null) {
            switch (processContext.getProcessState()) {
                case MONITORING: 
                case EXECUTING: {
                    JobSubmissionTask jobSubmissionTask = Factory.getJobSubmissionTask(processContext.getJobSubmissionProtocol());
                    TaskContext taskCtx = this.getJobSubmissionTaskContext(processContext);
                    this.executeCancel(taskCtx, jobSubmissionTask);
                    break;
                }
                case COMPLETED: 
                case FAILED: 
                case CANCELED: 
                case CANCELLING: {
                    log.warn("Process cancel trigger for already {} process", (Object)processContext.getProcessState().name());
                    break;
                }
            }
        }
    }

    private TaskStatus executeTask(TaskContext taskCtx, Task task, boolean recover) throws GFacException {
        TaskStatus taskStatus = null;
        taskStatus = recover ? task.recover(taskCtx) : task.execute(taskCtx);
        return taskStatus;
    }

    private void executeCancel(TaskContext taskContext, JobSubmissionTask jSTask) throws GFacException {
        try {
            JobStatus oldJobStatus = jSTask.cancel(taskContext);
            ProcessContext pc = taskContext.getParentProcessContext();
            JobMonitor monitorService = Factory.getMonitorService(pc.getMonitorMode());
            monitorService.canceledJob(pc.getJobModel().getJobId());
        }
        catch (TaskException e) {
            throw new GFacException("Error while cancelling job");
        }
        catch (AiravataException e) {
            throw new GFacException("Error wile getting monitoring service");
        }
    }

    private TaskContext getJobSubmissionTaskContext(ProcessContext processContext) throws GFacException {
        TaskContext taskCtx = new TaskContext();
        taskCtx.setParentProcessContext(processContext);
        TaskModel taskModel = new TaskModel();
        taskModel.setParentProcessId(processContext.getProcessId());
        taskModel.setCreationTime(new Date().getTime());
        taskModel.setLastUpdateTime(taskModel.getCreationTime());
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setTaskStatuses(Arrays.asList(taskStatus));
        taskModel.setTaskType(TaskTypes.JOB_SUBMISSION);
        taskCtx.setTaskModel(taskModel);
        return taskCtx;
    }

    private TaskContext getDataStagingTaskContext(ProcessContext processContext, OutputDataObjectType processOutput) throws TException, TaskException, GFacException {
        TaskContext taskCtx = new TaskContext();
        taskCtx.setParentProcessContext(processContext);
        TaskModel taskModel = new TaskModel();
        taskModel.setParentProcessId(processContext.getProcessId());
        taskModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setLastUpdateTime(taskModel.getCreationTime());
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setTaskStatuses(Arrays.asList(taskStatus));
        taskModel.setTaskType(TaskTypes.DATA_STAGING);
        String remoteOutputDir = processContext.getOutputDir();
        remoteOutputDir = remoteOutputDir.endsWith("/") ? remoteOutputDir : remoteOutputDir + "/";
        DataStagingTaskModel submodel = new DataStagingTaskModel();
        ServerInfo serverInfo = processContext.getComputeResourceServerInfo();
        URI source = null;
        try {
            source = new URI(processContext.getDataMovementProtocol().name(), serverInfo.getHost(), serverInfo.getUserName(), serverInfo.getPort(), remoteOutputDir + processOutput.getValue(), null, null);
        }
        catch (URISyntaxException e) {
            throw new TaskException("Error while constructing source file URI");
        }
        submodel.setSource(source.toString());
        submodel.setDestination("dummy://temp/file/location");
        taskModel.setSubTaskModel(ThriftUtils.serializeThriftObject((TBase)submodel));
        taskCtx.setTaskModel(taskModel);
        taskCtx.setProcessOutput(processOutput);
        return taskCtx;
    }

    private void saveTaskModel(TaskContext taskContext) throws GFacException {
        try {
            TaskModel taskModel = taskContext.getTaskModel();
            taskContext.getParentProcessContext().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)taskModel, (Object)taskModel.getParentProcessId());
        }
        catch (RegistryException e) {
            throw new GFacException("Error while saving task model", (Throwable)e);
        }
    }

    private TaskContext getTaskContext(ProcessContext processContext) {
        TaskContext taskCtx = new TaskContext();
        taskCtx.setParentProcessContext(processContext);
        return taskCtx;
    }

    private void sortByInputOrder(List<InputDataObjectType> processInputs) {
        Collections.sort(processInputs, new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDT_1, InputDataObjectType inputDT_2) {
                return inputDT_1.getInputOrder() - inputDT_2.getInputOrder();
            }
        });
    }

    private void updateProcessFailure(ProcessContext pc, String reason) throws GFacException {
        if (pc == null) {
            throw new GFacException("Can't update process failure, process context is null");
        }
        ProcessStatus status = new ProcessStatus(ProcessState.FAILED);
        status.setReason(reason);
        pc.setProcessStatus(status);
        try {
            GFacUtils.saveAndPublishProcessStatus((ProcessContext)pc);
        }
        catch (GFacException e) {
            log.error("Error while save and publishing process failed status event");
        }
    }

    private void saveErrorModel(ProcessContext pc, Exception e, String userFriendlyMsg) throws GFacException {
        if (pc == null) {
            throw new GFacException("Can't save error process context is null", (Throwable)e);
        }
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        ErrorModel errorModel = new ErrorModel();
        errorModel.setUserFriendlyMessage(userFriendlyMsg);
        errorModel.setActualErrorMessage(errors.toString());
        errorModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        try {
            GFacUtils.saveProcessError((ProcessContext)pc, (ErrorModel)errorModel);
            GFacUtils.saveExperimentError((ProcessContext)pc, (ErrorModel)errorModel);
        }
        catch (GFacException e1) {
            log.error("Error while updating error model for process:" + pc.getProcessId());
        }
    }

    public static ResourceJobManager getResourceJobManager(ProcessContext processCtx) throws AppCatalogException, GFacException {
        SSHJobSubmission sshJobSubmission;
        List jobSubmissionInterfaces = Factory.getDefaultAppCatalog().getComputeResource().getComputeResource(processCtx.getComputeResourceId()).getJobSubmissionInterfaces();
        ResourceJobManager resourceJobManager = null;
        JobSubmissionInterface jsInterface = null;
        for (JobSubmissionInterface jobSubmissionInterface : jobSubmissionInterfaces) {
            if (jobSubmissionInterface.getJobSubmissionProtocol() != processCtx.getJobSubmissionProtocol()) continue;
            jsInterface = jobSubmissionInterface;
            break;
        }
        if (jsInterface == null) {
            throw new GFacException("Job Submission interface cannot be empty at this point");
        }
        if (jsInterface.getJobSubmissionProtocol() == JobSubmissionProtocol.SSH) {
            sshJobSubmission = Factory.getDefaultAppCatalog().getComputeResource().getSSHJobSubmission(jsInterface.getJobSubmissionInterfaceId());
            processCtx.setMonitorMode(sshJobSubmission.getMonitorMode());
            resourceJobManager = sshJobSubmission.getResourceJobManager();
        } else if (jsInterface.getJobSubmissionProtocol() == JobSubmissionProtocol.LOCAL) {
            LOCALSubmission localSubmission = Factory.getDefaultAppCatalog().getComputeResource().getLocalJobSubmission(jsInterface.getJobSubmissionInterfaceId());
            resourceJobManager = localSubmission.getResourceJobManager();
        } else if (jsInterface.getJobSubmissionProtocol() == JobSubmissionProtocol.SSH_FORK) {
            sshJobSubmission = Factory.getDefaultAppCatalog().getComputeResource().getSSHJobSubmission(jsInterface.getJobSubmissionInterfaceId());
            processCtx.setMonitorMode(sshJobSubmission.getMonitorMode());
            resourceJobManager = sshJobSubmission.getResourceJobManager();
        } else {
            if (jsInterface.getJobSubmissionProtocol() == JobSubmissionProtocol.CLOUD) {
                return null;
            }
            throw new GFacException("Unsupported JobSubmissionProtocol - " + jsInterface.getJobSubmissionProtocol().name());
        }
        if (resourceJobManager == null) {
            throw new GFacException("Resource Job Manager is empty.");
        }
        return resourceJobManager;
    }
}

