/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import org.apache.airavata.gfac.impl.task.utils.bes.ResourceRequirement;

public class RangeValueType
implements ResourceRequirement {
    private double exact = Double.NaN;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private double epsilon = Double.NaN;
    private boolean includeLowerBound = true;
    private boolean includeUpperBound = true;
    private boolean enabled = false;

    public RangeValueType(double exact, double epsilon, double lowerBound, boolean includeLowerBound, double upperBound, boolean includeUpperBound, boolean enabled) {
        this.exact = exact;
        this.epsilon = epsilon;
        this.lowerBound = lowerBound;
        this.includeLowerBound = includeLowerBound;
        this.upperBound = upperBound;
        this.includeUpperBound = includeUpperBound;
        this.enabled = enabled;
    }

    public RangeValueType(double exact, double epsilon, double lowerBound, boolean includeLowerBound, double upperBound, boolean includeUpperBound) {
        this(exact, epsilon, lowerBound, includeLowerBound, upperBound, includeUpperBound, false);
    }

    public RangeValueType(double exact, double epsilon, double lowerBound, double upperBound) {
        this(exact, epsilon, lowerBound, true, upperBound, true);
    }

    public RangeValueType(double exact, double lowerBound, double upperBound) {
        this(exact, Double.NaN, lowerBound, true, upperBound, true);
    }

    public RangeValueType(double exact, double epsilon) {
        this(exact, epsilon, Double.NaN, Double.NaN);
    }

    public RangeValueType(double exact) {
        this(exact, Double.NaN);
    }

    public RangeValueType() {
    }

    public double getExact() {
        return this.exact;
    }

    public void setExact(double exact) {
        this.exact = exact;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public boolean lowerThanDouble(double value) {
        return value >= this.exact && value >= this.lowerBound && value <= this.upperBound;
    }

    public String toString() {
        if (this.lowerBound == Double.NEGATIVE_INFINITY && this.upperBound == Double.POSITIVE_INFINITY) {
            return Double.toString(this.exact);
        }
        return "(e=" + Double.toString(this.exact) + ",l=" + Double.toString(this.lowerBound) + ",u=" + Double.toString(this.upperBound) + ")";
    }

    public boolean isIncludeLowerBound() {
        return this.includeLowerBound;
    }

    public void setIncludeLowerBound(boolean includeLowerBound) {
        this.includeLowerBound = includeLowerBound;
    }

    public boolean isIncludeUpperBound() {
        return this.includeUpperBound;
    }

    public void setIncludeUpperBound(boolean includeUpperBound) {
        this.includeUpperBound = includeUpperBound;
    }

    public RangeValueType clone() {
        return new RangeValueType(this.exact, this.epsilon, this.lowerBound, this.includeLowerBound, this.upperBound, this.includeUpperBound, this.enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangeValueType)) {
            return false;
        }
        RangeValueType other = (RangeValueType)o;
        return this.doublesEqual(this.getExact(), other.getExact()) && this.doublesEqual(this.getEpsilon(), other.getEpsilon()) && this.doublesEqual(this.getLowerBound(), other.getLowerBound()) && this.doublesEqual(this.getUpperBound(), other.getUpperBound()) && this.isIncludeLowerBound() == other.isIncludeLowerBound() && this.isIncludeUpperBound() == other.isIncludeUpperBound() && this.isEnabled() == other.isEnabled();
    }

    private boolean doublesEqual(double a, double b) {
        Double A = new Double(a);
        Double B = new Double(b);
        return A.equals(B);
    }
}

