/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.hybrid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.common.UserRolesCache;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class HybridRoleManager {
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);
    private DataSource dataSource;
    int tenantId;
    private RealmConfiguration realmConfig;
    protected UserRealm userRealm = null;
    protected UserRolesCache userRolesCache = null;
    private boolean userRolesCacheEnabled = true;
    private final int DEFAULT_MAX_ROLE_LIST_SIZE = 1000;
    private final int DEFAULT_MAX_SEARCH_TIME = 1000;

    public HybridRoleManager(DataSource dataSource, int tenantId, RealmConfiguration realmConfig, UserRealm realm) throws UserStoreException {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
        this.realmConfig = realmConfig;
        this.userRealm = realm;
        UserCoreUtil.persistDomain("Internal", tenantId, dataSource);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHybridRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String primaryDomainName = this.getMyDomainName();
            if (primaryDomainName != null) {
                primaryDomainName = primaryDomainName.toUpperCase();
            }
            dbConnection = this.getDBConnection();
            if (this.isExistingRole(roleName)) throw new UserStoreException("Role name: " + roleName + " in the system. Please pick another role name.");
            DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", roleName, this.tenantId);
            if (userList != null) {
                String sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if ("mssql".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
                }
                if ("openedge".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sql, primaryDomainName, userList, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sql, primaryDomainName, userList, roleName, this.tenantId, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    protected void clearUserRolesCacheByTenant(int tenantID) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheByTenant(tenantID);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByTenant(tenantID);
        }
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME =? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Is roleName: " + roleName + " Exist: " + isExisting + " TenantId: " + this.tenantId));
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public String[] getHybridRoles(String filter) throws UserStoreException {
        String[] stringArray;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=?";
        int maxItemLimit = 100;
        int searchTime = 10000;
        try {
            maxItemLimit = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            maxItemLimit = 1000;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 1000;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            dbConnection.setTransactionIsolation(2);
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            prepStmt.setMaxRows(maxItemLimit);
            try {
                prepStmt.setQueryTimeout(searchTime);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            ArrayList<String> filteredRoles = new ArrayList<String>();
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                log.error((Object)"Error while retrieving roles from Internal JDBC role store", (Throwable)e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    name = "Internal/" + name;
                    filteredRoles.add(name);
                }
            }
            stringArray = filteredRoles.toArray(new String[filteredRoles.size()]);
        }
        catch (SQLException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return stringArray;
    }

    public String[] getUserListOfHybridRole(String roleName) throws UserStoreException {
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            throw new UserStoreException("Invalid operation. You are trying to retrieve all users from the external userstore.");
        }
        String sqlStmt = "SELECT UM_USER_NAME, UM_DOMAIN_NAME FROM UM_HYBRID_USER_ROLE, UM_DOMAIN WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID";
        Connection dbConnection = null;
        try {
            String[] names;
            dbConnection = this.getDBConnection();
            String[] stringArray = names = DatabaseUtil.getStringValuesFromDatabaseForInternalRoles(dbConnection, sqlStmt, roleName, this.tenantId, this.tenantId);
            return stringArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUserListOfHybridRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
        Connection dbConnection = null;
        try {
            String type;
            String primaryDomainName = this.getMyDomainName();
            if (primaryDomainName != null) {
                primaryDomainName = primaryDomainName.toUpperCase();
            }
            if ("mssql".equals(type = DatabaseCreator.getDatabaseType((Connection)(dbConnection = this.getDBConnection())))) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            if (deletedUsers != null && deletedUsers.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt1, primaryDomainName, deletedUsers, roleName, this.tenantId, this.tenantId, this.tenantId);
                for (String deletedUser : deletedUsers) {
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                }
            }
            if (newUsers != null && newUsers.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, primaryDomainName, newUsers, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, primaryDomainName, newUsers, roleName, this.tenantId, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    public String[] getHybridRoleListOfUser(String userName, String filter) throws UserStoreException {
        String[] stringArray;
        String[] roles;
        Connection dbConnection;
        block10: {
            block11: {
                String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME=? AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
                dbConnection = null;
                userName = UserCoreUtil.addDomainToName(userName, this.getMyDomainName());
                String domain = UserCoreUtil.extractDomainFromName(userName);
                dbConnection = this.getDBConnection();
                if (domain != null) {
                    domain = domain.toUpperCase();
                }
                roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, UserCoreUtil.removeDomainFromName(userName), this.tenantId, this.tenantId, this.tenantId, domain);
                if ("wso2.anonymous.user".equals(userName)) break block10;
                if (roles != null && roles.length != 0) break block11;
                String[] stringArray2 = new String[]{this.realmConfig.getEveryOneRoleName()};
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                return stringArray2;
            }
            ArrayList<String> allRoles = new ArrayList<String>();
            boolean isEveryone = false;
            for (String role : roles) {
                role = "Internal/" + role;
                if (role.equals(this.realmConfig.getEveryOneRoleName())) {
                    isEveryone = true;
                }
                allRoles.add(role);
            }
            if (!isEveryone) {
                allRoles.add(this.realmConfig.getEveryOneRoleName());
            }
            String[] stringArray3 = allRoles.toArray(new String[allRoles.size()]);
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
            return stringArray3;
        }
        try {
            stringArray = roles;
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateHybridRoleListOfUser(String user, String[] deletedRoles, String[] addRoles) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID, UM_DOMAIN_ID) VALUES ((SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, ?,(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
        Connection dbConnection = null;
        try {
            user = UserCoreUtil.addDomainToName(user, this.getMyDomainName());
            String domain = UserCoreUtil.extractDomainFromName(user);
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (?),(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, UserCoreUtil.removeDomainFromName(user), this.tenantId, this.tenantId, domain);
            }
            if (addRoles != null && addRoles.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT UM_ID, ?, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, user, this.tenantId, addRoles, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, addRoles, this.tenantId, UserCoreUtil.removeDomainFromName(user), this.tenantId, this.tenantId, domain);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        if (deletedRoles != null && deletedRoles.length > 0) {
            this.userRealm.getAuthorizationManager().clearUserAuthorization(user);
        }
    }

    public void deleteHybridRole(String roleName) throws UserStoreException {
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            throw new UserStoreException("Invalid operation");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, this.tenantId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", roleName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    public void updateHybridRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        String sqlStmt = "UPDATE UM_HYBRID_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update hybrid role name is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt.contains("UM_TENANT_ID")) {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName);
            }
            dbConnection.commit();
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using sql : " + sqlStmt));
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        String[] roles = this.getHybridRoleListOfUser(userName, "*");
        if (roles != null && roleName != null) {
            for (String role : roles) {
                if (!UserCoreUtil.removeDomainFromName(role).equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    public void deleteUser(String userName) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement preparedStatement = null;
        String domain = UserCoreUtil.extractDomainFromName(userName = UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
        if (domain != null) {
            domain = domain.toUpperCase();
        }
        try {
            dbConnection = this.getDBConnection();
            preparedStatement = dbConnection.prepareStatement("DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)");
            preparedStatement.setString(1, UserCoreUtil.removeDomainFromName(userName));
            preparedStatement.setInt(2, this.tenantId);
            preparedStatement.setInt(3, this.tenantId);
            preparedStatement.setString(4, domain);
            preparedStatement.execute();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    protected void initUserRolesCache() {
        String userRolesCacheEnabledString = this.realmConfig.getUserStoreProperty("UserRolesCacheEnabled");
        if (userRolesCacheEnabledString != null && !userRolesCacheEnabledString.equals("")) {
            this.userRolesCacheEnabled = Boolean.parseBoolean(userRolesCacheEnabledString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Roles Cache is configured to:" + userRolesCacheEnabledString));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("User Roles Cache is not configured. Default value: " + this.userRolesCacheEnabled + " is taken."));
        }
        if (this.userRolesCacheEnabled) {
            int timeOut = 5;
            String timeOutString = this.realmConfig.getUserStoreProperty("UserCoreCacheTimeOut");
            if (timeOutString != null) {
                timeOut = Integer.parseInt(timeOutString);
            }
            this.userRolesCache = UserRolesCache.getInstance();
            this.userRolesCache.setTimeOut(timeOut);
        }
    }

    protected String getMyDomainName() {
        return UserCoreUtil.getDomainName(this.realmConfig);
    }
}

