/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;

public class Cache
implements Map<Identifier, CachedObject> {
    PriorityQueue<CachedObject> sortedList;
    TreeMap<Identifier, CachedObject> theRealCache;

    public CachedObject add(Cacheable cacheable) {
        Identifier key = cacheable.getIdentifier();
        CachedObject co = this.get(key);
        if (co == null) {
            co = new CachedObject();
            co.setKey(key.toString());
            this.put(key, co);
        }
        co.setValue(cacheable);
        return co;
    }

    public PriorityQueue<CachedObject> getSortedList() {
        if (this.sortedList == null) {
            this.sortedList = new PriorityQueue();
        }
        return this.sortedList;
    }

    public TreeMap<Identifier, CachedObject> getTheRealCache() {
        if (this.theRealCache == null) {
            this.theRealCache = new TreeMap();
        }
        return this.theRealCache;
    }

    @Override
    public void clear() {
        this.getSortedList().clear();
        this.getTheRealCache().clear();
    }

    @Override
    public int size() {
        return this.getTheRealCache().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getTheRealCache().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getTheRealCache().containsKey(key);
    }

    public boolean containsObject(Cacheable cacheable) {
        return this.getTheRealCache().containsKey(cacheable.getIdentifier());
    }

    public Collection<? extends Cacheable> objectValues() {
        ArrayList<Cacheable> objects = new ArrayList<Cacheable>();
        for (CachedObject co : this.values()) {
            objects.add((Cacheable)co.getValue());
        }
        return objects;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getTheRealCache().containsValue(value);
    }

    @Override
    public CachedObject get(Object key) {
        return this.getTheRealCache().get(key);
    }

    public void put(CachedObject co) {
        this.put(new BasicIdentifier(co.getKey()), co);
    }

    @Override
    public CachedObject put(Identifier key, CachedObject value) {
        CachedObject oldCO = this.getTheRealCache().get(key);
        if (oldCO == null) {
            this.getTheRealCache().put(key, value);
            this.getSortedList().add(value);
        } else {
            oldCO.setTimestamp(value.getTimestamp());
        }
        return oldCO;
    }

    @Override
    public CachedObject remove(Object key) {
        CachedObject co = this.getTheRealCache().get(key);
        if (co == null) {
            return null;
        }
        this.getSortedList().remove(co);
        return this.getTheRealCache().remove(key);
    }

    @Override
    public void putAll(Map<? extends Identifier, ? extends CachedObject> m) {
        for (Map.Entry<? extends Identifier, ? extends CachedObject> e : m.entrySet()) {
            this.getSortedList().add(e.getValue());
        }
        this.getTheRealCache().putAll(m);
    }

    @Override
    public Set<Identifier> keySet() {
        return this.getTheRealCache().keySet();
    }

    @Override
    public Collection<CachedObject> values() {
        return this.getTheRealCache().values();
    }

    @Override
    public Set<Map.Entry<Identifier, CachedObject>> entrySet() {
        return this.getTheRealCache().entrySet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.size() + " objects]";
    }
}

